/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide;

import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeConstants;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.model.Project;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.model.Workspaces;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.util.ModelUtil;
import oracle.ide.view.ActiveViewEvent;
import oracle.ide.view.ActiveViewListener;
import oracle.ide.view.View;
import oracle.ide.view.ViewSelectionEvent;
import oracle.ide.view.ViewSelectionListener;

final class IdeViewHandler
implements ViewSelectionListener,
ActiveViewListener {
    private transient NavigatorWindow _lastActiveNavigator;
    private static Project _lastActiveProject;

    IdeViewHandler() {
    }

    public void activeViewChanged(ActiveViewEvent activeViewEvent) {
        View view;
        View view2 = activeViewEvent.getOldView();
        if (view2 != null) {
            view2.removeViewSelectionListener(this);
        }
        if ((view = activeViewEvent.getNewView()) == null) {
            view = Ide.getMainWindow().getLastActiveView();
        }
        view.addViewSelectionListener(this);
        Context context = view.getContext();
        if (context != null && context.getWorkspace() != null) {
            IdeViewHandler.activateProjectInWorkspace(context.getProject(), context.getWorkspace());
        } else {
            IdeViewHandler.activateProjectInWorkspace(Ide.getActiveProject(), Ide.getActiveWorkspace());
        }
        if (!IdeAction.isHandlerInProgress()) {
            IdeMainWindow.updateVisibleActions(Controller.UPDATE_FROM_ACTIVE_VIEW_CHANGED);
        }
        if (this._lastActiveNavigator != view && view instanceof NavigatorWindow) {
            this._lastActiveNavigator = (NavigatorWindow)view;
        }
    }

    private static void activateProjectInWorkspace(Project project, Workspace workspace) {
        Workspace workspace2;
        if (workspace == null && Ide.getActiveWorkspace() != null) {
            return;
        }
        if (project == null && workspace != null) {
            project = workspace.currentActiveProject();
        }
        if ((workspace2 = Ide.getActiveWorkspace()) != workspace) {
            Ide.setActiveWorkspace(workspace);
            workspace2 = workspace;
        }
        Project project2 = project;
        boolean bl = false;
        if (workspace2 != null) {
            Workspaces workspaces = Ide.getWorkspaces();
            if (!ModelUtil.areEqual((Object)workspaces.getActiveWorkspaceURL(), (Object)workspace2.getURL())) {
                workspaces.setActiveWorkspaceURL(workspace2.getURL());
                bl = true;
            }
            if ((project2 = workspace2.currentActiveProject()) != project) {
                workspace2.setActiveProject(project);
                project2 = project;
            } else if (project2 != null && !ModelUtil.areEqual((Object)project2.getURL(), (Object)workspace2.getActiveProjectURL())) {
                workspace2.setActiveProjectURL(project2.getURL());
                bl = true;
            }
        }
        if (bl || _lastActiveProject != project2) {
            IdeViewHandler.fireActiveProjectChanged(project2, workspace2);
            _lastActiveProject = project2;
        }
    }

    private static void fireActiveProjectChanged(Project project, Workspace workspace) {
        UpdateMessage updateMessage = new UpdateMessage(IdeConstants.ACTIVE_PROJECT_CHANGED, null);
        updateMessage.getModifyObjects().add(project);
        updateMessage.getModifyObjects().add(workspace);
        Ide.getSystem().notifyObservers(Ide.getSystem(), updateMessage);
    }

    NavigatorWindow getLastActiveNavigator() {
        return this._lastActiveNavigator;
    }

    public void viewSelectionChanged(ViewSelectionEvent viewSelectionEvent) {
        View view = viewSelectionEvent.getView();
        if (view == Ide.getMainWindow().getLastActiveView()) {
            Context context = view.getContext();
            IdeViewHandler.activateProjectInWorkspace(context.getProject(), context.getWorkspace());
            IdeMainWindow.updateVisibleActions(Controller.UPDATE_FROM_VIEW_SELECTION_CHANGED);
        }
    }
}

