/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor;

import java.awt.Color;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import oracle.ide.Ide;
import oracle.ide.ceditor.CEditorArb;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.controls.StatusBar;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.language.NumberRange;
import oracle.javatools.editor.plugins.AbstractClickPlugin;

public abstract class AbstractBrowseClickPlugin
extends AbstractClickPlugin {
    protected static final int ACTION_DECLARATION = 1;
    protected String _lastStatusText;
    private static HighlightStyle _declarationStyle;
    private static String _declarationText;
    private static final int MODIFIER_DECLARATION;

    static {
        boolean bl = System.getProperty("os.name").indexOf("Mac OS X") != -1;
        MODIFIER_DECLARATION = bl ? 256 : 128;
        _declarationText = bl ? CEditorArb.getString(36) : CEditorArb.getString(35);
        String string = CEditorArb.getString(37);
        _declarationStyle = CodeEditor.createHighlightStyle("click-navigation", string, 70, Color.blue, null, 0, 0, Color.blue);
    }

    protected int getActionTypeFor(MouseEvent mouseEvent) {
        if (this.hasModifierEx(mouseEvent, MODIFIER_DECLARATION) && SwingUtilities.isLeftMouseButton(mouseEvent) && !mouseEvent.isPopupTrigger() && mouseEvent.getID() == 500) {
            return 1;
        }
        if (this.hasModifierEx(mouseEvent, MODIFIER_DECLARATION) && mouseEvent.getID() == 503) {
            return 1;
        }
        return -1;
    }

    protected void handleClickAction(Point point, int n) {
        if (n == 1) {
            this.performDeclarationClick(point);
        }
    }

    protected HighlightStyle getHighlightStyleFor(int n) {
        if (n == 1) {
            return _declarationStyle;
        }
        return null;
    }

    protected String getHintTextFor(int n) {
        if (n == 1) {
            return _declarationText;
        }
        return null;
    }

    protected NumberRange getRegionFor(int n, int n2) {
        if (n2 == 1) {
            return this.getIdentifierAtOffset(n);
        }
        return null;
    }

    void $init$() {
        this._lastStatusText = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateHint(int n) {
        String string;
        StatusBar statusBar = Ide.getStatusBar();
        String string2 = null;
        if (n != -1 && (string = this.getHintTextFor(n)) != null) {
            string2 = string;
        }
        if (string2 != null) {
            AbstractBrowseClickPlugin abstractBrowseClickPlugin = this;
            synchronized (abstractBrowseClickPlugin) {
                this._lastStatusText = string2;
                statusBar.setText(this._lastStatusText);
            }
        }
        AbstractBrowseClickPlugin abstractBrowseClickPlugin = this;
        synchronized (abstractBrowseClickPlugin) {
            if (statusBar.getText() == this._lastStatusText) {
                statusBar.setText("");
            }
            this._lastStatusText = null;
        }
    }

    protected abstract void performDeclarationClick(Point var1);

    protected abstract NumberRange getIdentifierAtOffset(int var1);

    public AbstractBrowseClickPlugin() {
        this.$init$();
    }
}

