/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JScrollPane;
import javax.swing.ScrollPaneLayout;
import javax.swing.border.Border;

public final class CEScrollPaneLayout
extends ScrollPaneLayout {
    public void syncWithScrollPane(JScrollPane jScrollPane) {
        super.syncWithScrollPane(jScrollPane);
        this.ensureScrollBarsVisible(jScrollPane);
    }

    private void ensureScrollBarsVisible(JScrollPane jScrollPane) {
        this.vsbPolicy = jScrollPane.getVerticalScrollBarPolicy();
        this.hsbPolicy = jScrollPane.getHorizontalScrollBarPolicy();
        if (this.vsbPolicy != 22 || this.hsbPolicy != 32) {
            throw new IllegalStateException("LM requires visible SBs");
        }
    }

    public Dimension preferredLayoutSize(Container container) {
        Border border;
        JScrollPane jScrollPane = (JScrollPane)container;
        Insets insets = container.getInsets();
        int n = insets.left + insets.right;
        int n2 = insets.top + insets.bottom;
        if (this.viewport != null) {
            Dimension dimension = this.viewport.getPreferredSize();
            n += dimension.width;
            n2 += dimension.height;
        }
        if ((border = jScrollPane.getViewportBorder()) != null) {
            Insets insets2 = border.getBorderInsets(container);
            n += insets2.left + insets2.right;
            n2 += insets2.top + insets2.bottom;
        }
        if (this.rowHead != null && this.rowHead.isVisible()) {
            n += this.rowHead.getPreferredSize().width;
        }
        if (this.vsb != null) {
            n += this.vsb.getPreferredSize().width;
        }
        if (this.hsb != null) {
            n2 += this.hsb.getPreferredSize().height;
        }
        return new Dimension(n, n2);
    }

    public Dimension minimumLayoutSize(Container container) {
        Border border;
        JScrollPane jScrollPane = (JScrollPane)container;
        Insets insets = container.getInsets();
        int n = insets.left + insets.right;
        int n2 = insets.top + insets.bottom;
        if (this.viewport != null) {
            Dimension dimension = this.viewport.getMinimumSize();
            n += dimension.width;
            n2 += dimension.height;
        }
        if ((border = jScrollPane.getViewportBorder()) != null) {
            Insets insets2 = border.getBorderInsets(container);
            n += insets2.left + insets2.right;
            n2 += insets2.top + insets2.bottom;
        }
        if (this.rowHead != null && this.rowHead.isVisible()) {
            Dimension dimension = this.rowHead.getMinimumSize();
            n += dimension.width;
            n2 = Math.max(n2, dimension.height);
        }
        if (this.vsb != null) {
            Dimension dimension = this.vsb.getMinimumSize();
            n += dimension.width;
            n2 = Math.max(n2, dimension.height);
        }
        if (this.hsb != null) {
            Dimension dimension = this.hsb.getMinimumSize();
            n2 += dimension.height;
            n = Math.max(n, dimension.width);
        }
        return new Dimension(n, n2);
    }

    public void layoutContainer(Container container) {
        JScrollPane jScrollPane = (JScrollPane)container;
        boolean bl = jScrollPane.getComponentOrientation().isLeftToRight();
        Rectangle rectangle = jScrollPane.getBounds();
        int n = rectangle.width;
        int n2 = rectangle.height;
        Insets insets = container.getInsets();
        n -= insets.left + insets.right;
        n2 -= insets.top + insets.bottom;
        int n3 = 0;
        if (this.rowHead != null) {
            n3 = this.rowHead.getPreferredSize().width;
            n -= n3;
        }
        int n4 = 0;
        int n5 = 0;
        if (this.vsb != null) {
            n4 = this.vsb.getPreferredSize().width;
            n -= n4;
        }
        if (this.hsb != null) {
            n5 = this.hsb.getPreferredSize().height;
            n2 -= n5;
        }
        if (this.viewport != null) {
            int n6 = insets.left + (bl ? n3 : n4);
            Border border = jScrollPane.getViewportBorder();
            if (border != null) {
                Insets insets2 = border.getBorderInsets(container);
                this.viewport.setBounds(n6 + insets2.left, insets.top + insets2.top, n - insets2.left - insets2.right, n2 - insets2.top - insets2.bottom);
            } else {
                this.viewport.setBounds(n6, insets.top, n, n2);
            }
        }
        if (this.rowHead != null) {
            int n7 = insets.left + (bl ? 0 : n4 + n);
            this.rowHead.setBounds(n7, insets.top, n3, n2);
        }
        if (this.vsb != null) {
            int n8 = insets.left + (bl ? n3 + n : 0);
            this.vsb.setBounds(n8, insets.top, n4, n2);
        }
        if (this.hsb != null) {
            int n9 = insets.top + n2;
            int n10 = n + n3 + n4;
            this.hsb.setBounds(insets.left, n9, n10, n5);
        }
    }
}

