/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.accessibility.Accessible;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.undo.UndoableEdit;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CEFileOverviewMargin;
import oracle.ide.ceditor.CEToolTipProvider;
import oracle.ide.ceditor.CEditorArb;
import oracle.ide.ceditor.CodeEditorController;
import oracle.ide.ceditor.CodeEditorGutter;
import oracle.ide.ceditor.CodeEditorPluginsFactory;
import oracle.ide.ceditor.CursorListener;
import oracle.ide.ceditor.DropHandlerPlugin;
import oracle.ide.ceditor.EditorPluginsFactory;
import oracle.ide.ceditor.EditorStatusBar;
import oracle.ide.ceditor.NodeUpdater;
import oracle.ide.ceditor.UndoWrapperCommand;
import oracle.ide.ceditor.find.FindableEditor;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.controls.Toolbar;
import oracle.ide.datatransfer.TransferableContext;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.EditorUtil;
import oracle.ide.editor.TextEditor;
import oracle.ide.help.HelpInfo;
import oracle.ide.help.HelpableProvider;
import oracle.ide.layout.BaseLayoutListener;
import oracle.ide.layout.Layout;
import oracle.ide.model.Attributes;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Node;
import oracle.ide.model.TextNode;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.print.DocumentPrintFactory;
import oracle.ide.print.PrintManager;
import oracle.ide.util.AccessibleUtils;
import oracle.ide.util.StructuredPropertyAccess;
import oracle.ide.vcs.VCSManager;
import oracle.ide.view.StatusProvider;
import oracle.ide.view.View;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dnd.DndUtils;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.FileOverviewMargin;
import oracle.javatools.editor.PopupManager;
import oracle.javatools.editor.ToolTipProvider;
import oracle.javatools.editor.folding.CodeFoldingMargin;
import oracle.javatools.editor.highlight.HighlightRegistry;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.language.LanguageModule;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.plugins.DragDropPlugin;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.editor.plugins.LineHighlightPlugin;
import oracle.javatools.editor.plugins.TrailingSpacePlugin;

public final class CodeEditor
extends Editor
implements PropertyChangeListener,
TextEditor,
PopupManager,
BaseLayoutListener,
UndoableEditListener,
ToolTipProvider,
StatusProvider,
FindableEditor,
CaretListener {
    public static final String EDITOR_CONTEXT = "editor-ide-context";
    public static final String TYPE_PLAIN = "txt";
    public static final String TYPE_JAVA = "java";
    public static final String TYPE_SQL = "sql";
    public static final String TYPE_PLSQL = "plsql";
    public static final String TYPE_JSP = "jsp";
    public static final String TYPE_HTML = "html";
    public static final String TYPE_XML = "xml";
    public static final String TYPE_PROPERTIES = "properties";
    public static final String TYPE_IDL = "idl";
    public static final String TYPE_CPP = "cpp";
    public static final String TYPE_JS = "js";
    public static final String TYPE_DIFF = "diff";
    private BasicEditorPane editorComponent;
    private JPanel leftMargin;
    private Toolbar topToolbar;
    private CodeEditorGutter gutterComponent;
    private CodeFoldingMargin codeFoldingMargin;
    private FileOverviewMargin fileOverviewMargin;
    private JScrollPane scrollPane;
    private ArrayList cursorListeners = new ArrayList();
    private ArrayList providerList = new ArrayList();
    private HelpInfo helpInfo;
    private NodeUpdater nodeUpdater;
    private ArrayList ceToolTipProviders = new ArrayList(2);
    private EditorStatusBar statusBar;
    private static final String OFFSET_PROP = "offset";
    private static final String TAB_SIZE_PROP = "tabsize";
    private TextNode ideNode;
    private static List pluginsFactoryList;
    private static List classList;
    private static List typeList;
    private static final DataFlavor CONTEXT_FLAVOR;
    private static final DataFlavor FILELIST_FLAVOR;
    private static final DataFlavor[] EXTRA_CUSTOM_FLAVORS;

    static {
        classList = new ArrayList();
        typeList = new ArrayList();
        pluginsFactoryList = new ArrayList();
        CodeEditor.registerFactory(new CodeEditorPluginsFactory());
        CONTEXT_FLAVOR = TransferableContext.contextFlavor;
        FILELIST_FLAVOR = DataFlavor.javaFileListFlavor;
        EXTRA_CUSTOM_FLAVORS = new DataFlavor[]{CONTEXT_FLAVOR, FILELIST_FLAVOR};
    }

    public CodeEditor() {
        PrintManager printManager = PrintManager.getPrintManager();
        if (printManager != null) {
            printManager.registerDocumentPrintFactory(CodeEditor.class, DocumentPrintFactory.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerFactory(EditorPluginsFactory editorPluginsFactory) {
        if (editorPluginsFactory != null) {
            List list = pluginsFactoryList;
            synchronized (list) {
                pluginsFactoryList.add(editorPluginsFactory);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerNodeType(Class clazz, String string) {
        Class<TextNode> clazz2 = TextNode.class;
        if (clazz2.isAssignableFrom(clazz)) {
            List list = classList;
            synchronized (list) {
                classList.add(clazz);
                typeList.add(string);
            }
        }
    }

    public void changeDocumentType(String string) {
        LanguageSupport languageSupport = LanguageModule.createSupportForFileType((String)string);
        if (languageSupport != null) {
            BasicDocument basicDocument = (BasicDocument)this.editorComponent.getDocument();
            basicDocument.setLanguageSupport(languageSupport);
        }
    }

    public static HighlightStyle createHighlightStyle(String string, String string2, int n, Color color, Color color2) {
        EditorProperties editorProperties = EditorProperties.getProperties();
        HighlightRegistry highlightRegistry = editorProperties.getHighlightRegistry();
        return highlightRegistry.createStyle(string, string2, true, n, color, color2);
    }

    public static HighlightStyle createHighlightStyle(String string, String string2, int n, Color color, Color color2, int n2, int n3, Color color3) {
        EditorProperties editorProperties = EditorProperties.getProperties();
        HighlightRegistry highlightRegistry = editorProperties.getHighlightRegistry();
        return highlightRegistry.createStyle(string, string2, true, n, color, color2, n2, n3, color3);
    }

    public Toolbar getToolbar() {
        if (this.topToolbar == null) {
            this.topToolbar = new CEToolbar();
        }
        return this.topToolbar;
    }

    public String getText(int n, int n2) throws BadLocationException {
        return this.editorComponent.getText(n, n2);
    }

    public void setCaretPosition(int n) {
        this.editorComponent.setCaretPosition(n);
    }

    public void moveCaretPosition(int n) {
        this.editorComponent.moveCaretPosition(n);
    }

    public int getCaretPosition() {
        return this.editorComponent.getCaretPosition();
    }

    public int getCaretLine() {
        BasicDocument basicDocument = (BasicDocument)this.editorComponent.getDocument();
        basicDocument.readLock();
        int n = 0;
        try {
            int n2 = this.editorComponent.getCaretPosition();
            LineMap lineMap = basicDocument.getLineMap();
            n = lineMap.getLineFromOffset(n2);
        }
        finally {
            basicDocument.readUnlock();
        }
        return ++n;
    }

    public void replaceSelection(String string) {
        this.editorComponent.replaceSelection(string);
    }

    public boolean hasSelectedText() {
        int n;
        int n2 = this.editorComponent.getSelectionStart();
        return n2 != (n = this.editorComponent.getSelectionEnd());
    }

    public String getSelectedText() {
        return this.editorComponent.getSelectedText();
    }

    public int getSelectionStart() {
        return this.editorComponent.getSelectionStart();
    }

    public int getSelectionEnd() {
        return this.editorComponent.getSelectionEnd();
    }

    public void setSelectionStart(int n) {
        this.editorComponent.setSelectionStart(n);
    }

    public void setSelectionEnd(int n) {
        this.editorComponent.setSelectionEnd(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCursorListener(CursorListener cursorListener) {
        if (this.cursorListeners != null) {
            ArrayList arrayList = this.cursorListeners;
            synchronized (arrayList) {
                if (this.cursorListeners.indexOf(cursorListener) == -1) {
                    this.cursorListeners.add(cursorListener);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCursorListener(CursorListener cursorListener) {
        if (this.cursorListeners != null) {
            ArrayList arrayList = this.cursorListeners;
            synchronized (arrayList) {
                int n = this.cursorListeners.indexOf(cursorListener);
                if (n != -1) {
                    this.cursorListeners.remove(n);
                }
            }
        }
    }

    public CodeEditorGutter getGutter() {
        return this.gutterComponent;
    }

    public FileOverviewMargin getFileOverviewMargin() {
        return this.fileOverviewMargin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCEToolTipProvider(CEToolTipProvider cEToolTipProvider) {
        if (this.editorComponent != null) {
            ArrayList arrayList = this.ceToolTipProviders;
            synchronized (arrayList) {
                if (this.ceToolTipProviders.size() == 0) {
                    this.editorComponent.addToolTipProvider((ToolTipProvider)this);
                }
                this.ceToolTipProviders.add(cEToolTipProvider);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCEToolTipProvider(CEToolTipProvider cEToolTipProvider) {
        if (this.editorComponent != null) {
            ArrayList arrayList = this.ceToolTipProviders;
            synchronized (arrayList) {
                this.ceToolTipProviders.remove(cEToolTipProvider);
                if (this.ceToolTipProviders.size() == 0) {
                    this.editorComponent.removeToolTipProvider((ToolTipProvider)this);
                }
            }
        }
    }

    public boolean gotoOffset(int n, int n2) {
        BasicDocument basicDocument = (BasicDocument)this.editorComponent.getDocument();
        int n3 = basicDocument.getLength();
        int n4 = Math.max(0, Math.min(n, n3));
        int n5 = Math.max(n4, Math.min(n4 + n2, n3));
        this.editorComponent.setCaretPositionCenter(n4);
        if (n4 != n5) {
            this.editorComponent.moveCaretPositionCenter(n5);
        }
        return n == n4 && n2 == n5 - n4;
    }

    public boolean gotoLine(int n, int n2, boolean bl) {
        BasicDocument basicDocument = (BasicDocument)this.editorComponent.getDocument();
        LineMap lineMap = basicDocument.getLineMap();
        int n3 = lineMap.getLineCount();
        boolean bl2 = true;
        if (--n < 0 || n >= n3) {
            n = n < 0 ? 0 : n3 - 1;
            bl2 = false;
        }
        int n4 = lineMap.getLineStartOffset(n);
        int n5 = lineMap.getLineEndOffset(n);
        int n6 = Math.min(n5, n4 + n2);
        if (bl) {
            this.editorComponent.setCaretPositionCenter(n5);
            this.editorComponent.moveCaretPositionCenter(n4);
            this.editorComponent.getCaret().setSelectionVisible(true);
        } else {
            this.editorComponent.setCaretPositionCenter(n6);
        }
        this.editorComponent.requestFocus();
        return bl2;
    }

    public JComponent[] getCustomCells() {
        if (this.statusBar != null) {
            return this.statusBar.getStatusBarCells();
        }
        return null;
    }

    public boolean isExpandable(JComponent jComponent) {
        return false;
    }

    public BasicEditorPane getFocusedEditorPane() {
        return this.editorComponent;
    }

    public void showPopup(BasicEditorPane basicEditorPane, MouseEvent mouseEvent) {
        ContextMenu contextMenu = this.getContextMenu();
        if (contextMenu != null) {
            Context context = new Context(this.getContext());
            Node node = context.getNode();
            context.setSelection(new Element[]{node});
            context.setElement(node);
            context.setEvent(mouseEvent);
            contextMenu.show(context);
        }
    }

    public void hidePopup(BasicEditorPane basicEditorPane) {
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("code-folding-margin")) {
            if (this.codeFoldingMargin != null) {
                this.leftMargin.remove((Component)this.codeFoldingMargin);
            }
            this.codeFoldingMargin = (CodeFoldingMargin)propertyChangeEvent.getNewValue();
            if (this.codeFoldingMargin != null) {
                this.leftMargin.add((Component)this.codeFoldingMargin, "East");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void caretUpdate(CaretEvent caretEvent) {
        CodeEditorController codeEditorController = (CodeEditorController)this.getController();
        Context context = this.getContext();
        if (Ide.getMainWindow().getLastActiveView() == this) {
            codeEditorController.checkCommandsAfterNavigation(context);
        }
        ArrayList arrayList = this.cursorListeners;
        synchronized (arrayList) {
            int n;
            int n2 = n = this.cursorListeners.size();
            while (n2 > 0) {
                CursorListener cursorListener = (CursorListener)this.cursorListeners.get(--n2);
                try {
                    cursorListener.cursorUpdate(this);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
        }
    }

    public int getLineCount() {
        return this.editorComponent.getLineCount();
    }

    public int getLineFromOffset(int n) {
        return this.editorComponent.getLineFromOffset(n) + 1;
    }

    public int getLineStartOffset(int n) {
        return this.editorComponent.getLineStartOffset(n - 1);
    }

    public int getLineEndOffset(int n) {
        return this.editorComponent.getLineEndOffset(n - 1);
    }

    public static Context getContext(BasicEditorPane basicEditorPane) {
        Context context = (Context)basicEditorPane.getProperty(EDITOR_CONTEXT);
        return context;
    }

    protected Element[] getSelectionFromUI() {
        if (this.ideNode != null) {
            return new Element[]{this.ideNode};
        }
        return View.EMPTY_SELECTION;
    }

    public static CodeEditor getCodeEditor(BasicEditorPane basicEditorPane) {
        View view;
        Context context = CodeEditor.getContext(basicEditorPane);
        if (context != null && (view = context.getView()) instanceof CodeEditor) {
            return (CodeEditor)view;
        }
        return null;
    }

    public synchronized void setContext(Context context) {
        Node node;
        if (context != null && (node = context.getNode()) instanceof TextNode) {
            Context context2 = new Context(context);
            Node node2 = context.getNode();
            context2.setSelection(new Element[]{node2});
            context2.setElement(node2);
            if (this.editorComponent == null) {
                this.ideNode = (TextNode)node;
                this.updateSelection();
                super.setContext(context2);
                Context context3 = this.getContext();
                this.initializeEditor(context3);
            } else {
                if (node != this.ideNode) {
                    throw new IllegalStateException("Reset of context w/ different node");
                }
                super.setContext(context2);
                Context context4 = this.getContext();
                this.updateEditorContext(context4);
                if (context2.getProject() == null) {
                    // empty if block
                }
            }
        }
    }

    public void open() {
        this.editorComponent.requestFocus();
    }

    public Component getDefaultFocusComponent() {
        return this.editorComponent;
    }

    public void close() {
        super.close();
        EditorManager.getEditorManager().removeLayoutListener(this.getId());
        if (this.scrollPane != null) {
            this.scrollPane.setViewportView(null);
            this.scrollPane.setRowHeaderView(null);
            this.scrollPane = null;
        }
        this.gutterComponent.removeAllGutterColumns();
        this.gutterComponent = null;
        this.fileOverviewMargin = null;
        if (this.statusBar != null) {
            this.editorComponent.deinstallPlugin((EditorPlugin)this.statusBar);
            this.statusBar = null;
        }
        if (this.topToolbar != null) {
            this.topToolbar.dispose();
            this.topToolbar.removeAll();
        }
        BasicDocument basicDocument = (BasicDocument)this.editorComponent.getDocument();
        basicDocument.removeUndoableEditListener((UndoableEditListener)this);
        this.editorComponent.removePopupManager((PopupManager)this);
        this.editorComponent.removeCaretListener((CaretListener)this);
        this.editorComponent.dispose();
        this.editorComponent = null;
        this.ceToolTipProviders.clear();
        this.ceToolTipProviders = null;
        this.cursorListeners = null;
        this.nodeUpdater = null;
    }

    public Controller getController() {
        return CodeEditorController.getDefaultController();
    }

    public Object getEditorAttribute(String string) {
        if (string.equals("menu_id")) {
            return CEditorArb.getString(6);
        }
        return super.getEditorAttribute(string);
    }

    public void saveSettings(StructuredPropertyAccess structuredPropertyAccess) {
        try {
            int n = this.getCaretPosition();
            structuredPropertyAccess.setProperty(OFFSET_PROP, Integer.toString(n));
            int n2 = this.editorComponent.getIntegerProperty("tab-size");
            structuredPropertyAccess.setProperty(TAB_SIZE_PROP, Integer.toString(n2));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        super.saveSettings(structuredPropertyAccess);
    }

    public void loadSettings(StructuredPropertyAccess structuredPropertyAccess) {
        int n = structuredPropertyAccess.getIntegerProperty(OFFSET_PROP, 0);
        int n2 = structuredPropertyAccess.getIntegerProperty(TAB_SIZE_PROP, 0);
        this.editorComponent.setCaretPositionCenter(n);
        if (n2 != 0) {
            this.editorComponent.putIntegerProperty("tab-size", n2);
        }
        super.loadSettings(structuredPropertyAccess);
    }

    public Component getGUI() {
        return this.editorComponent;
    }

    public Component getScrollableLeftMargin() {
        return this.leftMargin;
    }

    public Component getFixedRightMargin() {
        return this.fileOverviewMargin;
    }

    public Component getFixedTopMargin() {
        return this.getToolbar();
    }

    public Icon getTabIcon() {
        return CEditorArb.getIcon(2);
    }

    public void update(Object object, UpdateMessage updateMessage) {
        int n = updateMessage.getMessageID();
        if (n == UpdateMessage.OBJECT_RENAMED) {
            Node node;
            Node node2;
            List list;
            boolean bl = false;
            List list2 = updateMessage.getAddObjects();
            if (list2.size() == 1 && (list = updateMessage.getRemoveObjects()).size() == 1 && (node2 = (Node)list2.get(0)) == (node = (Node)list.get(0))) {
                bl = true;
            }
            if (bl) {
                this.owner().updateTitle(this);
            } else {
                EditorManager editorManager = EditorManager.getEditorManager();
                editorManager.closeEditors(Collections.singletonList(this));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getToolTipText(BasicEditorPane basicEditorPane, MouseEvent mouseEvent, int n) {
        String string = null;
        ArrayList arrayList = this.ceToolTipProviders;
        synchronized (arrayList) {
            int n2 = this.ceToolTipProviders.size();
            int n3 = 0;
            while (n3 < n2) {
                CEToolTipProvider cEToolTipProvider = (CEToolTipProvider)this.ceToolTipProviders.get(n3);
                string = cEToolTipProvider.getToolTipText(this, mouseEvent, n);
                if (string != null && string.length() > 0) break;
                ++n3;
            }
        }
        return string;
    }

    public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
        UndoableEdit undoableEdit = undoableEditEvent.getEdit();
        UndoWrapperCommand undoWrapperCommand = new UndoWrapperCommand(undoableEdit, this.nodeUpdater);
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        undoWrapperCommand.setContext(this.getContext());
        try {
            commandProcessor.invoke(undoWrapperCommand);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void save(Layout layout) {
    }

    public void init(Layout layout) {
    }

    public void close(Layout layout) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HelpInfo getHelpInfo() {
        HelpInfo helpInfo = null;
        ArrayList arrayList = this.providerList;
        synchronized (arrayList) {
            int n = this.providerList.size();
            boolean bl = false;
            int n2 = n - 1;
            while (n2 >= 0) {
                HelpableProvider helpableProvider = (HelpableProvider)this.providerList.get(n2);
                if (helpableProvider != null) {
                    helpInfo = helpableProvider.getHelpInfo(this);
                } else {
                    bl = true;
                }
                if (helpInfo != null) break;
                --n2;
            }
            if (bl) {
                Iterator iterator = this.providerList.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (e != null) continue;
                    iterator.remove();
                }
            }
        }
        if (helpInfo != null) {
            return helpInfo;
        }
        if (this.helpInfo != null) {
            return this.helpInfo;
        }
        return new HelpInfo("f1_idecodeeditor_html");
    }

    public void setHelpInfo(HelpInfo helpInfo) {
        this.helpInfo = helpInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHelpableProvider(HelpableProvider helpableProvider) {
        ArrayList arrayList = this.providerList;
        synchronized (arrayList) {
            if (!this.providerList.contains(helpableProvider)) {
                this.providerList.add(helpableProvider);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHelpableProvider(HelpableProvider helpableProvider) {
        ArrayList arrayList = this.providerList;
        synchronized (arrayList) {
            int n = this.providerList.indexOf(helpableProvider);
            if (n != -1) {
                this.providerList.set(n, null);
            }
        }
    }

    public void setHelpableProvider(HelpableProvider helpableProvider) {
        this.addHelpableProvider(helpableProvider);
    }

    public HelpableProvider getHelpableProvider() {
        return null;
    }

    private void updateEditorContext(Context context) {
        this.editorComponent.putProperty(EDITOR_CONTEXT, (Object)context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeEditor(Context context) {
        EditorManager.getEditorManager().addLayoutListener(this.getId(), this);
        TextBuffer textBuffer = this.ideNode.acquireTextBuffer();
        this.editorComponent = EditorFactory.createIdeEditorPane();
        this.updateEditorContext(context);
        URL uRL = this.ideNode.getURL();
        URL uRL2 = URLFileSystem.getParent(uRL);
        String string = URLFileSystem.getFileName(uRL);
        String string2 = URLFileSystem.getPlatformPathName(uRL2);
        String string3 = CEditorArb.format(9, string, string2);
        AccessibleUtils.updateAccessibleName((Accessible)this.editorComponent, string3, true);
        String string4 = CodeEditor.getTypeForNode(this.ideNode);
        if (string4 == null) {
            string4 = URLFileSystem.getPlatformPathName(this.ideNode.getURL());
        }
        BasicDocument basicDocument = new BasicDocument(string4, textBuffer);
        basicDocument.addUndoableEditListener((UndoableEditListener)this);
        this.editorComponent.setDocument((Document)basicDocument);
        Attributes attributes = this.ideNode.getAttributes();
        if (attributes.isSet(ElementAttributes.NON_EDITABLE)) {
            this.editorComponent.setProtected(true);
        }
        this.editorComponent.addPopupManager((PopupManager)this);
        this.editorComponent.addCaretListener((CaretListener)this);
        this.editorComponent.setFocusTraversalKeysEnabled(false);
        TrailingSpacePlugin trailingSpacePlugin = new TrailingSpacePlugin();
        this.editorComponent.installPlugin((EditorPlugin)trailingSpacePlugin);
        this.leftMargin = new JPanel(new BorderLayout());
        this.gutterComponent = new CodeEditorGutter(this);
        this.editorComponent.installPlugin((EditorPlugin)this.gutterComponent);
        this.leftMargin.add((Component)((Object)this.gutterComponent), "Center");
        this.editorComponent.addPropertyChangeListener((PropertyChangeListener)this);
        this.fileOverviewMargin = new CEFileOverviewMargin(this);
        this.editorComponent.installPlugin((EditorPlugin)this.fileOverviewMargin);
        this.statusBar = new EditorStatusBar();
        this.editorComponent.installPlugin((EditorPlugin)this.statusBar);
        this.editorComponent.installPlugin((EditorPlugin)new LineHighlightPlugin());
        this.editorComponent.installPlugin((EditorPlugin)new CEDragDropPlugin(null));
        this.editorComponent.installPlugin((EditorPlugin)new CEOpenEditorDropHandler(null));
        List list = pluginsFactoryList;
        synchronized (list) {
            Context context2 = this.getContext();
            int n = pluginsFactoryList.size();
            int n2 = 0;
            while (n2 < n) {
                try {
                    EditorPluginsFactory editorPluginsFactory = (EditorPluginsFactory)pluginsFactoryList.get(n2);
                    List list2 = editorPluginsFactory.createPlugins(context2);
                    int n3 = list2.size();
                    int n4 = 0;
                    while (n4 < n3) {
                        EditorPlugin editorPlugin = (EditorPlugin)list2.get(n4);
                        if (editorPlugin instanceof EditorPlugin) {
                            this.editorComponent.installPlugin(editorPlugin);
                        }
                        ++n4;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n2;
            }
        }
        this.addMakeEditableVetoListeners(this.editorComponent, this.ideNode);
        this.nodeUpdater = NodeUpdater.getUpdater(this.ideNode, textBuffer);
    }

    private void addMakeEditableVetoListeners(BasicEditorPane basicEditorPane, TextNode textNode) {
        basicEditorPane.addVetoableChangeListener((VetoableChangeListener)new 2());
        basicEditorPane.addVetoableChangeListener((VetoableChangeListener)new 1(this, textNode));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getTypeForNode(TextNode textNode) {
        Class<?> clazz = textNode.getClass();
        List list = classList;
        synchronized (list) {
            int n = classList.size();
            int n2 = 0;
            while (n2 < n) {
                Class clazz2 = (Class)classList.get(n2);
                if (clazz2 == clazz) {
                    String string = (String)typeList.get(n2);
                    return string;
                }
                ++n2;
            }
            int n3 = 0;
            while (n3 < n) {
                Class clazz3 = (Class)classList.get(n3);
                if (clazz3.isAssignableFrom(clazz)) {
                    String string = (String)typeList.get(n3);
                    return string;
                }
                ++n3;
            }
        }
        return null;
    }

    protected BasicEditorPane getEditorComponent() {
        return this.editorComponent;
    }

    protected String getEditorText() {
        return this.editorComponent.getText();
    }

    protected boolean canCut() {
        return this.editorComponent.canCut();
    }

    protected boolean canCopy() {
        return this.editorComponent.canCopy();
    }

    protected boolean canPaste() {
        return this.editorComponent.canPaste();
    }

    static DataFlavor ra$CONTEXT_FLAVOR() {
        return CONTEXT_FLAVOR;
    }

    static DataFlavor ra$FILELIST_FLAVOR() {
        return FILELIST_FLAVOR;
    }

    static DataFlavor[] ra$EXTRA_CUSTOM_FLAVORS() {
        return EXTRA_CUSTOM_FLAVORS;
    }

    protected class CEToolbar
    extends Toolbar {
        protected CEToolbar() {
            this.updateVisibility();
        }

        protected void addImpl(Component component, Object object, int n) {
            super.addImpl(component, object, n);
            this.updateVisibility();
        }

        public void remove(int n) {
            super.remove(n);
            this.updateVisibility();
        }

        protected void updateVisibility() {
            boolean bl = this.getComponentCount() > 0;
            this.setVisible(bl);
        }
    }

    public final class 2
    implements VetoableChangeListener {
        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            if (propertyChangeEvent.getPropertyName().equals("consumerVetoForMakeEditable")) {
                throw new PropertyVetoException(null, propertyChangeEvent);
            }
        }
    }

    public final class 1
    implements VetoableChangeListener {
        private long _checkOutFailureTimeMillis;
        private final /* synthetic */ TextNode v$ideNode;
        final /* synthetic */ CodeEditor this$0;

        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            if (!propertyChangeEvent.getPropertyName().equals("isEditable")) {
                return;
            }
            if (!propertyChangeEvent.getOldValue().equals(Boolean.FALSE)) {
                return;
            }
            if (!propertyChangeEvent.getNewValue().equals(Boolean.TRUE)) {
                return;
            }
            if (System.currentTimeMillis() - this._checkOutFailureTimeMillis < 250L) {
                throw new PropertyVetoException(null, propertyChangeEvent);
            }
            VCSManager vCSManager = VCSManager.getVCSManager();
            if (vCSManager != null && !vCSManager.checkOutNode(this.v$ideNode, CommandProcessor.getInstance())) {
                this._checkOutFailureTimeMillis = System.currentTimeMillis();
                throw new PropertyVetoException(null, propertyChangeEvent);
            }
        }

        public 1(CodeEditor codeEditor, TextNode textNode) {
            this.v$ideNode = textNode;
            this.this$0 = codeEditor;
        }
    }

    private final class CEDragDropPlugin
    extends DragDropPlugin {
        protected void handleDragEvent(DropTargetDragEvent dropTargetDragEvent) {
            DropHandlerPlugin[] dropHandlerPluginArray = DropHandlerPlugin.getHandlers(this.editor);
            int n = 0;
            while (n < dropHandlerPluginArray.length) {
                DropHandlerPlugin dropHandlerPlugin = dropHandlerPluginArray[n];
                try {
                    int n2 = dropHandlerPlugin.shouldAllowDrag(dropTargetDragEvent);
                    if (n2 != 0) {
                        Point point = dropHandlerPlugin.getDropLocationToPaint(dropTargetDragEvent);
                        if (point != null) {
                            this.paintDropLocation(point);
                        }
                        dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
                        return;
                    }
                }
                catch (RuntimeException runtimeException) {
                    ExceptionDialog.showExceptionDialog((Component)this.editor, (Throwable)runtimeException);
                    return;
                }
                ++n;
            }
            super.handleDragEvent(dropTargetDragEvent);
        }

        protected void handleDropEvent(DropTargetDropEvent dropTargetDropEvent) {
            DropHandlerPlugin[] dropHandlerPluginArray = DropHandlerPlugin.getHandlers(this.editor);
            int n = 0;
            while (n < dropHandlerPluginArray.length) {
                DropHandlerPlugin dropHandlerPlugin = dropHandlerPluginArray[n];
                try {
                    int n2 = dropHandlerPlugin.shouldAllowDrop(dropTargetDropEvent);
                    if (n2 != 0) {
                        this.clearDropLocation();
                        int n3 = dropTargetDropEvent.getDropAction();
                        if (this.isDropActionSupported(n3)) {
                            dropTargetDropEvent.acceptDrop(n2);
                            boolean bl = dropHandlerPlugin.performDrop(dropTargetDropEvent);
                            dropTargetDropEvent.dropComplete(bl);
                        } else {
                            dropTargetDropEvent.rejectDrop();
                        }
                        return;
                    }
                }
                catch (RuntimeException runtimeException) {
                    ExceptionDialog.showExceptionDialog((Component)this.editor, (Throwable)runtimeException);
                    return;
                }
                ++n;
            }
            super.handleDropEvent(dropTargetDropEvent);
        }

        protected void cancelDragEvent(DropTargetEvent dropTargetEvent) {
            super.cancelDragEvent(dropTargetEvent);
            DropHandlerPlugin[] dropHandlerPluginArray = DropHandlerPlugin.getHandlers(this.editor);
            int n = 0;
            while (n < dropHandlerPluginArray.length) {
                DropHandlerPlugin dropHandlerPlugin = dropHandlerPluginArray[n];
                dropHandlerPlugin.cancelDragEvent(dropTargetEvent);
                ++n;
            }
        }

        private CEDragDropPlugin() {
        }

        CEDragDropPlugin(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private final class CEOpenEditorDropHandler
    extends DropHandlerPlugin {
        protected Point getDropLocationToPaint(DropTargetDragEvent dropTargetDragEvent) {
            return null;
        }

        protected int shouldAllowDrag(DropTargetDragEvent dropTargetDragEvent) {
            return this._allow(dropTargetDragEvent, dropTargetDragEvent.getDropAction());
        }

        protected int shouldAllowDrop(DropTargetDropEvent dropTargetDropEvent) {
            return this._allow(dropTargetDropEvent, dropTargetDropEvent.getDropAction());
        }

        private int _allow(DropTargetEvent dropTargetEvent, int n) {
            int n2 = 0;
            while (n2 < CodeEditor.ra$EXTRA_CUSTOM_FLAVORS().length) {
                if (DndUtils.isDataFlavorSupported((DropTargetEvent)dropTargetEvent, (DataFlavor)CodeEditor.ra$EXTRA_CUSTOM_FLAVORS()[n2])) {
                    return n;
                }
                ++n2;
            }
            return 0;
        }

        protected boolean performDrop(DropTargetDropEvent dropTargetDropEvent) {
            Transferable transferable = dropTargetDropEvent.getTransferable();
            if (transferable.isDataFlavorSupported(CodeEditor.ra$CONTEXT_FLAVOR())) {
                return this.handleContextDrop(transferable);
            }
            if (transferable.isDataFlavorSupported(CodeEditor.ra$FILELIST_FLAVOR())) {
                return this.handleFileListDrop(transferable);
            }
            return false;
        }

        protected boolean handleFileListDrop(Transferable transferable) {
            boolean bl = false;
            try {
                List list = (List)transferable.getTransferData(CodeEditor.ra$FILELIST_FLAVOR());
                for (File file : list) {
                    URL uRL = URLFactory.newFileURL(file);
                    EditorUtil.openDefaultEditorInFrameExternal(uRL);
                }
                bl = true;
            }
            catch (IOException iOException) {
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                // empty catch block
            }
            return bl;
        }

        protected boolean handleContextDrop(Transferable transferable) {
            boolean bl = false;
            try {
                EditorManager editorManager = EditorManager.getEditorManager();
                TransferableContext transferableContext = (TransferableContext)transferable.getTransferData(CodeEditor.ra$CONTEXT_FLAVOR());
                Context context = transferableContext.getContext();
                Element[] elementArray = context.getSelection();
                if (elementArray != null) {
                    int n = elementArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Element element = elementArray[n2];
                        if (element instanceof Node && editorManager.getDefaultAddin(element) != null) {
                            Context context2 = CodeEditor.this.getContext();
                            editorManager.openDefaultEditorInFrame(context2);
                            EditorUtil.openDefaultEditorInFrame(element);
                        }
                        ++n2;
                    }
                }
                bl = true;
            }
            catch (IOException iOException) {
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                // empty catch block
            }
            return bl;
        }

        private CEOpenEditorDropHandler() {
        }

        CEOpenEditorDropHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

