/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.AddinManager;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.ceditor.CEditorArb;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.CodeEditorAddin;
import oracle.ide.ceditor.CodeEditorGutter;
import oracle.ide.ceditor.CodeMenuConstants;
import oracle.ide.ceditor.keymap.EditorKeyStrokes;
import oracle.ide.ceditor.keymap.KeymapManager;
import oracle.ide.ceditor.options.DisplayOptions;
import oracle.ide.ceditor.options.GutterOptionsPanel;
import oracle.ide.ceditor.options.OptionsArb;
import oracle.ide.ceditor.options.PrintingHTMLOptions;
import oracle.ide.cmd.buffer.EditProcessor;
import oracle.ide.config.ClientSetting;
import oracle.ide.config.IdeSettings;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.DynamicMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.WaitCursor;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.TextNode;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.vcs.VCSManager;
import oracle.ide.view.View;
import oracle.ideri.util.Product;
import oracle.javatools.clipboard.ClipboardStack;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.print.DocumentToHTMLGenerator;
import oracle.javatools.editor.print.HTMLGeneratorOptions;

public class CodeEditorController
implements DynamicMenuListener,
ContextMenuListener,
CodeMenuConstants,
Controller {
    public static final int UNDO_WRAPPER_CMD_ID = Ide.findOrCreateCmdID("UndoWrapperCommand");
    public static final int UNDO_WRAPPER_MSG = UpdateMessage.newMessageID("CodeEditorController.UNDO_WRAPPER_MSG");
    private IdeAction ideCutAction;
    private IdeAction ideCopyAction;
    private IdeAction idePasteAction;
    private IdeAction ideExtendedPasteAction;
    private IdeAction ideDeleteAction;
    private IdeAction ideSelectAllAction;
    private IdeAction ideSaveAction;
    private IdeAction ideUndoAction;
    private IdeAction ideRedoAction;
    private IdeAction toggleLineNumberAction;
    private JMenuItem toggleLineNumberMenuItem;
    private IdeAction preferencesAction;
    private JMenuItem preferencesMenuItem;
    private IdeAction printToHTMLAction;
    private JMenuItem printToHTMLMenuItem;
    static CodeEditorController _singleton = null;
    private IdeAction completionInsightAction;
    private IdeAction smartCompletionInsightAction;
    private IdeAction parameterInsightAction;
    private IdeAction toggleCommentsAction;
    private IdeAction blockIndentAction;
    private IdeAction blockOutdentAction;
    private JComponent[] dynamicItems;

    private void initializeActions() {
        if (this.ideCutAction == null) {
            this.ideCutAction = IdeAction.find(17);
            this.ideCopyAction = IdeAction.find(18);
            this.idePasteAction = IdeAction.find(19);
            this.ideExtendedPasteAction = IdeAction.find(78);
            this.ideDeleteAction = IdeAction.find(20);
            this.ideSelectAllAction = IdeAction.find(22);
            this.ideSaveAction = IdeAction.find(11);
            this.ideUndoAction = IdeAction.find(5);
            this.ideRedoAction = IdeAction.find(6);
            int n = Ide.findOrCreateCmdID("ceditor.ToggleLineNumbers");
            String string = CEditorArb.getString(10);
            int n2 = StringUtils.getMnemonicKeyCode((String)string);
            string = StringUtils.stripMnemonic((String)string);
            this.toggleLineNumberAction = IdeAction.get(n, null, string, IdeMainWindow.ACTION_CATEGORY_TOOLS, new Integer(n2), CEditorArb.getInstance(), 11, null, false);
            this.toggleLineNumberAction.addController(this);
            this.toggleLineNumberMenuItem = Ide.getMenubar().createMenuItem(this.toggleLineNumberAction);
            int n3 = Ide.findOrCreateCmdID("CodeEditor.Preferences");
            String string2 = CEditorArb.getString(12);
            int n4 = StringUtils.getMnemonicKeyCode((String)string2);
            string2 = StringUtils.stripMnemonic((String)string2);
            this.preferencesAction = IdeAction.get(n3, null, string2, IdeMainWindow.ACTION_CATEGORY_TOOLS, new Integer(n4), CEditorArb.getInstance(), 13, null, false);
            this.preferencesAction.addController(this);
            this.preferencesMenuItem = Ide.getMenubar().createMenuItem(this.preferencesAction);
            int n5 = Ide.findOrCreateCmdID("CodeEditor.PrintToHTMLCommand");
            String string3 = CEditorArb.getString(29);
            int n6 = StringUtils.getMnemonicKeyCode((String)string3);
            string3 = StringUtils.stripMnemonic((String)string3);
            this.printToHTMLAction = IdeAction.get(n5, null, string3, IdeMainWindow.ACTION_CATEGORY_FILE, new Integer(n6), CEditorArb.getInstance(), 30, null, false);
            float f = MenuConstants.increment(MenuConstants.WEIGHT_FILE_PRINT);
            if (!Product.isRaptor()) {
                Menubar menubar = Ide.getMenubar();
                this.printToHTMLMenuItem = menubar.createMenuItem(this.printToHTMLAction, f);
                JMenu jMenu = MenuManager.getJMenu("File");
                menubar.add(this.printToHTMLMenuItem, jMenu, MenuConstants.SECTION_FILE_PRINT);
            }
        }
    }

    static synchronized CodeEditorController getDefaultController() {
        if (_singleton == null) {
            _singleton = new CodeEditorController();
        }
        return _singleton;
    }

    static synchronized void disposeDefaultController() {
        if (_singleton != null) {
            _singleton.dispose();
            _singleton = null;
        }
    }

    private CodeEditorController() {
        ContextMenu contextMenu;
        ContextMenu contextMenu2;
        EditorManager editorManager = EditorManager.getEditorManager();
        if (editorManager != null && (contextMenu2 = editorManager.getContextMenu()) != null) {
            contextMenu2.addContextMenuListener(this);
        }
        if ((contextMenu = CodeEditorGutter.getGutterContextMenu()) != null) {
            contextMenu.addContextMenuListener(this);
        }
        this.initializeActions();
        if (Product.isRaptor()) {
            this.initializeSourceMenu();
        } else {
            Ide.getMainWindow().addDynamicMenuListener(this);
            this.initializeDynamicActions();
        }
    }

    void dispose() {
        ContextMenu contextMenu;
        ContextMenu contextMenu2;
        EditorManager editorManager = EditorManager.getEditorManager();
        if (editorManager != null && (contextMenu2 = editorManager.getContextMenu()) != null) {
            contextMenu2.removeContextMenuListener(this);
        }
        if ((contextMenu = CodeEditorGutter.getGutterContextMenu()) != null) {
            contextMenu.removeContextMenuListener(this);
        }
        this.toggleLineNumberAction.removeController(this);
        this.preferencesAction.removeController(this);
        this.deinitializeDynamicActions();
    }

    protected void checkCommandsAfterNavigation(Context context) {
        this.update(this.ideCutAction, context);
        this.update(this.ideCopyAction, context);
    }

    private CodeEditor getCodeEditorFromContext(Context context) {
        CodeEditor codeEditor = null;
        View view = context.getView();
        if (view != null) {
            if (view instanceof CodeEditor) {
                codeEditor = (CodeEditor)view;
            } else if (view instanceof CodeEditorGutter.GutterView) {
                codeEditor = (CodeEditor)view.owner();
            }
        }
        return codeEditor;
    }

    public boolean update(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        CodeEditor codeEditor = this.getCodeEditorFromContext(context);
        if (codeEditor == null) {
            if (n == this.completionInsightAction.getCommandId() || n == this.smartCompletionInsightAction.getCommandId() || n == this.parameterInsightAction.getCommandId() || n == this.toggleCommentsAction.getCommandId() || n == this.blockIndentAction.getCommandId() || n == this.blockOutdentAction.getCommandId() || n == this.printToHTMLAction.getCommandId()) {
                ideAction.setEnabled(false);
                return true;
            }
            return false;
        }
        BasicEditorPane basicEditorPane = codeEditor.getEditorComponent();
        boolean bl = basicEditorPane.isEditable();
        if (n == 22) {
            ideAction.setEnabled(true);
            return true;
        }
        if (n == 17) {
            if (basicEditorPane.canCut()) {
                ideAction.setEnabled(true);
            } else {
                VCSManager vCSManager = VCSManager.getVCSManager();
                URL uRL = context.getNode().getURL();
                ideAction.setEnabled(vCSManager != null && vCSManager.isVersioned(uRL));
            }
            return true;
        }
        if (n == 18) {
            ideAction.setEnabled(basicEditorPane.canCopy());
            return true;
        }
        if (n == 19 || n == 78) {
            if (basicEditorPane.canPaste()) {
                ideAction.setEnabled(true);
            } else {
                VCSManager vCSManager = VCSManager.getVCSManager();
                URL uRL = context.getNode().getURL();
                ideAction.setEnabled(vCSManager != null && vCSManager.isVersioned(uRL));
            }
            return true;
        }
        if (n == 20) {
            boolean bl2 = basicEditorPane.isEditable();
            if (bl2) {
                ideAction.setEnabled(bl2);
            } else {
                VCSManager vCSManager = VCSManager.getVCSManager();
                URL uRL = context.getNode().getURL();
                ideAction.setEnabled(vCSManager != null && vCSManager.isVersioned(uRL));
            }
            return true;
        }
        if (n == this.completionInsightAction.getCommandId() || n == this.smartCompletionInsightAction.getCommandId() || n == this.parameterInsightAction.getCommandId() || n == this.toggleCommentsAction.getCommandId() || n == this.blockIndentAction.getCommandId() || n == this.blockOutdentAction.getCommandId()) {
            ideAction.setEnabled(bl);
            return true;
        }
        if (n == this.printToHTMLAction.getCommandId()) {
            ideAction.setEnabled(true);
            return true;
        }
        return false;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        CodeEditor codeEditor = this.getCodeEditorFromContext(context);
        if (codeEditor == null) {
            return n == this.completionInsightAction.getCommandId() || n == this.smartCompletionInsightAction.getCommandId() || n == this.parameterInsightAction.getCommandId() || n == this.toggleCommentsAction.getCommandId() || n == this.blockIndentAction.getCommandId() || n == this.blockOutdentAction.getCommandId() || n == this.printToHTMLAction.getCommandId();
        }
        BasicEditorPane basicEditorPane = codeEditor.getEditorComponent();
        if (n == 17) {
            basicEditorPane.requestFocus();
            basicEditorPane.invokeAction("cut-to-clipboard");
            return true;
        }
        if (n == 18) {
            basicEditorPane.requestFocus();
            basicEditorPane.invokeAction("copy-to-clipboard");
            return true;
        }
        if (n == 19) {
            basicEditorPane.requestFocus();
            basicEditorPane.invokeAction("paste-from-clipboard");
            return true;
        }
        if (n == 78) {
            basicEditorPane.requestFocus();
            if (ClipboardStack.adjustCurrentClipboard()) {
                basicEditorPane.invokeAction("paste-from-clipboard");
            }
            return true;
        }
        if (n == 20) {
            basicEditorPane.requestFocus();
            basicEditorPane.invokeAction("delete-next");
            return true;
        }
        if (n == 22) {
            basicEditorPane.requestFocus();
            basicEditorPane.invokeAction("select-all");
            return true;
        }
        if (n == this.completionInsightAction.getCommandId()) {
            basicEditorPane.requestFocus();
            basicEditorPane.invokeAction("completion-insight");
            return true;
        }
        if (n == this.smartCompletionInsightAction.getCommandId()) {
            basicEditorPane.requestFocus();
            basicEditorPane.invokeAction("smart-completion-insight");
            return true;
        }
        if (n == this.parameterInsightAction.getCommandId()) {
            basicEditorPane.requestFocus();
            basicEditorPane.invokeAction("tooltip-insight");
            return true;
        }
        if (n == this.toggleCommentsAction.getCommandId()) {
            basicEditorPane.requestFocus();
            basicEditorPane.invokeAction("toggle-java-comments");
            return true;
        }
        if (n == this.blockIndentAction.getCommandId()) {
            basicEditorPane.requestFocus();
            basicEditorPane.invokeAction("block-indent");
            return true;
        }
        if (n == this.blockOutdentAction.getCommandId()) {
            basicEditorPane.requestFocus();
            basicEditorPane.invokeAction("block-outdent");
            return true;
        }
        if (n == this.toggleLineNumberAction.getCommandId()) {
            String string = AddinManager.getAddinManager().getExtensionIDForAddin(CodeEditorAddin.class);
            ClientSetting clientSetting = ClientSetting.findOrCreate(string);
            DisplayOptions displayOptions = (DisplayOptions)clientSetting.getData("DisplayOptions");
            boolean bl = displayOptions.getShowLineNumbers();
            displayOptions.setShowLineNumbers(bl ^ true);
            clientSetting.putData("DisplayOptions", displayOptions);
            GutterOptionsPanel.applyOptions(displayOptions);
            basicEditorPane.requestFocus();
            return true;
        }
        if (n == this.preferencesAction.getCommandId()) {
            View view = context.getView();
            String[] stringArray = view instanceof CodeEditorGutter.GutterView ? new String[]{OptionsArb.getString(0), OptionsArb.getString(27)} : new String[]{OptionsArb.getString(0)};
            IdeSettings ideSettings = Ide.getSettings();
            ideSettings.showDialog((Frame)((Object)Ide.getMainWindow()), stringArray);
            basicEditorPane.requestFocus();
            return true;
        }
        if (n == this.printToHTMLAction.getCommandId()) {
            Node node = context.getNode();
            URL uRL = node.getURL();
            String string = URLFileSystem.getPlatformPathName(uRL);
            String string2 = URLFileSystem.getFileName(uRL);
            int n2 = string2.lastIndexOf(46);
            if (n2 != -1) {
                string2 = string2.substring(0, n2) + "_" + string2.substring(n2 + 1);
            }
            string2 = string2 + ".html";
            URL uRL2 = URLFileSystem.getParent(uRL);
            if (uRL2 == null) {
                uRL2 = URLFactory.newDirURL(Ide.getUserHomeDirectory());
            }
            URL uRL3 = URLFactory.newURL(uRL2, string2);
            URLChooser uRLChooser = DialogUtil.newURLChooser(uRL3);
            String string3 = CEditorArb.getString(31);
            int n3 = uRLChooser.showSaveDialog((Component)((Object)Ide.getMainWindow()), string3);
            if (n3 == 0) {
                uRL3 = uRLChooser.getSelectedURL();
                BasicDocument basicDocument = (BasicDocument)basicEditorPane.getDocument();
                DocumentToHTMLGenerator documentToHTMLGenerator = new DocumentToHTMLGenerator(basicDocument, string);
                int n4 = basicEditorPane.getIntegerProperty("tab-size");
                documentToHTMLGenerator.setTabSize(n4);
                ClientSetting clientSetting = ClientSetting.findOrCreate(CodeEditorAddin.getExtensionID());
                PrintingHTMLOptions printingHTMLOptions = (PrintingHTMLOptions)clientSetting.getData("PrintingHTMLOptions");
                PrintingHTMLOptions printingHTMLOptions2 = (PrintingHTMLOptions)((Object)printingHTMLOptions.copyTo(null));
                WaitCursor waitCursor = Ide.getWaitCursor();
                waitCursor.show(500L);
                Node node2 = NodeFactory.find(uRL3);
                try {
                    if (node2 != null && node2 instanceof TextNode && node2.isOpen()) {
                        CharArrayWriter charArrayWriter = new CharArrayWriter();
                        documentToHTMLGenerator.generateHTML((Writer)charArrayWriter, (HTMLGeneratorOptions)printingHTMLOptions2);
                        char[] cArray = charArrayWriter.toCharArray();
                        charArrayWriter.close();
                        EditProcessor.doReplaceAll(cArray, node2, false, "", this);
                    } else {
                        OutputStream outputStream = URLFileSystem.openOutputStream(uRL3);
                        documentToHTMLGenerator.generateHTML(outputStream, (HTMLGeneratorOptions)printingHTMLOptions2);
                        outputStream.close();
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    String string4 = CEditorArb.getString(32);
                    String string5 = CEditorArb.getString(33);
                    ExceptionDialog.showExceptionDialog((Window)((Object)Ide.getMainWindow()), (Exception)unsupportedEncodingException, (String)string4, (String)string5);
                }
                catch (IOException iOException) {
                    String string6 = CEditorArb.getString(32);
                    String string7 = CEditorArb.getString(34);
                    ExceptionDialog.showExceptionDialog((Window)((Object)Ide.getMainWindow()), (Exception)iOException, (String)string6, (String)string7);
                }
                waitCursor.hide();
            }
            return true;
        }
        return false;
    }

    public void menuWillShow(ContextMenu contextMenu) {
        Context context = contextMenu.getContext();
        View view = context.getView();
        if (view != null) {
            if (view instanceof CodeEditor) {
                CodeEditor codeEditor = (CodeEditor)view;
                BasicEditorPane basicEditorPane = codeEditor.getEditorComponent();
                this.ideCopyAction.setEnabled(basicEditorPane.canCopy());
                if (basicEditorPane.canPaste()) {
                    this.idePasteAction.setEnabled(true);
                    this.ideCutAction.setEnabled(true);
                } else {
                    VCSManager vCSManager = VCSManager.getVCSManager();
                    URL uRL = context.getNode().getURL();
                    boolean bl = vCSManager != null && vCSManager.isVersioned(uRL);
                    this.idePasteAction.setEnabled(bl);
                    this.ideCutAction.setEnabled(bl);
                }
                this.ideSelectAllAction.setEnabled(true);
                this.preferencesAction.setEnabled(true);
                contextMenu.add((Component)this.preferencesMenuItem, MenuConstants.SECTION_EDIT_PROPERTIES_CTXT_MENU);
            } else if (view instanceof CodeEditorGutter.GutterView && !CodeEditorGutter.isMarkDroppingDown(context)) {
                this.toggleLineNumberAction.setEnabled(true);
                contextMenu.add((Component)this.toggleLineNumberMenuItem, 4.0f);
                this.preferencesAction.setEnabled(true);
                contextMenu.add((Component)this.preferencesMenuItem, 4.0f);
            }
        }
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    private void deinitializeDynamicActions() {
        Ide.getMainWindow().removeDynamicMenuListener(this);
        this.completionInsightAction = null;
        this.smartCompletionInsightAction = null;
        this.parameterInsightAction = null;
        this.toggleCommentsAction = null;
        this.blockIndentAction = null;
        this.blockOutdentAction = null;
        this.dynamicItems = null;
    }

    private void updateActionName(IdeAction ideAction, String string) {
        int n = StringUtils.getMnemonicKeyCode((String)string);
        ideAction.putValue("Name", StringUtils.stripMnemonic((String)string));
        ideAction.putValue("MnemonicKey", new Integer(n));
    }

    private void initializeSourceMenu() {
        Menubar menubar = Ide.getMenubar();
        String string = CEditorArb.getString(6);
        JMenu jMenu = menubar.createMenu(StringUtils.stripMnemonic((String)string), new Integer(StringUtils.getMnemonicKeyCode((String)string)), MenuConstants.WEIGHT_SOURCE_MENU);
        this.initializeSourceActions();
        menubar.add((Component)menubar.createMenuItem(this.completionInsightAction, 100.0f), jMenu);
        menubar.add((Component)menubar.createMenuItem(this.smartCompletionInsightAction, 105.0f), jMenu);
        menubar.add((Component)menubar.createMenuItem(this.parameterInsightAction, 110.0f), jMenu);
        menubar.add((Component)menubar.createMenuItem(this.toggleCommentsAction, 510.0f), jMenu);
        menubar.add((Component)menubar.createMenuItem(this.blockIndentAction, 520.0f), jMenu);
        menubar.add((Component)menubar.createMenuItem(this.blockOutdentAction, 530.0f), jMenu);
        menubar.add(jMenu);
    }

    private void initializeSourceActions() {
        KeymapManager keymapManager = KeymapManager.getInstance();
        EditorKeyStrokes editorKeyStrokes = keymapManager.getEditorKeyStrokes();
        this.completionInsightAction = editorKeyStrokes.lookupAction("completion-insight");
        this.smartCompletionInsightAction = editorKeyStrokes.lookupAction("smart-completion-insight");
        this.parameterInsightAction = editorKeyStrokes.lookupAction("tooltip-insight");
        this.toggleCommentsAction = editorKeyStrokes.lookupAction("toggle-java-comments");
        this.blockIndentAction = editorKeyStrokes.lookupAction("block-indent");
        this.blockOutdentAction = editorKeyStrokes.lookupAction("block-outdent");
        this.completionInsightAction.addController(this);
        this.smartCompletionInsightAction.addController(this);
        this.parameterInsightAction.addController(this);
        this.toggleCommentsAction.addController(this);
        this.blockIndentAction.addController(this);
        this.blockOutdentAction.addController(this);
        this.updateActionName(this.completionInsightAction, CEditorArb.getString(23));
        this.updateActionName(this.smartCompletionInsightAction, CEditorArb.getString(24));
        this.updateActionName(this.parameterInsightAction, CEditorArb.getString(25));
        this.updateActionName(this.toggleCommentsAction, CEditorArb.getString(26));
        this.updateActionName(this.blockIndentAction, CEditorArb.getString(27));
        this.updateActionName(this.blockOutdentAction, CEditorArb.getString(28));
    }

    private void initializeDynamicActions() {
        this.initializeSourceActions();
        JSeparator jSeparator = new JSeparator();
        jSeparator.putClientProperty("menu-weight", new Float(199.0f));
        JSeparator jSeparator2 = new JSeparator();
        jSeparator2.putClientProperty("menu-weight", new Float(299.0f));
        JSeparator jSeparator3 = new JSeparator();
        jSeparator3.putClientProperty("menu-weight", new Float(399.0f));
        JSeparator jSeparator4 = new JSeparator();
        jSeparator4.putClientProperty("menu-weight", new Float(459.0f));
        JSeparator jSeparator5 = new JSeparator();
        jSeparator5.putClientProperty("menu-weight", new Float(499.0f));
        JSeparator jSeparator6 = new JSeparator();
        jSeparator6.putClientProperty("menu-weight", new Float(599.0f));
        JSeparator jSeparator7 = new JSeparator();
        jSeparator7.putClientProperty("menu-weight", new Float(639.0f));
        Menubar menubar = Ide.getMenubar();
        this.dynamicItems = new JComponent[]{menubar.createMenuItem(this.completionInsightAction, 100.0f), menubar.createMenuItem(this.smartCompletionInsightAction, 105.0f), menubar.createMenuItem(this.parameterInsightAction, 110.0f), menubar.createMenuItem(this.toggleCommentsAction, 510.0f), menubar.createMenuItem(this.blockIndentAction, 520.0f), menubar.createMenuItem(this.blockOutdentAction, 530.0f), jSeparator, jSeparator2, jSeparator3, jSeparator4, jSeparator5, jSeparator6, jSeparator7};
    }

    public JComponent[] gatherDynamicActions(Context context) {
        View view = context.getView();
        if (view != null && view instanceof CodeEditor) {
            return this.dynamicItems;
        }
        return new JComponent[0];
    }
}

