/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.help.HelpInfo;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.util.MnemonicSolver;
import oracle.ide.view.View;
import oracle.javatools.editor.gutter.Gutter;
import oracle.javatools.editor.gutter.GutterColumn;
import oracle.javatools.editor.gutter.GutterColumnListener;
import oracle.javatools.editor.gutter.GutterMark;
import oracle.javatools.editor.gutter.LineGutterPlugin;

public class CodeEditorGutter
extends LineGutterPlugin {
    public static final String COLUMN_NAME_LIGHTBULB = "lightbulb";
    public static final String COLUMN_NAME_BREAKPOINT = "breakpoint";
    public static final String COLUMN_NAME_WATCHPOINT = "watchpoint";
    public static final String COLUMN_NAME_IP = "ip";
    public static final int MARK_ORDER_BREAKPOINT = 0;
    public static final int MARK_ORDER_WATCHPOINT_ZERO = 1000;
    public static final int MARK_ORDER_BOOKMARK = 2000;
    public static final int MARK_ORDER_TODO = 5000;
    public static final int MARK_ORDER_IMPLEMENTS = 3000;
    public static final int MARK_ORDER_OVERRIDES = 4000;
    public static final int MARK_ORDER_LIGHTBULB = 6000;
    public static final int MARK_ORDER_EXECUTION = 7000;
    public static final int MARK_OPTION_CLICK_DROPS_MENU = 65536;
    private static final String GUTTER_MARK = "CodeEditorContext.GUTTER_MARK";
    private static final String LINE_NUMBER = "CodeEditorContext.LINE_NUMBER";
    private static final String DROPPING_DOWN = "CodeEditorContext.DROPPING_DOWN";
    private static ContextMenu _contextMenu = new ContextMenu(new MnemonicSolver());
    private static boolean _contextMenuWasDropped = false;
    private static GutterMark _lastDroppedContextMenuMark = null;
    private CodeEditor _codeEditor;
    private final GutterView _gutterView;
    private static final int TW = 2;
    protected static Polygon _triangle = new Polygon(new int[]{0, 2, 4}, new int[]{0, 2, 0}, 3);

    public static ContextMenu getGutterContextMenu() {
        return _contextMenu;
    }

    public static CodeEditorGutter getGutterFor(GutterColumn gutterColumn) {
        Gutter gutter = gutterColumn.getGutter();
        return (CodeEditorGutter)gutter;
    }

    public static CodeEditorGutter getGutterFor(GutterMark gutterMark) {
        Gutter gutter = gutterMark.getGutter();
        return (CodeEditorGutter)gutter;
    }

    public static GutterMark getMarkForContext(Context context) {
        if (context == null) {
            return null;
        }
        return (GutterMark)context.getProperty(GUTTER_MARK);
    }

    public static boolean isMarkDroppingDown(Context context) {
        if (context == null) {
            return false;
        }
        return Boolean.TRUE.equals(context.getProperty(DROPPING_DOWN));
    }

    public static int getLineForContext(Context context) {
        if (context == null) {
            return -1;
        }
        Integer n = (Integer)context.getProperty(LINE_NUMBER);
        if (n == null) {
            return -1;
        }
        return n;
    }

    CodeEditorGutter(CodeEditor codeEditor) {
        this._codeEditor = codeEditor;
        this._gutterView = new GutterView(null);
    }

    public Context getContext() {
        return this._gutterView.getContext();
    }

    public CodeEditor getCodeEditor() {
        return this._codeEditor;
    }

    public View getCodeEditorGutterView() {
        return this._gutterView;
    }

    protected LineGutterPlugin.Column createGutterColumnImpl(String string, GutterColumnListener gutterColumnListener) {
        return new CEColumn(string, gutterColumnListener);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            return;
        }
        super.mouseDragged(mouseEvent);
    }

    protected void processMousePressed(MouseEvent mouseEvent, int n, GutterMark gutterMark) {
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            this.showGutterContextMenu(mouseEvent, n, gutterMark);
        } else {
            super.processMousePressed(mouseEvent, n, gutterMark);
        }
    }

    protected void showGutterContextMenu(MouseEvent mouseEvent, int n, GutterMark gutterMark) {
        ContextMenu contextMenu = this.getContextMenu();
        if (contextMenu != null) {
            _lastDroppedContextMenuMark = null;
            contextMenu.show(this.getContext(mouseEvent, n, gutterMark, false));
        }
    }

    protected void showMarkDropdownMenu(MouseEvent mouseEvent, GutterMark gutterMark, int n) {
        ContextMenu contextMenu = this.getContextMenu();
        if (contextMenu != null) {
            if (_contextMenuWasDropped && gutterMark == _lastDroppedContextMenuMark) {
                return;
            }
            Rectangle rectangle = this.getRolloverRectFor(gutterMark);
            MouseEvent mouseEvent2 = mouseEvent;
            if (rectangle != null) {
                int n2 = rectangle.x;
                int n3 = rectangle.y + rectangle.height + 1;
                mouseEvent2 = new MouseEvent((Component)mouseEvent.getSource(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), n2, n3, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton());
            }
            _lastDroppedContextMenuMark = gutterMark;
            contextMenu.show(this.getContext(mouseEvent2, n, gutterMark, true));
        }
    }

    private Context getContext(EventObject eventObject, int n, GutterMark gutterMark, boolean bl) {
        Context context = this._gutterView.getContext(eventObject);
        int n2 = this._codeEditor.getLineCount();
        boolean bl2 = n > 0 && n <= n2;
        Integer n3 = bl2 ? new Integer(n) : null;
        context.setProperty(LINE_NUMBER, n3);
        context.setProperty(GUTTER_MARK, gutterMark);
        context.setProperty(DROPPING_DOWN, bl);
        return context;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Container container = this.getContextMenu().getGUI(false);
        _contextMenuWasDropped = container != null && container.isVisible();
        super.mousePressed(mouseEvent);
    }

    protected Rectangle paintRollover(Graphics graphics, GutterMark gutterMark, int n, int n2, int n3) {
        Rectangle rectangle = super.paintRollover(graphics, gutterMark, n, n2, n3);
        CEColumn cEColumn = (CEColumn)gutterMark.getGutterColumn();
        if (rectangle != null && cEColumn.isOptionSet(gutterMark, 65536)) {
            int n4 = rectangle.x + rectangle.width - 4 - 2;
            int n5 = rectangle.y + 2;
            Color color = graphics.getColor();
            graphics.translate(n4, n5);
            graphics.setColor(this.getForeground());
            graphics.fillPolygon(_triangle);
            graphics.drawPolygon(_triangle);
            graphics.translate(-n4, -n5);
            graphics.setColor(color);
        }
        return rectangle;
    }

    public String toString() {
        return "gutter " + this._codeEditor.getContext().getNode().getShortLabel();
    }

    private ContextMenu getContextMenu() {
        return this._gutterView.getContextMenu();
    }

    static CodeEditor ra$_codeEditor(CodeEditorGutter codeEditorGutter) {
        return codeEditorGutter._codeEditor;
    }

    static GutterView ra$_gutterView(CodeEditorGutter codeEditorGutter) {
        return codeEditorGutter._gutterView;
    }

    protected class CEColumn
    extends LineGutterPlugin.Column {
        protected CEColumn(String string, GutterColumnListener gutterColumnListener) {
            super((LineGutterPlugin)CodeEditorGutter.this, string, gutterColumnListener);
        }

        protected boolean isOptionSet(GutterMark gutterMark, int n) {
            LineGutterPlugin.Column.Mark mark = (LineGutterPlugin.Column.Mark)gutterMark;
            return mark.isOptionSet(n);
        }

        protected void fireMarkClicked(MouseEvent mouseEvent, GutterMark gutterMark, int n) {
            if (this.isOptionSet(gutterMark, 65536)) {
                CodeEditorGutter.this.showMarkDropdownMenu(mouseEvent, gutterMark, n);
            } else {
                super.fireMarkClicked(mouseEvent, gutterMark, n);
            }
        }
    }

    public final class GutterView
    extends View {
        private GutterView() {
            this.setOwner(CodeEditorGutter.ra$_codeEditor(CodeEditorGutter.this));
        }

        public Controller getController() {
            return CodeEditorGutter.ra$_codeEditor(CodeEditorGutter.this).getController();
        }

        public boolean isVisible() {
            return CodeEditorGutter.ra$_codeEditor(CodeEditorGutter.this).isVisible();
        }

        public Component getGUI() {
            return CodeEditorGutter.this;
        }

        public Context getContext(EventObject eventObject) {
            Context context = CodeEditorGutter.ra$_codeEditor(CodeEditorGutter.this).getContext();
            Context context2 = new Context(context);
            Node node = context2.getNode();
            context2.setSelection(new Element[]{node});
            context2.setElement(node);
            context2.setView(CodeEditorGutter.ra$_gutterView(CodeEditorGutter.this));
            context2.setEvent(eventObject);
            return context2;
        }

        public ContextMenu getContextMenu() {
            return CodeEditorGutter.getGutterContextMenu();
        }

        protected String newId() {
            return CodeEditorGutter.ra$_codeEditor(CodeEditorGutter.this).getId();
        }

        public HelpInfo getHelpInfo() {
            return CodeEditorGutter.ra$_codeEditor(CodeEditorGutter.this).getHelpInfo();
        }

        GutterView(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

