/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor;

import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.find.FindableEditor;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorInfo;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Node;
import oracle.ide.model.TextBufferTracker;
import oracle.ide.model.TextNode;
import oracle.ide.navigation.DefaultNavigationPoint;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;

public class CodeNavigationPoint
extends DefaultNavigationPoint {
    protected int start;
    protected int selLength;
    protected int change;
    protected TextBufferTracker tracker;
    protected Class preferredType;
    protected boolean explicit;

    void $init$() {
        this.preferredType = CodeEditor.class;
    }

    public CodeNavigationPoint() {
        this.$init$();
    }

    protected CodeNavigationPoint(Context context, int n, int n2) {
        this();
        this.setContext(context);
        this.start = n >= 0 ? n : 0;
        this.selLength = n2 >= 0 ? n2 : 0;
    }

    public void setContext(Context context) {
        Node node;
        super.setContext(context);
        Node node2 = node = context != null ? context.getNode() : null;
        if (node instanceof TextNode) {
            this.tracker = TextBufferTracker.getTracker((TextNode)node);
            this.change = this.tracker != null ? this.tracker.getVersion() : 0;
        } else {
            this.tracker = null;
            this.change = 0;
        }
    }

    public Object copyTo(Object object) {
        CodeNavigationPoint codeNavigationPoint = object != null ? (CodeNavigationPoint)object : new CodeNavigationPoint();
        this.copyToImpl(codeNavigationPoint);
        return codeNavigationPoint;
    }

    protected final void copyToImpl(CodeNavigationPoint codeNavigationPoint) {
        super.copyToImpl(codeNavigationPoint);
        codeNavigationPoint.tracker = this.tracker;
        codeNavigationPoint.start = this.start;
        codeNavigationPoint.selLength = this.selLength;
        codeNavigationPoint.change = this.change;
        codeNavigationPoint.preferredType = this.preferredType;
        codeNavigationPoint.explicit = this.explicit;
    }

    public void refresh() {
        Editor editor;
        EditorInfo editorInfo = CodeNavigationPoint.findEditorInfo(this.viewID, this.nodeURL);
        Editor editor2 = editor = editorInfo != null ? editorInfo._getEditor() : null;
        if (editor instanceof FindableEditor) {
            try {
                BasicEditorPane basicEditorPane = ((FindableEditor)((Object)editor)).getFocusedEditorPane();
                this.change = this.tracker != null ? this.tracker.getVersion() : this.change;
                this.start = basicEditorPane.getSelectionStart();
                this.selLength = basicEditorPane.getSelectionEnd() - basicEditorPane.getSelectionStart();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setExplicit(boolean bl) {
        this.explicit = bl;
    }

    protected int renavigate() throws Exception {
        Editor editor = this.findOrCreateEditor(true);
        if (editor == null) {
            return 1;
        }
        if (editor instanceof FindableEditor && this.start >= 0) {
            int[] nArray = new int[]{this.start, this.selLength};
            if (this.tracker != null) {
                this.tracker.adjustOffsetLength(this.start, this.selLength, this.change, nArray);
            }
            CodeNavigationPoint.gotoOffset((FindableEditor)((Object)editor), nArray[0], nArray[1]);
        }
        return 0;
    }

    public Class getPreferredEditorType() {
        return this.preferredType;
    }

    public void setPreferredEditorType(Class clazz) {
        this.preferredType = clazz;
    }

    protected Editor findOrCreateEditor(boolean bl) {
        EditorManager editorManager;
        Editor editor;
        EditorInfo editorInfo = CodeNavigationPoint.findEditorInfo(this.viewID, this.nodeURL);
        Editor editor2 = editor = editorInfo != null ? editorInfo._getEditor() : null;
        if (editor == null) {
            EditorManager editorManager2 = EditorManager.getEditorManager();
            if (editorManager2 == null) {
                return null;
            }
            Class clazz = this.getPreferredEditorType();
            editor = clazz == null ? editorManager2.openDefaultEditorInFrame(this.getContext()) : editorManager2.openEditorInFrame(clazz, this.getContext());
            if (editor != null) {
                editorManager2.setExplicit(editor, this.explicit);
                this.viewClass = editor.getClass();
                this.viewID = editor.getId();
            }
        } else if (bl && (editorManager = EditorManager.getEditorManager()) != null) {
            editorManager.activateEditor(editorInfo);
        }
        return editor;
    }

    protected static void gotoOffset(FindableEditor findableEditor, int n, int n2) {
        BasicEditorPane basicEditorPane = findableEditor.getFocusedEditorPane();
        BasicDocument basicDocument = (BasicDocument)basicEditorPane.getDocument();
        int n3 = basicDocument.getLength();
        int n4 = Math.max(0, Math.min(n, n3));
        int n5 = Math.max(n4, Math.min(n4 + n2, n3));
        basicEditorPane.setCaretPositionCenter(n4);
        if (n4 != n5) {
            basicEditorPane.moveCaretPositionCenter(n5);
        }
    }
}

