/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor;

import java.awt.Component;
import java.awt.Point;
import java.awt.Window;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.plugins.EditorPlugin;

public abstract class DropHandlerPlugin
implements EditorPlugin {
    private BasicEditorPane editor;
    private static String HANDLER_PROPERTY = "*DHPRegisterList*";

    public final void install(BasicEditorPane basicEditorPane) {
        this.editor = basicEditorPane;
        DropHandlerPlugin.registerHandler(this, basicEditorPane);
    }

    public void deinstall(BasicEditorPane basicEditorPane) {
        DropHandlerPlugin.unregisterHandler(this, this.editor);
        this.editor = null;
    }

    protected final BasicEditorPane getEditorPane() {
        return this.editor;
    }

    protected final BasicDocument getDocument() {
        return (BasicDocument)this.editor.getDocument();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    static synchronized void registerHandler(DropHandlerPlugin dropHandlerPlugin, BasicEditorPane basicEditorPane) {
        ArrayList<DropHandlerPlugin> arrayList = (ArrayList<DropHandlerPlugin>)basicEditorPane.getProperty(HANDLER_PROPERTY);
        if (arrayList == null) {
            arrayList = new ArrayList<DropHandlerPlugin>(5);
            basicEditorPane.putProperty(HANDLER_PROPERTY, arrayList);
        }
        if (!arrayList.contains(dropHandlerPlugin)) {
            arrayList.add(dropHandlerPlugin);
        }
    }

    static synchronized void unregisterHandler(DropHandlerPlugin dropHandlerPlugin, BasicEditorPane basicEditorPane) {
        List list = (List)basicEditorPane.getProperty(HANDLER_PROPERTY);
        if (list != null) {
            list.remove(dropHandlerPlugin);
        }
    }

    static synchronized DropHandlerPlugin[] getHandlers(BasicEditorPane basicEditorPane) {
        List list = (List)basicEditorPane.getProperty(HANDLER_PROPERTY);
        if (list != null) {
            int n = list.size();
            return list.toArray(new DropHandlerPlugin[n]);
        }
        return new DropHandlerPlugin[0];
    }

    protected final void raiseEditorToFront() {
        Window window = SwingUtilities.getWindowAncestor((Component)this.editor);
        if (window != null) {
            window.toFront();
        }
        this.editor.requestFocus();
    }

    protected abstract int shouldAllowDrag(DropTargetDragEvent var1);

    protected abstract int shouldAllowDrop(DropTargetDropEvent var1);

    protected void cancelDragEvent(DropTargetEvent dropTargetEvent) {
    }

    protected Point getDropLocationToPaint(DropTargetDragEvent dropTargetDragEvent) {
        return dropTargetDragEvent.getLocation();
    }

    protected abstract boolean performDrop(DropTargetDropEvent var1);
}

