/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.Caret;
import oracle.ide.Ide;
import oracle.ide.ceditor.CEditorArb;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicCaret;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.FeedbackManager;
import oracle.javatools.editor.Utilities;
import oracle.javatools.editor.plugins.EditorPlugin;

public class EditorStatusBar
implements FeedbackManager,
EditorPlugin,
ChangeListener,
ActionListener {
    private BasicEditorPane editor;
    private JPanel mainPanel;
    private StatusBarCell insertOverwriteCell;
    private StatusBarCell lineNumberCell;
    private StatusBarCell eolTypeCell;
    private StatusBarCell modifiedCell;
    private JComponent[] cells;
    private Timer feedbackTimer;
    private Timer caretTimer;
    private static final int CARET_TIMER_DELAY = 100;
    private int lastOffset;
    private String lastMessage;
    private int lastId;
    private static char[] digitArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    public static final String BLANK_MESSAGE = " ";
    public static final String INSERT_MODE = CEditorArb.getString(14);
    public static final String OVERWRITE_MODE = CEditorArb.getString(15);
    public static final String LINE_COLUMN = CEditorArb.getString(16);
    public static final String EOL_MACINTOSH = CEditorArb.getString(17);
    public static final String EOL_UNIX = CEditorArb.getString(18);
    public static final String EOL_WINDOWS = CEditorArb.getString(19);
    public static final String MODIFIED = CEditorArb.getString(20);
    public static final String READ_ONLY = CEditorArb.getString(21);
    public static final String PROTECTED = CEditorArb.getString(22);
    public static final String[] INSERT_OVERWRITE_CELL_STRINGS;
    public static final String[] EOL_CELL_STRINGS;
    public static final String[] MODIFIED_CELL_STRINGS;
    public static final String[] LINE_NUMBER_CELL_STRINGS;
    private static final StringBuffer scratchBuffer;

    public EditorStatusBar() {
        this.createCells();
    }

    public void install(BasicEditorPane basicEditorPane) {
        this.lastOffset = -1;
        this.lastId = -1;
        this.editor = basicEditorPane;
        basicEditorPane.addFeedbackManager((FeedbackManager)this);
        Caret caret = basicEditorPane.getCaret();
        caret.addChangeListener(this);
        this.feedbackTimer = new Timer(5000, this);
        this.feedbackTimer.setRepeats(false);
        this.caretTimer = new Timer(100, this);
        this.caretTimer.setRepeats(false);
        this.updateAllCells();
        StatusBarUpdater.mav$registerStatusBar(StatusBarUpdater.maS$getUpdater(), this);
    }

    public void deinstall(BasicEditorPane basicEditorPane) {
        StatusBarUpdater.mav$unregisterStatusBar(StatusBarUpdater.maS$getUpdater(), this);
        this.feedbackTimer.stop();
        this.feedbackTimer = null;
        this.caretTimer.stop();
        this.caretTimer = null;
        Caret caret = basicEditorPane.getCaret();
        if (caret != null) {
            caret.removeChangeListener(this);
        }
        basicEditorPane.removeFeedbackManager((FeedbackManager)this);
        basicEditorPane = null;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        boolean bl = false;
        if (string.equals("caret")) {
            Object object;
            Object object2 = propertyChangeEvent.getOldValue();
            if (object2 instanceof Caret) {
                Caret caret = (Caret)object2;
                caret.removeChangeListener(this);
            }
            if ((object = propertyChangeEvent.getNewValue()) instanceof Caret) {
                Caret caret = (Caret)object;
                caret.addChangeListener(this);
            }
            bl = true;
        } else if (string.equals("tab-size")) {
            bl = true;
        }
        if (bl) {
            this.lastOffset = -1;
            this.lastId = -1;
            this.updateAllCells();
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (!this.caretTimer.isRunning()) {
            this.caretTimer.restart();
        }
    }

    public void showFeedback(BasicEditorPane basicEditorPane, String string) {
        this.feedbackTimer.stop();
        this.setStatusBarMessage(string);
    }

    private void setStatusBarMessage(String string) {
        Ide.getStatusBar().setText(string);
    }

    private void clearStatusBarMessage(String string) {
        if (Ide.getStatusBar().getText().equals(string)) {
            Ide.getStatusBar().setText(BLANK_MESSAGE);
        }
    }

    private void clearStatusBarMessage() {
        Ide.getStatusBar().setText(BLANK_MESSAGE);
    }

    public void showFeedback(BasicEditorPane basicEditorPane, String string, int n) {
        this.feedbackTimer.stop();
        this.feedbackTimer.setInitialDelay(n);
        this.feedbackTimer.setDelay(n);
        this.feedbackTimer.start();
        this.lastMessage = string;
        this.setStatusBarMessage(string);
    }

    public void hideFeedback(BasicEditorPane basicEditorPane) {
        this.feedbackTimer.stop();
        this.clearStatusBarMessage();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.feedbackTimer) {
            this.clearStatusBarMessage(this.lastMessage);
            this.lastMessage = null;
        } else if (object == this.caretTimer) {
            this.updateAllCells();
        }
    }

    static {
        scratchBuffer = new StringBuffer();
        INSERT_OVERWRITE_CELL_STRINGS = new String[]{INSERT_MODE, OVERWRITE_MODE, READ_ONLY, PROTECTED};
        EOL_CELL_STRINGS = new String[]{EOL_MACINTOSH, EOL_UNIX, EOL_WINDOWS};
        MODIFIED_CELL_STRINGS = new String[]{MODIFIED};
        LINE_NUMBER_CELL_STRINGS = new String[]{EditorStatusBar.getLineColumnText(LINE_COLUMN, 1234, 123)};
    }

    public JComponent[] getStatusBarCells() {
        return this.cells;
    }

    private void createCells() {
        this.insertOverwriteCell = new StatusBarCell("Insert", INSERT_OVERWRITE_CELL_STRINGS);
        this.insertOverwriteCell.setHorizontalAlignment(2);
        this.eolTypeCell = new StatusBarCell("EOL", EOL_CELL_STRINGS);
        this.eolTypeCell.setHorizontalAlignment(2);
        this.modifiedCell = new StatusBarCell("Modified", MODIFIED_CELL_STRINGS);
        this.modifiedCell.setHorizontalAlignment(2);
        this.lineNumberCell = new StatusBarCell("LineCol", LINE_NUMBER_CELL_STRINGS);
        this.lineNumberCell.setHorizontalAlignment(2);
        this.cells = new JComponent[]{this.lineNumberCell, this.insertOverwriteCell, this.modifiedCell, this.eolTypeCell};
    }

    private int getTabSize() {
        Integer n = (Integer)this.editor.getProperty("tab-size");
        int n2 = n != null ? n : 8;
        return n2;
    }

    private void updateAllCells() {
        this.updateCaretCell();
        this.updateOtherCells();
    }

    private void updateCaretCell() {
        if (this.editor != null) {
            String string = BLANK_MESSAGE;
            BasicDocument basicDocument = (BasicDocument)this.editor.getDocument();
            TextBuffer textBuffer = basicDocument.getTextBuffer();
            int n = 0;
            int n2 = 0;
            basicDocument.readLock();
            try {
                int n3 = this.editor.getCaretPosition();
                if (n3 == this.lastOffset && textBuffer.getChangeId() == this.lastId) {
                    basicDocument.readUnlock();
                    return;
                }
                this.lastOffset = n3;
                this.lastId = textBuffer.getChangeId();
                LineMap lineMap = basicDocument.getLineMap();
                n = lineMap.getLineFromOffset(n3);
                int n4 = this.getTabSize();
                n2 = Utilities.getColumnFromOffset((TextBuffer)textBuffer, (int)n, (int)n3, (int)n4);
            }
            finally {
                basicDocument.readUnlock();
            }
            string = EditorStatusBar.getLineColumnText(LINE_COLUMN, ++n, ++n2);
            this.lineNumberCell.setText(string);
        }
    }

    private void appendNumber(StringBuffer stringBuffer, int n) {
        if (n < 10) {
            stringBuffer.append(digitArray[n]);
            return;
        }
        int n2 = EditorStatusBar.numDigits(n);
        int n3 = 0;
        while (n3 < n2) {
            stringBuffer.append(' ');
            ++n3;
        }
        int n4 = n;
        int n5 = stringBuffer.length() + n2 - 1;
        while (n2-- > 0) {
            int n6 = n4 % 10;
            n4 /= 10;
            stringBuffer.setCharAt(n5--, digitArray[n6]);
        }
    }

    private static int numDigits(int n) {
        if (n < 100) {
            return n < 10 ? 1 : 2;
        }
        if (n < 10000) {
            return n < 1000 ? 3 : 4;
        }
        int n2 = 0;
        do {
            ++n2;
        } while ((n /= 10) != 0);
        return n2;
    }

    private void updateOtherCells() {
        if (this.editor != null) {
            String string;
            String string2;
            String string3;
            BasicCaret basicCaret;
            boolean bl;
            Caret caret;
            String string4 = BLANK_MESSAGE;
            String string5 = BLANK_MESSAGE;
            String string6 = BLANK_MESSAGE;
            BasicDocument basicDocument = (BasicDocument)this.editor.getDocument();
            TextBuffer textBuffer = basicDocument.getTextBuffer();
            boolean bl2 = textBuffer.isReadOnly();
            boolean bl3 = this.editor.isProtected();
            string4 = bl2 ? READ_ONLY : (bl3 ? PROTECTED : ((caret = this.editor.getCaret()) != null && caret instanceof BasicCaret ? ((bl = (basicCaret = (BasicCaret)caret).getInsertMode()) ? INSERT_MODE : OVERWRITE_MODE) : INSERT_MODE));
            String string7 = textBuffer.getEOLType();
            string6 = string7 == "\r\n" ? EOL_WINDOWS : (string7 == "\n" ? EOL_UNIX : EOL_MACINTOSH);
            if (textBuffer.isModified()) {
                string5 = MODIFIED;
            }
            if ((string3 = this.insertOverwriteCell.getText()) != string4) {
                this.insertOverwriteCell.setText(string4);
            }
            if ((string2 = this.eolTypeCell.getText()) != string6) {
                this.eolTypeCell.setText(string6);
            }
            if ((string = this.modifiedCell.getText()) != string5) {
                this.modifiedCell.setText(string5);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getLineColumnText(String string, int n, int n2) {
        String string2;
        StringBuffer stringBuffer = scratchBuffer;
        synchronized (stringBuffer) {
            scratchBuffer.delete(0, scratchBuffer.length());
            scratchBuffer.append(LINE_COLUMN);
            int n3 = LINE_COLUMN.indexOf("{0}");
            int n4 = LINE_COLUMN.indexOf("{1}");
            if (n3 < n4) {
                if (n4 != -1) {
                    scratchBuffer.replace(n4, n4 + 3, Integer.toString(n2));
                }
                if (n3 != -1) {
                    scratchBuffer.replace(n3, n3 + 3, Integer.toString(n));
                }
            } else {
                if (n3 != -1) {
                    scratchBuffer.replace(n3, n3 + 3, Integer.toString(n));
                }
                if (n4 != -1) {
                    scratchBuffer.replace(n4, n4 + 3, Integer.toString(n2));
                }
            }
            string2 = scratchBuffer.toString();
        }
        return string2;
    }

    static void mav$updateAllCells(EditorStatusBar editorStatusBar) {
        editorStatusBar.updateAllCells();
    }

    protected static class StatusBarCell
    extends JLabel {
        private String[] cellStrings;
        private int minimumHeight = 0;
        private int minimumWidth = 0;
        private int preferredWidth;

        protected StatusBarCell(String string, String[] stringArray) {
            this.cellStrings = stringArray;
            this.setName(string);
        }

        protected void updateSize() {
            Font font = this.getFont();
            if (font != null) {
                FontMetrics fontMetrics = this.getFontMetrics(font);
                int n = fontMetrics.stringWidth(this.getText());
                if (this.cellStrings != null) {
                    int n2 = this.cellStrings.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        n = Math.max(n, fontMetrics.stringWidth(this.cellStrings[n3]));
                        ++n3;
                    }
                }
                int n4 = fontMetrics.getHeight();
                int n5 = 0;
                int n6 = 0;
                Border border = this.getBorder();
                if (border != null) {
                    Insets insets = border.getBorderInsets(this);
                    n5 = insets.top + insets.bottom;
                    n6 = insets.left + insets.right;
                }
                this.minimumHeight = n4 + n5;
                this.minimumWidth = n + n6;
                this.preferredWidth = this.minimumWidth + fontMetrics.charWidth('m');
            }
        }

        public Dimension getMinimumSize() {
            return new Dimension(this.minimumWidth, this.minimumHeight);
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.preferredWidth, this.minimumHeight);
        }

        public void setFont(Font font) {
            super.setFont(font);
            this.updateSize();
        }

        public void setBorder(Border border) {
            super.setBorder(border);
            this.updateSize();
        }
    }

    private static final class StatusBarUpdater
    implements ActionListener {
        private static final StatusBarUpdater singleton = new StatusBarUpdater();
        private static final int UPDATE_DELAY = 1000;
        private List statusbarList = new ArrayList();
        private Timer updateTimer = new Timer(1000, this);

        private static StatusBarUpdater getUpdater() {
            return singleton;
        }

        private StatusBarUpdater() {
            this.updateTimer.setRepeats(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void registerStatusBar(EditorStatusBar editorStatusBar) {
            List list = this.statusbarList;
            synchronized (list) {
                WeakReference<EditorStatusBar> weakReference = new WeakReference<EditorStatusBar>(editorStatusBar);
                this.statusbarList.add(weakReference);
            }
            this.updateTimer.restart();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void unregisterStatusBar(EditorStatusBar editorStatusBar) {
            List list = this.statusbarList;
            synchronized (list) {
                int n = this.statusbarList.size();
                int n2 = 0;
                while (n2 < n) {
                    WeakReference weakReference;
                    Object e = this.statusbarList.get(n2);
                    if (e != null && (weakReference = (WeakReference)e).get() == editorStatusBar) {
                        weakReference.clear();
                        this.statusbarList.set(n2, null);
                        break;
                    }
                    ++n2;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            List list = this.statusbarList;
            synchronized (list) {
                int n = this.statusbarList.size();
                int n2 = n - 1;
                while (n2 >= 0) {
                    WeakReference weakReference;
                    Object e = this.statusbarList.get(n2);
                    if (e != null && (weakReference = (WeakReference)e).get() != null) {
                        EditorStatusBar editorStatusBar = (EditorStatusBar)weakReference.get();
                        EditorStatusBar.mav$updateAllCells(editorStatusBar);
                    } else {
                        this.statusbarList.remove(n2);
                    }
                    --n2;
                }
                if (this.statusbarList.size() == 0) {
                    this.updateTimer.stop();
                }
            }
        }

        static StatusBarUpdater maS$getUpdater() {
            return StatusBarUpdater.getUpdater();
        }

        static void mav$unregisterStatusBar(StatusBarUpdater statusBarUpdater, EditorStatusBar editorStatusBar) {
            statusBarUpdater.unregisterStatusBar(editorStatusBar);
        }

        static void mav$registerStatusBar(StatusBarUpdater statusBarUpdater, EditorStatusBar editorStatusBar) {
            statusBarUpdater.registerStatusBar(editorStatusBar);
        }
    }
}

