/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor;

import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.CodeNavigationPoint;
import oracle.ide.editor.Editor;

public class LineNavigationPoint
extends CodeNavigationPoint {
    protected boolean hilight;
    protected boolean translate;

    public LineNavigationPoint(Context context, int n, int n2, boolean bl) {
        this.setContext(context);
        this.start = n;
        this.selLength = n2;
        this.hilight = bl;
    }

    public LineNavigationPoint(Context context, int n, boolean bl) {
        this.setContext(context);
        this.start = n;
        this.translate = true;
        this.hilight = bl;
    }

    private LineNavigationPoint() {
    }

    public Object copyTo(Object object) {
        LineNavigationPoint lineNavigationPoint = object != null ? (LineNavigationPoint)object : new LineNavigationPoint();
        this.copyToImpl(lineNavigationPoint);
        return lineNavigationPoint;
    }

    protected final void copyToImpl(LineNavigationPoint lineNavigationPoint) {
        super.copyToImpl(lineNavigationPoint);
        lineNavigationPoint.hilight = this.hilight;
        lineNavigationPoint.translate = this.translate;
    }

    protected int navigateImpl() throws Exception {
        Editor editor = this.findOrCreateEditor(true);
        if (editor == null) {
            return 1;
        }
        if (editor instanceof CodeEditor) {
            CodeEditor codeEditor = (CodeEditor)editor;
            if (this.start < 0) {
                this.start = codeEditor.getLineFromOffset(-this.start);
                this.selLength = 0;
            }
            if (this.translate) {
                this.selLength = this.start;
                this.start = codeEditor.getLineFromOffset(this.start);
                this.selLength -= codeEditor.getLineStartOffset(this.start);
            }
            codeEditor.gotoLine(this.start, this.selLength, this.hilight);
        }
        return super.navigateImpl();
    }
}

