/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor;

import java.lang.ref.WeakReference;
import oracle.ide.ceditor.NodeUpdater;
import oracle.ide.model.Observer;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;

final class NodeObserver
implements Observer {
    WeakReference updaterReference;
    private Subject nodeSubject;

    NodeObserver(Subject subject, NodeUpdater nodeUpdater) {
        subject.attach(this);
        this.nodeSubject = subject;
        this.updaterReference = new WeakReference<NodeUpdater>(nodeUpdater);
    }

    public void update(Object object, UpdateMessage updateMessage) {
        int n = updateMessage.getMessageID();
        if (n != UpdateMessage.CHILD_REMOVED && n != UpdateMessage.CHILD_ADDED && n != UpdateMessage.PROPERTY_SET && n != UpdateMessage.OBJECT_RENAMED && n != UpdateMessage.CHILD_RENAMED && n != UpdateMessage.OBJECT_OPENED && n != UpdateMessage.ATTRIBUTE_CHANGED) {
            if (n == UpdateMessage.OBJECT_CLOSED) {
                this.initiateCleanup();
            } else {
                this.cancelTimer();
            }
        }
    }

    synchronized void cancelTimer() {
        block0: {
            if (this.updaterReference == null || this.updaterReference.get() == null) break block0;
            NodeUpdater nodeUpdater = (NodeUpdater)this.updaterReference.get();
            nodeUpdater.stopTimer();
        }
    }

    synchronized void respondCleanup() {
        if (this.nodeSubject != null) {
            this.nodeSubject.detach(this);
            this.nodeSubject = null;
        }
        if (this.updaterReference != null) {
            this.updaterReference.clear();
            this.updaterReference = null;
        }
    }

    synchronized void initiateCleanup() {
        block0: {
            if (this.updaterReference == null || this.updaterReference.get() == null) break block0;
            NodeUpdater nodeUpdater = (NodeUpdater)this.updaterReference.get();
            nodeUpdater.requestCleanup();
        }
    }
}

