/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.Timer;
import oracle.ide.ceditor.CodeEditorController;
import oracle.ide.ceditor.NodeObserver;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferListener;

public final class NodeUpdater
implements TextBufferListener,
ActionListener {
    private TextBuffer textBuffer;
    private Subject nodeSubject;
    private Timer timer;
    private NodeObserver observer;
    private static final int NOTIFY_TIMER_DELAY = 2000;
    private static final ArrayList updaterList = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NodeUpdater getUpdater(Subject subject, TextBuffer textBuffer) {
        ArrayList arrayList = updaterList;
        synchronized (arrayList) {
            Iterator iterator = updaterList.iterator();
            while (iterator.hasNext()) {
                WeakReference weakReference = (WeakReference)iterator.next();
                if (weakReference == null || weakReference.get() == null) {
                    iterator.remove();
                    continue;
                }
                NodeUpdater nodeUpdater = (NodeUpdater)weakReference.get();
                if (nodeUpdater.textBuffer != textBuffer || nodeUpdater.nodeSubject != subject) continue;
                NodeUpdater nodeUpdater2 = nodeUpdater;
                return nodeUpdater2;
            }
            NodeUpdater nodeUpdater = new NodeUpdater(subject, textBuffer);
            WeakReference weakReference = nodeUpdater.observer.updaterReference;
            updaterList.add(weakReference);
            NodeUpdater nodeUpdater3 = nodeUpdater;
            return nodeUpdater3;
        }
    }

    private NodeUpdater(Subject subject, TextBuffer textBuffer) {
        textBuffer.addTextBufferListener((TextBufferListener)this);
        this.textBuffer = textBuffer;
        this.nodeSubject = subject;
        this.timer = new Timer(2000, this);
        this.timer.setRepeats(false);
        this.observer = new NodeObserver(subject, this);
    }

    synchronized void requestCleanup() {
        if (this.textBuffer != null) {
            this.textBuffer.removeTextBufferListener((TextBufferListener)this);
            this.textBuffer = null;
        }
        this.nodeSubject = null;
        if (this.timer != null) {
            this.timer.stop();
            this.timer.removeActionListener(this);
            this.timer = null;
        }
        if (this.observer != null) {
            this.observer.respondCleanup();
            this.observer = null;
        }
    }

    protected void finalize() throws Throwable {
        this.requestCleanup();
    }

    public synchronized void actionPerformed(ActionEvent actionEvent) {
        UpdateMessage updateMessage = new UpdateMessage(CodeEditorController.UNDO_WRAPPER_MSG, null);
        this.nodeSubject.notifyObservers(this.nodeSubject, updateMessage);
    }

    void startTimer() {
        this.timer.restart();
    }

    void stopTimer() {
        this.timer.stop();
    }

    public void insertUpdate(TextBuffer textBuffer, int n, int n2, char[] cArray) {
        this.startTimer();
    }

    public void removeUpdate(TextBuffer textBuffer, int n, int n2, char[] cArray) {
        this.startTimer();
    }

    public void attributeUpdate(TextBuffer textBuffer, int n) {
    }
}

