/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor;

import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import oracle.ide.ceditor.CodeEditorController;
import oracle.ide.controller.Command;

public final class UndoWrapperCommand
extends Command {
    private Object updater;
    private UndoableEdit edit;

    public UndoWrapperCommand(UndoableEdit undoableEdit, Object object) {
        super(CodeEditorController.UNDO_WRAPPER_CMD_ID, 0);
        this.edit = undoableEdit;
        this.updater = object;
    }

    public int doit() {
        int n = 0;
        if (this.edit.canRedo()) {
            try {
                this.edit.redo();
                n = 0;
            }
            catch (CannotRedoException cannotRedoException) {
                // empty catch block
            }
        }
        return n;
    }

    public int undo() {
        int n = 1;
        if (this.edit.canUndo()) {
            try {
                this.edit.undo();
                n = 0;
            }
            catch (CannotUndoException cannotUndoException) {
                // empty catch block
            }
        }
        return n;
    }

    public String getName() {
        return this.edit.getPresentationName();
    }
}

