/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.find;

import java.awt.Toolkit;
import javax.swing.JMenuItem;
import oracle.ide.AddinManager;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.ceditor.find.FindAddin;
import oracle.ide.ceditor.find.FindArb;
import oracle.ide.ceditor.find.FindDialog;
import oracle.ide.ceditor.find.FindNavigator;
import oracle.ide.ceditor.find.FindOptions;
import oracle.ide.ceditor.find.FindableEditor;
import oracle.ide.ceditor.find.GotoLineDialog;
import oracle.ide.ceditor.find.ISearchDialog;
import oracle.ide.config.ClientSetting;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.model.Node;
import oracle.ide.vcs.VCSManager;
import oracle.ide.view.View;
import oracle.ideri.util.Product;
import oracle.javatools.editor.BasicEditorPane;

public final class FindController
implements Controller {
    private static IdeAction ideSearchAgainAction;
    private static IdeAction ideSearchBackwardAction;
    private static final int CANCEL_HIGHLIGHT_CMD_ID;
    private JMenuItem cancelHighlightMenuItem;
    private static final int FIND_NEXT_AT_CURSOR_CMD_ID;
    private static final int FIND_PREVIOUS_AT_CURSOR_CMD_ID;
    private FindDialog finder;
    private GotoLineDialog gotoLiner;
    private ISearchDialog iSearcher;

    FindController() {
        ideSearchAgainAction = IdeAction.find(25);
        ideSearchBackwardAction = IdeAction.find(53);
        String string = FindArb.getString(41);
        Integer n = FindArb.getInteger(42);
        IdeAction ideAction = IdeAction.get(CANCEL_HIGHLIGHT_CMD_ID, null, string, IdeMainWindow.ACTION_CATEGORY_SEARCH, n, FindArb.getInstance(), 43, null, false);
        ideAction.addController(this);
        Menubar menubar = Ide.getMenubar();
        this.cancelHighlightMenuItem = menubar.createMenuItem(ideAction, MenuConstants.WEIGHT_SEARCH_CLEAR_HIGHLIGHTING);
        String string2 = "Search";
        float f = 1.0f;
        if (Product.isRaptor()) {
            string2 = "Edit";
            f = MenuConstants.SECTION_EDIT_FIND;
        }
        menubar.add(this.cancelHighlightMenuItem, MenuManager.getJMenu(string2), 1.0f);
        String string3 = FindArb.getString(44);
        IdeAction ideAction2 = IdeAction.get(FIND_NEXT_AT_CURSOR_CMD_ID, null, string3, IdeMainWindow.ACTION_CATEGORY_SEARCH, null, FindArb.getInstance(), 45, null, false);
        ideAction2.addController(this);
        String string4 = FindArb.getString(46);
        IdeAction ideAction3 = IdeAction.get(FIND_PREVIOUS_AT_CURSOR_CMD_ID, null, string4, IdeMainWindow.ACTION_CATEGORY_SEARCH, null, FindArb.getInstance(), 47, null, false);
        ideAction3.addController(this);
        ideSearchAgainAction.addController(this);
        ideSearchBackwardAction.addController(this);
        IdeAction.find(23).addController(this);
        IdeAction.find(24).addController(this);
        IdeAction.find(29).addController(this);
        IdeAction.find(26).addController(this);
        IdeAction.find(27).addController(this);
        FindNavigator.createFindNavigator();
        this.finder = new FindDialog();
        this.iSearcher = new ISearchDialog(this);
        this.gotoLiner = new GotoLineDialog();
        FindOptions findOptions = this.loadFindOptions();
        findOptions.copyTo(this.finder);
    }

    private FindOptions loadFindOptions() {
        ClientSetting clientSetting = ClientSetting.findOrCreate(AddinManager.getAddinManager().getExtensionIDForAddin(FindAddin.class));
        if (!clientSetting.hasData("FindOptions")) {
            clientSetting.putData("FindOptions", new FindOptions());
        }
        return (FindOptions)clientSetting.getData("FindOptions");
    }

    private void saveFindOptions() {
        FindOptions findOptions = this.loadFindOptions();
        boolean bl = findOptions.getSaveOnExit();
        if (bl) {
            this.finder.copyTo(findOptions);
            findOptions.setSaveOnExit(bl);
            ClientSetting clientSetting = ClientSetting.findOrCreate(AddinManager.getAddinManager().getExtensionIDForAddin(FindAddin.class));
            clientSetting.putData("FindOptions", findOptions);
        }
    }

    void dispose() {
        IdeAction.find(23).removeController(this);
        ideSearchAgainAction.removeController(this);
        ideSearchBackwardAction.removeController(this);
        IdeAction.find(24).removeController(this);
        IdeAction.find(29).removeController(this);
        IdeAction.find(26).removeController(this);
        IdeAction.find(27).removeController(this);
        Menubar menubar = Ide.getMenubar();
        menubar.remove(this.cancelHighlightMenuItem);
        this.saveFindOptions();
        this.finder = null;
        this.gotoLiner = null;
        this.iSearcher = null;
    }

    static {
        CANCEL_HIGHLIGHT_CMD_ID = Ide.findOrCreateCmdID("CancelHighlightingCommand");
        FIND_NEXT_AT_CURSOR_CMD_ID = Ide.findOrCreateCmdID("FindNextAtCursorCommand");
        FIND_PREVIOUS_AT_CURSOR_CMD_ID = Ide.findOrCreateCmdID("FindPreviousAtCursorCommand");
    }

    void updateSearchText(String string) {
        if (this.finder != null) {
            this.finder.setSearchText(string);
            ideSearchAgainAction.updateAction();
            ideSearchBackwardAction.updateAction();
        }
    }

    private static BasicEditorPane getBasicEditorPane(Context context) {
        View view;
        BasicEditorPane basicEditorPane = null;
        if (context != null && (view = context.getView()) instanceof FindableEditor) {
            FindableEditor findableEditor = (FindableEditor)((Object)view);
            basicEditorPane = findableEditor.getFocusedEditorPane();
        }
        return basicEditorPane;
    }

    public boolean update(IdeAction ideAction, Context context) {
        boolean bl;
        BasicEditorPane basicEditorPane = FindController.getBasicEditorPane(context);
        int n = ideAction.getCommandId();
        if (basicEditorPane == null) {
            if (n == CANCEL_HIGHLIGHT_CMD_ID) {
                ideAction.setEnabled(false);
                return true;
            }
            return false;
        }
        boolean bl2 = basicEditorPane.isEditable();
        FindNavigator findNavigator = FindNavigator.getFindNavigator();
        if (n == 23) {
            bl = this.finder.canPerformFind(1);
        } else if (n == 25) {
            bl = findNavigator.isSearchHighlightMode() ? findNavigator.hasHighlights(basicEditorPane) : this.finder.canPerformFind(2);
        } else if (n == 53) {
            bl = findNavigator.isSearchHighlightMode() ? findNavigator.hasHighlights(basicEditorPane) : this.finder.canPerformFind(4);
        } else if (n == 24) {
            bl = (bl2 || this.isNodeVersioned(context)) && this.finder.canPerformFind(3);
        } else if (n == CANCEL_HIGHLIGHT_CMD_ID) {
            bl = findNavigator.hasHighlights(basicEditorPane);
        } else if (n == FIND_NEXT_AT_CURSOR_CMD_ID) {
            bl = this.finder.canPerformFind(5);
        } else if (n == FIND_PREVIOUS_AT_CURSOR_CMD_ID) {
            bl = this.finder.canPerformFind(6);
        } else if (n == 29) {
            bl = this.gotoLiner.canPerformGotoLine(context);
        } else if (n == 26) {
            bl = this.iSearcher.canPerformISearchForward(context);
        } else if (n == 27) {
            bl = this.iSearcher.canPerformISearchBackward(context);
        } else {
            return false;
        }
        ideAction.setEnabled(bl);
        return true;
    }

    private boolean isNodeVersioned(Context context) {
        Node node = context.getNode();
        return node != null && node.getURL() != null && VCSManager.getVCSManager().isVersioned(node.getURL());
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        BasicEditorPane basicEditorPane = FindController.getBasicEditorPane(context);
        if (basicEditorPane == null) {
            return false;
        }
        int n = ideAction.getCommandId();
        FindNavigator findNavigator = FindNavigator.getFindNavigator();
        if (n == 23) {
            this.finder.performFind(1, context);
            findNavigator.setSearchHighlightMode(false);
        } else if (n == 25) {
            if (findNavigator.isSearchHighlightMode()) {
                findNavigator.searchForward(basicEditorPane);
            } else {
                this.finder.performFind(2, context);
            }
        } else if (n == 53) {
            if (findNavigator.isSearchHighlightMode()) {
                findNavigator.searchBackward(basicEditorPane);
            } else {
                this.finder.performFind(4, context);
            }
        } else if (n == 24) {
            if (basicEditorPane.isEditable() || this.isNodeVersioned(context)) {
                this.finder.performFind(3, context);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        } else if (n == CANCEL_HIGHLIGHT_CMD_ID) {
            findNavigator.clearHighlights(basicEditorPane);
            findNavigator.setSearchHighlightMode(false);
        } else if (n == FIND_NEXT_AT_CURSOR_CMD_ID) {
            this.finder.performFind(5, context);
            findNavigator.setSearchHighlightMode(false);
        } else if (n == FIND_PREVIOUS_AT_CURSOR_CMD_ID) {
            this.finder.performFind(6, context);
            findNavigator.setSearchHighlightMode(false);
        } else if (n == 29) {
            this.gotoLiner.performGotoLine(context);
        } else if (n == 26) {
            this.finder.performCancelHighlighting(basicEditorPane);
            this.iSearcher.performISearchForward(context);
        } else if (n == 27) {
            this.finder.performCancelHighlighting(basicEditorPane);
            this.iSearcher.performISearchBackward(context);
        } else {
            return false;
        }
        return true;
    }
}

