/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.find;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import oracle.bali.ewt.util.WindowUtils;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.OffsetNavigationPoint;
import oracle.ide.ceditor.find.FindArb;
import oracle.ide.ceditor.find.FindNavigator;
import oracle.ide.ceditor.find.FindOptions;
import oracle.ide.ceditor.find.FindableEditor;
import oracle.ide.ceditor.find.NavigableHighlighter;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Node;
import oracle.ide.navigation.NavigationManager;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.HistoryList;
import oracle.ide.util.ResourceUtils;
import oracle.ide.vcs.VCSManager;
import oracle.ide.view.View;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditDescriptor;
import oracle.javatools.editor.FeedbackManager;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.editor.plugins.FindHighlightPlugin;

final class FindDialog
extends FindOptions {
    static final String PLUGIN_PROPERTY = "*find_plugin*";
    public static final int FIND = 1;
    public static final int SEARCH_FORWARD = 2;
    public static final int REPLACE = 3;
    public static final int SEARCH_BACKWARD = 4;
    public static final int FIND_NEXT_AT_CURSOR = 5;
    public static final int FIND_PREVIOUS_AT_CURSOR = 6;
    private ReplaceOccurenceDialog replaceDialog;
    private String searchText;
    private Pattern searchPattern;
    private String _replaceText;
    private boolean optionSearchForward;
    private boolean optionReplace;
    private boolean optionSelectedText;
    private boolean replacePerformed;
    private int hitReplaceCount;
    private int hitSkipCount;
    private int optionScope;
    private static final int SCOPE_SINGLE = 1;
    private static final int SCOPE_PROMPTED = 2;
    private static final int SCOPE_GLOBAL = 3;
    private static final int YES = 0;
    private static final int NO = 1;
    private static final int CANCEL = 2;
    private static final int GLOBAL = 3;
    private static final String FIND_TEXT_HISTORY_NAME = "FindTextHistory";
    private HistoryList findTextHistoryList;
    private static final String REPLACE_TEXT_HISTORY_NAME = "ReplaceTextHistory";
    private HistoryList replaceTextHistoryList;
    private static final EditDescriptor replaceDescriptor;
    private static final EditDescriptor replaceAllDescriptor;
    private static final boolean NO_INITIAL_TEXT;

    static {
        String string = FindArb.getString(60);
        replaceDescriptor = new EditDescriptor(string);
        string = FindArb.getString(61);
        replaceAllDescriptor = new EditDescriptor(string);
        String string2 = System.getProperty("find.disable.autofill");
        NO_INITIAL_TEXT = "true".equalsIgnoreCase(string2);
        if (NO_INITIAL_TEXT) {
            // empty if block
        }
    }

    void $init$() {
        this.replaceDialog = null;
        this.searchText = "";
        this.searchPattern = null;
        this._replaceText = "";
        this.optionSearchForward = true;
        this.optionReplace = false;
        this.optionSelectedText = false;
        this.replacePerformed = false;
        this.hitReplaceCount = 0;
        this.hitSkipCount = 0;
        this.optionScope = 1;
    }

    FindDialog() {
        this.$init$();
        this.searchText = "";
        this.findTextHistoryList = Ide.loadHistoryList(FIND_TEXT_HISTORY_NAME);
        this.replaceTextHistoryList = Ide.loadHistoryList(REPLACE_TEXT_HISTORY_NAME);
        FindNavigator.getFindNavigator().registerNavigableHighlighter(new FindHighlightAdaptor(null));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void performFind(int n, Context context) {
        int n2;
        if (!this.canPerformFind(n) || context == null || !(context.getView() instanceof FindableEditor)) {
            return;
        }
        this.setOptionReplace(false);
        boolean bl = false;
        View view = context.getView();
        BasicEditorPane basicEditorPane = ((FindableEditor)((Object)view)).getFocusedEditorPane();
        boolean bl2 = basicEditorPane.hasSelection();
        switch (n) {
            case 1: 
            case 3: {
                if (!this.showDialog(basicEditorPane, context, this._getInitialText(basicEditorPane), n)) {
                    return;
                }
                bl = this.getSearchFromBeginning();
                break;
            }
            case 2: {
                bl2 = false;
                this.setOptionSearchForward(true);
                break;
            }
            case 4: {
                bl2 = false;
                this.setOptionSearchForward(false);
                break;
            }
            case 5: 
            case 6: {
                bl2 = false;
                this.setRegexpSearch(false);
                this.setOptionSearchForward(n == 5);
                String string = this._getInitialText(basicEditorPane);
                if (string == null) {
                    return;
                }
                this.setSearchText(string);
                break;
            }
            default: {
                throw new IllegalStateException("unknown type: " + n);
            }
        }
        String string = this.getSearchText();
        if (string == null || string.length() == 0) {
            return;
        }
        if (n == 3 && !basicEditorPane.isEditable() && this.isNodeVersioned(context)) {
            URLFileSystem.setReadOnly(context.getNode().getURL(), false);
            context.getNode().isReadOnly();
            if (!basicEditorPane.isEditable()) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
        }
        BasicDocument basicDocument = (BasicDocument)basicEditorPane.getDocument();
        TextBuffer textBuffer = basicDocument.getTextBuffer();
        boolean bl3 = this.getRegexpSearch();
        Matcher matcher = null;
        if (bl3) {
            int n3 = 8;
            if (!this.getMatchCase()) {
                n3 |= 0x42;
            }
            if (this.searchPattern.flags() != n3) {
                this.searchPattern = Pattern.compile(this.searchPattern.pattern(), n3);
            }
            BufferCharSequence bufferCharSequence = new BufferCharSequence((ReadTextBuffer)textBuffer, null);
            matcher = this.searchPattern.matcher(bufferCharSequence);
        }
        boolean bl4 = bl2 && this.getOptionSelectedText();
        int n4 = bl4 ? basicEditorPane.getSelectionStart() : -1;
        int n5 = n2 = bl4 ? basicEditorPane.getSelectionEnd() : -1;
        if (this.isOptionReplace() && n != 2 && n != 4) {
            this.hitSkipCount = 0;
            this.hitReplaceCount = 0;
            textBuffer.readLock();
            try {
                if (bl3) {
                    this.performCancelHighlighting(basicEditorPane);
                    this._doRegexpReplace(context, matcher, n4, n2, bl);
                } else {
                    this._doReplace(context, string, n4, n2, bl);
                }
                String string2 = FindArb.format(15, Integer.toString(this.hitReplaceCount), Integer.toString(this.hitSkipCount));
                FeedbackManager feedbackManager = basicEditorPane.getFeedbackManager();
                if (feedbackManager == null) return;
                feedbackManager.showFeedback(basicEditorPane, string2, 20000);
                return;
            }
            finally {
                textBuffer.readUnlock();
            }
        }
        int n6 = bl ? 0 : this._getFindStartOffset(basicEditorPane);
        boolean bl5 = this.getOptionSearchForward() || bl;
        boolean bl6 = this.getWrapAround() && !bl && !bl4;
        int n7 = -1;
        textBuffer.readLock();
        try {
            if (bl3) {
                this.performCancelHighlighting(basicEditorPane);
                n7 = bl4 ? this._doRegexpSearchBounded(context, matcher, n4, n2, null) : this._doRegexpSearch(context, matcher, n6, bl6, null);
            } else {
                n7 = bl4 ? this._doSearchBounded(context, string, n4, n2, null) : this._doSearch(context, string, n6, bl5, bl6, null);
            }
        }
        finally {
            textBuffer.readUnlock();
        }
        if (bl6) {
            int n8 = basicEditorPane.getCaretPosition();
            if (bl5 && n8 < n6 || !bl5 && n6 < n8) {
                String string3 = FindArb.getString(14);
                FeedbackManager feedbackManager = basicEditorPane.getFeedbackManager();
                if (feedbackManager != null) {
                    feedbackManager.showFeedback(basicEditorPane, string3, 5000);
                }
                Toolkit.getDefaultToolkit().beep();
            }
        }
        if (n7 != -1) return;
        this.showErrorDialog((Component)basicEditorPane);
    }

    private boolean isNodeVersioned(Context context) {
        if (VCSManager.getVCSManager() == null) {
            return false;
        }
        Node node = context.getNode();
        return node != null && node.getURL() != null && VCSManager.getVCSManager().isVersioned(node.getURL());
    }

    private static BasicEditorPane _getEditorPane(Context context) {
        return ((FindableEditor)((Object)context.getView())).getFocusedEditorPane();
    }

    private int _doSearch(Context context, String string, int n, boolean bl, boolean bl2, int[] nArray) {
        BasicEditorPane basicEditorPane = FindDialog._getEditorPane(context);
        FindHighlightPlugin findHighlightPlugin = FindDialog._getFindHilightPlugin(basicEditorPane);
        int n2 = findHighlightPlugin.findText(string, n, bl, this.getMatchCase(), bl2, this.getWholeWordOnly(), this.getHighlightOccurrences());
        if (n2 != -1) {
            int n3 = n2;
            int n4 = n2 + string.length();
            if (nArray != null) {
                nArray[0] = n3;
                nArray[1] = n4;
            } else {
                this._setCaretPosition(context, n3, n4, false);
            }
        }
        return n2;
    }

    private int _doSearchBounded(Context context, String string, int n, int n2, int[] nArray) {
        BasicEditorPane basicEditorPane = FindDialog._getEditorPane(context);
        FindHighlightPlugin findHighlightPlugin = FindDialog._getFindHilightPlugin(basicEditorPane);
        int n3 = findHighlightPlugin.findText(string, n, true, this.getMatchCase(), false, this.getWholeWordOnly(), this.getHighlightOccurrences());
        if (n3 == -1) {
            return -1;
        }
        int n4 = n3;
        int n5 = n3 + string.length();
        if (n5 > n2) {
            return -1;
        }
        if (nArray != null) {
            nArray[0] = n4;
            nArray[1] = n5;
        } else {
            this._setCaretPosition(context, n4, n5, false);
        }
        return n3;
    }

    private int _doRegexpSearch(Context context, Matcher matcher, int n, boolean bl, int[] nArray) {
        boolean bl2;
        try {
            bl2 = matcher.find(n);
            if (!bl2 && bl && n != 0) {
                bl2 = matcher.find(0);
            }
        }
        catch (RuntimeException runtimeException) {
            bl2 = false;
        }
        if (!bl2) {
            return -1;
        }
        int n2 = matcher.start();
        int n3 = matcher.end();
        if (nArray != null) {
            nArray[0] = n2;
            nArray[1] = n3;
        } else {
            this._setCaretPosition(context, n2, n3, false);
        }
        return n2;
    }

    private int _doRegexpSearchBounded(Context context, Matcher matcher, int n, int n2, int[] nArray) {
        boolean bl = matcher.find(n);
        if (!bl) {
            return -1;
        }
        int n3 = matcher.start();
        int n4 = matcher.end();
        if (n4 > n2) {
            return -1;
        }
        if (nArray != null) {
            nArray[0] = n3;
            nArray[1] = n4;
        } else {
            this._setCaretPosition(context, n3, n4, false);
        }
        return n3;
    }

    private void _doReplace(Context context, String string, int n, int n2, boolean bl) {
        boolean bl2;
        boolean bl3 = true;
        this.replacePerformed = false;
        BasicEditorPane basicEditorPane = FindDialog._getEditorPane(context);
        boolean bl4 = bl2 = this.getOptionScope() == 3;
        if (bl2) {
            basicEditorPane.beginEdit(replaceAllDescriptor);
        }
        try {
            try {
                boolean bl5;
                boolean bl6 = this.getWrapAround();
                if (bl2 && bl6) {
                    bl = true;
                }
                int n3 = bl ? 0 : this._getReplaceStartOffset(basicEditorPane, false);
                boolean bl7 = bl5 = n != -1 && n2 != -1;
                if (bl5) {
                    Position position = basicEditorPane.getDocument().createPosition(n2);
                    this._doRegionalReplace(context, string, true, n, position);
                } else if (bl || n3 == 0) {
                    this._doRegionalReplace(context, string, true, 0, null);
                } else {
                    boolean bl8 = this.getOptionSearchForward();
                    Position position = null;
                    if (bl6 && !bl8) {
                        position = basicEditorPane.getDocument().createPosition(n3);
                    }
                    bl3 = this._doRegionalReplace(context, string, bl8, n3, null);
                    if (bl6 && bl8) {
                        position = basicEditorPane.getDocument().createPosition(n3);
                    }
                    if (position != null && bl3) {
                        int n4 = bl8 ? 0 : basicEditorPane.getDocument().getLength();
                        bl3 = this._doRegionalReplace(context, string, bl8, n4, position);
                    }
                    if (bl2 && position != null) {
                        this._setCaretPosition(context, position.getOffset(), position.getOffset(), true);
                    }
                }
            }
            catch (BadLocationException badLocationException) {}
        }
        finally {
            if (bl2) {
                basicEditorPane.endEdit();
            }
        }
        if (bl3 && this.hitSkipCount == 0 && this.hitReplaceCount == 0) {
            this.showErrorDialog((Component)basicEditorPane);
        }
    }

    private void _doRegexpReplace(Context context, Matcher matcher, int n, int n2, boolean bl) {
        boolean bl2;
        boolean bl3 = true;
        this.replacePerformed = false;
        BasicEditorPane basicEditorPane = FindDialog._getEditorPane(context);
        boolean bl4 = bl2 = this.getOptionScope() == 3;
        if (bl2) {
            basicEditorPane.beginEdit(replaceAllDescriptor);
        }
        try {
            try {
                boolean bl5;
                boolean bl6 = this.getWrapAround();
                if (bl2 && bl6) {
                    bl = true;
                }
                int n3 = bl ? 0 : this._getReplaceStartOffset(basicEditorPane, true);
                boolean bl7 = bl5 = n != -1 && n2 != -1;
                if (bl5) {
                    Position position = basicEditorPane.getDocument().createPosition(n2);
                    this._doRegionalRegexpReplace(context, matcher, n, position);
                } else if (bl || n3 == 0) {
                    this._doRegionalRegexpReplace(context, matcher, 0, null);
                } else {
                    boolean bl8 = this.getOptionSearchForward();
                    Position position = null;
                    if (bl6 && !bl8) {
                        position = basicEditorPane.getDocument().createPosition(n3);
                    }
                    bl3 = this._doRegionalRegexpReplace(context, matcher, n3, null);
                    if (bl6 && bl8) {
                        position = basicEditorPane.getDocument().createPosition(n3);
                    }
                    if (position != null && bl3) {
                        int n4 = bl8 ? 0 : basicEditorPane.getDocument().getLength();
                        bl3 = this._doRegionalRegexpReplace(context, matcher, n4, position);
                    }
                    if (bl2 && position != null) {
                        this._setCaretPosition(context, position.getOffset(), position.getOffset(), true);
                    }
                }
            }
            catch (BadLocationException badLocationException) {}
        }
        finally {
            if (bl2) {
                basicEditorPane.endEdit();
            }
        }
        if (bl3 && this.hitSkipCount == 0 && this.hitReplaceCount == 0) {
            this.showErrorDialog((Component)basicEditorPane);
        }
    }

    private boolean _doRegionalReplace(Context context, String string, boolean bl, int n, Position position) {
        boolean bl2;
        int n2 = n;
        int[] nArray = new int[2];
        BasicEditorPane basicEditorPane = FindDialog._getEditorPane(context);
        String string2 = this.getReplaceText();
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = bl2 = this.getOptionSearchForward() || bl;
        while (true) {
            if ((n2 = this._doSearch(context, string, n2, bl2, false, nArray)) == -1) {
                if (bl4) {
                    basicEditorPane.endEdit();
                }
                return true;
            }
            if (position != null) {
                if (bl2) {
                    int n3 = nArray[1];
                    if (n3 > position.getOffset()) {
                        if (bl4) {
                            basicEditorPane.endEdit();
                        }
                        return true;
                    }
                } else {
                    int n4 = nArray[0];
                    if (n4 < position.getOffset()) {
                        if (bl4) {
                            basicEditorPane.endEdit();
                        }
                        return true;
                    }
                }
            }
            bl3 = false;
            if (this.getOptionScope() == 3) {
                this._replaceOccurrence(context, null, nArray, string2, false);
                bl3 = true;
            } else {
                if (this.getOptionScope() == 1) {
                    this._replaceOccurrence(context, replaceDescriptor, nArray, string2, true);
                    return false;
                }
                if (this.getOptionScope() == 2) {
                    this._setCaretPosition(context, nArray[0], nArray[1], false);
                    int n5 = this._showReplaceDialog();
                    if (n5 == 0) {
                        this._replaceOccurrence(context, replaceDescriptor, nArray, string2, true);
                        bl3 = true;
                    } else {
                        if (n5 == 2) {
                            ++this.hitSkipCount;
                            return false;
                        }
                        if (n5 == 3) {
                            this.setOptionScope(3);
                            bl4 = true;
                            basicEditorPane.beginEdit(replaceAllDescriptor);
                            this._replaceOccurrence(context, null, nArray, string2, false);
                            bl3 = true;
                        } else if (n5 == 1) {
                            ++this.hitSkipCount;
                            bl3 = false;
                        }
                    }
                }
            }
            if (bl2) {
                if (bl3) {
                    int n6 = string2.length();
                    n2 += n6;
                    continue;
                }
                ++n2;
                continue;
            }
            if (bl3) {
                int n7 = string2.length();
                n2 -= n7;
                continue;
            }
            --n2;
        }
    }

    private boolean _doRegionalRegexpReplace(Context context, Matcher matcher, int n, Position position) {
        int n2;
        int n3;
        int n4 = n;
        int[] nArray = new int[2];
        BasicEditorPane basicEditorPane = FindDialog._getEditorPane(context);
        String string = this.getReplaceText();
        boolean bl = false;
        boolean bl2 = false;
        do {
            int n5;
            if ((n4 = this._doRegexpSearch(context, matcher, n4, false, nArray)) == -1) {
                if (bl2) {
                    basicEditorPane.endEdit();
                }
                return true;
            }
            if (position != null && (n5 = nArray[1]) > position.getOffset()) {
                if (bl2) {
                    basicEditorPane.endEdit();
                }
                return true;
            }
            bl = false;
            int n6 = 0;
            int n7 = matcher.end() - matcher.start();
            if (this.getOptionScope() == 3) {
                n6 = this._replaceRegexpOccurrence(context, matcher, null, nArray, string, false);
                bl = true;
            } else {
                if (this.getOptionScope() == 1) {
                    n6 = this._replaceRegexpOccurrence(context, matcher, replaceDescriptor, nArray, string, true);
                    return false;
                }
                if (this.getOptionScope() == 2) {
                    this._setCaretPosition(context, nArray[0], nArray[1], false);
                    int n8 = this._showReplaceDialog();
                    if (n8 == 0) {
                        n6 = this._replaceRegexpOccurrence(context, matcher, replaceDescriptor, nArray, string, true);
                        bl = true;
                    } else {
                        if (n8 == 2) {
                            ++this.hitSkipCount;
                            return false;
                        }
                        if (n8 == 3) {
                            this.setOptionScope(3);
                            basicEditorPane.beginEdit(replaceAllDescriptor);
                            bl2 = true;
                            n6 = this._replaceRegexpOccurrence(context, matcher, null, nArray, string, false);
                            bl = true;
                        } else if (n8 == 1) {
                            ++this.hitSkipCount;
                            bl = false;
                        }
                    }
                }
            }
            String string2 = this.getSearchText();
            int n9 = n3 = string2.endsWith("$") ? 1 : 0;
            if (bl) {
                n4 += n6 + n3;
                continue;
            }
            n4 += n7 + n3;
        } while (n3 != 1 || n4 <= (n2 = basicEditorPane.getDocument().getLength()));
        return true;
    }

    private void _setCaretPosition(Context context, int n, int n2, boolean bl) {
        NavigationManager navigationManager = NavigationManager.getNavigationManager();
        OffsetNavigationPoint offsetNavigationPoint = new OffsetNavigationPoint(context, n, n2 - n);
        try {
            if (navigationManager != null) {
                navigationManager.navigateTo(offsetNavigationPoint, bl);
            } else {
                offsetNavigationPoint.navigate();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void _replaceOccurrence(Context context, EditDescriptor editDescriptor, int[] nArray, String string, boolean bl) {
        BasicEditorPane basicEditorPane = FindDialog._getEditorPane(context);
        int n = Math.min(nArray[0], nArray[1]);
        int n2 = Math.max(nArray[0], nArray[1]);
        int n3 = n2 - n;
        if (editDescriptor != null) {
            basicEditorPane.beginEdit(editDescriptor);
        }
        try {
            try {
                Document document = basicEditorPane.getDocument();
                document.remove(n, n3);
                document.insertString(n, string, null);
                this.replacePerformed = true;
                ++this.hitReplaceCount;
                if (bl) {
                    int n4 = n;
                    int n5 = n + string.length();
                    this._setCaretPosition(context, n4, n5, this.replacePerformed);
                }
            }
            catch (BadLocationException badLocationException) {}
        }
        finally {
            if (editDescriptor != null) {
                basicEditorPane.endEdit();
            }
        }
    }

    private int _replaceRegexpOccurrence(Context context, Matcher matcher, EditDescriptor editDescriptor, int[] nArray, String string, boolean bl) {
        BasicEditorPane basicEditorPane = FindDialog._getEditorPane(context);
        BasicDocument basicDocument = (BasicDocument)basicEditorPane.getDocument();
        TextBuffer textBuffer = basicDocument.getTextBuffer();
        int n = matcher.groupCount() + 1;
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = matcher.start(n2);
            int n4 = matcher.end(n2) - n3;
            stringArray[n2] = textBuffer.getString(n3, n4);
            ++n2;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n5 = 0;
        int n6 = string.length();
        while (n5 < n6) {
            int n7 = string.indexOf(92, n5);
            if (n7 == -1) {
                stringBuffer.append(string.substring(n5));
                break;
            }
            stringBuffer.append(string.substring(n5, n7));
            n5 = n7;
            int n8 = n7 + 1;
            if (n8 < n6) {
                int n9 = string.charAt(n8);
                switch (n9) {
                    case 38: {
                        n9 = 48;
                    }
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: {
                        int n10 = n9 - 48;
                        if (n10 >= n) break;
                        stringBuffer.append(stringArray[n10]);
                        break;
                    }
                    case 92: {
                        stringBuffer.append('\\');
                        break;
                    }
                    case 110: 
                    case 114: {
                        stringBuffer.append('\n');
                        break;
                    }
                    case 116: {
                        stringBuffer.append('\t');
                        break;
                    }
                    default: {
                        stringBuffer.append(string.substring(n5, n5 + 2));
                    }
                }
                n5 += 2;
                continue;
            }
            stringBuffer.append(string.substring(n5, n5 + 1));
            ++n5;
        }
        String string2 = stringBuffer.toString();
        this._replaceOccurrence(context, editDescriptor, nArray, string2, bl);
        return string2.length();
    }

    private int _getReplaceStartOffset(BasicEditorPane basicEditorPane, boolean bl) {
        if (this._hasSelection(basicEditorPane)) {
            BasicDocument basicDocument = (BasicDocument)basicEditorPane.getDocument();
            int n = basicDocument.getLength();
            if (this.getOptionSearchForward() || bl) {
                int n2 = Math.min(basicEditorPane.getSelectionStart(), n);
                return n2;
            }
            int n3 = Math.max(basicEditorPane.getSelectionEnd(), 0);
            return n3;
        }
        return basicEditorPane.getCaretPosition();
    }

    private int _getFindStartOffset(BasicEditorPane basicEditorPane) {
        if (this._hasSelection(basicEditorPane)) {
            BasicDocument basicDocument = (BasicDocument)basicEditorPane.getDocument();
            int n = basicDocument.getLength();
            if (this.getOptionSearchForward()) {
                int n2 = Math.min(basicEditorPane.getSelectionStart() + 1, n);
                return n2;
            }
            int n3 = Math.max(basicEditorPane.getSelectionEnd() - 1, 0);
            return n3;
        }
        return basicEditorPane.getCaretPosition();
    }

    private static FindHighlightPlugin _getFindHilightPlugin(BasicEditorPane basicEditorPane) {
        FindHighlightPlugin findHighlightPlugin = (FindHighlightPlugin)basicEditorPane.getProperty(PLUGIN_PROPERTY);
        if (findHighlightPlugin == null) {
            findHighlightPlugin = new FindHighlightPlugin();
            basicEditorPane.installPlugin((EditorPlugin)findHighlightPlugin);
            basicEditorPane.putProperty(PLUGIN_PROPERTY, (Object)findHighlightPlugin);
        }
        return findHighlightPlugin;
    }

    private String _getInitialText(BasicEditorPane basicEditorPane) {
        if (NO_INITIAL_TEXT) {
            return null;
        }
        String string = null;
        try {
            int n = basicEditorPane.getSelectionStart();
            int n2 = basicEditorPane.getSelectionEnd();
            if (n == n2) {
                int n3 = basicEditorPane.getLineFromOffset(n);
                int n4 = basicEditorPane.getLineStartOffset(n3);
                int n5 = basicEditorPane.getLineEndOffset(n3);
                int n6 = n5 - n4;
                if (n4 < n5) {
                    Document document = basicEditorPane.getDocument();
                    String string2 = document.getText(n4, n5 - n4);
                    n = n2 = n - n4;
                    while (n > 0) {
                        char c = string2.charAt(n - 1);
                        if (!Character.isJavaIdentifierPart(c) && !Character.isJavaIdentifierStart(c)) break;
                        --n;
                    }
                    while (n2 < n6) {
                        char c = string2.charAt(n2);
                        if (!Character.isJavaIdentifierPart(c) && !Character.isJavaIdentifierStart(c)) break;
                        ++n2;
                    }
                    if (n != n2) {
                        string = string2.substring(n, n2);
                    }
                }
            } else {
                int n7;
                int n8 = basicEditorPane.getLineFromOffset(n);
                if (n8 == (n7 = basicEditorPane.getLineFromOffset(n2))) {
                    Document document = basicEditorPane.getDocument();
                    string = document.getText(n, n2 - n);
                }
            }
        }
        catch (BadLocationException badLocationException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return string;
    }

    private boolean _hasSelection(BasicEditorPane basicEditorPane) {
        return basicEditorPane.getSelectionStart() != basicEditorPane.getSelectionEnd();
    }

    public boolean canPerformFind(int n) {
        switch (n) {
            case 1: 
            case 5: 
            case 6: {
                return true;
            }
            case 4: {
                if (this.getRegexpSearch()) {
                    return false;
                }
            }
            case 2: {
                if (this.getRegexpSearch() && this.searchPattern == null) {
                    return false;
                }
                String string = this.getSearchText();
                return string != null && string.length() > 0;
            }
            case 3: {
                return true;
            }
        }
        return false;
    }

    public void performCancelHighlighting(BasicEditorPane basicEditorPane) {
        FindHighlightPlugin findHighlightPlugin = (FindHighlightPlugin)basicEditorPane.getProperty(PLUGIN_PROPERTY);
        if (findHighlightPlugin != null) {
            findHighlightPlugin.clearFindHighlighting();
        }
    }

    public boolean canCancelHighlighting(BasicEditorPane basicEditorPane) {
        FindHighlightPlugin findHighlightPlugin = (FindHighlightPlugin)basicEditorPane.getProperty(PLUGIN_PROPERTY);
        if (findHighlightPlugin != null) {
            return findHighlightPlugin.hasFindHighlighting();
        }
        return false;
    }

    public boolean getOptionSearchForward() {
        return this.optionSearchForward;
    }

    public void setOptionSearchForward(boolean bl) {
        this.optionSearchForward = bl;
    }

    public boolean getOptionSelectedText() {
        return this.optionSelectedText;
    }

    public void setOptionSelectedText(boolean bl) {
        this.optionSelectedText = bl;
    }

    public String getSearchText() {
        return this.searchText;
    }

    public void setSearchText(String string) {
        this.searchText = string;
        this.searchPattern = null;
    }

    public String getReplaceText() {
        return this._replaceText;
    }

    public void setReplaceText(String string) {
        this._replaceText = string;
    }

    public boolean isOptionReplace() {
        return this.optionReplace;
    }

    public void setOptionReplace(boolean bl) {
        this.optionReplace = bl;
    }

    public int getOptionScope() {
        return this.optionScope;
    }

    public void setOptionScope(int n) {
        this.optionScope = n;
    }

    private boolean showDialog(BasicEditorPane basicEditorPane, Context context, String string, int n) {
        String string2;
        boolean bl;
        Object[] objectArray;
        Object[] objectArray2;
        String string3 = FindArb.getString(2);
        JLabel jLabel = new JLabel(string3);
        if (string == null) {
            string = this.getSearchText();
        }
        int n2 = (objectArray2 = this.findTextHistoryList.getHistory()) != null ? objectArray2.length : 0;
        boolean bl2 = false;
        int n3 = 0;
        while (n3 < n2) {
            if (objectArray2[n3].equals(string)) {
                bl2 = true;
                break;
            }
            ++n3;
        }
        if (bl2) {
            objectArray = objectArray2;
        } else {
            objectArray = new String[n2 + 1];
            if (objectArray2 != null) {
                System.arraycopy(objectArray2, 0, objectArray, 1, n2);
            }
            objectArray[0] = string;
        }
        CappedComboBox cappedComboBox = new CappedComboBox(objectArray, 300, null);
        cappedComboBox.setSelectedItem(string);
        cappedComboBox.setEditable(true);
        cappedComboBox.getEditor().selectAll();
        Component component = cappedComboBox.getEditor().getEditorComponent();
        ResourceUtils.resLabel(jLabel, component, string3);
        String string4 = FindArb.getString(3);
        JCheckBox jCheckBox = new JCheckBox("", this.isOptionReplace());
        ResourceUtils.resButton(jCheckBox, string4);
        jCheckBox.setSelected(n == 3);
        String string5 = StringUtils.stripMnemonic((String)string4);
        if (!basicEditorPane.isEditable() && !this.isNodeVersioned(context)) {
            jCheckBox.setSelected(false);
            jCheckBox.setEnabled(false);
        }
        CappedComboBox cappedComboBox2 = new CappedComboBox(this.replaceTextHistoryList.getHistory(), 300, null);
        cappedComboBox2.setEditable(true);
        cappedComboBox2.setSelectedItem(this.getReplaceText());
        cappedComboBox2.getEditor().selectAll();
        cappedComboBox2.getAccessibleContext().setAccessibleName(string5);
        JPanel jPanel = new JPanel(new GridBagLayout());
        Insets insets = new Insets(3, 3, 3, 3);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0);
        jPanel.add((Component)cappedComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0);
        jPanel.add((Component)jCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0);
        jPanel.add((Component)cappedComboBox2, gridBagConstraints);
        String string6 = FindArb.getString(4);
        JCheckBox jCheckBox2 = new JCheckBox();
        ResourceUtils.resButton(jCheckBox2, string6);
        jCheckBox2.setSelected(this.getMatchCase());
        String string7 = FindArb.getString(5);
        JCheckBox jCheckBox3 = new JCheckBox();
        ResourceUtils.resButton(jCheckBox3, string7);
        jCheckBox3.setSelected(this.getWholeWordOnly());
        String string8 = FindArb.getString(6);
        JCheckBox jCheckBox4 = new JCheckBox();
        ResourceUtils.resButton(jCheckBox4, string8);
        jCheckBox4.setSelected(this.getSearchFromBeginning());
        String string9 = FindArb.getString(7);
        JCheckBox jCheckBox5 = new JCheckBox();
        ResourceUtils.resButton(jCheckBox5, string9);
        jCheckBox5.setSelected(this.getHighlightOccurrences());
        String string10 = FindArb.getString(8);
        JCheckBox jCheckBox6 = new JCheckBox();
        ResourceUtils.resButton(jCheckBox6, string10);
        jCheckBox6.setSelected(this.getWrapAround());
        String string11 = FindArb.getString(9);
        JCheckBox jCheckBox7 = new JCheckBox();
        ResourceUtils.resButton(jCheckBox7, string11);
        jCheckBox7.setSelected(this.getRegexpSearch());
        String string12 = FindArb.getString(10);
        JCheckBox jCheckBox8 = new JCheckBox();
        ResourceUtils.resButton(jCheckBox8, string12);
        jCheckBox8.setSelected(this.getOptionSelectedText());
        boolean bl3 = basicEditorPane.hasSelection();
        if (!bl3) {
            jCheckBox8.setEnabled(false);
            jCheckBox8.setSelected(false);
        }
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        String string13 = FindArb.getString(20);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(string13);
        jPanel2.setBorder(titledBorder);
        Insets insets2 = new Insets(0, 8, 0, 0);
        gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, insets2, 0, 0);
        jPanel2.add((Component)jCheckBox2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, insets2, 0, 0);
        jPanel2.add((Component)jCheckBox4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 0, insets2, 0, 0);
        jPanel2.add((Component)jCheckBox5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 0, insets2, 0, 0);
        jPanel2.add((Component)jCheckBox6, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 0, insets2, 0, 0);
        jPanel2.add((Component)jCheckBox3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 17, 0, insets2, 0, 0);
        jPanel2.add((Component)jCheckBox7, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 6, 1, 1, 1.0, 0.0, 17, 0, insets2, 0, 0);
        jPanel2.add((Component)jCheckBox8, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 7, 1, 1, 1.0, 1.0, 17, 1, insets2, 0, 0);
        jPanel2.add(Box.createVerticalGlue(), gridBagConstraints);
        String string14 = FindArb.getString(17);
        JRadioButton jRadioButton = new JRadioButton();
        ResourceUtils.resButton(jRadioButton, string14);
        String string15 = FindArb.getString(18);
        JRadioButton jRadioButton2 = new JRadioButton();
        ResourceUtils.resButton(jRadioButton2, string15);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        JRadioButton jRadioButton3 = this.getOptionSearchForward() ? jRadioButton : jRadioButton2;
        jRadioButton3.setSelected(true);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        String string16 = FindArb.getString(19);
        TitledBorder titledBorder2 = BorderFactory.createTitledBorder(string16);
        jPanel3.setBorder(titledBorder2);
        gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, insets2, 0, 0);
        jPanel3.add((Component)jRadioButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, insets2, 0, 0);
        jPanel3.add((Component)jRadioButton2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 1, insets2, 0, 0);
        jPanel3.add(Box.createVerticalGlue(), gridBagConstraints);
        String string17 = FindArb.getString(22);
        JRadioButton jRadioButton4 = new JRadioButton();
        ResourceUtils.resButton(jRadioButton4, string17);
        String string18 = FindArb.getString(24);
        JRadioButton jRadioButton5 = new JRadioButton();
        ResourceUtils.resButton(jRadioButton5, string18);
        String string19 = FindArb.getString(23);
        JRadioButton jRadioButton6 = new JRadioButton();
        ResourceUtils.resButton(jRadioButton6, string19);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(jRadioButton4);
        buttonGroup2.add(jRadioButton5);
        buttonGroup2.add(jRadioButton6);
        jRadioButton3 = this.getOptionScope() == 3 ? jRadioButton6 : (this.getOptionScope() == 2 ? jRadioButton5 : jRadioButton4);
        jRadioButton3.setSelected(true);
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        String string20 = FindArb.getString(21);
        TitledBorder titledBorder3 = BorderFactory.createTitledBorder(string20);
        jPanel4.setBorder(titledBorder3);
        gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, insets2, 0, 0);
        jPanel4.add((Component)jRadioButton4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, insets2, 0, 0);
        jPanel4.add((Component)jRadioButton5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 0, insets2, 0, 0);
        jPanel4.add((Component)jRadioButton6, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 17, 1, insets2, 0, 0);
        jPanel4.add(Box.createVerticalGlue(), gridBagConstraints);
        1 var59_59 = new 1(this, jCheckBox, cappedComboBox2, jRadioButton4, jRadioButton5, jRadioButton6, jCheckBox7, jCheckBox5, jCheckBox3, jCheckBox8, jCheckBox4, jRadioButton, jRadioButton2, jCheckBox6);
        jCheckBox.addItemListener(var59_59);
        jCheckBox7.addItemListener(var59_59);
        jCheckBox8.addItemListener(var59_59);
        jCheckBox4.addItemListener(var59_59);
        var59_59.itemStateChanged(null);
        JPanel jPanel5 = new JPanel(new GridBagLayout());
        Insets insets3 = new Insets(2, 2, 2, 2);
        gridBagConstraints = new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 1, insets3, 0, 0);
        jPanel5.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 1, 1, 2, 0.5, 1.0, 17, 1, insets3, 0, 0);
        jPanel5.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 1, 1, 1, 0.5, 0.5, 17, 1, insets3, 0, 0);
        jPanel5.add((Component)jPanel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 2, 1, 1, 0.5, 0.5, 17, 1, insets3, 0, 0);
        jPanel5.add((Component)jPanel4, gridBagConstraints);
        HelpSystem helpSystem = HelpSystem.getHelpSystem();
        if (helpSystem != null) {
            helpSystem.registerTopic(jPanel5, "f1_idedfindreplacetext_html");
        }
        if (bl = OnePageWizardDialogFactory.runDialog(jPanel5, component, string2 = n == 3 ? FindArb.getString(1) : FindArb.getString(0))) {
            this.setSearchText((String)cappedComboBox.getSelectedItem());
            this.setReplaceText((String)cappedComboBox2.getSelectedItem());
            this.setMatchCase(jCheckBox2.isSelected());
            this.setWholeWordOnly(jCheckBox3.isSelected());
            this.setSearchFromBeginning(jCheckBox4.isSelected());
            this.setOptionSearchForward(jRadioButton.isSelected());
            this.setHighlightOccurrences(jCheckBox5.isSelected());
            this.setWrapAround(jCheckBox6.isSelected());
            if (bl3) {
                this.setOptionSelectedText(jCheckBox8.isSelected());
            }
            this.setOptionReplace(jCheckBox.isSelected());
            this.setRegexpSearch(jCheckBox7.isSelected());
            if (jRadioButton6.isSelected()) {
                this.setOptionScope(3);
            } else if (jRadioButton5.isSelected()) {
                this.setOptionScope(2);
            } else {
                this.setOptionScope(1);
            }
            String string21 = this.getSearchText();
            if (string21 != null && string21.length() > 0) {
                this.findTextHistoryList.updateHistory(string21);
            }
            if ((string21 = this.getReplaceText()) != null && string21.length() > 0) {
                this.replaceTextHistoryList.updateHistory(string21);
            }
            if (this.getRegexpSearch()) {
                try {
                    int n4 = 8;
                    if (!this.getMatchCase()) {
                        n4 |= 0x42;
                    }
                    this.searchPattern = Pattern.compile(this.getSearchText(), n4);
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    this.searchPattern = null;
                    this.showInvalidRegexpDialog((Component)basicEditorPane, patternSyntaxException.getPattern(), patternSyntaxException.getDescription());
                    boolean bl4 = false;
                    return bl4;
                }
            }
        }
        return bl;
    }

    private void showErrorDialog(Component component) {
        String string = FindArb.getString(13);
        String string2 = FindArb.getString(11);
        MessageDialog.information(component, string, string2, "f1_idedfindreplacenotfound_html");
    }

    private void showInvalidRegexpDialog(Component component, String string, String string2) {
        String string3 = FindArb.format(16, string, string2);
        String string4 = FindArb.getString(12);
        MessageDialog.error(component, string3, string4, "f1_idedfindreplaceinvalidregexp_html");
    }

    private int _showReplaceDialog() {
        if (this.replaceDialog == null) {
            this.replaceDialog = new ReplaceOccurenceDialog();
        }
        return this.replaceDialog.runDialog();
    }

    static FindHighlightPlugin maS$_getFindHilightPlugin(BasicEditorPane basicEditorPane) {
        return FindDialog._getFindHilightPlugin(basicEditorPane);
    }

    final class 1
    implements ItemListener {
        private final /* synthetic */ JCheckBox v$replaceCheckBox;
        private final /* synthetic */ JComboBox v$replaceComboBox;
        private final /* synthetic */ JRadioButton v$singleRadio;
        private final /* synthetic */ JRadioButton v$promptedRadio;
        private final /* synthetic */ JRadioButton v$globalRadio;
        private final /* synthetic */ JCheckBox v$regexpCheckBox;
        private final /* synthetic */ JCheckBox v$highlightCheckBox;
        private final /* synthetic */ JCheckBox v$wordCheckBox;
        private final /* synthetic */ JCheckBox v$selectedCheckBox;
        private final /* synthetic */ JCheckBox v$startCheckBox;
        private final /* synthetic */ JRadioButton v$forwardRadio;
        private final /* synthetic */ JRadioButton v$backwardRadio;
        private final /* synthetic */ JCheckBox v$wrapCheckBox;
        final /* synthetic */ FindDialog this$0;

        public void itemStateChanged(ItemEvent itemEvent) {
            boolean bl = this.v$replaceCheckBox.isSelected() && this.v$replaceCheckBox.isEnabled();
            this.v$replaceComboBox.setEnabled(bl);
            this.v$singleRadio.setEnabled(bl);
            this.v$promptedRadio.setEnabled(bl);
            this.v$globalRadio.setEnabled(bl);
            boolean bl2 = this.v$regexpCheckBox.isSelected() && this.v$regexpCheckBox.isEnabled();
            this.v$highlightCheckBox.setEnabled(bl2 ^ true);
            this.v$wordCheckBox.setEnabled(bl2 ^ true);
            boolean bl3 = this.v$selectedCheckBox.isSelected() && this.v$selectedCheckBox.isEnabled();
            this.v$startCheckBox.setEnabled(bl3 ^ true);
            boolean bl4 = this.v$startCheckBox.isSelected() && this.v$startCheckBox.isEnabled();
            boolean bl5 = (bl2 || bl3 || bl4) ^ true;
            this.v$forwardRadio.setEnabled(bl5);
            this.v$backwardRadio.setEnabled(bl5);
            boolean bl6 = (bl3 || bl4) ^ true;
            this.v$wrapCheckBox.setEnabled(bl6);
        }

        public 1(FindDialog findDialog, JCheckBox jCheckBox, JComboBox jComboBox, JRadioButton jRadioButton, JRadioButton jRadioButton2, JRadioButton jRadioButton3, JCheckBox jCheckBox2, JCheckBox jCheckBox3, JCheckBox jCheckBox4, JCheckBox jCheckBox5, JCheckBox jCheckBox6, JRadioButton jRadioButton4, JRadioButton jRadioButton5, JCheckBox jCheckBox7) {
            this.v$wrapCheckBox = jCheckBox7;
            this.v$backwardRadio = jRadioButton5;
            this.v$forwardRadio = jRadioButton4;
            this.v$startCheckBox = jCheckBox6;
            this.v$selectedCheckBox = jCheckBox5;
            this.v$wordCheckBox = jCheckBox4;
            this.v$highlightCheckBox = jCheckBox3;
            this.v$regexpCheckBox = jCheckBox2;
            this.v$globalRadio = jRadioButton3;
            this.v$promptedRadio = jRadioButton2;
            this.v$singleRadio = jRadioButton;
            this.v$replaceComboBox = jComboBox;
            this.v$replaceCheckBox = jCheckBox;
            this.this$0 = findDialog;
        }
    }

    private class ReplaceOccurenceDialog
    extends WindowAdapter
    implements ActionListener {
        JDialog dialog;
        int resultCode;
        JLabel message;
        JPanel buttonPanel;
        JButton btnYes;
        JButton btnNo;
        JButton btnCancel;
        JButton btnGlobal;
        private static final String _KEY_YES = "YES";
        private static final String _KEY_NO = "NO";
        private static final String _KEY_CANCEL = "CANCEL";
        private static final String _KEY_GLOBAL = "GLOBAL";

        void $init$() {
            this.resultCode = -1;
            this.message = new JLabel();
            this.buttonPanel = new JPanel();
            this.btnYes = new JButton();
            this.btnNo = new JButton();
            this.btnCancel = new JButton();
            this.btnGlobal = new JButton();
        }

        ReplaceOccurenceDialog() {
            this.$init$();
            String string = FindArb.getString(37);
            this.btnYes.setText(StringUtils.stripMnemonic((String)string));
            this.btnYes.setActionCommand(_KEY_YES);
            this.btnYes.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
            string = FindArb.getString(38);
            this.btnNo.setText(StringUtils.stripMnemonic((String)string));
            this.btnNo.setActionCommand(_KEY_NO);
            this.btnNo.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
            string = FindArb.getString(39);
            this.btnCancel.setText(StringUtils.stripMnemonic((String)string));
            this.btnCancel.setActionCommand(_KEY_CANCEL);
            this.btnCancel.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
            string = FindArb.getString(40);
            this.btnGlobal.setText(StringUtils.stripMnemonic((String)string));
            this.btnGlobal.setActionCommand(_KEY_GLOBAL);
            this.btnGlobal.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
            string = FindArb.getString(35);
            JLabel jLabel = new JLabel(StringUtils.stripMnemonic((String)string));
            Insets insets = new Insets(2, 2, 2, 2);
            JPanel jPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 4, 1, 1.0, 1.0, 17, 0, insets, 0, 0);
            jPanel.add((Component)jLabel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints(0, 1, 1, 1, 0.25, 0.0, 17, 0, insets, 0, 0);
            jPanel.add((Component)this.btnYes, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints(1, 1, 1, 1, 0.25, 0.0, 17, 0, insets, 0, 0);
            jPanel.add((Component)this.btnNo, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints(2, 1, 1, 1, 0.25, 0.0, 17, 0, insets, 0, 0);
            jPanel.add((Component)this.btnGlobal, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints(3, 1, 1, 1, 0.25, 0.0, 17, 0, insets, 0, 0);
            jPanel.add((Component)this.btnCancel, gridBagConstraints);
            String string2 = FindArb.getString(36);
            this.dialog = new JDialog((Frame)((Object)Ide.getMainWindow()), string2, true);
            this.dialog.getContentPane().add((Component)jPanel, "Center");
            this.btnYes.addActionListener(this);
            this.btnNo.addActionListener(this);
            this.btnGlobal.addActionListener(this);
            this.btnCancel.addActionListener(this);
            this.dialog.getRootPane().registerKeyboardAction(this, _KEY_CANCEL, KeyStroke.getKeyStroke(27, 0), 1);
            this.dialog.setDefaultCloseOperation(0);
            this.dialog.getRootPane().setDefaultButton(this.btnYes);
            this.dialog.addWindowListener(this);
            this.dialog.pack();
            this.dialog.setResizable(false);
            WindowUtils.centerWindow((Window)this.dialog, (Component)((Object)Ide.getMainWindow()));
        }

        public int runDialog() {
            this.dialog.setVisible(true);
            return this.resultCode;
        }

        public void windowClosing(WindowEvent windowEvent) {
            this.resultCode = 2;
            this.dialog.setVisible(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            this.resultCode = string == _KEY_YES ? 0 : (string == _KEY_NO ? 1 : (string == _KEY_CANCEL ? 2 : (string == _KEY_GLOBAL ? 3 : -1)));
            this.dialog.setVisible(false);
        }
    }

    private static final class CappedComboBox
    extends JComboBox {
        private int maxWidth;

        private CappedComboBox(Object[] objectArray, int n) {
            super(objectArray);
            this.maxWidth = n;
        }

        public Dimension getPreferredSize() {
            Dimension dimension = new Dimension();
            Dimension dimension2 = super.getPreferredSize();
            dimension.height = dimension2.height;
            dimension.width = Math.min(this.maxWidth, dimension2.width);
            return dimension;
        }

        public Dimension getMaximumSize() {
            Dimension dimension = new Dimension();
            Dimension dimension2 = super.getMaximumSize();
            dimension.height = dimension2.height;
            dimension.width = Math.min(this.maxWidth, dimension2.width);
            return dimension;
        }

        CappedComboBox(Object[] objectArray, int n, 1 var3_3) {
            this(objectArray, n);
        }

        public final class 1 {
        }
    }

    private static final class BufferCharSequence
    implements CharSequence {
        private ReadTextBuffer _buffer;

        private BufferCharSequence(ReadTextBuffer readTextBuffer) {
            this._buffer = readTextBuffer;
        }

        public int length() {
            return this._buffer.getLength();
        }

        public char charAt(int n) {
            if (n < 0 || n >= this.length()) {
                throw new IndexOutOfBoundsException();
            }
            return this._buffer.getChar(n);
        }

        public CharSequence subSequence(int n, int n2) {
            if (n < 0 || n2 < 0 || n > n2 || n2 >= this.length()) {
                throw new IndexOutOfBoundsException();
            }
            return new SubCharSequence(this, n, n2, null);
        }

        public String toString() {
            return this._buffer.getString(0, this.length());
        }

        BufferCharSequence(ReadTextBuffer readTextBuffer, 1 var2_2) {
            this(readTextBuffer);
        }

        public final class 1 {
        }
    }

    private static final class SubCharSequence
    implements CharSequence {
        private CharSequence _sequence;
        private int _start;
        private int _end;
        private int _length;

        private SubCharSequence(CharSequence charSequence, int n, int n2) {
            this._sequence = charSequence;
            this._start = n;
            this._end = n2;
            this._length = this._end - this._start;
        }

        public int length() {
            return this._length;
        }

        public char charAt(int n) {
            if (n < 0 || n >= this.length()) {
                throw new IndexOutOfBoundsException();
            }
            return this._sequence.charAt(this._start + n);
        }

        public CharSequence subSequence(int n, int n2) {
            if (n < 0 || n2 < 0 || n > n2 || n2 >= this.length()) {
                throw new IndexOutOfBoundsException();
            }
            return new SubCharSequence(this, n, n2);
        }

        public String toString() {
            int n = this.length();
            StringBuffer stringBuffer = new StringBuffer(n);
            int n2 = 0;
            while (n2 < n) {
                stringBuffer.append(this.charAt(0));
                ++n2;
            }
            return stringBuffer.toString();
        }

        SubCharSequence(CharSequence charSequence, int n, int n2, 1 var4_4) {
            this(charSequence, n, n2);
        }

        public final class 1 {
        }
    }

    private static class FindHighlightAdaptor
    implements NavigableHighlighter {
        public boolean hasHighlights(BasicEditorPane basicEditorPane) {
            FindHighlightPlugin findHighlightPlugin = FindDialog.maS$_getFindHilightPlugin(basicEditorPane);
            return findHighlightPlugin.hasFindHighlighting();
        }

        public boolean getHighlightAfter(BasicEditorPane basicEditorPane, int n, int[] nArray) {
            FindHighlightPlugin findHighlightPlugin = FindDialog.maS$_getFindHilightPlugin(basicEditorPane);
            return findHighlightPlugin.getFirstHighlightAfter(n, nArray);
        }

        public boolean getHighlightBefore(BasicEditorPane basicEditorPane, int n, int[] nArray) {
            FindHighlightPlugin findHighlightPlugin = FindDialog.maS$_getFindHilightPlugin(basicEditorPane);
            return findHighlightPlugin.getFirstHighlightBefore(n, nArray);
        }

        public void clearHighlights(BasicEditorPane basicEditorPane) {
            FindHighlightPlugin findHighlightPlugin = FindDialog.maS$_getFindHilightPlugin(basicEditorPane);
            findHighlightPlugin.clearFindHighlighting();
        }

        private FindHighlightAdaptor() {
        }

        FindHighlightAdaptor(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

