/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.find;

import java.util.ArrayList;
import oracle.ide.ceditor.find.NavigableHighlighter;
import oracle.javatools.editor.BasicEditorPane;

public final class FindNavigator {
    private static FindNavigator INSTANCE;
    private ArrayList _navigables;
    private boolean _isSearchHighlightMode;

    void $init$() {
        this._navigables = new ArrayList();
    }

    private FindNavigator() {
        this.$init$();
    }

    static void createFindNavigator() {
        INSTANCE = new FindNavigator();
    }

    public static FindNavigator getFindNavigator() {
        return INSTANCE;
    }

    boolean isSearchHighlightMode() {
        return this._isSearchHighlightMode;
    }

    public void setSearchHighlightMode(boolean bl) {
        this._isSearchHighlightMode = bl;
    }

    public void registerNavigableHighlighter(NavigableHighlighter navigableHighlighter) {
        this._navigables.add(navigableHighlighter);
    }

    public void unregisterNavigableHighlighter(NavigableHighlighter navigableHighlighter) {
        this._navigables.remove(navigableHighlighter);
    }

    boolean hasHighlights(BasicEditorPane basicEditorPane) {
        int n = 0;
        while (n < this._navigables.size()) {
            NavigableHighlighter navigableHighlighter = (NavigableHighlighter)this._navigables.get(n);
            if (navigableHighlighter.hasHighlights(basicEditorPane)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean getHighlightAfter(BasicEditorPane basicEditorPane, int n, int[] nArray) {
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MAX_VALUE;
        int n4 = 0;
        while (n4 < this._navigables.size()) {
            NavigableHighlighter navigableHighlighter = (NavigableHighlighter)this._navigables.get(n4);
            if (navigableHighlighter.getHighlightAfter(basicEditorPane, n, nArray) && nArray[0] < n2) {
                n2 = nArray[0];
                n3 = nArray[1];
            }
            ++n4;
        }
        nArray[1] = n3;
        return n2 != Integer.MAX_VALUE;
    }

    private boolean getHighlightBefore(BasicEditorPane basicEditorPane, int n, int[] nArray) {
        int n2 = Integer.MIN_VALUE;
        int n3 = Integer.MIN_VALUE;
        int n4 = 0;
        while (n4 < this._navigables.size()) {
            NavigableHighlighter navigableHighlighter = (NavigableHighlighter)this._navigables.get(n4);
            if (navigableHighlighter.getHighlightBefore(basicEditorPane, n, nArray) && nArray[0] > n2) {
                n2 = nArray[0];
                n3 = nArray[1];
            }
            ++n4;
        }
        nArray[1] = n3;
        return n2 != Integer.MIN_VALUE;
    }

    void searchForward(BasicEditorPane basicEditorPane) {
        int[] nArray;
        int n = basicEditorPane.getSelectionEnd();
        if (this.getHighlightAfter(basicEditorPane, n, nArray = new int[2])) {
            basicEditorPane.setSelectionStart(nArray[0]);
            basicEditorPane.setSelectionEnd(nArray[1]);
        } else if (this.getHighlightAfter(basicEditorPane, 0, nArray)) {
            basicEditorPane.setSelectionStart(nArray[0]);
            basicEditorPane.setSelectionEnd(nArray[1]);
        }
    }

    void searchBackward(BasicEditorPane basicEditorPane) {
        int[] nArray;
        int n = basicEditorPane.getSelectionStart();
        if (this.getHighlightBefore(basicEditorPane, n, nArray = new int[2])) {
            basicEditorPane.setSelectionStart(nArray[0]);
            basicEditorPane.setSelectionEnd(nArray[1]);
        } else {
            int n2 = basicEditorPane.getDocument().getLength();
            if (this.getHighlightBefore(basicEditorPane, n2, nArray)) {
                basicEditorPane.setSelectionStart(nArray[0]);
                basicEditorPane.setSelectionEnd(nArray[1]);
            }
        }
    }

    void clearHighlights(BasicEditorPane basicEditorPane) {
        int n = 0;
        while (n < this._navigables.size()) {
            NavigableHighlighter navigableHighlighter = (NavigableHighlighter)this._navigables.get(n);
            navigableHighlighter.clearHighlights(basicEditorPane);
            ++n;
        }
    }
}

