/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.find;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import oracle.ide.Ide;
import oracle.ide.ceditor.find.FindArb;
import oracle.ide.ceditor.find.FindOptions;
import oracle.ide.controls.ItemSelectableTracker;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.ApplyListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;

public final class FindOptionsPanel
extends DefaultTraversablePanel
implements ApplyListener {
    private JCheckBox checkBox_matchCase;
    private JCheckBox checkBox_searchFromBeginning;
    private JCheckBox checkBox_highlightOccurrences;
    private JCheckBox checkBox_wrapAround;
    private JCheckBox checkBox_wholeWordOnly;
    private JCheckBox checkBox_regexpSearch;
    private JRadioButton radio_saveOnExit;
    private JRadioButton radio_useDefault;

    public FindOptionsPanel() {
        this.setHelpID("f1_idedidesetfindoptions_html");
        this.setLayout(new GridBagLayout());
        this.initializeComponent();
    }

    public void onEntry(TraversableContext traversableContext) {
        FindOptions findOptions = this.findOptions(traversableContext);
        this.loadSettingsFrom(findOptions);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        FindOptions findOptions = this.findOptions(traversableContext);
        this.saveSettingsTo(findOptions);
    }

    private FindOptions findOptions(TraversableContext traversableContext) {
        FindOptions findOptions = (FindOptions)traversableContext.find("FindOptions");
        return findOptions;
    }

    public void apply(ApplyEvent applyEvent) {
        TraversableContext traversableContext = (TraversableContext)applyEvent.getSource();
        FindOptions findOptions = this.findOptions(traversableContext);
        FindOptionsPanel.applyOptions(findOptions);
    }

    public void cancel(ApplyEvent applyEvent) {
    }

    public static void applyOptions(FindOptions findOptions) {
    }

    void loadSettingsFrom(FindOptions findOptions) {
        boolean bl = findOptions.getSaveOnExit();
        boolean bl2 = findOptions.getMatchCase();
        boolean bl3 = findOptions.getSearchFromBeginning();
        boolean bl4 = findOptions.getHighlightOccurrences();
        boolean bl5 = findOptions.getWrapAround();
        boolean bl6 = findOptions.getWholeWordOnly();
        boolean bl7 = findOptions.getRegexpSearch();
        this.checkBox_matchCase.setSelected(bl2);
        this.checkBox_searchFromBeginning.setSelected(bl3);
        this.checkBox_highlightOccurrences.setSelected(bl4);
        this.checkBox_wrapAround.setSelected(bl5);
        this.checkBox_wholeWordOnly.setSelected(bl6);
        this.checkBox_regexpSearch.setSelected(bl7);
        JRadioButton jRadioButton = bl ? this.radio_saveOnExit : this.radio_useDefault;
        jRadioButton.setSelected(true);
    }

    void saveSettingsTo(FindOptions findOptions) {
        boolean bl = this.radio_saveOnExit.isSelected();
        boolean bl2 = this.checkBox_matchCase.isSelected();
        boolean bl3 = this.checkBox_searchFromBeginning.isSelected();
        boolean bl4 = this.checkBox_highlightOccurrences.isSelected();
        boolean bl5 = this.checkBox_wrapAround.isSelected();
        boolean bl6 = this.checkBox_wholeWordOnly.isSelected();
        boolean bl7 = this.checkBox_regexpSearch.isSelected();
        findOptions.setSaveOnExit(bl);
        findOptions.setMatchCase(bl2);
        findOptions.setSearchFromBeginning(bl3);
        findOptions.setHighlightOccurrences(bl4);
        findOptions.setWrapAround(bl5);
        findOptions.setWholeWordOnly(bl6);
        findOptions.setRegexpSearch(bl7);
    }

    private void initializeComponent() {
        String string = FindArb.getString(30);
        this.checkBox_matchCase = new JCheckBox();
        ResourceUtils.resButton(this.checkBox_matchCase, string);
        String string2 = FindArb.getString(29);
        this.checkBox_searchFromBeginning = new JCheckBox();
        ResourceUtils.resButton(this.checkBox_searchFromBeginning, string2);
        String string3 = FindArb.getString(32);
        this.checkBox_highlightOccurrences = new JCheckBox();
        ResourceUtils.resButton(this.checkBox_highlightOccurrences, string3);
        String string4 = FindArb.getString(33);
        this.checkBox_wrapAround = new JCheckBox();
        ResourceUtils.resButton(this.checkBox_wrapAround, string4);
        String string5 = FindArb.getString(31);
        this.checkBox_wholeWordOnly = new JCheckBox();
        ResourceUtils.resButton(this.checkBox_wholeWordOnly, string5);
        String string6 = FindArb.getString(34);
        this.checkBox_regexpSearch = new JCheckBox();
        ResourceUtils.resButton(this.checkBox_regexpSearch, string6);
        String string7 = FindArb.format(26, Ide.getProgramShortName());
        JLabel jLabel = new JLabel(string7);
        String string8 = FindArb.format(27, Ide.getProgramShortName());
        this.radio_saveOnExit = new JRadioButton();
        ResourceUtils.resButton(this.radio_saveOnExit, string8);
        String string9 = FindArb.getString(28);
        this.radio_useDefault = new JRadioButton();
        ResourceUtils.resButton(this.radio_useDefault, string9);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.radio_saveOnExit);
        buttonGroup.add(this.radio_useDefault);
        Component[] componentArray = new Component[]{this.checkBox_matchCase, this.checkBox_searchFromBeginning, this.checkBox_highlightOccurrences, this.checkBox_wrapAround, this.checkBox_wholeWordOnly, this.checkBox_regexpSearch};
        ItemSelectableTracker itemSelectableTracker = new ItemSelectableTracker(this.radio_useDefault, componentArray);
        Insets insets = new Insets(2, 5, 2, 5);
        Insets insets2 = new Insets(2, 30, 2, 5);
        Insets insets3 = new Insets(1, 55, 1, 5);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, insets2, 0, 0);
        this.add((Component)this.radio_saveOnExit, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 0, insets2, 0, 0);
        this.add((Component)this.radio_useDefault, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 0, insets3, 0, 0);
        this.add((Component)this.checkBox_matchCase, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 0, insets3, 0, 0);
        this.add((Component)this.checkBox_searchFromBeginning, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 17, 0, insets3, 0, 0);
        this.add((Component)this.checkBox_highlightOccurrences, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 6, 1, 1, 1.0, 0.0, 17, 0, insets3, 0, 0);
        this.add((Component)this.checkBox_wrapAround, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 7, 1, 1, 1.0, 0.0, 17, 0, insets3, 0, 0);
        this.add((Component)this.checkBox_wholeWordOnly, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 8, 1, 1, 1.0, 0.0, 17, 0, insets3, 0, 0);
        this.add((Component)this.checkBox_regexpSearch, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 9, 1, 1, 1.0, 1.0, 17, 1, insets, 0, 0);
        this.add(Box.createVerticalGlue(), gridBagConstraints);
    }
}

