/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.find;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.ide.Context;
import oracle.ide.ceditor.OffsetNavigationPoint;
import oracle.ide.ceditor.find.FindArb;
import oracle.ide.ceditor.find.FindableEditor;
import oracle.ide.controls.WholeNumberField;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.navigation.NavigationManager;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;

final class GotoLineDialog {
    private int requestedLine;

    GotoLineDialog() {
    }

    public void performGotoLine(Context context) {
        block6: {
            BasicEditorPane basicEditorPane = ((FindableEditor)((Object)context.getView())).getFocusedEditorPane();
            int n = basicEditorPane.getCaretPosition();
            BasicDocument basicDocument = (BasicDocument)basicEditorPane.getDocument();
            LineMap lineMap = basicDocument.getLineMap();
            int n2 = lineMap.getLineFromOffset(n) + 1;
            boolean bl = this.showDialog(n2);
            if (bl) {
                int n3 = this.requestedLine;
                if (n3 > 0 && n3 <= lineMap.getLineCount()) {
                    int n4 = lineMap.getLineStartOffset(--n3);
                    NavigationManager navigationManager = NavigationManager.getNavigationManager();
                    OffsetNavigationPoint offsetNavigationPoint = new OffsetNavigationPoint(context, n4, 0);
                    try {
                        if (navigationManager != null) {
                            navigationManager.navigateTo(offsetNavigationPoint);
                            break block6;
                        }
                        offsetNavigationPoint.navigate();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                } else {
                    String string = FindArb.getString(50);
                    String string2 = FindArb.getString(51);
                    MessageDialog.error((Component)basicEditorPane, string, string2, "f1_idedgotolinenumbadline_html");
                }
            }
        }
    }

    public boolean canPerformGotoLine(Context context) {
        return true;
    }

    private boolean showDialog(int n) {
        boolean bl;
        String string = FindArb.getString(48);
        String string2 = FindArb.getString(49);
        JLabel jLabel = new JLabel();
        WholeNumberField wholeNumberField = new WholeNumberField(n, 6);
        wholeNumberField.selectAll();
        ResourceUtils.resLabel(jLabel, (Component)((Object)wholeNumberField), string2);
        JPanel jPanel = new JPanel(new GridBagLayout());
        Insets insets = new Insets(0, 0, 0, 0);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.insets.left = 8;
        gridBagConstraints = new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 8, 0, 0), 0, 0);
        jPanel.add((Component)((Object)wholeNumberField), gridBagConstraints);
        HelpSystem helpSystem = HelpSystem.getHelpSystem();
        if (helpSystem != null) {
            helpSystem.registerTopic(jPanel, "f1_idedgotolinenum_html");
        }
        if (bl = OnePageWizardDialogFactory.runDialog(jPanel, (Component)((Object)wholeNumberField), string)) {
            try {
                this.requestedLine = wholeNumberField.getValue();
            }
            catch (NullPointerException nullPointerException) {
                this.requestedLine = -1;
            }
        }
        return bl;
    }
}

