/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.find;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeNavigationPoint;
import oracle.ide.ceditor.find.FindArb;
import oracle.ide.ceditor.find.FindController;
import oracle.ide.ceditor.find.FindableEditor;
import oracle.ide.config.IdeSettings;
import oracle.ide.controls.GridBagConstraints2;
import oracle.ide.keyboard.KeyStrokeMap;
import oracle.ide.keyboard.KeyStrokeOptions;
import oracle.ide.keyboard.KeyStrokes;
import oracle.ide.navigation.NavigationManager;
import oracle.javatools.editor.ActionInvoker;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.keys.MultiKeyHandler;
import oracle.javatools.editor.keys.MultiKeymap;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.editor.plugins.FindHighlightPlugin;

final class ISearchDialog
implements WindowListener,
DocumentListener,
ActionInvoker {
    private static final boolean RESTORE = true;
    private static final boolean NO_RESTORE = false;
    private static final boolean REQUEST_FOCUS = true;
    private static final boolean NO_REQUEST_FOCUS = false;
    private JDialog searchDialog;
    private Context searchContext;
    private FindHighlightPlugin findPlugin;
    private JTextField searchField;
    private JLabel messageLabel;
    private int searchDirection;
    private static final int FORWARD = 1;
    private static final int BACKWARD = 2;
    private int anchorOffset;
    private Rectangle anchorRect;
    private int lastFoundOffset;
    private int originalOffset;
    private Rectangle originalRect;
    private MultiKeyHandler keyHandler;
    private FindController controller;
    private boolean beepedForNotFound;
    private boolean beepedForEndBuffer;
    private static final String FORWARD_ACTION = "isearch-forward";
    private static final String BACKWARD_ACTION = "isearch-backward";
    private static final String OK_ACTION = "isearch-ok";
    private static final String CANCEL_ACTION = "isearch-cancel";
    private static final int FROM_ANCHOR = 1;
    private static final int FROM_CURRENT = 2;
    private static final int FROM_NEXT = 3;
    private static final int MINIMUM_LENGTH_TO_HIGHLIGHT = 2;

    ISearchDialog(FindController findController) {
        this.controller = findController;
    }

    public void performISearchForward(Context context) {
        this.showDialog(context, 1);
    }

    public boolean canPerformISearchForward(Context context) {
        return true;
    }

    public void performISearchBackward(Context context) {
        this.showDialog(context, 2);
    }

    public boolean canPerformISearchBackward(Context context) {
        return true;
    }

    private void showDialog(Context context, int n) {
        BasicEditorPane basicEditorPane = ((FindableEditor)((Object)context.getView())).getFocusedEditorPane();
        Point point = null;
        String string = null;
        if (this.searchDialog != null) {
            point = this.searchDialog.getLocation();
            string = this.searchField.getText();
            this.searchDialog.dispose();
            this.searchDialog = null;
            this.searchField = null;
        }
        if (this.searchDialog == null) {
            this.searchDialog = new JDialog((Frame)((Object)Ide.getMainWindow()), false);
            this.searchDialog.addWindowListener(this);
            this.searchDialog.setDefaultCloseOperation(1);
            String string2 = FindArb.getString(54);
            this.searchField = new JTextField(30);
            JLabel jLabel = new JLabel(string2);
            this.messageLabel = new JLabel();
            this.clearMessage();
            this.messageLabel.setHorizontalTextPosition(2);
            JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.add((Component)jLabel, new GridBagConstraints2(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
            jPanel.add((Component)this.searchField, new GridBagConstraints2(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
            jPanel.add((Component)this.messageLabel, new GridBagConstraints2(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
            this.searchDialog.getContentPane().add(jPanel);
            this.searchDialog.pack();
            if (point != null) {
                this.searchDialog.setLocation(point);
            } else {
                Point point2 = basicEditorPane.getLocationOnScreen();
                Rectangle rectangle = new Rectangle();
                basicEditorPane.computeVisibleRect(rectangle);
                int n2 = point2.x;
                int n3 = point2.y + rectangle.y + rectangle.height + 10;
                Dimension dimension = basicEditorPane.getToolkit().getScreenSize();
                int n4 = this.searchDialog.getHeight();
                int n5 = this.searchDialog.getWidth();
                int n6 = 30;
                n3 = Math.min(n3, dimension.height - n4 - 30);
                n2 = Math.min(n2, dimension.width - n5 - 30);
                this.searchDialog.setLocation(n2, n3);
            }
        }
        if (this.originalRect == null) {
            this.originalRect = new Rectangle();
            this.anchorRect = new Rectangle();
            this.findPlugin = new FindHighlightPlugin();
        }
        IdeSettings ideSettings = Ide.getSettings();
        KeyStrokeOptions keyStrokeOptions = ideSettings.getKeyStrokeOptions();
        KeyStrokeMap keyStrokeMap = keyStrokeOptions.getGlobalKeyMap();
        Integer n7 = new Integer(26);
        List list = keyStrokeMap.getKeyStrokesFor(n7);
        Integer n8 = new Integer(27);
        List list2 = keyStrokeMap.getKeyStrokesFor(n8);
        if (list.size() == 0 || list2.size() == 0) {
            String string3 = this.getMissingShortcutMessage();
            JOptionPane.showMessageDialog((Component)basicEditorPane, string3);
            return;
        }
        MultiKeymap multiKeymap = new MultiKeymap();
        int n9 = list.size();
        int n10 = 0;
        while (n10 < n9) {
            KeyStrokes keyStrokes = (KeyStrokes)list.get(n10);
            int n11 = keyStrokes.getLength();
            KeyStroke[] keyStrokeArray = new KeyStroke[n11];
            int n12 = 0;
            while (n12 < n11) {
                keyStrokeArray[n12] = keyStrokes.getKeyStroke(n12);
                ++n12;
            }
            multiKeymap.put(keyStrokeArray, n11, FORWARD_ACTION);
            ++n10;
        }
        int n13 = list2.size();
        int n14 = 0;
        while (n14 < n13) {
            KeyStrokes keyStrokes = (KeyStrokes)list2.get(n14);
            int n15 = keyStrokes.getLength();
            KeyStroke[] keyStrokeArray = new KeyStroke[n15];
            int n16 = 0;
            while (n16 < n15) {
                keyStrokeArray[n16] = keyStrokes.getKeyStroke(n16);
                ++n16;
            }
            multiKeymap.put(keyStrokeArray, n15, BACKWARD_ACTION);
            ++n14;
        }
        KeyStroke keyStroke = KeyStroke.getKeyStroke("DOWN");
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke("UP");
        multiKeymap.put(keyStroke, FORWARD_ACTION);
        multiKeymap.put(keyStroke2, BACKWARD_ACTION);
        KeyStroke keyStroke3 = KeyStroke.getKeyStroke("ENTER");
        KeyStroke keyStroke4 = KeyStroke.getKeyStroke("ESCAPE");
        multiKeymap.put(keyStroke3, OK_ACTION);
        multiKeymap.put(keyStroke4, CANCEL_ACTION);
        this.keyHandler = new MultiKeyHandler(multiKeymap);
        this.keyHandler.install((Component)this.searchField, (ActionInvoker)this);
        this.searchContext = context;
        basicEditorPane.computeVisibleRect(this.originalRect);
        this.originalOffset = basicEditorPane.getCaretPosition();
        basicEditorPane.computeVisibleRect(this.anchorRect);
        this.anchorOffset = this.originalOffset;
        this.lastFoundOffset = -1;
        if (string != null) {
            this.searchField.setText(string);
        }
        this.searchField.selectAll();
        basicEditorPane.installPlugin((EditorPlugin)this.findPlugin);
        this.findPlugin.clearFindHighlighting();
        this.setDirection(n);
        Document document = this.searchField.getDocument();
        document.addDocumentListener(this);
        this.clearMessage();
        this.searchDialog.show();
        SwingUtilities.invokeLater(new 1());
        this.beepedForNotFound = false;
        this.beepedForEndBuffer = false;
    }

    private void hideDialog(boolean bl, boolean bl2) {
        if (this.searchDialog == null) {
            throw new IllegalStateException("Cannot hide null dialog");
        }
        if (this.searchDialog.isVisible()) {
            this.searchField.selectAll();
            this.searchDialog.hide();
            this.keyHandler.deinstall();
            this.keyHandler = null;
            Document document = this.searchField.getDocument();
            document.removeDocumentListener(this);
            BasicEditorPane basicEditorPane = ((FindableEditor)((Object)this.searchContext.getView())).getFocusedEditorPane();
            this.findPlugin.clearFindHighlighting();
            basicEditorPane.deinstallPlugin((EditorPlugin)this.findPlugin);
            if (bl) {
                basicEditorPane.scrollRectToVisible(this.originalRect);
                basicEditorPane.setCaretPosition(this.originalOffset);
            } else {
                NavigationManager navigationManager = NavigationManager.getNavigationManager();
                CodeNavigationPoint codeNavigationPoint = new CodeNavigationPoint();
                codeNavigationPoint.setContext(this.searchContext);
                try {
                    if (navigationManager != null) {
                        navigationManager.navigateTo(codeNavigationPoint);
                    } else {
                        codeNavigationPoint.navigate();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (this.controller != null) {
                String string = this.searchField.getText();
                this.controller.updateSearchText(string);
            }
            if (bl2) {
                basicEditorPane.requestFocus();
            }
            this.searchContext = null;
        }
    }

    private boolean containsUpperCase(String string) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (Character.isUpperCase(c)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void doSearch(int n) {
        int n2;
        this.clearMessage();
        String string = this.searchField.getText();
        BasicEditorPane basicEditorPane = ((FindableEditor)((Object)this.searchContext.getView())).getFocusedEditorPane();
        Document document = basicEditorPane.getDocument();
        int n3 = document.getLength() - 1;
        if (string.length() == 0) {
            basicEditorPane.scrollRectToVisible(this.anchorRect);
            basicEditorPane.setCaretPosition(this.anchorOffset);
            this.lastFoundOffset = -1;
            this.findPlugin.clearFindHighlighting();
            return;
        }
        boolean bl = this.containsUpperCase(string);
        boolean bl2 = this.searchDirection == 1;
        boolean bl3 = false;
        boolean bl4 = string.length() >= 2;
        switch (n) {
            case 1: {
                n2 = this.anchorOffset;
                break;
            }
            case 2: {
                if (this.lastFoundOffset == -1) {
                    n2 = this.anchorOffset;
                    break;
                }
                if (this.searchDirection == 1) {
                    n2 = this.lastFoundOffset;
                    break;
                }
                int n4 = basicEditorPane.getSelectionStart();
                int n5 = basicEditorPane.getSelectionEnd();
                int n6 = n5 - n4;
                int n7 = string.length();
                n2 = n5 + (n7 - n6);
                n2 = Math.max(0, n2);
                n2 = Math.min(n2, n3);
                break;
            }
            case 3: {
                n2 = this.lastFoundOffset == -1 ? this.anchorOffset : (this.searchDirection == 1 ? this.lastFoundOffset + 1 : basicEditorPane.getSelectionEnd() - 1);
                break;
            }
            default: {
                throw new IllegalStateException("unknown from: " + n);
            }
        }
        boolean bl5 = false;
        boolean bl6 = false;
        int n8 = this.findPlugin.findText(string, n2, bl2, bl, bl3, false, bl4);
        if (n8 == -1) {
            bl6 = true;
            bl5 = true;
            n2 = this.searchDirection == 1 ? 0 : n3;
            n8 = this.findPlugin.findText(string, n2, bl2, bl, bl3, false, bl4);
        }
        if (n8 != -1) {
            if (bl6 && !this.beepedForEndBuffer) {
                this.beepedForEndBuffer = true;
                basicEditorPane.getToolkit().beep();
                String string2 = this.searchDirection == 1 ? this.getEndBufferMessage() : this.getStartBufferMessage();
                this.showMessage(string2);
                bl6 = false;
            } else {
                basicEditorPane.setCaretPositionCenter(n8);
                basicEditorPane.moveCaretPositionCenter(n8 + string.length());
                this.lastFoundOffset = n8;
                this.beepedForEndBuffer = false;
            }
            this.beepedForNotFound = false;
            bl5 = false;
        }
        if (bl5) {
            if (!this.beepedForNotFound) {
                basicEditorPane.getToolkit().beep();
            }
            this.showMessage(this.getNotFoundMessage());
            this.beepedForNotFound = true;
        } else if (bl6) {
            this.showMessage(this.getWrappedMessage());
        }
    }

    private void searchForward() {
        if (this.searchDirection == 2) {
            this.setDirection(1);
            if (this.lastFoundOffset != -1) {
                BasicEditorPane basicEditorPane = ((FindableEditor)((Object)this.searchContext.getView())).getFocusedEditorPane();
                this.anchorOffset = this.lastFoundOffset;
                basicEditorPane.computeVisibleRect(this.anchorRect);
            }
            this.clearMessage();
            return;
        }
        this.doSearch(3);
    }

    private void searchBackward() {
        if (this.searchDirection == 1) {
            this.setDirection(2);
            if (this.lastFoundOffset != -1) {
                BasicEditorPane basicEditorPane = ((FindableEditor)((Object)this.searchContext.getView())).getFocusedEditorPane();
                this.anchorOffset = basicEditorPane.getSelectionEnd();
                basicEditorPane.computeVisibleRect(this.anchorRect);
            }
            this.clearMessage();
            return;
        }
        this.doSearch(3);
    }

    private void setDirection(int n) {
        this.searchDirection = n;
        String string = null;
        switch (n) {
            case 1: {
                string = FindArb.getString(52);
                break;
            }
            case 2: {
                string = FindArb.getString(53);
                break;
            }
            default: {
                throw new IllegalStateException("unknown direction: " + n);
            }
        }
        this.searchDialog.setTitle(string);
    }

    private String getNotFoundMessage() {
        return FindArb.getString(55);
    }

    private String getWrappedMessage() {
        return FindArb.getString(58);
    }

    private String getEndBufferMessage() {
        return FindArb.getString(56);
    }

    private String getStartBufferMessage() {
        return FindArb.getString(57);
    }

    private String getMissingShortcutMessage() {
        return FindArb.getString(59);
    }

    private void showMessage(String string) {
        this.messageLabel.setText(string);
    }

    private void clearMessage() {
        this.messageLabel.setText(" ");
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.beepedForEndBuffer = false;
        this.doSearch(2);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.beepedForEndBuffer = false;
        this.doSearch(2);
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.hideDialog(false, true);
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
        this.hideDialog(false, false);
    }

    public void invokeAction(String string) {
        if (string == FORWARD_ACTION) {
            this.searchForward();
        } else if (string == BACKWARD_ACTION) {
            this.searchBackward();
        } else if (string == OK_ACTION) {
            this.hideDialog(false, true);
        } else if (string == CANCEL_ACTION) {
            this.hideDialog(true, true);
        } else {
            throw new IllegalStateException("unknown action: " + string);
        }
    }

    static JTextField ra$searchField(ISearchDialog iSearchDialog) {
        return iSearchDialog.searchField;
    }

    final class 1
    implements Runnable {
        public void run() {
            ISearchDialog.ra$searchField(ISearchDialog.this).requestFocus();
        }
    }
}

