/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.keymap;

import oracle.ide.ceditor.keymap.IdeEditorPane;
import oracle.ide.ceditor.keymap.KeymapHelper;
import oracle.ide.ceditor.keymap.KeymapManager;
import oracle.ide.keyboard.KeyStrokeContext;
import oracle.javatools.editor.BasicEditorPane;

public final class EditorFactory {
    public static BasicEditorPane createIdeEditorPane() {
        return EditorFactory.createIdeEditorPane(null);
    }

    public static BasicEditorPane createIdeEditorPane(KeyStrokeContext[] keyStrokeContextArray) {
        try {
            IdeEditorPane ideEditorPane = new IdeEditorPane();
            KeymapManager keymapManager = KeymapManager.getInstance();
            KeymapHelper keymapHelper = keymapManager.createIdeKeymapHelper(keyStrokeContextArray);
            ideEditorPane.installPlugin(keymapHelper);
            IdeEditorPane ideEditorPane2 = ideEditorPane;
            return ideEditorPane2;
        }
        catch (RuntimeException runtimeException) {
            System.out.println("Unexpected exception: " + runtimeException.toString());
            runtimeException.printStackTrace();
            BasicEditorPane basicEditorPane = new BasicEditorPane();
            return basicEditorPane;
        }
    }

    public static BasicEditorPane createStandaloneEditorPane() {
        return EditorFactory.createStandaloneEditorPane(null);
    }

    private static BasicEditorPane createStandaloneEditorPane(KeyStrokeContext[] keyStrokeContextArray) {
        try {
            IdeEditorPane ideEditorPane = new IdeEditorPane();
            KeymapManager keymapManager = KeymapManager.getInstance();
            KeymapHelper keymapHelper = keymapManager.createStandaloneKeymapHelper(keyStrokeContextArray);
            ideEditorPane.installPlugin(keymapHelper);
            IdeEditorPane ideEditorPane2 = ideEditorPane;
            return ideEditorPane2;
        }
        catch (RuntimeException runtimeException) {
            System.out.println("Unexpected exception: " + runtimeException.toString());
            runtimeException.printStackTrace();
            return new BasicEditorPane();
        }
    }

    public static void initialize() {
        KeymapManager.getInstance();
    }
}

