/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.keymap;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import oracle.ide.Ide;
import oracle.ide.ceditor.CEditorArb;
import oracle.ide.controller.IdeAction;
import oracle.javatools.editor.ActionNames;

public final class EditorKeyStrokes {
    private static final String EDITOR_CATEGORY = CEditorArb.getString(4);
    private HashMap actionMap;

    public EditorKeyStrokes() {
        this.initialize();
    }

    private void initialize() {
        if (this.actionMap == null) {
            String[] stringArray = ActionNames.getAllActionNames();
            this.actionMap = new HashMap();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                if (!(string.equals("cut-to-clipboard") || string.equals("copy-to-clipboard") || string.equals("paste-from-clipboard") || string.equals("extended-paste-from-clipboard") || string.equals("select-all") || string.equals("delete-next"))) {
                    IdeAction ideAction = IdeAction.get(Ide.findOrCreateCmdID(string), string, ActionNames.lookupTranslatedName((String)string), EDITOR_CATEGORY, null, null, null, false);
                    this.actionMap.put(string, ideAction);
                }
                ++n2;
            }
        }
    }

    public Set getAllActions(boolean bl) {
        if (!bl) {
            Collection collection = this.actionMap.values();
            return new HashSet(collection);
        }
        return null;
    }

    public IdeAction lookupAction(String string) {
        return (IdeAction)this.actionMap.get(string);
    }
}

