/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.keymap;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Map;
import oracle.ide.ceditor.keymap.KeymapHelper;
import oracle.ide.ceditor.keymap.KeymapManager;
import oracle.ide.controller.IdeAction;
import oracle.ide.keyboard.KeyStrokeContext;
import oracle.javatools.editor.ActionInvoker;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.keys.MultiKeyHandler;
import oracle.javatools.editor.keys.MultiKeymap;

final class IdeKeymapHelper
extends KeymapHelper
implements ActionInvoker {
    private Map ideActionMap;
    private MultiKeyHandler keyHandler;
    private KeyStrokeContext[] localContexts;
    private Map localActionMap;

    IdeKeymapHelper() {
        this(null);
    }

    IdeKeymapHelper(KeyStrokeContext[] keyStrokeContextArray) {
        this.localContexts = keyStrokeContextArray;
        this.localActionMap = null;
    }

    protected void installKeymap() {
        BasicEditorPane basicEditorPane = this.getEditor();
        if (basicEditorPane != null) {
            KeymapManager keymapManager = KeymapManager.getInstance();
            MultiKeymap multiKeymap = keymapManager.getIdeKeymap();
            this.ideActionMap = keymapManager.getIdeActionMap();
            if (this.localContexts == null) {
                this.keyHandler = new MultiKeyHandler(multiKeymap);
                this.keyHandler.install((Component)basicEditorPane, (ActionInvoker)this);
            } else {
                MultiKeymap[] multiKeymapArray = new MultiKeymap[1];
                Map[] mapArray = new Map[1];
                keymapManager.buildExtendedMaps(this.localContexts, multiKeymapArray, mapArray);
                MultiKeymap multiKeymap2 = multiKeymapArray[0];
                multiKeymap2.setParent(multiKeymap);
                this.localActionMap = mapArray[0];
                this.keyHandler = new MultiKeyHandler(multiKeymap2);
                this.keyHandler.install((Component)basicEditorPane, (ActionInvoker)this);
            }
        }
    }

    protected void deinstallKeymap() {
        if (this.keyHandler != null) {
            this.keyHandler.deinstall();
            this.keyHandler = null;
        }
        this.ideActionMap = null;
        this.localActionMap = null;
    }

    public void invokeAction(String string) {
        IdeAction ideAction;
        BasicEditorPane basicEditorPane = this.getEditor();
        if (this.localActionMap != null && (ideAction = (IdeAction)this.localActionMap.get(string)) != null) {
            ideAction.updateAction();
            ActionEvent actionEvent = new ActionEvent(basicEditorPane, 1001, null);
            ideAction.actionPerformed(actionEvent);
            return;
        }
        IdeAction ideAction2 = (IdeAction)this.ideActionMap.get(string);
        if (ideAction2 != null) {
            ideAction2.updateAction();
            ActionEvent actionEvent = new ActionEvent(basicEditorPane, 1001, null);
            ideAction2.actionPerformed(actionEvent);
        } else {
            basicEditorPane.invokeAction(string);
        }
    }
}

