/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.keymap;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.ide.Ide;
import oracle.ide.ceditor.keymap.EditorKeyStrokes;
import oracle.ide.ceditor.keymap.IdeKeymapHelper;
import oracle.ide.ceditor.keymap.KeymapHelper;
import oracle.ide.ceditor.keymap.StandaloneKeymapHelper;
import oracle.ide.config.IdeSettings;
import oracle.ide.controller.IdeAction;
import oracle.ide.keyboard.KeyStrokeContext;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.keyboard.KeyStrokeMap;
import oracle.ide.keyboard.KeyStrokeOptions;
import oracle.ide.keyboard.KeyStrokes;
import oracle.javatools.editor.keys.MultiKeymap;

public final class KeymapManager
implements ChangeListener {
    static final String ACCEL_FILE = "oracle/ide/ceditor/keymap/accelerators.xml";
    private static KeymapManager singleton = new KeymapManager();
    private EditorKeyStrokes editorContext;
    private List helperList = new ArrayList();
    private MultiKeymap ideKeymap = null;
    private MultiKeymap standaloneKeymap = null;
    private HashMap ideActionMap = null;

    public static KeymapManager getInstance() {
        return singleton;
    }

    private KeymapManager() {
        KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
        this.editorContext = new EditorKeyStrokes();
        keyStrokeContextRegistry.addAcceleratorDefinitionFile(this.getClass().getClassLoader(), ACCEL_FILE);
        IdeSettings ideSettings = Ide.getSettings();
        KeyStrokeOptions keyStrokeOptions = ideSettings.getKeyStrokeOptions();
        keyStrokeOptions.addChangeListener(this);
    }

    public EditorKeyStrokes getEditorKeyStrokes() {
        return this.editorContext;
    }

    synchronized KeymapHelper createIdeKeymapHelper(KeyStrokeContext[] keyStrokeContextArray) {
        IdeKeymapHelper ideKeymapHelper = new IdeKeymapHelper(keyStrokeContextArray);
        WeakReference weakReference = ideKeymapHelper.getWeakReference();
        this.helperList.add(weakReference);
        return ideKeymapHelper;
    }

    synchronized KeymapHelper createStandaloneKeymapHelper(KeyStrokeContext[] keyStrokeContextArray) {
        StandaloneKeymapHelper standaloneKeymapHelper = new StandaloneKeymapHelper(keyStrokeContextArray);
        WeakReference weakReference = standaloneKeymapHelper.getWeakReference();
        this.helperList.add(weakReference);
        return standaloneKeymapHelper;
    }

    synchronized MultiKeymap getIdeKeymap() {
        if (this.ideKeymap == null) {
            this.buildIdeMaps();
        }
        return this.ideKeymap;
    }

    synchronized MultiKeymap getStandaloneKeymap() {
        if (this.standaloneKeymap == null) {
            this.buildStandaloneMaps();
        }
        return this.standaloneKeymap;
    }

    synchronized Map getIdeActionMap() {
        if (this.ideActionMap == null) {
            this.buildIdeMaps();
        }
        return this.ideActionMap;
    }

    synchronized void buildExtendedMaps(KeyStrokeContext[] keyStrokeContextArray, MultiKeymap[] multiKeymapArray, Map[] mapArray) {
        MultiKeymap multiKeymap = new MultiKeymap();
        HashMap<String, IdeAction> hashMap = new HashMap<String, IdeAction>();
        IdeSettings ideSettings = Ide.getSettings();
        KeyStrokeOptions keyStrokeOptions = ideSettings.getKeyStrokeOptions();
        int n = keyStrokeContextArray.length;
        int n2 = 0;
        while (n2 < n) {
            KeyStrokeContext keyStrokeContext = keyStrokeContextArray[n2];
            if (keyStrokeContext != null) {
                Set set;
                KeyStrokeMap keyStrokeMap = keyStrokeOptions.getLocalKeyMap(keyStrokeContext);
                Set set2 = keyStrokeContext.getAllActions(false);
                Set set3 = set = keyStrokeMap != null ? keyStrokeMap.keySet() : null;
                if (set != null) {
                    for (KeyStrokes keyStrokes : set) {
                        Integer n3 = keyStrokeMap.getBindingFor(keyStrokes);
                        int n4 = n3;
                        IdeAction ideAction = IdeAction.find(n4);
                        if (ideAction == null) continue;
                        String string = "*LOCAL*" + n4;
                        hashMap.put(string, ideAction);
                        KeyStroke[] keyStrokeArray = this.splitKeyStrokes(keyStrokes);
                        try {
                            multiKeymap.put(keyStrokeArray, keyStrokeArray.length, string);
                        }
                        catch (RuntimeException runtimeException) {
                            System.out.println("Keymap exception: " + runtimeException.toString());
                        }
                    }
                }
            }
            ++n2;
        }
        multiKeymapArray[0] = multiKeymap;
        mapArray[0] = hashMap;
    }

    private synchronized void buildIdeMaps() {
        KeyStrokeMap keyStrokeMap;
        Set set;
        Set set2;
        this.ideKeymap = new MultiKeymap();
        this.ideActionMap = new HashMap();
        IdeSettings ideSettings = Ide.getSettings();
        KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
        KeyStrokeContext keyStrokeContext = keyStrokeContextRegistry.getContext(ACCEL_FILE);
        KeyStrokeOptions keyStrokeOptions = ideSettings.getKeyStrokeOptions();
        KeyStrokeMap keyStrokeMap2 = keyStrokeOptions.getLocalKeyMap(keyStrokeContext);
        Set set3 = this.editorContext.getAllActions(false);
        Set set4 = set2 = keyStrokeMap2 != null ? keyStrokeMap2.keySet() : null;
        if (set2 != null) {
            block12: for (KeyStrokes keyStrokes : set2) {
                Integer n = keyStrokeMap2.getBindingFor(keyStrokes);
                int n2 = n;
                for (IdeAction ideAction : set3) {
                    int n3 = ideAction.getCommandId();
                    if (n3 != n2) continue;
                    String string = ideAction.getCommand();
                    KeyStroke[] keyStrokeArray = this.splitKeyStrokes(keyStrokes);
                    try {
                        this.ideKeymap.put(keyStrokeArray, keyStrokeArray.length, string);
                    }
                    catch (RuntimeException runtimeException) {
                        System.out.println("Keymap exception: " + runtimeException.toString());
                    }
                    continue block12;
                }
            }
        }
        Set set5 = set = (keyStrokeMap = keyStrokeOptions.getGlobalKeyMap()) != null ? keyStrokeMap.keySet() : null;
        if (set != null) {
            for (KeyStrokes keyStrokes : set) {
                String string;
                Integer n = keyStrokeMap.getBindingFor(keyStrokes);
                int n4 = n;
                IdeAction ideAction = IdeAction.find(n4);
                if (ideAction == null) continue;
                switch (n4) {
                    case 17: {
                        string = "cut-to-clipboard";
                        break;
                    }
                    case 18: {
                        string = "copy-to-clipboard";
                        break;
                    }
                    case 19: {
                        string = "paste-from-clipboard";
                        break;
                    }
                    case 78: {
                        string = "extended-paste-from-clipboard";
                        break;
                    }
                    case 22: {
                        string = "select-all";
                        break;
                    }
                    case 20: {
                        string = "delete-next";
                        break;
                    }
                    default: {
                        string = "*IDE*" + n4;
                        this.ideActionMap.put(string, ideAction);
                    }
                }
                KeyStroke[] keyStrokeArray = this.splitKeyStrokes(keyStrokes);
                try {
                    this.ideKeymap.put(keyStrokeArray, keyStrokeArray.length, string);
                }
                catch (RuntimeException runtimeException) {
                    System.out.println("Keymap exception: " + runtimeException.toString());
                }
            }
        }
    }

    private synchronized void buildStandaloneMaps() {
        KeyStrokeMap keyStrokeMap;
        Set set;
        Set set2;
        this.standaloneKeymap = new MultiKeymap();
        IdeSettings ideSettings = Ide.getSettings();
        KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
        KeyStrokeContext keyStrokeContext = keyStrokeContextRegistry.getContext(ACCEL_FILE);
        KeyStrokeOptions keyStrokeOptions = ideSettings.getKeyStrokeOptions();
        KeyStrokeMap keyStrokeMap2 = keyStrokeOptions.getLocalKeyMap(keyStrokeContext);
        Set set3 = this.editorContext.getAllActions(false);
        Set set4 = set2 = keyStrokeMap2 != null ? keyStrokeMap2.keySet() : null;
        if (set2 != null) {
            block12: for (KeyStrokes keyStrokes : set2) {
                Integer n = keyStrokeMap2.getBindingFor(keyStrokes);
                int n2 = n;
                for (IdeAction ideAction : set3) {
                    int n3 = ideAction.getCommandId();
                    if (n3 != n2) continue;
                    String string = ideAction.getCommand();
                    KeyStroke[] keyStrokeArray = this.splitKeyStrokes(keyStrokes);
                    try {
                        this.standaloneKeymap.put(keyStrokeArray, keyStrokeArray.length, string);
                    }
                    catch (RuntimeException runtimeException) {
                        System.out.println("Keymap exception: " + runtimeException.toString());
                    }
                    continue block12;
                }
            }
        }
        Set set5 = set = (keyStrokeMap = keyStrokeOptions.getGlobalKeyMap()) != null ? keyStrokeMap.keySet() : null;
        if (set != null) {
            block14: for (KeyStrokes keyStrokes : set) {
                String string;
                Integer n = keyStrokeMap.getBindingFor(keyStrokes);
                int n4 = n;
                IdeAction ideAction = IdeAction.find(n4);
                if (ideAction == null) continue;
                switch (n4) {
                    case 17: {
                        string = "cut-to-clipboard";
                        break;
                    }
                    case 18: {
                        string = "copy-to-clipboard";
                        break;
                    }
                    case 19: {
                        string = "paste-from-clipboard";
                        break;
                    }
                    case 78: {
                        string = "extended-paste-from-clipboard";
                        break;
                    }
                    case 22: {
                        string = "select-all";
                        break;
                    }
                    case 20: {
                        string = "delete-next";
                        break;
                    }
                    default: {
                        continue block14;
                    }
                }
                KeyStroke[] keyStrokeArray = this.splitKeyStrokes(keyStrokes);
                try {
                    this.standaloneKeymap.put(keyStrokeArray, keyStrokeArray.length, string);
                }
                catch (RuntimeException runtimeException) {
                    System.out.println("Keymap exception: " + runtimeException.toString());
                }
            }
        }
    }

    private KeyStroke[] splitKeyStrokes(KeyStrokes keyStrokes) {
        int n = keyStrokes.getLength();
        KeyStroke[] keyStrokeArray = new KeyStroke[n];
        int n2 = 0;
        while (n2 < n) {
            keyStrokeArray[n2] = keyStrokes.getKeyStroke(n2);
            ++n2;
        }
        return keyStrokeArray;
    }

    public synchronized void stateChanged(ChangeEvent changeEvent) {
        this.ideKeymap = null;
        this.standaloneKeymap = null;
        this.ideActionMap = null;
        Iterator iterator = this.helperList.iterator();
        while (iterator.hasNext()) {
            WeakReference weakReference = (WeakReference)iterator.next();
            if (weakReference == null || weakReference.get() == null) {
                iterator.remove();
                continue;
            }
            KeymapHelper keymapHelper = (KeymapHelper)weakReference.get();
            if (keymapHelper == null) continue;
            keymapHelper.keymapChanged();
        }
    }
}

