/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.macrorecorder;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.ceditor.macrorecorder.MacroEvent;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;

final class MacroController
implements Runnable,
Controller,
AWTEventListener {
    private static final int TOGGLE_CMD_ID = Ide.findOrCreateCmdID("MacroRecord");
    private IdeAction toggleAction;
    private static final int PLAYBACK_CMD_ID = Ide.findOrCreateCmdID("MacroPlay");
    private IdeAction playbackAction;
    private Window activeWindow;
    private Thread playbackThread;
    private boolean shutdown;
    private List macroList;
    private boolean recording;
    private boolean playing;

    MacroController() {
        this.$init$();
        this.toggleAction = IdeAction.get(TOGGLE_CMD_ID, null, "Toggle Macro Recording", IdeMainWindow.ACTION_CATEGORY_TOOLS, null, null, null, false);
        this.toggleAction.addController(this);
        this.toggleAction.setEnabled(true);
        this.playbackAction = IdeAction.get(PLAYBACK_CMD_ID, null, "Play Recorded Macro", IdeMainWindow.ACTION_CATEGORY_TOOLS, null, null, null, false);
        this.playbackAction.addController(this);
        this.playbackAction.setEnabled(false);
        Menubar menubar = Ide.getMenubar();
        JMenuItem jMenuItem = menubar.createMenuItem(this.toggleAction);
        JMenuItem jMenuItem2 = menubar.createMenuItem(this.playbackAction);
        JMenu jMenu = MenuManager.getJMenu("Tools");
        jMenu.addSeparator();
        jMenu.add(jMenuItem);
        jMenu.add(jMenuItem2);
        long l = 72;
        Toolkit.getDefaultToolkit().addAWTEventListener(this, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void shutdown() {
        if (this.playbackThread != null) {
            Thread thread = this.playbackThread;
            synchronized (thread) {
                this.shutdown = true;
                this.playbackThread.notify();
            }
        }
    }

    void $init$() {
        this.activeWindow = null;
        this.playbackThread = null;
        this.shutdown = false;
        this.macroList = null;
        this.recording = false;
        this.playing = false;
    }

    private synchronized void toggleRecording() {
        if (this.playing) {
            return;
        }
        if (this.recording) {
            this.recording = false;
            this.playbackAction.setEnabled(true);
        } else {
            this.recording = true;
            this.playbackAction.setEnabled(false);
            if (this.macroList == null) {
                this.macroList = new ArrayList();
            }
        }
    }

    private synchronized void playbackRecording() {
        if (this.recording) {
            return;
        }
        this.playing = true;
        this.toggleAction.setEnabled(false);
        this.playbackAction.setEnabled(false);
        this.playbackThread = new Thread(this);
        this.playbackThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        System.out.println("Playback thread started");
        Thread thread = this.playbackThread;
        synchronized (thread) {
            System.out.println("Beginning initial sleep");
            this.sleep(this.playbackThread, 100);
            EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
            int n = this.macroList.size();
            int n2 = 0;
            while (n2 < n) {
                if (this.shutdown) break;
                MacroEvent macroEvent = (MacroEvent)this.macroList.get(n2);
                KeyEvent keyEvent = macroEvent.getKeyEvent(this.activeWindow);
                eventQueue.postEvent(keyEvent);
                System.out.println("Posted key event type: " + keyEvent.getID());
                System.out.println("old source class: " + macroEvent.source.getClass().getName());
                long l = 25;
                if (n2 + 1 < n) {
                    MacroEvent macroEvent2 = (MacroEvent)this.macroList.get(n2 + 1);
                    long l2 = macroEvent2.when - macroEvent.when;
                    l = Math.max(l, l2);
                }
                System.out.println("sleeping for: " + l);
                this.sleep(this.playbackThread, l);
                ++n2;
            }
        }
        System.out.println("playback complete");
        this.playing = false;
        this.toggleAction.setEnabled(true);
        this.playbackAction.setEnabled(true);
        this.playbackThread = null;
    }

    private void sleep(Object object, long l) {
        try {
            object.wait(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public synchronized void eventDispatched(AWTEvent aWTEvent) {
        block9: {
            Component component;
            int n;
            block8: {
                n = aWTEvent.getID();
                component = (Component)aWTEvent.getSource();
                if (n < 200 || n > 209) break block8;
                switch (n) {
                    case 205: {
                        this.activeWindow = (Window)component;
                        break;
                    }
                    case 206: {
                        if (component == this.activeWindow) {
                            this.activeWindow = null;
                            break;
                        } else {
                            break;
                        }
                    }
                }
                break block9;
            }
            if (n >= 400 && n <= 402) {
                if (this.activeWindow == null) {
                    this.activeWindow = SwingUtilities.getWindowAncestor(component);
                }
                if (this.recording && aWTEvent instanceof KeyEvent) {
                    MacroEvent macroEvent = new MacroEvent((KeyEvent)aWTEvent);
                    this.macroList.add(macroEvent);
                }
            }
        }
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        if (ideAction == this.toggleAction) {
            this.toggleRecording();
            return true;
        }
        if (ideAction == this.playbackAction) {
            this.playbackRecording();
            return true;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        if (ideAction == this.toggleAction) {
            ideAction.setEnabled(this.playing ^ true);
            return true;
        }
        if (ideAction == this.playbackAction) {
            ideAction.setEnabled(!this.recording && !this.playing && this.macroList != null);
            return true;
        }
        return false;
    }
}

