/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.options;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.ide.ceditor.options.CaretOptions;
import oracle.ide.ceditor.options.OptionsArb;
import oracle.ide.controls.CustomColorChoice;
import oracle.ide.controls.ItemSelectableTracker;
import oracle.ide.controls.JLabelListCellRenderer;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.ApplyListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.editor.EditorProperties;

public final class CaretOptionsPanel
extends DefaultTraversablePanel
implements ItemListener,
ChangeListener,
ApplyListener {
    private JCheckBox checkbox_enableBlink;
    private JSlider slider_blinkRate;
    private JLabel label_blinkRateText;
    private JLabel label_insertShape;
    private JComboBox combobox_insertShape;
    private JLabel label_overwriteShape;
    private JComboBox combobox_overwriteShape;
    private CustomColorChoice colorchoice_caretColor;
    private Map textToShapeMap;
    private Map shapeToTextMap;
    private NumberFormat numberFormatter;

    public CaretOptionsPanel() {
        this.setHelpID("f1_idedidesetcaretbehavior_html");
        this.setLayout(new GridBagLayout());
        this.initializeComponent();
    }

    public void onEntry(TraversableContext traversableContext) {
        CaretOptions caretOptions = this.findOptions(traversableContext);
        this.loadSettingsFrom(caretOptions);
    }

    public void onExit(TraversableContext traversableContext) {
        CaretOptions caretOptions = this.findOptions(traversableContext);
        this.saveSettingsTo(caretOptions);
    }

    private CaretOptions findOptions(TraversableContext traversableContext) {
        CaretOptions caretOptions = (CaretOptions)traversableContext.find("CaretOptions");
        return caretOptions;
    }

    public void apply(ApplyEvent applyEvent) {
        TraversableContext traversableContext = (TraversableContext)applyEvent.getSource();
        CaretOptions caretOptions = this.findOptions(traversableContext);
        CaretOptionsPanel.applyOptions(caretOptions);
    }

    public void cancel(ApplyEvent applyEvent) {
    }

    public static void applyOptions(CaretOptions caretOptions) {
        EditorProperties editorProperties = EditorProperties.getProperties();
        boolean bl = caretOptions.getEnableBlink();
        editorProperties.putBooleanProperty("caret-enable-blink", bl);
        int n = caretOptions.getBlinkRate();
        editorProperties.putIntegerProperty("caret-blink-rate", n);
        int n2 = caretOptions.getInsertShape();
        editorProperties.putIntegerProperty("caret-shape-insert", n2);
        int n3 = caretOptions.getOverwriteShape();
        editorProperties.putIntegerProperty("caret-shape-overwrite", n3);
        int n4 = caretOptions.getCaretColor();
        Color color = new Color(n4);
        editorProperties.putProperty("caret-color", (Object)color);
        boolean bl2 = caretOptions.getRightClickSelection();
        editorProperties.putBooleanProperty("caret-right-click-selection", bl2);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        float f = (float)this.slider_blinkRate.getValue() / 10.0f;
        String string = OptionsArb.format(125, this.numberFormatter.format(f));
        this.slider_blinkRate.setToolTipText(string);
        this.label_blinkRateText.setText(string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        Object object2 = itemEvent.getItem();
        int n = itemEvent.getStateChange();
        if (object == this.combobox_insertShape) {
            if (n != 1) return;
        }
        if (object == this.combobox_overwriteShape && n != 1) return;
    }

    void loadSettingsFrom(CaretOptions caretOptions) {
        boolean bl = caretOptions.getEnableBlink();
        int n = caretOptions.getBlinkRate();
        int n2 = caretOptions.getInsertShape();
        int n3 = caretOptions.getOverwriteShape();
        int n4 = caretOptions.getCaretColor();
        this.checkbox_enableBlink.setSelected(bl);
        this.slider_blinkRate.setValue(n / 100);
        this.stateChanged(null);
        Object v = this.shapeToTextMap.get(new Integer(n2));
        Object v2 = this.shapeToTextMap.get(new Integer(n3));
        this.combobox_insertShape.setSelectedItem(v);
        this.combobox_overwriteShape.setSelectedItem(v2);
        this.colorchoice_caretColor.setClosestSelectedColor(new Color(n4));
    }

    void saveSettingsTo(CaretOptions caretOptions) {
        boolean bl = this.checkbox_enableBlink.isSelected();
        int n = this.slider_blinkRate.getValue() * 100;
        Object object = this.combobox_insertShape.getSelectedItem();
        Object object2 = this.combobox_overwriteShape.getSelectedItem();
        Color color = this.colorchoice_caretColor.getSelectedColor();
        caretOptions.setEnableBlink(bl);
        caretOptions.setBlinkRate(n);
        Integer n2 = (Integer)this.textToShapeMap.get(object);
        Integer n3 = (Integer)this.textToShapeMap.get(object2);
        caretOptions.setInsertShape(n2);
        caretOptions.setOverwriteShape(n3);
        caretOptions.setCaretColor(color.getRGB());
    }

    private void initializeComponent() {
        this.numberFormatter = NumberFormat.getNumberInstance();
        this.numberFormatter.setMinimumFractionDigits(1);
        this.numberFormatter.setMaximumFractionDigits(1);
        String string = OptionsArb.getString(122);
        this.checkbox_enableBlink = new JCheckBox();
        ResourceUtils.resButton(this.checkbox_enableBlink, string);
        String string2 = OptionsArb.getString(123);
        JLabel jLabel = new JLabel();
        this.slider_blinkRate = new JSlider(1, 20, 10);
        this.slider_blinkRate.addChangeListener(this);
        this.label_blinkRateText = new JLabel();
        ResourceUtils.resLabel(jLabel, this.slider_blinkRate, string2);
        String string3 = this.numberFormatter.format(0.1);
        String string4 = this.numberFormatter.format(2.0);
        JLabel jLabel2 = new JLabel(string3);
        JLabel jLabel3 = new JLabel(string4);
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>(5);
        hashtable.put(new Integer(1), jLabel2);
        hashtable.put(new Integer(20), jLabel3);
        this.slider_blinkRate.setLabelTable(hashtable);
        this.slider_blinkRate.setPaintLabels(true);
        this.slider_blinkRate.setPaintTicks(true);
        this.slider_blinkRate.setMajorTickSpacing(10);
        this.slider_blinkRate.setMinorTickSpacing(1);
        this.slider_blinkRate.setSnapToTicks(true);
        Component[] componentArray = new Component[]{this.slider_blinkRate, jLabel, jLabel2, jLabel3, this.label_blinkRateText};
        ItemSelectableTracker itemSelectableTracker = new ItemSelectableTracker(this.checkbox_enableBlink, componentArray);
        this.checkbox_enableBlink.addItemListener(itemSelectableTracker);
        this.slider_blinkRate.setValue(1);
        JLabel jLabel4 = new JLabel(OptionsArb.getString(128), OptionsArb.getIcon(138), 10);
        JLabel jLabel5 = new JLabel(OptionsArb.getString(129), OptionsArb.getIcon(139), 10);
        JLabel jLabel6 = new JLabel(OptionsArb.getString(130), OptionsArb.getIcon(140), 10);
        JLabel jLabel7 = new JLabel(OptionsArb.getString(131), OptionsArb.getIcon(141), 10);
        JLabel jLabel8 = new JLabel(OptionsArb.getString(132), OptionsArb.getIcon(142), 10);
        JLabel jLabel9 = new JLabel(OptionsArb.getString(133), OptionsArb.getIcon(143), 10);
        JLabel jLabel10 = new JLabel(OptionsArb.getString(134), OptionsArb.getIcon(144), 10);
        JLabel jLabel11 = new JLabel(OptionsArb.getString(135), OptionsArb.getIcon(145), 10);
        JLabel jLabel12 = new JLabel(OptionsArb.getString(136), OptionsArb.getIcon(147), 10);
        JLabel jLabel13 = new JLabel(OptionsArb.getString(137), OptionsArb.getIcon(146), 10);
        Object[] objectArray = new Object[]{jLabel4, jLabel5, jLabel6, jLabel7, jLabel8, jLabel9, jLabel10, jLabel11, jLabel12, jLabel13};
        this.textToShapeMap = new HashMap();
        this.textToShapeMap.put(jLabel4, new Integer(1));
        this.textToShapeMap.put(jLabel5, new Integer(2));
        this.textToShapeMap.put(jLabel6, new Integer(7));
        this.textToShapeMap.put(jLabel7, new Integer(8));
        this.textToShapeMap.put(jLabel8, new Integer(3));
        this.textToShapeMap.put(jLabel9, new Integer(4));
        this.textToShapeMap.put(jLabel10, new Integer(9));
        this.textToShapeMap.put(jLabel11, new Integer(10));
        this.textToShapeMap.put(jLabel12, new Integer(5));
        this.textToShapeMap.put(jLabel13, new Integer(6));
        this.shapeToTextMap = new HashMap();
        this.shapeToTextMap.put(new Integer(1), jLabel4);
        this.shapeToTextMap.put(new Integer(2), jLabel5);
        this.shapeToTextMap.put(new Integer(7), jLabel6);
        this.shapeToTextMap.put(new Integer(8), jLabel7);
        this.shapeToTextMap.put(new Integer(3), jLabel8);
        this.shapeToTextMap.put(new Integer(4), jLabel9);
        this.shapeToTextMap.put(new Integer(9), jLabel10);
        this.shapeToTextMap.put(new Integer(10), jLabel11);
        this.shapeToTextMap.put(new Integer(5), jLabel12);
        this.shapeToTextMap.put(new Integer(6), jLabel13);
        JLabelListCellRenderer jLabelListCellRenderer = new JLabelListCellRenderer();
        String string5 = OptionsArb.getString(126);
        JLabel jLabel14 = new JLabel();
        NonNullableComboBoxModel nonNullableComboBoxModel = new NonNullableComboBoxModel(objectArray);
        this.combobox_insertShape = new JComboBox(nonNullableComboBoxModel);
        this.combobox_insertShape.setEditable(false);
        this.combobox_insertShape.setSelectedItem(objectArray[0]);
        this.combobox_insertShape.addItemListener(this);
        this.combobox_insertShape.setRenderer(jLabelListCellRenderer);
        ResourceUtils.resLabel(jLabel14, this.combobox_insertShape, string5);
        String string6 = OptionsArb.getString(127);
        JLabel jLabel15 = new JLabel();
        NonNullableComboBoxModel nonNullableComboBoxModel2 = new NonNullableComboBoxModel(objectArray);
        this.combobox_overwriteShape = new JComboBox(nonNullableComboBoxModel2);
        this.combobox_overwriteShape.setEditable(false);
        this.combobox_overwriteShape.setSelectedItem(objectArray[0]);
        this.combobox_overwriteShape.addItemListener(this);
        this.combobox_overwriteShape.setRenderer(jLabelListCellRenderer);
        ResourceUtils.resLabel(jLabel15, this.combobox_overwriteShape, string6);
        String string7 = OptionsArb.getString(124);
        JLabel jLabel16 = new JLabel();
        this.colorchoice_caretColor = new CustomColorChoice();
        ResourceUtils.resLabel(jLabel16, (Component)((Object)this.colorchoice_caretColor), string7);
        Insets insets = new Insets(5, 5, 5, 5);
        Insets insets2 = new Insets(2, 30, 2, 2);
        Insets insets3 = new Insets(2, 55, 2, 2);
        Insets insets4 = new Insets(2, 2, 2, 2);
        Insets insets5 = new Insets(0, 0, 0, 0);
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        jPanel.add((Component)this.checkbox_enableBlink, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, insets2, 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, insets3, 0, 0);
        jPanel.add((Component)this.label_blinkRateText, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 1, 1, 2, 1.0, 0.0, 17, 2, insets4, 0, 0);
        jPanel.add((Component)this.slider_blinkRate, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 3, 2, 1, 1.0, 1.0, 17, 1, insets5, 0, 0);
        jPanel.add(Box.createGlue(), gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0);
        jPanel2.add((Component)jLabel14, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0);
        jPanel2.add((Component)this.combobox_insertShape, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0);
        jPanel2.add((Component)jLabel15, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0);
        jPanel2.add((Component)this.combobox_overwriteShape, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0);
        jPanel2.add((Component)jLabel16, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        jPanel2.add((Component)((Object)this.colorchoice_caretColor), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 3, 2, 1, 1.0, 1.0, 17, 1, insets, 0, 0);
        jPanel2.add(Box.createGlue(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 1, insets5, 0, 0);
        this.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, insets5, 0, 0);
        this.add(Box.createVerticalStrut(10), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 1, insets5, 0, 0);
        this.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 17, 1, insets5, 0, 0);
        this.add(Box.createGlue(), gridBagConstraints);
    }
}

