/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.options;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import oracle.ide.ceditor.options.InsightOptions;
import oracle.ide.ceditor.options.OptionsArb;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.ApplyListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.editor.EditorProperties;

public final class CompletionOptionsPanel
extends DefaultTraversablePanel
implements ApplyListener {
    private JCheckBox checkbox_invokeMatching;
    private JCheckBox checkbox_partialMatching;
    private JCheckBox checkbox_typedMatching;
    private JCheckBox checkbox_filterCompletion;

    public CompletionOptionsPanel() {
        this.setHelpID("f1_idedidesetcompletion_html");
        this.setLayout(new GridBagLayout());
        this.initializeComponent();
    }

    public void onEntry(TraversableContext traversableContext) {
        InsightOptions insightOptions = this.findOptions(traversableContext);
        this.loadSettingsFrom(insightOptions);
    }

    public void onExit(TraversableContext traversableContext) {
        InsightOptions insightOptions = this.findOptions(traversableContext);
        this.saveSettingsTo(insightOptions);
    }

    private InsightOptions findOptions(TraversableContext traversableContext) {
        InsightOptions insightOptions = (InsightOptions)traversableContext.find("InsightOptions");
        return insightOptions;
    }

    public void apply(ApplyEvent applyEvent) {
        TraversableContext traversableContext = (TraversableContext)applyEvent.getSource();
        InsightOptions insightOptions = this.findOptions(traversableContext);
        CompletionOptionsPanel.applyOptions(insightOptions);
    }

    public void cancel(ApplyEvent applyEvent) {
    }

    public static void applyOptions(InsightOptions insightOptions) {
        EditorProperties editorProperties = EditorProperties.getProperties();
        boolean bl = insightOptions.getInvokeCompleteMatch();
        boolean bl2 = insightOptions.getPartialCompleteMatch();
        boolean bl3 = insightOptions.getTypedCompleteMatch();
        boolean bl4 = insightOptions.getFilterCompletion();
        editorProperties.putBooleanProperty("insight-manual-complete-single", bl);
        editorProperties.putBooleanProperty("insight-partial-complete-single", bl2);
        editorProperties.putBooleanProperty("insight-typed-complete-single", bl3);
        editorProperties.putBooleanProperty("insight-filter-matching", bl4);
        boolean bl5 = insightOptions.getNewDataCompleteMatch();
        editorProperties.putBooleanProperty("insight-newdata-complete-single", bl5 && bl);
    }

    void loadSettingsFrom(InsightOptions insightOptions) {
        boolean bl = insightOptions.getInvokeCompleteMatch();
        boolean bl2 = insightOptions.getPartialCompleteMatch();
        boolean bl3 = insightOptions.getTypedCompleteMatch();
        boolean bl4 = insightOptions.getFilterCompletion();
        this.checkbox_invokeMatching.setSelected(bl);
        this.checkbox_partialMatching.setSelected(bl2);
        this.checkbox_typedMatching.setSelected(bl3);
        this.checkbox_filterCompletion.setSelected(bl4);
    }

    void saveSettingsTo(InsightOptions insightOptions) {
        boolean bl = this.checkbox_invokeMatching.isSelected();
        boolean bl2 = this.checkbox_partialMatching.isSelected();
        boolean bl3 = this.checkbox_typedMatching.isSelected();
        boolean bl4 = this.checkbox_filterCompletion.isSelected();
        insightOptions.setInvokeCompleteMatch(bl);
        insightOptions.setPartialCompleteMatch(bl2);
        insightOptions.setTypedCompleteMatch(bl3);
        insightOptions.setFilterCompletion(bl4);
    }

    private void initializeComponent() {
        String string = OptionsArb.getString(44);
        String string2 = OptionsArb.getString(45);
        String string3 = OptionsArb.getString(46);
        String string4 = OptionsArb.getString(47);
        JLabel jLabel = new JLabel(string);
        this.checkbox_invokeMatching = new JCheckBox();
        ResourceUtils.resButton(this.checkbox_invokeMatching, string2);
        this.checkbox_partialMatching = new JCheckBox();
        ResourceUtils.resButton(this.checkbox_partialMatching, string3);
        this.checkbox_typedMatching = new JCheckBox();
        ResourceUtils.resButton(this.checkbox_typedMatching, string4);
        String string5 = OptionsArb.getString(48);
        String string6 = OptionsArb.getString(49);
        JLabel jLabel2 = new JLabel(string6);
        this.checkbox_filterCompletion = new JCheckBox();
        ResourceUtils.resButton(this.checkbox_filterCompletion, string5);
        Insets insets = new Insets(2, 5, 2, 5);
        Insets insets2 = new Insets(0, 30, 2, 2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, insets2, 0, 0);
        this.add((Component)this.checkbox_invokeMatching, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 0, insets2, 0, 0);
        this.add((Component)this.checkbox_partialMatching, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 0, insets2, 0, 0);
        this.add((Component)this.checkbox_typedMatching, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 0, insets2, 0, 0);
        this.add(Box.createVerticalStrut(10), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        this.add((Component)this.checkbox_filterCompletion, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 6, 1, 1, 1.0, 0.0, 17, 0, insets2, 0, 0);
        this.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 7, 2, 1, 1.0, 1.0, 17, 0, insets, 0, 0);
        this.add(Box.createGlue(), gridBagConstraints);
    }
}

