/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.options;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.NumberFormat;
import java.util.Hashtable;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.ide.ceditor.options.DisplayOptions;
import oracle.ide.ceditor.options.OptionsArb;
import oracle.ide.controls.CustomColorChoice;
import oracle.ide.controls.ItemSelectableTracker;
import oracle.ide.controls.WholeNumberField;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.ApplyListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.editor.EditorProperties;

public final class DisplayOptionsPanel
extends DefaultTraversablePanel
implements ChangeListener,
ApplyListener {
    private JCheckBox checkBox_showCodeFoldingMargin;
    private JCheckBox checkBox_showCodeFoldingHighlight;
    private WholeNumberField textField_rightMarginColumn;
    private JCheckBox checkBox_showRightMargin;
    private CustomColorChoice colorChoice_rightMarginColor;
    private JCheckBox checkBox_autoBraceMatch;
    private JCheckBox checkBox_braceEnclosingBlock;
    private JCheckBox checkBox_braceEnclosingParens;
    private JSlider slider_braceMatchDelay;
    private JLabel label_braceMatchDelayText;
    private NumberFormat numberFormatter;
    private JCheckBox checkBox_useAAText;

    public DisplayOptionsPanel() {
        this.setHelpID("f1_idedidesetdisplay_html");
        this.setLayout(new GridBagLayout());
        this.initializeComponent();
    }

    public void onEntry(TraversableContext traversableContext) {
        DisplayOptions displayOptions = this.findOptions(traversableContext);
        this.loadSettingsFrom(displayOptions);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        DisplayOptions displayOptions = this.findOptions(traversableContext);
        this.saveSettingsTo(displayOptions);
    }

    private DisplayOptions findOptions(TraversableContext traversableContext) {
        DisplayOptions displayOptions = (DisplayOptions)traversableContext.find("DisplayOptions");
        return displayOptions;
    }

    public void apply(ApplyEvent applyEvent) {
        TraversableContext traversableContext = (TraversableContext)applyEvent.getSource();
        DisplayOptions displayOptions = this.findOptions(traversableContext);
        DisplayOptionsPanel.applyOptions(displayOptions);
    }

    public void cancel(ApplyEvent applyEvent) {
    }

    public static void applyOptions(DisplayOptions displayOptions) {
        EditorProperties editorProperties = EditorProperties.getProperties();
        boolean bl = displayOptions.getShowCodeFoldingMargin();
        editorProperties.putBooleanProperty("code-folding-margin-visible", bl);
        boolean bl2 = displayOptions.getShowCodeFoldingHighlight();
        editorProperties.putBooleanProperty("code-folding-highlight", bl2);
        boolean bl3 = displayOptions.getCodeFoldingEnabled();
        editorProperties.putBooleanProperty("code-folding-enabled", bl3);
        boolean bl4 = displayOptions.getShowRightMargin();
        editorProperties.putBooleanProperty("right-margin-visible", bl4);
        int n = displayOptions.getRightMarginColumn();
        editorProperties.putIntegerProperty("right-margin-column", n);
        int n2 = displayOptions.getRightMarginColor();
        Color color = new Color(n2);
        editorProperties.putProperty("right-margin-color", (Object)color);
        boolean bl5 = displayOptions.getAutoBraceMatch();
        boolean bl6 = displayOptions.getBraceEnclosingBlock();
        boolean bl7 = displayOptions.getBraceEnclosingParens();
        int n3 = displayOptions.getBraceMatchDelay();
        editorProperties.putBooleanProperty("brace-matching-auto", bl5);
        editorProperties.putBooleanProperty("brace-matching-enclosing-blocks", bl6);
        editorProperties.putBooleanProperty("brace-matching-enclosing-parens", bl7);
        editorProperties.putIntegerProperty("brace-matching-delay", n3);
        if (!DisplayOptionsPanel.hasAntialiasProperty()) {
            boolean bl8 = displayOptions.getUseAAText();
            editorProperties.putBooleanProperty("editor-antialiasing", bl8);
        }
    }

    private static boolean hasAntialiasProperty() {
        EditorProperties editorProperties = EditorProperties.getProperties();
        return editorProperties.getBooleanProperty("editor-antialiasing-set");
    }

    public void stateChanged(ChangeEvent changeEvent) {
        float f = (float)this.slider_braceMatchDelay.getValue() / 10.0f;
        String string = OptionsArb.format(125, this.numberFormatter.format(f));
        this.slider_braceMatchDelay.setToolTipText(string);
        this.label_braceMatchDelayText.setText(string);
    }

    void loadSettingsFrom(DisplayOptions displayOptions) {
        boolean bl = displayOptions.getShowCodeFoldingMargin();
        boolean bl2 = displayOptions.getShowCodeFoldingHighlight();
        boolean bl3 = displayOptions.getCodeFoldingEnabled();
        boolean bl4 = displayOptions.getShowRightMargin();
        int n = displayOptions.getRightMarginColumn();
        int n2 = displayOptions.getRightMarginColor();
        this.checkBox_showCodeFoldingMargin.setSelected(bl);
        this.checkBox_showCodeFoldingHighlight.setSelected(bl2);
        this.checkBox_showRightMargin.setSelected(bl4);
        this.textField_rightMarginColumn.setText(Integer.toString(n));
        this.colorChoice_rightMarginColor.setClosestSelectedColor(new Color(n2));
        boolean bl5 = displayOptions.getAutoBraceMatch();
        boolean bl6 = displayOptions.getBraceEnclosingBlock();
        boolean bl7 = displayOptions.getBraceEnclosingParens();
        int n3 = displayOptions.getBraceMatchDelay();
        this.checkBox_autoBraceMatch.setSelected(bl5);
        this.checkBox_braceEnclosingBlock.setSelected(bl6);
        this.checkBox_braceEnclosingParens.setSelected(bl7);
        this.slider_braceMatchDelay.setValue(n3 / 100);
        boolean bl8 = displayOptions.getUseAAText();
        this.checkBox_useAAText.setSelected(bl8);
    }

    void saveSettingsTo(DisplayOptions displayOptions) throws TraversalException {
        int n;
        try {
            n = this.textField_rightMarginColumn.getValue();
        }
        catch (NullPointerException nullPointerException) {
            n = -1;
        }
        if (n < 10 || n > 200) {
            String string = OptionsArb.getString(25);
            String string2 = OptionsArb.getString(26);
            this.showErrorDialog(string, string2);
            this.textField_rightMarginColumn.selectAll();
            this.textField_rightMarginColumn.requestFocus();
            throw new TraversalException(null);
        }
        boolean bl = this.checkBox_showCodeFoldingMargin.isSelected();
        boolean bl2 = this.checkBox_showCodeFoldingHighlight.isSelected();
        boolean bl3 = this.checkBox_showRightMargin.isSelected();
        Color color = this.colorChoice_rightMarginColor.getSelectedColor();
        displayOptions.setShowCodeFoldingMargin(bl);
        displayOptions.setShowCodeFoldingHighlight(bl2);
        displayOptions.setRightMarginColumn(n);
        displayOptions.setShowRightMargin(bl3);
        displayOptions.setRightMarginColor(color.getRGB());
        boolean bl4 = this.checkBox_autoBraceMatch.isSelected();
        boolean bl5 = this.checkBox_braceEnclosingBlock.isSelected();
        boolean bl6 = this.checkBox_braceEnclosingParens.isSelected();
        int n2 = this.slider_braceMatchDelay.getValue() * 100;
        displayOptions.setAutoBraceMatch(bl4);
        displayOptions.setBraceEnclosingBlock(bl5);
        displayOptions.setBraceEnclosingParens(bl6);
        displayOptions.setBraceMatchDelay(n2);
        boolean bl7 = this.checkBox_useAAText.isSelected();
        displayOptions.setUseAAText(bl7);
    }

    private void showErrorDialog(String string, String string2) {
        JOptionPane.showMessageDialog(this, string, string2, 2);
    }

    private void initializeComponent() {
        this.numberFormatter = NumberFormat.getNumberInstance();
        this.numberFormatter.setMinimumFractionDigits(1);
        this.numberFormatter.setMaximumFractionDigits(1);
        String string = OptionsArb.getString(16);
        this.checkBox_showCodeFoldingMargin = new JCheckBox();
        ResourceUtils.resButton(this.checkBox_showCodeFoldingMargin, string);
        String string2 = OptionsArb.getString(17);
        this.checkBox_showCodeFoldingHighlight = new JCheckBox();
        ResourceUtils.resButton(this.checkBox_showCodeFoldingHighlight, string2);
        Component[] componentArray = new Component[]{this.checkBox_showCodeFoldingHighlight};
        ItemSelectableTracker itemSelectableTracker = new ItemSelectableTracker(this.checkBox_showCodeFoldingMargin, componentArray);
        String string3 = OptionsArb.getString(18);
        this.checkBox_showRightMargin = new JCheckBox();
        ResourceUtils.resButton(this.checkBox_showRightMargin, string3);
        String string4 = OptionsArb.getString(19);
        JLabel jLabel = new JLabel();
        this.textField_rightMarginColumn = new WholeNumberField(5);
        ResourceUtils.resLabel(jLabel, (Component)((Object)this.textField_rightMarginColumn), string4);
        String string5 = OptionsArb.getString(20);
        JLabel jLabel2 = new JLabel();
        this.colorChoice_rightMarginColor = new CustomColorChoice();
        ResourceUtils.resLabel(jLabel2, (Component)((Object)this.colorChoice_rightMarginColor), string5);
        componentArray = new Component[]{this.textField_rightMarginColumn, jLabel, jLabel2, this.colorChoice_rightMarginColor};
        itemSelectableTracker = new ItemSelectableTracker(this.checkBox_showRightMargin, componentArray);
        String string6 = OptionsArb.getString(21);
        this.checkBox_autoBraceMatch = new JCheckBox();
        ResourceUtils.resButton(this.checkBox_autoBraceMatch, string6);
        String string7 = OptionsArb.getString(22);
        this.checkBox_braceEnclosingBlock = new JCheckBox();
        ResourceUtils.resButton(this.checkBox_braceEnclosingBlock, string7);
        String string8 = OptionsArb.getString(23);
        this.checkBox_braceEnclosingParens = new JCheckBox();
        ResourceUtils.resButton(this.checkBox_braceEnclosingParens, string8);
        String string9 = OptionsArb.getString(24);
        JLabel jLabel3 = new JLabel();
        this.slider_braceMatchDelay = new JSlider(1, 20, 2);
        this.slider_braceMatchDelay.addChangeListener(this);
        this.label_braceMatchDelayText = new JLabel();
        ResourceUtils.resLabel(jLabel3, this.slider_braceMatchDelay, string9);
        String string10 = this.numberFormatter.format(0.1);
        String string11 = this.numberFormatter.format(2.0);
        JLabel jLabel4 = new JLabel(string10);
        JLabel jLabel5 = new JLabel(string11);
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>(5);
        hashtable.put(new Integer(1), jLabel4);
        hashtable.put(new Integer(20), jLabel5);
        this.slider_braceMatchDelay.setLabelTable(hashtable);
        this.slider_braceMatchDelay.setPaintLabels(true);
        this.slider_braceMatchDelay.setPaintTicks(true);
        this.slider_braceMatchDelay.setMajorTickSpacing(10);
        this.slider_braceMatchDelay.setMinorTickSpacing(1);
        this.slider_braceMatchDelay.setSnapToTicks(true);
        componentArray = new Component[]{this.slider_braceMatchDelay, jLabel3, this.label_braceMatchDelayText, jLabel4, jLabel5, this.checkBox_braceEnclosingBlock, this.checkBox_braceEnclosingParens};
        itemSelectableTracker = new ItemSelectableTracker(this.checkBox_autoBraceMatch, componentArray);
        this.checkBox_autoBraceMatch.addItemListener(itemSelectableTracker);
        this.slider_braceMatchDelay.setValue(1);
        String string12 = OptionsArb.getString(15);
        this.checkBox_useAAText = new JCheckBox();
        ResourceUtils.resButton(this.checkBox_useAAText, string12);
        Insets insets = new Insets(2, 5, 2, 5);
        Insets insets2 = new Insets(2, 30, 2, 5);
        Insets insets3 = new Insets(2, 55, 2, 5);
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        jPanel.add((Component)this.checkBox_showRightMargin, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, insets2, 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        jPanel.add((Component)((Object)this.textField_rightMarginColumn), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, insets2, 0, 0);
        jPanel.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        jPanel.add((Component)((Object)this.colorChoice_rightMarginColor), gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        jPanel2.add((Component)this.checkBox_autoBraceMatch, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 17, 0, insets2, 0, 0);
        jPanel2.add((Component)this.checkBox_braceEnclosingBlock, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 17, 0, insets2, 0, 0);
        jPanel2.add((Component)this.checkBox_braceEnclosingParens, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, insets2, 0, 0);
        jPanel2.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, insets3, 0, 0);
        jPanel2.add((Component)this.label_braceMatchDelayText, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 3, 1, 2, 1.0, 0.0, 17, 2, insets, 0, 0);
        jPanel2.add((Component)this.slider_braceMatchDelay, gridBagConstraints);
        Insets insets4 = new Insets(0, 0, 0, 0);
        if (!DisplayOptionsPanel.hasAntialiasProperty()) {
            gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0);
            this.add((Component)this.checkBox_useAAText, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0);
            this.add(Box.createVerticalStrut(5), gridBagConstraints);
        }
        gridBagConstraints = new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0);
        this.add((Component)this.checkBox_showCodeFoldingMargin, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 2, insets2, 0, 0);
        this.add((Component)this.checkBox_showCodeFoldingHighlight, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0);
        this.add(Box.createVerticalStrut(5), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 17, 2, insets4, 0, 0);
        this.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 6, 1, 1, 1.0, 0.0, 17, 1, insets, 0, 0);
        this.add(Box.createVerticalStrut(5), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 7, 1, 1, 1.0, 0.0, 17, 2, insets4, 0, 0);
        this.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 8, 1, 1, 1.0, 1.0, 17, 1, insets, 0, 0);
        this.add(Box.createVerticalGlue(), gridBagConstraints);
    }
}

