/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.options;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import oracle.ide.ceditor.options.EditorOptions;
import oracle.ide.ceditor.options.OptionsArb;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.ApplyListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.editor.EditorProperties;

public final class EditorOptionsPanel
extends DefaultTraversablePanel
implements ApplyListener {
    private JCheckBox checkBox_autoIndent;
    private JCheckBox checkBox_useBlockOnSelection;
    private JCheckBox checkBox_useJumpScroll;
    private JCheckBox checkBox_useSmartHome;
    private JCheckBox checkBox_useSmartEnd;
    private JCheckBox checkBox_useLineStartForWord;
    private JCheckBox checkBox_useLineEndForWord;
    private JCheckBox checkBox_cutCopyLine;
    private JCheckBox checkBox_importsCopyPaste;
    private JCheckBox checkBox_indentCopyPaste;
    private JCheckBox checkBox_escapeStringPaste;

    public EditorOptionsPanel() {
        this.setHelpID("f1_idedideseteditor_html");
        this.setLayout(new GridBagLayout());
        this.initializeComponent();
    }

    public void onEntry(TraversableContext traversableContext) {
        EditorOptions editorOptions = this.findOptions(traversableContext);
        this.loadSettingsFrom(editorOptions);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        EditorOptions editorOptions = this.findOptions(traversableContext);
        this.saveSettingsTo(editorOptions);
    }

    private EditorOptions findOptions(TraversableContext traversableContext) {
        EditorOptions editorOptions = (EditorOptions)traversableContext.find("EditorOptions");
        return editorOptions;
    }

    public void apply(ApplyEvent applyEvent) {
        TraversableContext traversableContext = (TraversableContext)applyEvent.getSource();
        EditorOptions editorOptions = this.findOptions(traversableContext);
        EditorOptionsPanel.applyOptions(editorOptions);
    }

    public void cancel(ApplyEvent applyEvent) {
    }

    public static void applyOptions(EditorOptions editorOptions) {
        EditorProperties editorProperties = EditorProperties.getProperties();
        boolean bl = editorOptions.getAutoIndent();
        editorProperties.putBooleanProperty("use-auto-indent", bl);
        boolean bl2 = editorOptions.getUseBlockOnSelection();
        editorProperties.putBooleanProperty("do-block-indents-on-selection", bl2);
        boolean bl3 = editorOptions.getUseJumpScroll();
        editorProperties.putBooleanProperty("use-jump-scroll", bl3);
        boolean bl4 = editorOptions.getUseSmartHome();
        editorProperties.putBooleanProperty("use-smart-home", bl4);
        boolean bl5 = editorOptions.getUseSmartEnd();
        editorProperties.putBooleanProperty("use-smart-end", bl5);
        boolean bl6 = editorOptions.getUseLineStartForWord();
        editorProperties.putBooleanProperty("word-boundary-use-line-start", bl6);
        boolean bl7 = editorOptions.getUseLineEndForWord();
        editorProperties.putBooleanProperty("word-boundary-use-line-end", bl7);
        boolean bl8 = editorOptions.getCutCopyLine();
        editorProperties.putBooleanProperty("cut-copy-line", bl8);
        boolean bl9 = editorOptions.getImportsCopyPaste();
        editorProperties.putBooleanProperty("smart-copy-paste", bl9);
        boolean bl10 = editorOptions.getIndentCopyPaste();
        editorProperties.putBooleanProperty("autoindent-copy-paste", bl10);
        boolean bl11 = editorOptions.getEscapeStringPaste();
        editorProperties.putBooleanProperty("escape-string-paste", bl11);
        boolean bl12 = editorOptions.getReuseUndoEvent();
        editorProperties.putBooleanProperty("reuse-undoable-edit", bl12);
        boolean bl13 = editorOptions.getReuseDocEvent();
        editorProperties.putBooleanProperty("reuse-document-event", bl13);
        boolean bl14 = editorOptions.getUseExpensivePasteChecking();
        editorProperties.putBooleanProperty("check-clipboard-for-paste", bl14);
    }

    void loadSettingsFrom(EditorOptions editorOptions) {
        boolean bl = editorOptions.getAutoIndent();
        boolean bl2 = editorOptions.getUseBlockOnSelection();
        boolean bl3 = editorOptions.getUseJumpScroll();
        boolean bl4 = editorOptions.getUseSmartHome();
        boolean bl5 = editorOptions.getUseSmartEnd();
        boolean bl6 = editorOptions.getUseLineStartForWord();
        boolean bl7 = editorOptions.getUseLineEndForWord();
        boolean bl8 = editorOptions.getCutCopyLine();
        boolean bl9 = editorOptions.getImportsCopyPaste();
        boolean bl10 = editorOptions.getIndentCopyPaste();
        boolean bl11 = editorOptions.getEscapeStringPaste();
        this.checkBox_autoIndent.setSelected(bl);
        this.checkBox_useBlockOnSelection.setSelected(bl2);
        this.checkBox_useJumpScroll.setSelected(bl3);
        this.checkBox_useSmartHome.setSelected(bl4);
        this.checkBox_useSmartEnd.setSelected(bl5);
        this.checkBox_useLineStartForWord.setSelected(bl6);
        this.checkBox_useLineEndForWord.setSelected(bl7);
        this.checkBox_cutCopyLine.setSelected(bl8);
        this.checkBox_importsCopyPaste.setSelected(bl9);
        this.checkBox_indentCopyPaste.setSelected(bl10);
        this.checkBox_escapeStringPaste.setSelected(bl11);
    }

    void saveSettingsTo(EditorOptions editorOptions) throws TraversalException {
        boolean bl = this.checkBox_autoIndent.isSelected();
        boolean bl2 = this.checkBox_useBlockOnSelection.isSelected();
        boolean bl3 = this.checkBox_useJumpScroll.isSelected();
        boolean bl4 = this.checkBox_useSmartHome.isSelected();
        boolean bl5 = this.checkBox_useSmartEnd.isSelected();
        boolean bl6 = this.checkBox_useLineStartForWord.isSelected();
        boolean bl7 = this.checkBox_useLineEndForWord.isSelected();
        boolean bl8 = this.checkBox_cutCopyLine.isSelected();
        boolean bl9 = this.checkBox_importsCopyPaste.isSelected();
        boolean bl10 = this.checkBox_indentCopyPaste.isSelected();
        boolean bl11 = this.checkBox_escapeStringPaste.isSelected();
        editorOptions.setAutoIndent(bl);
        editorOptions.setUseBlockOnSelection(bl2);
        editorOptions.setUseJumpScroll(bl3);
        editorOptions.setUseSmartHome(bl4);
        editorOptions.setUseSmartEnd(bl5);
        editorOptions.setUseLineStartForWord(bl6);
        editorOptions.setUseLineEndForWord(bl7);
        editorOptions.setCutCopyLine(bl8);
        editorOptions.setImportsCopyPaste(bl9);
        editorOptions.setIndentCopyPaste(bl10);
        editorOptions.setEscapeStringPaste(bl11);
    }

    private void showErrorDialog(String string, String string2) {
        JOptionPane.showMessageDialog(this, string, string2, 2);
    }

    private void initializeComponent() {
        String string = OptionsArb.getString(1);
        this.checkBox_autoIndent = new JCheckBox();
        ResourceUtils.resButton(this.checkBox_autoIndent, string);
        String string2 = OptionsArb.getString(2);
        this.checkBox_useBlockOnSelection = new JCheckBox();
        ResourceUtils.resButton(this.checkBox_useBlockOnSelection, string2);
        String string3 = OptionsArb.getString(3);
        this.checkBox_useJumpScroll = new JCheckBox();
        ResourceUtils.resButton(this.checkBox_useJumpScroll, string3);
        String string4 = OptionsArb.getString(4);
        this.checkBox_useSmartHome = new JCheckBox();
        ResourceUtils.resButton(this.checkBox_useSmartHome, string4);
        String string5 = OptionsArb.getString(5);
        this.checkBox_useSmartEnd = new JCheckBox();
        ResourceUtils.resButton(this.checkBox_useSmartEnd, string5);
        String string6 = OptionsArb.getString(6);
        this.checkBox_useLineStartForWord = new JCheckBox();
        ResourceUtils.resButton(this.checkBox_useLineStartForWord, string6);
        String string7 = OptionsArb.getString(7);
        this.checkBox_useLineEndForWord = new JCheckBox();
        ResourceUtils.resButton(this.checkBox_useLineEndForWord, string7);
        String string8 = OptionsArb.getString(8);
        this.checkBox_cutCopyLine = new JCheckBox();
        ResourceUtils.resButton(this.checkBox_cutCopyLine, string8);
        String string9 = OptionsArb.getString(9);
        this.checkBox_importsCopyPaste = new JCheckBox();
        ResourceUtils.resButton(this.checkBox_importsCopyPaste, string9);
        String string10 = OptionsArb.getString(10);
        this.checkBox_indentCopyPaste = new JCheckBox();
        ResourceUtils.resButton(this.checkBox_indentCopyPaste, string10);
        String string11 = OptionsArb.getString(11);
        this.checkBox_escapeStringPaste = new JCheckBox();
        ResourceUtils.resButton(this.checkBox_escapeStringPaste, string11);
        Insets insets = new Insets(0, 5, 0, 5);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        this.add((Component)this.checkBox_autoIndent, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        this.add((Component)this.checkBox_useBlockOnSelection, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        this.add((Component)this.checkBox_useSmartHome, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        this.add((Component)this.checkBox_useSmartEnd, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        this.add((Component)this.checkBox_useJumpScroll, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        this.add((Component)this.checkBox_useLineStartForWord, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 6, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        this.add((Component)this.checkBox_useLineEndForWord, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 7, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        this.add((Component)this.checkBox_cutCopyLine, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 8, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        this.add((Component)this.checkBox_importsCopyPaste, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 9, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        this.add((Component)this.checkBox_indentCopyPaste, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 10, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        this.add((Component)this.checkBox_escapeStringPaste, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 11, 1, 1, 1.0, 1.0, 17, 1, insets, 0, 0);
        this.add(Box.createVerticalGlue(), gridBagConstraints);
    }
}

