/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.options;

import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.ceditor.options.FontSettings;
import oracle.ide.ceditor.options.OptionsArb;
import oracle.ide.config.DTCache;

public final class FontManager {
    private static FontManager singleton;
    private String[] proportionalList;
    private String[] fixedList;
    private String[] symbolList;
    private String[] allList;
    private List unknownList;

    public static FontManager getInstance() {
        if (singleton == null) {
            singleton = new FontManager();
        }
        return singleton;
    }

    private FontManager() {
        this.loadSettings();
        this.unknownList = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFontInfoComplete() {
        boolean bl = false;
        FontManager fontManager = this;
        synchronized (fontManager) {
            if (this.unknownList == null) {
                bl = true;
            } else if (this.unknownList.size() <= 0) {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.addAll(Arrays.asList(this.proportionalList));
                arrayList.addAll(Arrays.asList(this.fixedList));
                arrayList.addAll(Arrays.asList(this.symbolList));
                String[] stringArray = this.getAllFontFamilies();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray[n2];
                    if (arrayList.indexOf(string) == -1) {
                        this.unknownList.add(string);
                    }
                    ++n2;
                }
                if (this.unknownList.size() == 0) {
                    this.unknownList = null;
                    bl = true;
                }
            }
        }
        return bl;
    }

    public void updateFontInfo(Frame frame) {
        if (this.isFontInfoComplete()) {
            return;
        }
        FontDialog fontDialog = new FontDialog(null);
        FontDialog.mav$showDialog(fontDialog, frame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getKnownProportionalFamilies() {
        String[] stringArray;
        FontManager fontManager = this;
        synchronized (fontManager) {
            stringArray = this.proportionalList;
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getKnownFixedFamilies() {
        String[] stringArray;
        FontManager fontManager = this;
        synchronized (fontManager) {
            stringArray = this.fixedList;
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getKnownSymbolFamilies() {
        String[] stringArray;
        FontManager fontManager = this;
        synchronized (fontManager) {
            stringArray = this.symbolList;
        }
        return stringArray;
    }

    public String[] getAllFontFamilies() {
        if (this.allList == null) {
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            this.allList = graphicsEnvironment.getAvailableFontFamilyNames();
            Arrays.sort(this.allList);
        }
        return this.allList;
    }

    private void loadSettings() {
        DTCache dTCache = Ide.getDTCache();
        FontSettings fontSettings = (FontSettings)dTCache.getData("FontSettings");
        if (fontSettings == null) {
            fontSettings = new FontSettings();
            dTCache.putData("FontSettings", fontSettings);
        }
        this.proportionalList = fontSettings.getProportionalFamilies();
        this.fixedList = fontSettings.getFixedFamilies();
        this.symbolList = fontSettings.getSymbolFamilies();
        Arrays.sort(this.proportionalList);
        Arrays.sort(this.fixedList);
        Arrays.sort(this.symbolList);
    }

    private void saveSettings() {
        FontSettings fontSettings = new FontSettings();
        fontSettings.setProportionalFamilies(this.proportionalList);
        fontSettings.setFixedFamilies(this.fixedList);
        fontSettings.setSymbolFamilies(this.symbolList);
        DTCache dTCache = Ide.getDTCache();
        dTCache.putData("FontSettings", fontSettings);
    }

    static List ra$unknownList(FontManager fontManager) {
        return fontManager.unknownList;
    }

    static String[] ra$proportionalList(FontManager fontManager) {
        return fontManager.proportionalList;
    }

    static void wa$proportionalList(FontManager fontManager, String[] stringArray) {
        fontManager.proportionalList = stringArray;
    }

    static String[] ra$fixedList(FontManager fontManager) {
        return fontManager.fixedList;
    }

    static void wa$fixedList(FontManager fontManager, String[] stringArray) {
        fontManager.fixedList = stringArray;
    }

    static String[] ra$symbolList(FontManager fontManager) {
        return fontManager.symbolList;
    }

    static void wa$symbolList(FontManager fontManager, String[] stringArray) {
        fontManager.symbolList = stringArray;
    }

    static void mav$saveSettings(FontManager fontManager) {
        fontManager.saveSettings();
    }

    private final class FontDialog
    implements Runnable,
    ActionListener {
        private JLabel statusLabel;
        private JProgressBar progressBar;
        private JEWTDialog statusDialog;
        private int completionStatus;
        private String currentFont;
        private Timer labelTimer;
        private Timer completionTimer;
        private boolean bail;

        private void showDialog(Frame frame) {
            String string = OptionsArb.getString(59);
            this.statusLabel = new JLabel(string);
            this.progressBar = new JProgressBar();
            this.progressBar.setValue(0);
            this.statusLabel.setLabelFor(this.progressBar);
            JPanel jPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0);
            jPanel.add((Component)this.statusLabel, gridBagConstraints);
            gridBagConstraints.gridy = 1;
            jPanel.add((Component)this.progressBar, gridBagConstraints);
            gridBagConstraints.gridy = 2;
            jPanel.add(Box.createHorizontalStrut(300), gridBagConstraints);
            this.labelTimer = new Timer(1, this);
            this.labelTimer.setRepeats(false);
            this.completionTimer = new Timer(1, this);
            this.labelTimer.setRepeats(false);
            this.bail = false;
            String string2 = OptionsArb.getString(58);
            this.statusDialog = new JEWTDialog(frame, string2, 2);
            this.statusDialog.setContent((Component)jPanel);
            this.statusDialog.setDefaultButton(2);
            Thread thread = new Thread(this);
            thread.setPriority(1);
            thread.start();
            this.statusDialog.runDialog();
            this.bail = true;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.labelTimer) {
                String string = OptionsArb.getString(60);
                string = string + "  " + this.currentFont;
                this.statusLabel.setText(string);
                this.progressBar.setValue(this.completionStatus);
            } else if (object == this.completionTimer) {
                if (this.statusDialog.isVisible()) {
                    this.statusDialog.hide();
                    this.statusDialog.dispose();
                }
                this.labelTimer.stop();
                this.labelTimer.removeActionListener(this);
                this.completionTimer.stop();
                this.completionTimer.removeActionListener(this);
                this.labelTimer = null;
                this.completionTimer = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            FontManager fontManager = FontManager.this;
            synchronized (fontManager) {
                int n = FontManager.ra$unknownList(FontManager.this).size();
                String[] stringArray = FontManager.ra$unknownList(FontManager.this).toArray(new String[n]);
                ArrayList<String> arrayList = new ArrayList<String>();
                ArrayList<String> arrayList2 = new ArrayList<String>();
                ArrayList<String> arrayList3 = new ArrayList<String>();
                long l = System.currentTimeMillis();
                int n2 = 0;
                while (n2 < n) {
                    String string;
                    if (this.bail) break;
                    long l2 = System.currentTimeMillis();
                    long l3 = l2 - l;
                    if (l3 > 1000L) {
                        try {
                            Thread.sleep(100);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        l = l2;
                    }
                    if (this.bail) break;
                    this.currentFont = string = stringArray[n2];
                    this.completionStatus = n2 * 100 / n;
                    this.labelTimer.start();
                    if (this.bail) break;
                    Font font = new Font(string, 0, 12);
                    if (this.bail) break;
                    if (!font.canDisplay('a')) {
                        arrayList3.add(string);
                    } else {
                        if (this.bail) break;
                        FontMetrics fontMetrics = this.statusDialog.getFontMetrics(font);
                        if (fontMetrics.charWidth('l') == fontMetrics.charWidth('w')) {
                            arrayList2.add(string);
                        } else {
                            arrayList.add(string);
                        }
                    }
                    ++n2;
                }
                FontManager.ra$unknownList(FontManager.this).clear();
                arrayList.addAll(Arrays.asList(FontManager.ra$proportionalList(FontManager.this)));
                int n3 = arrayList.size();
                FontManager.wa$proportionalList(FontManager.this, arrayList.toArray(new String[n3]));
                Arrays.sort(FontManager.ra$proportionalList(FontManager.this));
                arrayList2.addAll(Arrays.asList(FontManager.ra$fixedList(FontManager.this)));
                int n4 = arrayList2.size();
                FontManager.wa$fixedList(FontManager.this, arrayList2.toArray(new String[n4]));
                Arrays.sort(FontManager.ra$fixedList(FontManager.this));
                arrayList3.addAll(Arrays.asList(FontManager.ra$symbolList(FontManager.this)));
                int n5 = arrayList3.size();
                FontManager.wa$symbolList(FontManager.this, arrayList3.toArray(new String[n5]));
                Arrays.sort(FontManager.ra$symbolList(FontManager.this));
                FontManager.mav$saveSettings(FontManager.this);
            }
            this.completionTimer.start();
        }

        private FontDialog() {
        }

        FontDialog(1 var2_2) {
            this();
        }

        static void mav$showDialog(FontDialog fontDialog, Frame frame) {
            fontDialog.showDialog(frame);
        }

        public final class 1 {
        }
    }
}

