/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.options;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import oracle.ide.ceditor.options.FontManager;
import oracle.ide.ceditor.options.FontSizeOptions;
import oracle.ide.ceditor.options.OptionsArb;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.ApplyListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.editor.EditorProperties;

public final class FontSizeOptionsPanel
extends DefaultTraversablePanel
implements ItemListener,
DocumentListener,
ApplyListener,
ActionListener {
    private JCheckBox checkBox_showFixedOnly;
    private JComboBox comboBox_fontFamily;
    private JComboBox comboBox_fontSize;
    private JTextField textField_sampleText;
    private JLabel label_normalFont;
    private JLabel label_boldFont;
    private JLabel label_italicFont;
    private JLabel label_boldItalicFont;
    private Timer fontCheckTimer;
    private static String DEFAULT_FONT = "DialogInput";

    public FontSizeOptionsPanel() {
        this.setHelpID("f1_idedidesetfonts_html");
        this.setLayout(new GridBagLayout());
        this.initializeComponent();
    }

    public void onEntry(TraversableContext traversableContext) {
        FontSizeOptions fontSizeOptions = this.findOptions(traversableContext);
        this.loadSettingsFrom(fontSizeOptions);
    }

    public void onExit(TraversableContext traversableContext) {
        FontSizeOptions fontSizeOptions = this.findOptions(traversableContext);
        this.saveSettingsTo(fontSizeOptions);
    }

    private FontSizeOptions findOptions(TraversableContext traversableContext) {
        FontSizeOptions fontSizeOptions = (FontSizeOptions)traversableContext.find("FontSizeOptions");
        return fontSizeOptions;
    }

    public void apply(ApplyEvent applyEvent) {
        TraversableContext traversableContext = (TraversableContext)applyEvent.getSource();
        FontSizeOptions fontSizeOptions = this.findOptions(traversableContext);
        FontSizeOptionsPanel.applyOptions(fontSizeOptions);
    }

    public void cancel(ApplyEvent applyEvent) {
    }

    public static void applyOptions(FontSizeOptions fontSizeOptions) {
        EditorProperties editorProperties = EditorProperties.getProperties();
        String string = fontSizeOptions.getFontFamily();
        int n = fontSizeOptions.getFontSize();
        editorProperties.setBaseFont(string, n);
    }

    void loadSettingsFrom(FontSizeOptions fontSizeOptions) {
        String string = fontSizeOptions.getFontFamily();
        int n = fontSizeOptions.getFontSize();
        boolean bl = fontSizeOptions.getShowOnlyFixedWidth();
        this.checkBox_showFixedOnly.setSelected(false);
        this.setSelectedFontFamily(string);
        this.comboBox_fontSize.setSelectedItem(new Integer(n));
        this.checkBox_showFixedOnly.setSelected(bl);
    }

    void saveSettingsTo(FontSizeOptions fontSizeOptions) {
        String string = this.comboBox_fontFamily.getSelectedItem().toString();
        Integer n = (Integer)this.comboBox_fontSize.getSelectedItem();
        int n2 = n;
        boolean bl = this.checkBox_showFixedOnly.isSelected();
        fontSizeOptions.setFontFamily(string);
        fontSizeOptions.setFontSize(n2);
        fontSizeOptions.setShowOnlyFixedWidth(bl);
    }

    private void initializeComponent() {
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        String string = OptionsArb.getString(51);
        JLabel jLabel = new JLabel();
        Object[] objectArray = new String[]{DEFAULT_FONT};
        NonNullableComboBoxModel nonNullableComboBoxModel = new NonNullableComboBoxModel(objectArray);
        this.comboBox_fontFamily = new JComboBox(nonNullableComboBoxModel);
        this.comboBox_fontFamily.setEditable(false);
        this.comboBox_fontFamily.setSelectedItem(objectArray[0]);
        this.comboBox_fontFamily.addItemListener(this);
        ResourceUtils.resLabel(jLabel, this.comboBox_fontFamily, string);
        String string2 = OptionsArb.getString(52);
        JLabel jLabel2 = new JLabel();
        Object[] objectArray2 = new Integer[]{new Integer(7), new Integer(8), new Integer(9), new Integer(10), new Integer(11), new Integer(12), new Integer(13), new Integer(14), new Integer(15), new Integer(16), new Integer(17), new Integer(18), new Integer(19), new Integer(20), new Integer(21), new Integer(22), new Integer(23), new Integer(24)};
        NonNullableComboBoxModel nonNullableComboBoxModel2 = new NonNullableComboBoxModel(objectArray2);
        this.comboBox_fontSize = new JComboBox(nonNullableComboBoxModel2);
        this.comboBox_fontSize.setEditable(false);
        this.comboBox_fontSize.setSelectedItem(objectArray2[0]);
        this.comboBox_fontSize.addItemListener(this);
        ResourceUtils.resLabel(jLabel2, this.comboBox_fontSize, string2);
        String string3 = OptionsArb.getString(53);
        String string4 = OptionsArb.getString(54);
        JLabel jLabel3 = new JLabel();
        this.textField_sampleText = new JTextField(string4);
        Document document = this.textField_sampleText.getDocument();
        document.addDocumentListener(this);
        ResourceUtils.resLabel(jLabel3, this.textField_sampleText, string3);
        String string5 = OptionsArb.getString(55);
        JLabel jLabel4 = new JLabel(string5, 2);
        this.label_normalFont = new JLabel(string4);
        this.label_boldFont = new JLabel(string4);
        this.label_italicFont = new JLabel(string4);
        this.label_boldItalicFont = new JLabel(string4);
        Box box = Box.createVerticalBox();
        box.add(this.label_normalFont);
        box.add(this.label_boldFont);
        box.add(this.label_italicFont);
        box.add(this.label_boldItalicFont);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)box, "Center");
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        FontManager fontManager = FontManager.getInstance();
        String string6 = fontManager.isFontInfoComplete() ? OptionsArb.getString(57) : OptionsArb.getString(56);
        this.checkBox_showFixedOnly = new JCheckBox();
        this.checkBox_showFixedOnly.setSelected(true);
        this.checkBox_showFixedOnly.addItemListener(this);
        this.checkBox_showFixedOnly.setSelected(false);
        ResourceUtils.resButton(this.checkBox_showFixedOnly, string6);
        Insets insets = new Insets(5, 5, 5, 5);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0);
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0);
        this.add((Component)this.comboBox_fontFamily, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        this.add((Component)this.checkBox_showFixedOnly, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0);
        this.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0);
        this.add((Component)this.comboBox_fontSize, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0);
        this.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0);
        this.add((Component)this.textField_sampleText, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        this.add((Component)jLabel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 5, 2, 1, 1.0, 1.0, 17, 1, insets, 0, 0);
        this.add((Component)jScrollPane, gridBagConstraints);
    }

    private void setSelectedFontFamily(String string) {
        ComboBoxModel comboBoxModel = this.comboBox_fontFamily.getModel();
        int n = comboBoxModel.getSize();
        int n2 = 0;
        while (n2 < n) {
            Object e = comboBoxModel.getElementAt(n2);
            if (e.equals(string)) {
                this.comboBox_fontFamily.setSelectedItem(string);
            }
            ++n2;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl;
        Frame frame = null;
        Container container = this.getParent();
        while (container != null) {
            if (container instanceof Frame) {
                frame = (Frame)container;
                break;
            }
            container = container.getParent();
        }
        FontManager fontManager = FontManager.getInstance();
        if (!fontManager.isFontInfoComplete()) {
            fontManager.updateFontInfo(frame);
        }
        if (!(bl = fontManager.isFontInfoComplete())) {
            this.checkBox_showFixedOnly.setSelected(false);
        } else {
            String string = (String)this.comboBox_fontFamily.getSelectedItem();
            Object[] objectArray = fontManager.getKnownFixedFamilies();
            NonNullableComboBoxModel nonNullableComboBoxModel = new NonNullableComboBoxModel(objectArray);
            this.comboBox_fontFamily.setModel(nonNullableComboBoxModel);
            this.setSelectedFontFamily(DEFAULT_FONT);
            this.setSelectedFontFamily(string);
            String string2 = OptionsArb.getString(57);
            ResourceUtils.resButton(this.checkBox_showFixedOnly, string2);
        }
        if (this.fontCheckTimer != null) {
            this.fontCheckTimer.removeActionListener(this);
            this.fontCheckTimer = null;
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateSampleLabelText();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateSampleLabelText();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    private void updateSampleLabelText() {
        String string = this.textField_sampleText.getText();
        this.label_normalFont.setText(string);
        this.label_boldFont.setText(string);
        this.label_italicFont.setText(string);
        this.label_boldItalicFont.setText(string);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.comboBox_fontFamily || object == this.comboBox_fontSize) {
            ItemSelectable itemSelectable = itemEvent.getItemSelectable();
            Object object2 = itemEvent.getItem();
            int n = itemEvent.getStateChange();
            if (n == 1) {
                this.updateSampleFonts();
            }
        } else if (object == this.checkBox_showFixedOnly) {
            boolean bl = this.checkBox_showFixedOnly.isSelected();
            if (bl) {
                this.fontCheckTimer = new Timer(100, this);
                this.fontCheckTimer.setRepeats(false);
                this.fontCheckTimer.start();
            } else {
                FontManager fontManager = FontManager.getInstance();
                Object[] objectArray = fontManager.getAllFontFamilies();
                NonNullableComboBoxModel nonNullableComboBoxModel = new NonNullableComboBoxModel(objectArray);
                Object object3 = this.comboBox_fontFamily.getSelectedItem();
                this.comboBox_fontFamily.setModel(nonNullableComboBoxModel);
                this.setSelectedFontFamily(DEFAULT_FONT);
                this.setSelectedFontFamily((String)object3);
            }
        }
    }

    private void updateSampleFonts() {
        String string = this.comboBox_fontFamily.getSelectedItem().toString();
        Integer n = (Integer)this.comboBox_fontSize.getSelectedItem();
        int n2 = n;
        Font font = new Font(string, 0, n2);
        Font font2 = font.deriveFont(1);
        Font font3 = font.deriveFont(2);
        Font font4 = font.deriveFont(3);
        this.label_normalFont.setFont(font);
        this.label_boldFont.setFont(font2);
        this.label_italicFont.setFont(font3);
        this.label_boldItalicFont.setFont(font4);
    }
}

