/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.options;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import oracle.ide.IdeConstants;
import oracle.ide.ceditor.options.DisplayOptions;
import oracle.ide.ceditor.options.OptionsArb;
import oracle.ide.controls.CustomColorChoice;
import oracle.ide.controls.ItemSelectableTracker;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.ApplyListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.editor.EditorProperties;

public final class GutterOptionsPanel
extends DefaultTraversablePanel
implements ApplyListener {
    private JCheckBox checkBox_showLineNumbers;
    private JRadioButton button_useLnF;
    private JRadioButton button_useEditor;
    private JRadioButton button_useCustom;
    private CustomColorChoice colorChoice_gutterBgColor;
    private CustomColorChoice colorChoice_gutterFgColor;
    private JCheckBox checkbox_clickDragging;

    public GutterOptionsPanel() {
        this.setHelpID("f1_idedidesetlinegutter_html");
        this.setLayout(new GridBagLayout());
        this.initializeComponent();
    }

    public void onEntry(TraversableContext traversableContext) {
        DisplayOptions displayOptions = this.findOptions(traversableContext);
        this.loadSettingsFrom(displayOptions);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        DisplayOptions displayOptions = this.findOptions(traversableContext);
        this.saveSettingsTo(displayOptions);
    }

    private DisplayOptions findOptions(TraversableContext traversableContext) {
        DisplayOptions displayOptions = (DisplayOptions)traversableContext.find("DisplayOptions");
        return displayOptions;
    }

    public void apply(ApplyEvent applyEvent) {
        TraversableContext traversableContext = (TraversableContext)applyEvent.getSource();
        DisplayOptions displayOptions = this.findOptions(traversableContext);
        GutterOptionsPanel.applyOptions(displayOptions);
    }

    public void cancel(ApplyEvent applyEvent) {
    }

    public static void applyOptions(DisplayOptions displayOptions) {
        EditorProperties editorProperties = EditorProperties.getProperties();
        boolean bl = displayOptions.getShowLineNumbers();
        editorProperties.putBooleanProperty("show-line-numbers", bl);
        int n = displayOptions.getGutterColorSource();
        editorProperties.putIntegerProperty("gutter-color-source", n);
        int n2 = displayOptions.getGutterBackgroundColor();
        editorProperties.putProperty("gutter-custom-bgcolor", (Object)new Color(n2));
        int n3 = displayOptions.getGutterForegroundColor();
        editorProperties.putProperty("gutter-custom-fgcolor", (Object)new Color(n3));
        boolean bl2 = displayOptions.getEnableClickDragging();
        editorProperties.putBooleanProperty("gutter-enable-selection", bl2);
        Color color = IdeConstants.COLOR_IDE_LINES;
        if (color != null) {
            editorProperties.putProperty("gutter-default-bordercolor", (Object)color);
        }
    }

    void loadSettingsFrom(DisplayOptions displayOptions) {
        JRadioButton jRadioButton;
        boolean bl = displayOptions.getShowLineNumbers();
        int n = displayOptions.getGutterColorSource();
        int n2 = displayOptions.getGutterBackgroundColor();
        int n3 = displayOptions.getGutterForegroundColor();
        boolean bl2 = displayOptions.getEnableClickDragging();
        this.checkBox_showLineNumbers.setSelected(bl);
        this.checkbox_clickDragging.setSelected(bl2);
        switch (n) {
            case 3: {
                jRadioButton = this.button_useCustom;
                break;
            }
            case 2: {
                jRadioButton = this.button_useEditor;
                break;
            }
            default: {
                jRadioButton = this.button_useLnF;
            }
        }
        jRadioButton.setSelected(true);
        this.colorChoice_gutterBgColor.setClosestSelectedColor(new Color(n2));
        this.colorChoice_gutterFgColor.setClosestSelectedColor(new Color(n3));
    }

    void saveSettingsTo(DisplayOptions displayOptions) {
        int n = 1;
        if (this.button_useEditor.isSelected()) {
            n = 2;
        } else if (this.button_useCustom.isSelected()) {
            n = 3;
        }
        boolean bl = this.checkBox_showLineNumbers.isSelected();
        Color color = this.colorChoice_gutterBgColor.getSelectedColor();
        Color color2 = this.colorChoice_gutterFgColor.getSelectedColor();
        boolean bl2 = this.checkbox_clickDragging.isSelected();
        displayOptions.setShowLineNumbers(bl);
        displayOptions.setGutterColorSource(n);
        displayOptions.setGutterBackgroundColor(color.getRGB());
        displayOptions.setGutterForegroundColor(color2.getRGB());
        displayOptions.setEnableClickDragging(bl2);
    }

    private void initializeComponent() {
        String string = OptionsArb.getString(28);
        this.checkBox_showLineNumbers = new JCheckBox();
        ResourceUtils.resButton(this.checkBox_showLineNumbers, string);
        String string2 = OptionsArb.getString(35);
        this.checkbox_clickDragging = new JCheckBox();
        ResourceUtils.resButton(this.checkbox_clickDragging, string2);
        String string3 = OptionsArb.getString(29);
        JLabel jLabel = new JLabel(string3);
        String string4 = OptionsArb.getString(30);
        this.button_useLnF = new JRadioButton();
        ResourceUtils.resButton(this.button_useLnF, string4);
        String string5 = OptionsArb.getString(31);
        this.button_useEditor = new JRadioButton();
        ResourceUtils.resButton(this.button_useEditor, string5);
        String string6 = OptionsArb.getString(32);
        this.button_useCustom = new JRadioButton();
        ResourceUtils.resButton(this.button_useCustom, string6);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.button_useLnF);
        buttonGroup.add(this.button_useEditor);
        buttonGroup.add(this.button_useCustom);
        String string7 = OptionsArb.getString(33);
        JLabel jLabel2 = new JLabel();
        this.colorChoice_gutterBgColor = new CustomColorChoice();
        ResourceUtils.resLabel(jLabel2, (Component)((Object)this.colorChoice_gutterBgColor), string7);
        String string8 = OptionsArb.getString(34);
        JLabel jLabel3 = new JLabel();
        this.colorChoice_gutterFgColor = new CustomColorChoice();
        ResourceUtils.resLabel(jLabel3, (Component)((Object)this.colorChoice_gutterFgColor), string8);
        Component[] componentArray = new Component[]{jLabel2, this.colorChoice_gutterBgColor, jLabel3, this.colorChoice_gutterFgColor};
        ItemSelectableTracker itemSelectableTracker = new ItemSelectableTracker(this.button_useCustom, componentArray);
        Insets insets = new Insets(2, 5, 2, 5);
        Insets insets2 = new Insets(2, 30, 2, 5);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        this.add((Component)this.checkBox_showLineNumbers, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 2, 3, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        this.add((Component)this.checkbox_clickDragging, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 3, 3, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 4, 3, 1, 1.0, 0.0, 17, 0, insets2, 0, 0);
        this.add((Component)this.button_useLnF, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 5, 3, 1, 1.0, 0.0, 17, 0, insets2, 0, 0);
        this.add((Component)this.button_useEditor, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, insets2, 0, 0);
        this.add((Component)this.button_useCustom, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0);
        this.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(2, 6, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        this.add((Component)((Object)this.colorChoice_gutterBgColor), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0);
        this.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(2, 7, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        this.add((Component)((Object)this.colorChoice_gutterFgColor), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 8, 3, 1, 1.0, 1.0, 17, 1, insets, 0, 0);
        this.add(Box.createVerticalGlue(), gridBagConstraints);
    }
}

