/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.options;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.NumberFormat;
import java.util.Hashtable;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.ide.ceditor.options.FontManager;
import oracle.ide.ceditor.options.InsightOptions;
import oracle.ide.ceditor.options.OptionsArb;
import oracle.ide.controls.ItemSelectableTracker;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.ApplyListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.editor.EditorProperties;

public final class InsightOptionsPanel
extends DefaultTraversablePanel
implements ChangeListener,
ApplyListener {
    private static String DEFAULT_FONT = "Dialog";
    private JComboBox combobox_fontFamily;
    private JComboBox combobox_fontSize;
    private JCheckBox checkbox_completionEnablePopup;
    private JSlider slider_completionPopupDelay;
    private JLabel label_completionPopupDelayText;
    private JCheckBox checkbox_parameterEnablePopup;
    private JSlider slider_parameterPopupDelay;
    private JLabel label_parameterPopupDelayText;
    private NumberFormat numberFormatter;

    public InsightOptionsPanel() {
        this.setHelpID("f1_idedidesetcodeinsight_html");
        this.setLayout(new GridBagLayout());
        this.initializeComponent();
    }

    public void onEntry(TraversableContext traversableContext) {
        InsightOptions insightOptions = this.findOptions(traversableContext);
        this.loadSettingsFrom(insightOptions);
    }

    public void onExit(TraversableContext traversableContext) {
        InsightOptions insightOptions = this.findOptions(traversableContext);
        this.saveSettingsTo(insightOptions);
    }

    private InsightOptions findOptions(TraversableContext traversableContext) {
        InsightOptions insightOptions = (InsightOptions)traversableContext.find("InsightOptions");
        return insightOptions;
    }

    public void apply(ApplyEvent applyEvent) {
        TraversableContext traversableContext = (TraversableContext)applyEvent.getSource();
        InsightOptions insightOptions = this.findOptions(traversableContext);
        InsightOptionsPanel.applyOptions(insightOptions);
    }

    public void cancel(ApplyEvent applyEvent) {
    }

    public static void applyOptions(InsightOptions insightOptions) {
        EditorProperties editorProperties = EditorProperties.getProperties();
        String string = insightOptions.getFontFamily();
        editorProperties.putProperty("insight-font-family", (Object)string);
        int n = insightOptions.getFontSize();
        editorProperties.putIntegerProperty("insight-font-size", n);
        boolean bl = insightOptions.getCompletionEnablePopup();
        editorProperties.putBooleanProperty("completion-enable-autopopup", bl);
        int n2 = insightOptions.getCompletionPopupDelay();
        editorProperties.putIntegerProperty("completion-popup-delay", n2);
        boolean bl2 = insightOptions.getParameterEnablePopup();
        editorProperties.putBooleanProperty("parameter-enable-autopopup", bl2);
        int n3 = insightOptions.getParameterPopupDelay();
        editorProperties.putIntegerProperty("parameter-popup-delay", n3);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        JLabel jLabel;
        JSlider jSlider;
        Object object = changeEvent.getSource();
        if (object == this.slider_completionPopupDelay) {
            jSlider = this.slider_completionPopupDelay;
            jLabel = this.label_completionPopupDelayText;
        } else if (object == this.slider_parameterPopupDelay) {
            jSlider = this.slider_parameterPopupDelay;
            jLabel = this.label_parameterPopupDelayText;
        } else {
            throw new IllegalStateException("unknown source");
        }
        float f = (float)jSlider.getValue() / 10.0f;
        String string = OptionsArb.format(125, this.numberFormatter.format(f));
        jLabel.setText(string);
        jSlider.setToolTipText(string);
    }

    void loadSettingsFrom(InsightOptions insightOptions) {
        String string = insightOptions.getFontFamily();
        int n = insightOptions.getFontSize();
        boolean bl = insightOptions.getCompletionEnablePopup();
        int n2 = insightOptions.getCompletionPopupDelay();
        boolean bl2 = insightOptions.getParameterEnablePopup();
        int n3 = insightOptions.getParameterPopupDelay();
        this.setSelectedFontFamily(string);
        this.combobox_fontSize.setSelectedItem(new Integer(n));
        this.checkbox_completionEnablePopup.setSelected(bl);
        this.slider_completionPopupDelay.setValue(n2 / 100);
        this.checkbox_parameterEnablePopup.setSelected(bl2);
        this.slider_parameterPopupDelay.setValue(n3 / 100);
    }

    void saveSettingsTo(InsightOptions insightOptions) {
        String string = this.combobox_fontFamily.getSelectedItem().toString();
        Integer n = (Integer)this.combobox_fontSize.getSelectedItem();
        int n2 = n;
        boolean bl = this.checkbox_completionEnablePopup.isSelected();
        int n3 = this.slider_completionPopupDelay.getValue() * 100;
        boolean bl2 = this.checkbox_parameterEnablePopup.isSelected();
        int n4 = this.slider_parameterPopupDelay.getValue() * 100;
        insightOptions.setFontFamily(string);
        insightOptions.setFontSize(n2);
        insightOptions.setCompletionEnablePopup(bl);
        insightOptions.setCompletionPopupDelay(n3);
        insightOptions.setParameterEnablePopup(bl2);
        insightOptions.setParameterPopupDelay(n4);
    }

    private void setSelectedFontFamily(String string) {
        ComboBoxModel comboBoxModel = this.combobox_fontFamily.getModel();
        int n = comboBoxModel.getSize();
        int n2 = 0;
        while (n2 < n) {
            Object e = comboBoxModel.getElementAt(n2);
            if (e.equals(string)) {
                this.combobox_fontFamily.setSelectedItem(string);
            }
            ++n2;
        }
    }

    private void initializeComponent() {
        this.numberFormatter = NumberFormat.getNumberInstance();
        this.numberFormatter.setMinimumFractionDigits(1);
        this.numberFormatter.setMaximumFractionDigits(1);
        String string = OptionsArb.getString(37);
        JLabel jLabel = new JLabel();
        FontManager fontManager = FontManager.getInstance();
        Object[] objectArray = fontManager.getAllFontFamilies();
        NonNullableComboBoxModel nonNullableComboBoxModel = new NonNullableComboBoxModel(objectArray);
        this.combobox_fontFamily = new JComboBox(nonNullableComboBoxModel);
        this.combobox_fontFamily.setEditable(false);
        this.combobox_fontFamily.setSelectedItem(DEFAULT_FONT);
        ResourceUtils.resLabel(jLabel, this.combobox_fontFamily, string);
        String string2 = OptionsArb.getString(38);
        JLabel jLabel2 = new JLabel();
        Object[] objectArray2 = new Integer[]{new Integer(9), new Integer(10), new Integer(11), new Integer(12), new Integer(13), new Integer(14), new Integer(15), new Integer(16)};
        NonNullableComboBoxModel nonNullableComboBoxModel2 = new NonNullableComboBoxModel(objectArray2);
        this.combobox_fontSize = new JComboBox(nonNullableComboBoxModel2);
        this.combobox_fontSize.setEditable(false);
        this.combobox_fontSize.setSelectedItem(objectArray2[0]);
        ResourceUtils.resLabel(jLabel2, this.combobox_fontSize, string2);
        String string3 = OptionsArb.getString(39);
        this.checkbox_completionEnablePopup = new JCheckBox();
        ResourceUtils.resButton(this.checkbox_completionEnablePopup, string3);
        String string4 = OptionsArb.getString(40);
        JLabel jLabel3 = new JLabel();
        this.slider_completionPopupDelay = new JSlider(1, 30, 10);
        this.slider_completionPopupDelay.addChangeListener(this);
        this.label_completionPopupDelayText = new JLabel();
        ResourceUtils.resLabel(jLabel3, this.slider_completionPopupDelay, string4);
        String string5 = this.numberFormatter.format(0.1);
        String string6 = this.numberFormatter.format(3.0);
        JLabel jLabel4 = new JLabel(string5);
        JLabel jLabel5 = new JLabel(string6);
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>(5);
        hashtable.put(new Integer(1), jLabel4);
        hashtable.put(new Integer(30), jLabel5);
        this.slider_completionPopupDelay.setLabelTable(hashtable);
        this.slider_completionPopupDelay.setPaintLabels(true);
        this.slider_completionPopupDelay.setPaintTicks(true);
        this.slider_completionPopupDelay.setMajorTickSpacing(10);
        this.slider_completionPopupDelay.setMinorTickSpacing(1);
        this.slider_completionPopupDelay.setSnapToTicks(true);
        Component[] componentArray = new Component[]{this.slider_completionPopupDelay, jLabel3, this.label_completionPopupDelayText, jLabel4, jLabel5};
        ItemSelectableTracker itemSelectableTracker = new ItemSelectableTracker(this.checkbox_completionEnablePopup, componentArray);
        this.checkbox_completionEnablePopup.addItemListener(itemSelectableTracker);
        String string7 = OptionsArb.getString(41);
        this.checkbox_parameterEnablePopup = new JCheckBox();
        ResourceUtils.resButton(this.checkbox_parameterEnablePopup, string7);
        String string8 = OptionsArb.getString(42);
        JLabel jLabel6 = new JLabel();
        this.slider_parameterPopupDelay = new JSlider(1, 30, 10);
        this.slider_parameterPopupDelay.addChangeListener(this);
        this.label_parameterPopupDelayText = new JLabel();
        ResourceUtils.resLabel(jLabel6, this.slider_parameterPopupDelay, string8);
        jLabel4 = new JLabel(string5);
        jLabel5 = new JLabel(string6);
        hashtable = new Hashtable(5);
        hashtable.put(new Integer(1), jLabel4);
        hashtable.put(new Integer(30), jLabel5);
        this.slider_parameterPopupDelay.setLabelTable(hashtable);
        this.slider_parameterPopupDelay.setPaintLabels(true);
        this.slider_parameterPopupDelay.setPaintTicks(true);
        this.slider_parameterPopupDelay.setMajorTickSpacing(10);
        this.slider_parameterPopupDelay.setMinorTickSpacing(1);
        this.slider_parameterPopupDelay.setSnapToTicks(true);
        Component[] componentArray2 = new Component[]{this.slider_parameterPopupDelay, jLabel6, this.label_parameterPopupDelayText, jLabel4, jLabel5};
        ItemSelectableTracker itemSelectableTracker2 = new ItemSelectableTracker(this.checkbox_parameterEnablePopup, componentArray2);
        this.checkbox_parameterEnablePopup.addItemListener(itemSelectableTracker2);
        this.slider_completionPopupDelay.setValue(1);
        this.slider_parameterPopupDelay.setValue(1);
        Insets insets = new Insets(5, 5, 5, 5);
        Insets insets2 = new Insets(2, 30, 2, 2);
        Insets insets3 = new Insets(2, 55, 2, 2);
        Insets insets4 = new Insets(2, 2, 2, 2);
        Insets insets5 = new Insets(0, 0, 0, 0);
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0);
        jPanel.add((Component)this.combobox_fontFamily, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0);
        jPanel.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0);
        jPanel.add((Component)this.combobox_fontSize, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        jPanel2.add((Component)this.checkbox_completionEnablePopup, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, insets2, 0, 0);
        jPanel2.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, insets3, 0, 0);
        jPanel2.add((Component)this.label_completionPopupDelayText, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 1, 1, 2, 1.0, 0.0, 17, 2, insets4, 0, 0);
        jPanel2.add((Component)this.slider_completionPopupDelay, gridBagConstraints);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        jPanel3.add((Component)this.checkbox_parameterEnablePopup, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, insets2, 0, 0);
        jPanel3.add((Component)jLabel6, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, insets3, 0, 0);
        jPanel3.add((Component)this.label_parameterPopupDelayText, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 1, 1, 2, 1.0, 0.0, 17, 2, insets4, 0, 0);
        jPanel3.add((Component)this.slider_parameterPopupDelay, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 1, insets5, 0, 0);
        this.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 17, 0, insets5, 0, 0);
        this.add(Box.createVerticalStrut(10), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 17, 1, insets5, 0, 0);
        this.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 17, 0, insets5, 0, 0);
        this.add(Box.createVerticalStrut(10), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 17, 1, insets5, 0, 0);
        this.add((Component)jPanel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 7, 2, 1, 1.0, 1.0, 17, 0, insets5, 0, 0);
        this.add(Box.createGlue(), gridBagConstraints);
    }
}

