/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.options;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import oracle.ide.ceditor.options.FontManager;
import oracle.ide.ceditor.options.OptionsArb;
import oracle.ide.ceditor.options.PrintingHTMLOptions;
import oracle.ide.controls.ItemSelectableTracker;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.controls.WholeNumberField;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.ApplyListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;

public final class PrintingHTMLOptionsPanel
extends DefaultTraversablePanel
implements ApplyListener {
    private JCheckBox checkbox_useFontInfo;
    private JComboBox combobox_fontFamily;
    private JComboBox combobox_fontSize;
    private JCheckBox checkbox_anchors;
    private JCheckBox checkbox_lineNumbers;
    private JCheckBox checkbox_fileHeader;
    private JCheckBox checkbox_timeStamp;
    private JCheckBox checkbox_wrapLines;
    private WholeNumberField textfield_wrapColumn;
    private JTextField textfield_wrapSymbol;
    private JCheckBox checkbox_printColors;
    private JCheckBox checkbox_printStyles;

    public PrintingHTMLOptionsPanel() {
        this.setHelpID("f1_idedidesetprintinghtml_html");
        this.setLayout(new GridBagLayout());
        this.initializeComponent();
    }

    public void onEntry(TraversableContext traversableContext) {
        PrintingHTMLOptions printingHTMLOptions = this.findOptions(traversableContext);
        this.loadSettingsFrom(printingHTMLOptions);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        PrintingHTMLOptions printingHTMLOptions = this.findOptions(traversableContext);
        this.saveSettingsTo(printingHTMLOptions);
    }

    private PrintingHTMLOptions findOptions(TraversableContext traversableContext) {
        PrintingHTMLOptions printingHTMLOptions = (PrintingHTMLOptions)((Object)traversableContext.find("PrintingHTMLOptions"));
        return printingHTMLOptions;
    }

    public void apply(ApplyEvent applyEvent) {
        TraversableContext traversableContext = (TraversableContext)applyEvent.getSource();
        PrintingHTMLOptions printingHTMLOptions = this.findOptions(traversableContext);
        PrintingHTMLOptionsPanel.applyOptions(printingHTMLOptions);
    }

    public void cancel(ApplyEvent applyEvent) {
    }

    public static void applyOptions(PrintingHTMLOptions printingHTMLOptions) {
    }

    void loadSettingsFrom(PrintingHTMLOptions printingHTMLOptions) {
        boolean bl = printingHTMLOptions.getUseAnchors();
        boolean bl2 = printingHTMLOptions.getPrintLineNumbers() == 1;
        boolean bl3 = printingHTMLOptions.getPrintFileHeader();
        boolean bl4 = printingHTMLOptions.getPrintTimeStamp();
        boolean bl5 = printingHTMLOptions.getPrintColors();
        boolean bl6 = printingHTMLOptions.getPrintFontStyles();
        boolean bl7 = printingHTMLOptions.getWrapBehavior() == 1;
        int n = printingHTMLOptions.getWrapColumn();
        String string = printingHTMLOptions.getWrapSymbol().trim();
        boolean bl8 = printingHTMLOptions.getUseFontInfo();
        String string2 = printingHTMLOptions.getFontFamily();
        int n2 = printingHTMLOptions.getFontSize();
        this.checkbox_anchors.setSelected(bl);
        this.checkbox_lineNumbers.setSelected(bl2);
        this.checkbox_fileHeader.setSelected(bl3);
        this.checkbox_timeStamp.setSelected(bl4);
        this.checkbox_printColors.setSelected(bl5);
        this.checkbox_printStyles.setSelected(bl6);
        this.checkbox_wrapLines.setSelected(bl7);
        this.textfield_wrapColumn.setValue(n);
        this.textfield_wrapSymbol.setText(string);
        this.checkbox_useFontInfo.setSelected(bl8);
        this.setSelectedFontFamily(string2);
        this.setSelectedFontSize(n2);
    }

    private void setSelectedFontFamily(String string) {
        ComboBoxModel comboBoxModel = this.combobox_fontFamily.getModel();
        int n = comboBoxModel.getSize();
        int n2 = 0;
        while (n2 < n) {
            Object e = comboBoxModel.getElementAt(n2);
            if (e.equals(string)) {
                this.combobox_fontFamily.setSelectedItem(string);
            }
            ++n2;
        }
    }

    private void setSelectedFontSize(int n) {
        ComboBoxModel comboBoxModel = this.combobox_fontSize.getModel();
        int n2 = comboBoxModel.getSize();
        int n3 = 0;
        while (n3 < n2) {
            Integer n4 = (Integer)comboBoxModel.getElementAt(n3);
            if (n4 == n) {
                this.combobox_fontSize.setSelectedItem(n4);
            }
            ++n3;
        }
    }

    void saveSettingsTo(PrintingHTMLOptions printingHTMLOptions) throws TraversalException {
        int n;
        try {
            n = this.textfield_wrapColumn.getValue();
        }
        catch (NullPointerException nullPointerException) {
            n = -1;
        }
        if (n < 10) {
            String string = OptionsArb.getString(169);
            String string2 = OptionsArb.getString(170);
            this.showErrorDialog(string, string2);
            this.textfield_wrapColumn.selectAll();
            this.textfield_wrapColumn.requestFocus();
            throw new TraversalException(null);
        }
        boolean bl = this.checkbox_anchors.isSelected();
        int n2 = this.checkbox_lineNumbers.isSelected() ? 1 : 0;
        boolean bl2 = this.checkbox_fileHeader.isSelected();
        boolean bl3 = this.checkbox_timeStamp.isSelected();
        boolean bl4 = this.checkbox_printColors.isSelected();
        boolean bl5 = this.checkbox_printStyles.isSelected();
        int n3 = this.checkbox_wrapLines.isSelected() ? 1 : 0;
        String string = this.textfield_wrapSymbol.getText().trim();
        String string3 = (String)this.combobox_fontFamily.getSelectedItem();
        boolean bl6 = this.checkbox_useFontInfo.isSelected();
        Integer n4 = (Integer)this.combobox_fontSize.getSelectedItem();
        int n5 = n4;
        printingHTMLOptions.setUseAnchors(bl);
        printingHTMLOptions.setPrintLineNumbers(n2);
        printingHTMLOptions.setPrintFileHeader(bl2);
        printingHTMLOptions.setPrintTimeStamp(bl3);
        printingHTMLOptions.setPrintColors(bl4);
        printingHTMLOptions.setPrintFontStyles(bl5);
        printingHTMLOptions.setWrapBehavior(n3);
        printingHTMLOptions.setWrapColumn(n);
        printingHTMLOptions.setWrapSymbol(string);
        printingHTMLOptions.setUseFontInfo(bl6);
        printingHTMLOptions.setFontFamily(string3);
        printingHTMLOptions.setFontSize(n5);
    }

    private void initializeComponent() {
        String string = OptionsArb.getString(160);
        this.checkbox_useFontInfo = new JCheckBox();
        ResourceUtils.resButton(this.checkbox_useFontInfo, string);
        String string2 = OptionsArb.getString(161);
        JLabel jLabel = new JLabel();
        FontManager fontManager = FontManager.getInstance();
        Object[] objectArray = fontManager.getAllFontFamilies();
        NonNullableComboBoxModel nonNullableComboBoxModel = new NonNullableComboBoxModel(objectArray);
        this.combobox_fontFamily = new JComboBox(nonNullableComboBoxModel);
        this.combobox_fontFamily.setEditable(false);
        this.combobox_fontFamily.setSelectedItem("DialogInput");
        ResourceUtils.resLabel(jLabel, this.combobox_fontFamily, string2);
        String string3 = OptionsArb.getString(162);
        JLabel jLabel2 = new JLabel();
        Object[] objectArray2 = new Integer[]{new Integer(7), new Integer(8), new Integer(9), new Integer(10), new Integer(11), new Integer(12), new Integer(13), new Integer(14), new Integer(15), new Integer(16), new Integer(17), new Integer(18), new Integer(19), new Integer(20), new Integer(21), new Integer(22), new Integer(23), new Integer(24)};
        NonNullableComboBoxModel nonNullableComboBoxModel2 = new NonNullableComboBoxModel(objectArray2);
        this.combobox_fontSize = new JComboBox(nonNullableComboBoxModel2);
        this.combobox_fontSize.setEditable(false);
        this.combobox_fontSize.setSelectedItem(objectArray2[0]);
        ResourceUtils.resLabel(jLabel2, this.combobox_fontSize, string3);
        Component[] componentArray = new Component[]{jLabel, this.combobox_fontFamily, jLabel2, this.combobox_fontSize};
        ItemSelectableTracker itemSelectableTracker = new ItemSelectableTracker(this.checkbox_useFontInfo, componentArray);
        String string4 = OptionsArb.getString(163);
        this.checkbox_anchors = new JCheckBox();
        ResourceUtils.resButton(this.checkbox_anchors, string4);
        String string5 = OptionsArb.getString(164);
        this.checkbox_lineNumbers = new JCheckBox();
        ResourceUtils.resButton(this.checkbox_lineNumbers, string5);
        String string6 = OptionsArb.getString(165);
        this.checkbox_fileHeader = new JCheckBox();
        ResourceUtils.resButton(this.checkbox_fileHeader, string6);
        String string7 = OptionsArb.getString(166);
        this.checkbox_timeStamp = new JCheckBox();
        ResourceUtils.resButton(this.checkbox_timeStamp, string7);
        componentArray = new Component[]{this.checkbox_timeStamp};
        itemSelectableTracker = new ItemSelectableTracker(this.checkbox_fileHeader, componentArray);
        String string8 = OptionsArb.getString(167);
        this.checkbox_wrapLines = new JCheckBox();
        ResourceUtils.resButton(this.checkbox_wrapLines, string8);
        String string9 = OptionsArb.getString(168);
        JLabel jLabel3 = new JLabel();
        this.textfield_wrapColumn = new WholeNumberField(80, 4);
        ResourceUtils.resLabel(jLabel3, (Component)((Object)this.textfield_wrapColumn), string9);
        String string10 = OptionsArb.getString(171);
        JLabel jLabel4 = new JLabel();
        this.textfield_wrapSymbol = new JTextField(4);
        ResourceUtils.resLabel(jLabel4, this.textfield_wrapSymbol, string10);
        componentArray = new Component[]{this.textfield_wrapColumn, jLabel3, this.textfield_wrapSymbol, jLabel4};
        itemSelectableTracker = new ItemSelectableTracker(this.checkbox_wrapLines, componentArray);
        String string11 = OptionsArb.getString(172);
        this.checkbox_printColors = new JCheckBox();
        ResourceUtils.resButton(this.checkbox_printColors, string11);
        String string12 = OptionsArb.getString(173);
        this.checkbox_printStyles = new JCheckBox();
        ResourceUtils.resButton(this.checkbox_printStyles, string12);
        String string13 = OptionsArb.getString(174);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(string13);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(titledBorder);
        Insets insets = new Insets(2, 2, 2, 2);
        Insets insets2 = new Insets(2, 30, 2, 2);
        Insets insets3 = insets;
        Insets insets4 = insets2;
        Insets insets5 = new Insets(0, 0, 0, 0);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        jPanel2.add((Component)this.checkbox_useFontInfo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, insets4, 0, 0);
        jPanel2.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 0, insets3, 0, 0);
        jPanel2.add((Component)this.combobox_fontFamily, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, insets4, 0, 0);
        jPanel2.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 0, insets3, 0, 0);
        jPanel2.add((Component)this.combobox_fontSize, gridBagConstraints);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        jPanel3.add((Component)this.checkbox_anchors, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        jPanel3.add((Component)this.checkbox_lineNumbers, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        jPanel3.add((Component)this.checkbox_fileHeader, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 0, insets2, 0, 0);
        jPanel3.add((Component)this.checkbox_timeStamp, gridBagConstraints);
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        jPanel4.add((Component)this.checkbox_wrapLines, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, insets2, 0, 0);
        jPanel4.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        jPanel4.add((Component)((Object)this.textfield_wrapColumn), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, insets2, 0, 0);
        jPanel4.add((Component)jLabel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        jPanel4.add((Component)this.textfield_wrapSymbol, gridBagConstraints);
        JPanel jPanel5 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        jPanel5.add((Component)this.checkbox_printColors, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        jPanel5.add((Component)this.checkbox_printStyles, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 1, insets5, 0, 0);
        jPanel5.add(Box.createGlue(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 1, insets5, 0, 0);
        this.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 6, 1, 1, 1.0, 0.0, 17, 1, insets5, 0, 0);
        this.add((Component)jPanel5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 8, 1, 1, 1.0, 0.0, 17, 1, insets5, 0, 0);
        this.add((Component)jPanel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 11, 1, 1, 1.0, 0.0, 17, 1, insets5, 0, 0);
        this.add((Component)jPanel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 15, 1, 1, 1.0, 1.0, 17, 1, insets5, 0, 0);
        this.add(Box.createGlue(), gridBagConstraints);
    }

    private void showErrorDialog(String string, String string2) {
        JOptionPane.showMessageDialog(this, string, string2, 2);
    }
}

