/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.options;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import oracle.ide.ceditor.options.FontManager;
import oracle.ide.ceditor.options.OptionsArb;
import oracle.ide.ceditor.options.PrintingOptions;
import oracle.ide.controls.ItemSelectableTracker;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.ApplyListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.language.LanguageModule;
import oracle.javatools.editor.print.EditorPageable;
import oracle.javatools.editor.print.PrintOptions;

public final class PrintingOptionsPanel
extends DefaultTraversablePanel
implements ItemListener,
DocumentListener,
ApplyListener {
    private JComboBox combobox_fontFamily;
    private JComboBox combobox_fontSize;
    private JCheckBox checkbox_lineNumbers;
    private JCheckBox checkbox_pageNumbers;
    private JCheckBox checkbox_fileHeader;
    private JCheckBox checkbox_wrapLines;
    private JTextField textfield_wrapSymbol;
    private JCheckBox checkbox_printColors;
    private JCheckBox checkbox_printStyles;
    private Previewer previewer;

    public PrintingOptionsPanel() {
        this.setHelpID("f1_idedidesetprinting_html");
        this.setLayout(new GridBagLayout());
        this.initializeComponent();
    }

    public void onEntry(TraversableContext traversableContext) {
        PrintingOptions printingOptions = this.findOptions(traversableContext);
        this.loadSettingsFrom(printingOptions);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        PrintingOptions printingOptions = this.findOptions(traversableContext);
        this.saveSettingsTo(printingOptions);
    }

    private PrintingOptions findOptions(TraversableContext traversableContext) {
        PrintingOptions printingOptions = (PrintingOptions)((Object)traversableContext.find("PrintingOptions"));
        return printingOptions;
    }

    public void apply(ApplyEvent applyEvent) {
        TraversableContext traversableContext = (TraversableContext)applyEvent.getSource();
        PrintingOptions printingOptions = this.findOptions(traversableContext);
        PrintingOptionsPanel.applyOptions(printingOptions);
    }

    public void cancel(ApplyEvent applyEvent) {
    }

    public static void applyOptions(PrintingOptions printingOptions) {
    }

    void loadSettingsFrom(PrintingOptions printingOptions) {
        boolean bl = printingOptions.getPrintLineNumbers() == 1;
        boolean bl2 = printingOptions.getPrintPageNumbers();
        boolean bl3 = printingOptions.getPrintFileHeader();
        boolean bl4 = printingOptions.getPrintColors();
        boolean bl5 = printingOptions.getPrintFontStyles();
        boolean bl6 = printingOptions.getWrapBehavior() == 1;
        String string = printingOptions.getWrapSymbol().trim();
        String string2 = printingOptions.getFontFamily();
        int n = printingOptions.getFontSize();
        this.checkbox_lineNumbers.setSelected(bl);
        this.checkbox_pageNumbers.setSelected(bl2);
        this.checkbox_fileHeader.setSelected(bl3);
        this.checkbox_printColors.setSelected(bl4);
        this.checkbox_printStyles.setSelected(bl5);
        this.checkbox_wrapLines.setSelected(bl6);
        this.textfield_wrapSymbol.setText(string);
        this.setSelectedFontFamily(string2);
        this.setSelectedFontSize(n);
    }

    private void setSelectedFontFamily(String string) {
        ComboBoxModel comboBoxModel = this.combobox_fontFamily.getModel();
        int n = comboBoxModel.getSize();
        int n2 = 0;
        while (n2 < n) {
            Object e = comboBoxModel.getElementAt(n2);
            if (e.equals(string)) {
                this.combobox_fontFamily.setSelectedItem(string);
            }
            ++n2;
        }
    }

    private void setSelectedFontSize(int n) {
        ComboBoxModel comboBoxModel = this.combobox_fontSize.getModel();
        int n2 = comboBoxModel.getSize();
        int n3 = 0;
        while (n3 < n2) {
            Integer n4 = (Integer)comboBoxModel.getElementAt(n3);
            if (n4 == n) {
                this.combobox_fontSize.setSelectedItem(n4);
            }
            ++n3;
        }
    }

    void saveSettingsTo(PrintingOptions printingOptions) throws TraversalException {
        int n = this.checkbox_lineNumbers.isSelected() ? 1 : 0;
        boolean bl = this.checkbox_pageNumbers.isSelected();
        boolean bl2 = this.checkbox_fileHeader.isSelected();
        boolean bl3 = this.checkbox_printColors.isSelected();
        boolean bl4 = this.checkbox_printStyles.isSelected();
        int n2 = this.checkbox_wrapLines.isSelected() ? 1 : 0;
        String string = this.textfield_wrapSymbol.getText().trim();
        String string2 = (String)this.combobox_fontFamily.getSelectedItem();
        Integer n3 = (Integer)this.combobox_fontSize.getSelectedItem();
        int n4 = n3;
        printingOptions.setPrintLineNumbers(n);
        printingOptions.setPrintPageNumbers(bl);
        printingOptions.setPrintFileHeader(bl2);
        printingOptions.setPrintColors(bl3);
        printingOptions.setPrintFontStyles(bl4);
        printingOptions.setWrapBehavior(n2);
        printingOptions.setWrapSymbol(string);
        printingOptions.setFontFamily(string2);
        printingOptions.setFontSize(n4);
    }

    private void initializeComponent() {
        String string = OptionsArb.getString(149);
        JLabel jLabel = new JLabel();
        FontManager fontManager = FontManager.getInstance();
        Object[] objectArray = fontManager.getAllFontFamilies();
        NonNullableComboBoxModel nonNullableComboBoxModel = new NonNullableComboBoxModel(objectArray);
        this.combobox_fontFamily = new JComboBox(nonNullableComboBoxModel);
        this.combobox_fontFamily.setEditable(false);
        this.combobox_fontFamily.setSelectedItem("DialogInput");
        this.combobox_fontFamily.addItemListener(this);
        ResourceUtils.resLabel(jLabel, this.combobox_fontFamily, string);
        String string2 = OptionsArb.getString(150);
        JLabel jLabel2 = new JLabel();
        Object[] objectArray2 = new Integer[]{new Integer(7), new Integer(8), new Integer(9), new Integer(10), new Integer(11), new Integer(12), new Integer(13), new Integer(14), new Integer(15), new Integer(16), new Integer(17), new Integer(18), new Integer(19), new Integer(20), new Integer(21), new Integer(22), new Integer(23), new Integer(24)};
        NonNullableComboBoxModel nonNullableComboBoxModel2 = new NonNullableComboBoxModel(objectArray2);
        this.combobox_fontSize = new JComboBox(nonNullableComboBoxModel2);
        this.combobox_fontSize.setEditable(false);
        this.combobox_fontSize.setSelectedItem(objectArray2[0]);
        this.combobox_fontSize.addItemListener(this);
        ResourceUtils.resLabel(jLabel2, this.combobox_fontSize, string2);
        String string3 = OptionsArb.getString(151);
        this.checkbox_lineNumbers = new JCheckBox();
        ResourceUtils.resButton(this.checkbox_lineNumbers, string3);
        this.checkbox_lineNumbers.addItemListener(this);
        String string4 = OptionsArb.getString(152);
        this.checkbox_pageNumbers = new JCheckBox();
        ResourceUtils.resButton(this.checkbox_pageNumbers, string4);
        this.checkbox_pageNumbers.addItemListener(this);
        String string5 = OptionsArb.getString(153);
        this.checkbox_fileHeader = new JCheckBox();
        ResourceUtils.resButton(this.checkbox_fileHeader, string5);
        this.checkbox_fileHeader.addItemListener(this);
        String string6 = OptionsArb.getString(154);
        this.checkbox_wrapLines = new JCheckBox();
        ResourceUtils.resButton(this.checkbox_wrapLines, string6);
        this.checkbox_wrapLines.addItemListener(this);
        String string7 = OptionsArb.getString(155);
        JLabel jLabel3 = new JLabel();
        this.textfield_wrapSymbol = new JTextField(4);
        ResourceUtils.resLabel(jLabel3, this.textfield_wrapSymbol, string7);
        Document document = this.textfield_wrapSymbol.getDocument();
        document.addDocumentListener(this);
        Component[] componentArray = new Component[]{this.textfield_wrapSymbol, jLabel3};
        ItemSelectableTracker itemSelectableTracker = new ItemSelectableTracker(this.checkbox_wrapLines, componentArray);
        String string8 = OptionsArb.getString(156);
        this.checkbox_printColors = new JCheckBox();
        ResourceUtils.resButton(this.checkbox_printColors, string8);
        this.checkbox_printColors.addItemListener(this);
        String string9 = OptionsArb.getString(157);
        this.checkbox_printStyles = new JCheckBox();
        ResourceUtils.resButton(this.checkbox_printStyles, string9);
        this.checkbox_printStyles.addItemListener(this);
        String string10 = OptionsArb.getString(158);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(string10);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(titledBorder);
        this.previewer = new Previewer(null);
        jPanel.add((Component)this.previewer, "Center");
        Insets insets = new Insets(5, 2, 5, 2);
        Insets insets2 = new Insets(2, 2, 2, 2);
        Insets insets3 = new Insets(2, 30, 2, 2);
        Insets insets4 = new Insets(0, 0, 0, 0);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0);
        jPanel2.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0);
        jPanel2.add((Component)this.combobox_fontFamily, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0);
        jPanel2.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0);
        jPanel2.add((Component)this.combobox_fontSize, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 17, 1, insets4, 0, 0);
        jPanel2.add(Box.createGlue(), gridBagConstraints);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, insets2, 0, 0);
        jPanel3.add((Component)this.checkbox_lineNumbers, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, insets2, 0, 0);
        jPanel3.add((Component)this.checkbox_pageNumbers, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 0, insets2, 0, 0);
        jPanel3.add((Component)this.checkbox_fileHeader, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 17, 1, insets4, 0, 0);
        jPanel3.add(Box.createGlue(), gridBagConstraints);
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, insets2, 0, 0);
        jPanel4.add((Component)this.checkbox_wrapLines, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, insets3, 0, 0);
        jPanel4.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, insets3, 0, 0);
        jPanel4.add((Component)this.textfield_wrapSymbol, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 17, 1, insets4, 0, 0);
        jPanel4.add(Box.createGlue(), gridBagConstraints);
        JPanel jPanel5 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, insets2, 0, 0);
        jPanel5.add((Component)this.checkbox_printColors, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, insets2, 0, 0);
        jPanel5.add((Component)this.checkbox_printStyles, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 1, insets4, 0, 0);
        jPanel5.add(Box.createGlue(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, insets4, 0, 0);
        this.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 1, insets4, 0, 0);
        this.add(Box.createHorizontalStrut(8), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 1, insets4, 0, 0);
        this.add((Component)jPanel5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 1, 3, 1, 1.0, 0.0, 17, 1, insets4, 0, 0);
        this.add(Box.createVerticalStrut(2), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, insets4, 0, 0);
        this.add((Component)jPanel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 1, insets4, 0, 0);
        this.add(Box.createHorizontalStrut(8), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(2, 2, 1, 1, 1.0, 0.0, 17, 1, insets4, 0, 0);
        this.add((Component)jPanel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 3, 3, 1, 1.0, 1.0, 17, 1, insets4, 0, 0);
        this.add((Component)jPanel, gridBagConstraints);
    }

    private void repaintPreview() {
        try {
            PrintingOptions printingOptions = new PrintingOptions();
            this.saveSettingsTo(printingOptions);
            Previewer.mav$setPrintOptions(this.previewer, printingOptions);
        }
        catch (TraversalException traversalException) {
            // empty catch block
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.repaintPreview();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.repaintPreview();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.repaintPreview();
    }

    private static final class Previewer
    extends JComponent {
        private PrintingOptions options;
        private EditorPageable pageable;
        private static final int OUTER_INSETS = 5;
        private static final int INNER_INSETS = 4;

        private Previewer() {
            this.$init$();
            String string = "java";
            LanguageModule languageModule = LanguageModule.getModuleForFileType((String)"java");
            String string2 = languageModule.getContentSample();
            TextBuffer textBuffer = TextBufferFactory.createTextBuffer();
            textBuffer.append(string2.toCharArray());
            String string3 = "PrintingPreview.java";
            BasicDocument basicDocument = new BasicDocument(string3, textBuffer);
            this.options = new PrintingOptions();
            this.pageable = new EditorPageable(string3, basicDocument, (PrintOptions)this.options, new PageFormat());
        }

        private void setPrintOptions(PrintingOptions printingOptions) {
            this.options = printingOptions;
            this.options.setFontSize(this.options.getFontSize() + 1);
            this.repaint();
        }

        void $init$() {
            this.options = null;
        }

        public void paint(Graphics graphics) {
            int n = 5;
            int n2 = 5;
            int n3 = this.getWidth() - 10;
            int n4 = this.getHeight() - 10;
            graphics.setColor(Color.white);
            graphics.fillRect(n, n2, n3, n4);
            graphics.setColor(Color.black);
            graphics.drawRect(n, n2, n3, n4);
            Paper paper = new Paper();
            paper.setImageableArea(n += 4, n2 += 4, n3 -= 8, n4 -= 8);
            PageFormat pageFormat = new PageFormat();
            pageFormat.setPaper(paper);
            this.pageable.setPageFormat(pageFormat);
            this.pageable.setPrintOptions((PrintOptions)this.options);
            this.pageable.repaginate();
            try {
                graphics.clipRect(n, n2, n3, n4);
                this.pageable.print(graphics, pageFormat, 0);
            }
            catch (PrinterException printerException) {
                // empty catch block
            }
        }

        static void mav$setPrintOptions(Previewer previewer, PrintingOptions printingOptions) {
            previewer.setPrintOptions(printingOptions);
        }

        Previewer(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

