/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.options;

import oracle.javatools.util.Copyable;

public final class UndoOptions
implements Copyable {
    public static final String KEY_SETTINGS = "UndoOptions";
    private static final int MINIMUM_EDITS = 1;
    private static final int MAXIMUM_EDITS = 40;
    private int editMergeCountOption = 10;
    private boolean mergeTypedInsertOption = true;
    private boolean mergeTypedReplaceOption = true;
    private boolean mergeDeleteNextOption = true;
    private boolean mergeDeletePreviousOption = true;
    private boolean enableNavigationUndoOption = false;
    private int navigationMergeCountOption = 20;

    public Object copyTo(Object object) {
        UndoOptions undoOptions = object != null ? (UndoOptions)object : new UndoOptions();
        undoOptions.editMergeCountOption = this.editMergeCountOption;
        undoOptions.mergeTypedInsertOption = this.mergeTypedInsertOption;
        undoOptions.mergeTypedReplaceOption = this.mergeTypedReplaceOption;
        undoOptions.mergeDeleteNextOption = this.mergeDeleteNextOption;
        undoOptions.mergeDeletePreviousOption = this.mergeDeletePreviousOption;
        undoOptions.enableNavigationUndoOption = this.enableNavigationUndoOption;
        undoOptions.navigationMergeCountOption = this.navigationMergeCountOption;
        return undoOptions;
    }

    public int getEditMergeCount() {
        return this.editMergeCountOption;
    }

    public void setEditMergeCount(int n) {
        this.editMergeCountOption = n;
        Math.min(Math.max(n, 1), 40);
    }

    public boolean getMergeTypedInsert() {
        return this.mergeTypedInsertOption;
    }

    public void setMergeTypedInsert(boolean bl) {
        this.mergeTypedInsertOption = bl;
    }

    public boolean getMergeTypedReplace() {
        return this.mergeTypedReplaceOption;
    }

    public void setMergeTypedReplace(boolean bl) {
        this.mergeTypedReplaceOption = bl;
    }

    public boolean getMergeDeleteNext() {
        return this.mergeDeleteNextOption;
    }

    public void setMergeDeleteNext(boolean bl) {
        this.mergeDeleteNextOption = bl;
    }

    public boolean getMergeDeletePrevious() {
        return this.mergeDeletePreviousOption;
    }

    public void setMergeDeletePrevious(boolean bl) {
        this.mergeDeletePreviousOption = bl;
    }

    public boolean getEnableNavigationUndo() {
        return this.enableNavigationUndoOption;
    }

    public void setEnableNavigationUndo(boolean bl) {
        this.enableNavigationUndoOption = bl;
    }

    public int getNavigationMergeCount() {
        return this.navigationMergeCountOption;
    }

    public void setNavigationMergeCount(int n) {
        this.navigationMergeCountOption = Math.min(Math.max(n, 1), 40);
    }
}

