/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.options;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Hashtable;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.ide.ceditor.options.OptionsArb;
import oracle.ide.ceditor.options.UndoOptions;
import oracle.ide.controls.ItemSelectableTracker;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.ApplyListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.editor.EditorProperties;

public final class UndoOptionsPanel
extends DefaultTraversablePanel
implements ChangeListener,
ApplyListener {
    private JSlider slider_editMergeCount;
    private JLabel label_editCount;
    private JCheckBox checkbox_mergeTypedInsert;
    private JCheckBox checkbox_mergeTypedReplace;
    private JCheckBox checkbox_mergeDeleteNext;
    private JCheckBox checkbox_mergeDeletePrevious;
    private JCheckBox checkbox_enableNavigationUndo;
    private JSlider slider_navigationMergeCount;
    private JLabel label_navigationCount;

    public UndoOptionsPanel() {
        this.setHelpID("f1_idedidesetundo_html");
        this.setLayout(new GridBagLayout());
        this.initializeComponent();
    }

    public void onEntry(TraversableContext traversableContext) {
        UndoOptions undoOptions = this.findOptions(traversableContext);
        this.loadSettingsFrom(undoOptions);
    }

    public void onExit(TraversableContext traversableContext) {
        UndoOptions undoOptions = this.findOptions(traversableContext);
        this.saveSettingsTo(undoOptions);
    }

    private UndoOptions findOptions(TraversableContext traversableContext) {
        UndoOptions undoOptions = (UndoOptions)traversableContext.find("UndoOptions");
        return undoOptions;
    }

    public void apply(ApplyEvent applyEvent) {
        TraversableContext traversableContext = (TraversableContext)applyEvent.getSource();
        UndoOptions undoOptions = this.findOptions(traversableContext);
        UndoOptionsPanel.applyOptions(undoOptions);
    }

    public void cancel(ApplyEvent applyEvent) {
    }

    public static void applyOptions(UndoOptions undoOptions) {
        EditorProperties editorProperties = EditorProperties.getProperties();
        int n = undoOptions.getEditMergeCount();
        editorProperties.putProperty("edit-merge-count", (Object)new Integer(n));
        boolean bl = undoOptions.getMergeTypedInsert();
        editorProperties.putProperty("merge-typed-insert", (Object)(bl ? Boolean.TRUE : Boolean.FALSE));
        boolean bl2 = undoOptions.getMergeTypedReplace();
        editorProperties.putProperty("merge-typed-replace", (Object)(bl2 ? Boolean.TRUE : Boolean.FALSE));
        boolean bl3 = undoOptions.getMergeDeleteNext();
        editorProperties.putProperty("merge-delete-next", (Object)(bl3 ? Boolean.TRUE : Boolean.FALSE));
        boolean bl4 = undoOptions.getMergeDeletePrevious();
        editorProperties.putProperty("merge-delete-previous", (Object)(bl4 ? Boolean.TRUE : Boolean.FALSE));
        boolean bl5 = undoOptions.getEnableNavigationUndo();
        editorProperties.putProperty("undo-navigation", (Object)(bl5 ? Boolean.TRUE : Boolean.FALSE));
        int n2 = undoOptions.getNavigationMergeCount();
        editorProperties.putProperty("navigation-merge-count", (Object)new Integer(n2));
        editorProperties.putProperty("merge-navigation", (Object)Boolean.TRUE);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object instanceof JSlider) {
            this.updateSliderText((JSlider)object);
        }
    }

    private void updateSliderText(JSlider jSlider) {
        int n = jSlider.getValue();
        if (jSlider == this.slider_editMergeCount) {
            int n2 = n == 1 ? 63 : 64;
            String string = OptionsArb.format(n2, Integer.toString(n));
            this.label_editCount.setText(string);
            this.slider_editMergeCount.setToolTipText(string);
            boolean bl = n > 1;
            this.checkbox_mergeTypedInsert.setEnabled(bl);
            this.checkbox_mergeTypedReplace.setEnabled(bl);
            this.checkbox_mergeDeleteNext.setEnabled(bl);
            this.checkbox_mergeDeletePrevious.setEnabled(bl);
        } else if (jSlider == this.slider_navigationMergeCount) {
            int n3 = n == 1 ? 71 : 72;
            String string = OptionsArb.format(n3, Integer.toString(n));
            this.label_navigationCount.setText(string);
            this.slider_navigationMergeCount.setToolTipText(string);
        }
    }

    void loadSettingsFrom(UndoOptions undoOptions) {
        int n = undoOptions.getEditMergeCount();
        boolean bl = undoOptions.getMergeTypedInsert();
        boolean bl2 = undoOptions.getMergeTypedReplace();
        boolean bl3 = undoOptions.getMergeDeleteNext();
        boolean bl4 = undoOptions.getMergeDeletePrevious();
        boolean bl5 = undoOptions.getEnableNavigationUndo();
        int n2 = undoOptions.getNavigationMergeCount();
        this.slider_editMergeCount.setValue(n);
        this.checkbox_mergeTypedInsert.setSelected(bl);
        this.checkbox_mergeTypedReplace.setSelected(bl2);
        this.checkbox_mergeDeleteNext.setSelected(bl3);
        this.checkbox_mergeDeletePrevious.setSelected(bl4);
        this.checkbox_enableNavigationUndo.setSelected(bl5);
        this.slider_navigationMergeCount.setValue(n2);
    }

    void saveSettingsTo(UndoOptions undoOptions) {
        int n = this.slider_editMergeCount.getValue();
        boolean bl = this.checkbox_mergeTypedInsert.isSelected();
        boolean bl2 = this.checkbox_mergeTypedReplace.isSelected();
        boolean bl3 = this.checkbox_mergeDeleteNext.isSelected();
        boolean bl4 = this.checkbox_mergeDeletePrevious.isSelected();
        boolean bl5 = this.checkbox_enableNavigationUndo.isSelected();
        int n2 = this.slider_navigationMergeCount.getValue();
        undoOptions.setEditMergeCount(n);
        undoOptions.setMergeTypedInsert(bl);
        undoOptions.setMergeTypedReplace(bl2);
        undoOptions.setMergeDeleteNext(bl3);
        undoOptions.setMergeDeletePrevious(bl4);
        undoOptions.setEnableNavigationUndo(bl5);
        undoOptions.setNavigationMergeCount(n2);
    }

    private void initializeComponent() {
        String string = OptionsArb.getString(62);
        JLabel jLabel = new JLabel();
        this.slider_editMergeCount = new JSlider(1, 40, 40);
        this.slider_editMergeCount.addChangeListener(this);
        ResourceUtils.resLabel(jLabel, this.slider_editMergeCount, string);
        this.label_editCount = new JLabel();
        JLabel jLabel2 = new JLabel("1");
        JLabel jLabel3 = new JLabel("40");
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>(5);
        hashtable.put(new Integer(1), jLabel2);
        hashtable.put(new Integer(40), jLabel3);
        this.slider_editMergeCount.setLabelTable(hashtable);
        this.slider_editMergeCount.setPaintLabels(true);
        this.slider_editMergeCount.setPaintTicks(true);
        this.slider_editMergeCount.setMajorTickSpacing(10);
        this.slider_editMergeCount.setMinorTickSpacing(1);
        this.slider_editMergeCount.setSnapToTicks(true);
        String string2 = OptionsArb.getString(65);
        this.checkbox_mergeTypedInsert = new JCheckBox();
        ResourceUtils.resButton(this.checkbox_mergeTypedInsert, string2);
        String string3 = OptionsArb.getString(66);
        this.checkbox_mergeTypedReplace = new JCheckBox();
        ResourceUtils.resButton(this.checkbox_mergeTypedReplace, string3);
        String string4 = OptionsArb.getString(67);
        this.checkbox_mergeDeleteNext = new JCheckBox();
        ResourceUtils.resButton(this.checkbox_mergeDeleteNext, string4);
        String string5 = OptionsArb.getString(68);
        this.checkbox_mergeDeletePrevious = new JCheckBox();
        ResourceUtils.resButton(this.checkbox_mergeDeletePrevious, string5);
        String string6 = OptionsArb.getString(69);
        this.checkbox_enableNavigationUndo = new JCheckBox();
        ResourceUtils.resButton(this.checkbox_enableNavigationUndo, string6);
        String string7 = OptionsArb.getString(70);
        JLabel jLabel4 = new JLabel();
        this.slider_navigationMergeCount = new JSlider(1, 40, 1);
        this.slider_navigationMergeCount.addChangeListener(this);
        ResourceUtils.resLabel(jLabel4, this.slider_navigationMergeCount, string7);
        this.label_navigationCount = new JLabel();
        jLabel2 = new JLabel("1");
        jLabel3 = new JLabel("40");
        hashtable = new Hashtable(5);
        hashtable.put(new Integer(1), jLabel2);
        hashtable.put(new Integer(40), jLabel3);
        this.slider_navigationMergeCount.setLabelTable(hashtable);
        this.slider_navigationMergeCount.setPaintLabels(true);
        this.slider_navigationMergeCount.setPaintTicks(true);
        this.slider_navigationMergeCount.setMajorTickSpacing(10);
        this.slider_navigationMergeCount.setMinorTickSpacing(1);
        this.slider_navigationMergeCount.setSnapToTicks(true);
        Component[] componentArray = new Component[]{this.slider_navigationMergeCount, jLabel4, this.label_navigationCount, jLabel2, jLabel3};
        ItemSelectableTracker itemSelectableTracker = new ItemSelectableTracker(this.checkbox_enableNavigationUndo, componentArray);
        this.updateSliderText(this.slider_editMergeCount);
        this.updateSliderText(this.slider_navigationMergeCount);
        Insets insets = new Insets(5, 5, 5, 5);
        Insets insets2 = new Insets(2, 30, 2, 2);
        Insets insets3 = new Insets(2, 2, 2, 2);
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 2, insets3, 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, insets3, 0, 0);
        jPanel.add((Component)this.slider_editMergeCount, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, insets3, 0, 0);
        jPanel.add((Component)this.label_editCount, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 2, insets3, 0, 0);
        jPanel2.add((Component)jLabel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, insets3, 0, 0);
        jPanel2.add((Component)this.slider_navigationMergeCount, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, insets3, 0, 0);
        jPanel2.add((Component)this.label_navigationCount, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0);
        this.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, insets2, 0, 0);
        this.add((Component)this.checkbox_mergeTypedInsert, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, insets2, 0, 0);
        this.add((Component)this.checkbox_mergeTypedReplace, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 2, insets2, 0, 0);
        this.add((Component)this.checkbox_mergeDeleteNext, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 2, insets2, 0, 0);
        this.add((Component)this.checkbox_mergeDeletePrevious, gridBagConstraints);
        Component component = Box.createVerticalStrut(15);
        gridBagConstraints = new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0);
        this.add(component, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 6, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0);
        this.add((Component)this.checkbox_enableNavigationUndo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 7, 1, 1, 1.0, 0.0, 17, 2, insets2, 0, 0);
        this.add((Component)jPanel2, gridBagConstraints);
        Component component2 = Box.createVerticalGlue();
        gridBagConstraints = new GridBagConstraints(0, 8, 1, 1, 1.0, 1.0, 17, 1, insets, 0, 0);
        this.add(component2, gridBagConstraints);
    }
}

