/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.cmd;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Command;
import oracle.ide.controls.StatusBar;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.ContentSet;
import oracle.ide.model.ContentSetProvider;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.Subject;
import oracle.ide.navigator.ContentSetSupport;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.ModelArb;
import oracle.javatools.data.ChangeBuffer;
import oracle.javatools.data.StructureChangeListener;

public class AddContentCommand
extends Command {
    private String _explicitKey;
    private String _registeredKey;
    private boolean _includeSubFolders;
    private static final HashMap _mapping = new HashMap(15);
    private static final String RESOURCES_KEY = "oracle.ide.model.ResourcePaths/resourcesContentSet";
    public static final int FAILED = 2;

    public AddContentCommand() {
        super(ContentSetSupport.ADD_URL_TO_PROJECT_CMD_ID, 2);
    }

    public static void registerPreferredContentSet(Class clazz, String string) {
        _mapping.put(clazz, string);
    }

    public static void unRegisterPreferredContentSet(Class clazz, String string) {
        if (_mapping.containsKey(clazz) && _mapping.get(clazz).equals(string)) {
            _mapping.remove(clazz);
        }
    }

    public static void addToProject(Node node, Project project, String string) {
        Context context = new Context();
        context.setProject(project);
        context.setNode(node);
        AddContentCommand.addToProject(context, string);
    }

    public static void addToProject(Node[] nodeArray, Project project, String string) {
        Context context = new Context();
        context.setProject(project);
        context.setSelection(nodeArray);
        AddContentCommand.addToProject(context, string);
    }

    public static void addToProject(Context context, String string) {
        AddContentCommand addContentCommand = new AddContentCommand();
        addContentCommand.setContext(context);
        try {
            addContentCommand.doit(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public int doit(boolean bl) throws Exception {
        this._includeSubFolders = bl;
        return this.doit();
    }

    public int doit(String string) throws Exception {
        return this.doit(string, false);
    }

    public int doit(String string, boolean bl) throws Exception {
        if (this.lookupProvider(string) == null) {
            throw new IllegalArgumentException("Unknown content set key: " + string);
        }
        this._explicitKey = string;
        this._includeSubFolders = bl;
        return this.doit();
    }

    public int doit() throws Exception {
        Context context = this.getContext();
        Project project = context.getProject();
        if (project != null) {
            StatusBar statusBar = Ide.getStatusBar();
            String string = "";
            Node[] nodeArray = this.getNodes(context);
            if (nodeArray.length == 1) {
                if (this._explicitKey == null) {
                    this._registeredKey = this.lookupPreferredKey(nodeArray[0]);
                }
                string = URLFileSystem.getPlatformPathName(nodeArray[0].getURL());
            } else if (nodeArray.length > 1) {
                string = ModelArb.getString(65);
            }
            statusBar.setText(ModelArb.format(62, string, project.getShortLabel()));
            int n = this.addContent(nodeArray, project);
            if (n == 0) {
                statusBar.setText(ModelArb.format(63, string, project.getShortLabel()));
                return 0;
            }
            statusBar.setText("");
            return n;
        }
        return 2;
    }

    private Node[] getNodes(Context context) {
        Node node;
        Project project = context.getProject();
        Element[] elementArray = context.getSelection();
        if ((elementArray.length == 0 || elementArray.length > 0 && !(elementArray[0] instanceof Subject)) && (node = context.getNode()) != null) {
            elementArray = new Element[]{node};
        }
        if (elementArray.length == 0) {
            return new Node[0];
        }
        ArrayList<Element> arrayList = new ArrayList<Element>(elementArray.length);
        ContentSet contentSet = this._explicitKey != null && !RESOURCES_KEY.equals(this._explicitKey) ? ContentSet.getInstance(project, this._explicitKey) : ProjectContent.getInstance(project).getAllContents();
        int n = 0;
        while (n < elementArray.length) {
            URL uRL;
            Element element = elementArray[n];
            if (element instanceof Node && !contentSet.canHaveMember(uRL = ((Node)element).getURL())) {
                arrayList.add(element);
            }
            ++n;
        }
        return arrayList.toArray(new Node[arrayList.size()]);
    }

    private int addContent(Node[] nodeArray, Project project) {
        Project project2 = (Project)project.copyTo(null);
        ChangeBuffer changeBuffer = new ChangeBuffer();
        project2.getSharedPropertiesOnly().addStructureChangeListener((StructureChangeListener)changeBuffer);
        ChangeBuffer changeBuffer2 = new ChangeBuffer();
        project2.getUserPropertiesOnly().addStructureChangeListener((StructureChangeListener)changeBuffer2);
        ProjectContent projectContent = ProjectContent.getInstance(project2);
        int n = this.addContentImpl(nodeArray, projectContent);
        project2.getSharedPropertiesOnly().removeStructureChangeListener((StructureChangeListener)changeBuffer);
        project2.getUserPropertiesOnly().removeStructureChangeListener((StructureChangeListener)changeBuffer2);
        if (n == 0) {
            project.applyBatchChanges(new 1(this, project, changeBuffer, changeBuffer2));
        }
        return n;
    }

    private int addContentImpl(Node[] nodeArray, ProjectContent projectContent) {
        if (nodeArray.length == 0) {
            return 0;
        }
        if (this._explicitKey != null) {
            return projectContent.add(nodeArray, this._explicitKey) ? 0 : 2;
        }
        ContentSetSelector contentSetSelector = new ContentSetSelector(nodeArray, projectContent);
        HelpSystem.getHelpSystem().registerTopic(contentSetSelector, "f1_idedaddtoproject_html");
        if (OnePageWizardDialogFactory.runDialog((Component)((Object)Ide.getMainWindow()), (Component)contentSetSelector, contentSetSelector.getFocusComponent(), ModelArb.getString(60))) {
            String string = contentSetSelector.getKey();
            return projectContent.add(nodeArray, string) ? 0 : 2;
        }
        return 1;
    }

    private ContentSetProvider lookupProvider(String string) {
        ContentSetProvider[] contentSetProviderArray = ProjectContent.getContentSetProviders();
        int n = 0;
        while (n < contentSetProviderArray.length) {
            if (contentSetProviderArray[n].getKey().equals(string)) {
                return contentSetProviderArray[n];
            }
            ++n;
        }
        return null;
    }

    private String lookupPreferredKey(Node node) {
        Class<?> clazz = node.getClass();
        if (_mapping.containsKey(clazz)) {
            return (String)_mapping.get(clazz);
        }
        return null;
    }

    static String ra$_registeredKey(AddContentCommand addContentCommand) {
        return addContentCommand._registeredKey;
    }

    public final class 1
    implements Runnable {
        private final /* synthetic */ Project v$project;
        private final /* synthetic */ ChangeBuffer v$sharedChangeBuffer;
        private final /* synthetic */ ChangeBuffer v$userChangeBuffer;
        final /* synthetic */ AddContentCommand this$0;

        public void run() {
            this.v$project.getSharedPropertiesOnly().applyChanges(this.v$sharedChangeBuffer.getChanges());
            this.v$project.getUserPropertiesOnly().applyChanges(this.v$userChangeBuffer.getChanges());
        }

        public 1(AddContentCommand addContentCommand, Project project, ChangeBuffer changeBuffer, ChangeBuffer changeBuffer2) {
            this.v$userChangeBuffer = changeBuffer2;
            this.v$sharedChangeBuffer = changeBuffer;
            this.v$project = project;
            this.this$0 = addContentCommand;
        }
    }

    private class ContentSetSelector
    extends JPanel {
        String csKey;
        JRadioButton focus;

        void $init$() {
            this.csKey = "";
        }

        ContentSetSelector(Node[] nodeArray, ProjectContent projectContent) {
            block4: {
                super(new GridBagLayout());
                this.$init$();
                JLabel jLabel = new JLabel(ModelArb.getString(64));
                String string = nodeArray.length == 1 ? URLFileSystem.getPlatformPathName(nodeArray[0].getURL()) : ModelArb.getString(65);
                JLabel jLabel2 = new JLabel(string + ".");
                JLabel jLabel3 = new JLabel(ModelArb.getString(66));
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = -1;
                gridBagConstraints.anchor = 18;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 2;
                gridBagConstraints.insets.bottom = 2;
                this.add((Component)jLabel, gridBagConstraints);
                gridBagConstraints.insets.bottom = 10;
                this.add((Component)jLabel2, gridBagConstraints);
                this.add((Component)jLabel3, gridBagConstraints);
                gridBagConstraints.insets.left = 8;
                gridBagConstraints.insets.bottom = 3;
                gridBagConstraints.fill = 0;
                ContentSetProvider[] contentSetProviderArray = ProjectContent.getContentSetProviders();
                ButtonGroup buttonGroup = new ButtonGroup();
                int n = 0;
                while (n < contentSetProviderArray.length) {
                    if (this.canAdd(contentSetProviderArray[n], nodeArray, projectContent)) {
                        int n2 = n;
                        JRadioButton jRadioButton = new JRadioButton(contentSetProviderArray[n].getNavigable().getShortLabel());
                        jRadioButton.addItemListener(new 1(this, contentSetProviderArray, n2));
                        if (contentSetProviderArray[n].getKey().equals(AddContentCommand.ra$_registeredKey(AddContentCommand.this))) {
                            jRadioButton.setSelected(true);
                            this.focus = jRadioButton;
                        }
                        buttonGroup.add(jRadioButton);
                        this.add((Component)jRadioButton, gridBagConstraints);
                    }
                    ++n;
                }
                if (buttonGroup.getSelection() != null) break block4;
                Enumeration<AbstractButton> enumeration = buttonGroup.getElements();
                if (enumeration.hasMoreElements()) {
                    JRadioButton jRadioButton = (JRadioButton)enumeration.nextElement();
                    jRadioButton.setSelected(true);
                }
            }
        }

        String getKey() {
            return this.csKey;
        }

        Component getFocusComponent() {
            return this.focus;
        }

        boolean canAdd(ContentSetProvider contentSetProvider, Node[] nodeArray, ProjectContent projectContent) {
            int n = 0;
            while (n < nodeArray.length) {
                if (!contentSetProvider.getContentSetHelper().canAddContent(nodeArray[n].getURL(), projectContent)) {
                    return false;
                }
                ++n;
            }
            return true;
        }

        public final class 1
        implements ItemListener {
            private final /* synthetic */ ContentSetProvider[] v$providers;
            private final /* synthetic */ int v$which;
            final /* synthetic */ ContentSetSelector this$0;

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    this.this$0.csKey = this.v$providers[this.v$which].getKey();
                }
            }

            public 1(ContentSetSelector contentSetSelector, ContentSetProvider[] contentSetProviderArray, int n) {
                this.v$which = n;
                this.v$providers = contentSetProviderArray;
                this.this$0 = contentSetSelector;
            }
        }
    }
}

