/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.cmd;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.cmd.RemoveFileCommand;
import oracle.ide.controller.Command;
import oracle.ide.controls.checkboxlist.CheckBoxListModel;
import oracle.ide.dialogs.SelectFilesPanel;
import oracle.ide.explorer.ExplorerContext;
import oracle.ide.explorer.TNode;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Folder;
import oracle.ide.model.LazyLoadable;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.model.Workspaces;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.IdeArb;

public class CloseNodeCommand
extends Command {
    private List affectedNodes;
    private final UpdateMessage _messageTemplate;
    private boolean _confirm;

    void $init$() {
        this.affectedNodes = new ArrayList(1);
        this._confirm = true;
    }

    public CloseNodeCommand() {
        this(null);
    }

    public CloseNodeCommand(UpdateMessage updateMessage) {
        super(20, 1);
        this.$init$();
        this._messageTemplate = updateMessage != null ? updateMessage.copyMessage() : new UpdateMessage(UpdateMessage.NO_MESSAGE, null);
    }

    public int doit() throws Exception {
        List list;
        Context context = this.getContext();
        TNode[] tNodeArray = ExplorerContext.getTNodes(context);
        if (tNodeArray != null) {
            if (tNodeArray.length == 0) {
                return 1;
            }
            list = this.confirmClose(tNodeArray);
        } else {
            list = this.confirmClose(context.getNode());
        }
        int n = this.close(list, false, true);
        return n;
    }

    public boolean isNeedConfirm() {
        return this._confirm;
    }

    public void setNeedConfirm(boolean bl) {
        this._confirm = bl;
    }

    private void notifyNodesClosing(List list) {
        UpdateMessage updateMessage = this._messageTemplate.forNewMessageID(UpdateMessage.OBJECT_CLOSING);
        int n = 0;
        while (n < list.size()) {
            Node node = (Node)list.get(n);
            node.notifyObservers(node, updateMessage);
            ++n;
        }
    }

    private void recCollectClosingNodes(Iterator iterator, List list) {
        this.collectAffectedNodes(iterator, new ArrayList(), list);
    }

    public int close(List list, boolean bl, boolean bl2) {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        this.collectAffectedNodes(list.iterator(), arrayList, arrayList2);
        int n = this.checkSave(arrayList, true);
        if (n != 0) {
            return n;
        }
        return this.close(arrayList2, this.getContext(), bl, bl2);
    }

    public int close(Node node, boolean bl, boolean bl2) {
        if (!node.isOpen()) {
            return 0;
        }
        return this.close(Collections.singletonList(node), bl, bl2);
    }

    public int close(Node node) {
        if (!node.isOpen()) {
            return 0;
        }
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        this.collectAffectedNodes(Collections.singletonList(node).iterator(), arrayList, arrayList2);
        this.checkSave(arrayList, false);
        return this.close(arrayList2, this.getContext(), false, true);
    }

    public Node[] getAffectedNodes() {
        Node[] nodeArray = new Node[this.affectedNodes.size()];
        this.affectedNodes.toArray(nodeArray);
        return nodeArray;
    }

    public void clearAffectedNodes() {
        this.affectedNodes.clear();
    }

    public int checkSave(Iterator iterator) {
        return this.checkSave(iterator, true);
    }

    public int checkSave(Iterator iterator, boolean bl) {
        ArrayList arrayList = new ArrayList();
        this.collectDirtyNodes(iterator, arrayList);
        return this.checkSave(arrayList, bl);
    }

    public int checkSave(List list, boolean bl) {
        int n;
        if (list.size() == 0) {
            return 0;
        }
        Iterator iterator = list.iterator();
        CheckBoxListModel checkBoxListModel = new CheckBoxListModel();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            checkBoxListModel.addElement(node, node.getIcon(), true, true, URLFileSystem.getPlatformPathName(node.getURL()));
        }
        int n2 = 1;
        if (this.isNeedConfirm()) {
            int n3 = 1;
            if (!bl) {
                n3 = 0;
            }
            n = SelectFilesPanel.showDialog(IdeArb.getString(285), IdeArb.format(217, checkBoxListModel.findTextForElement(0)), IdeArb.getString(220), checkBoxListModel, true, n3, "f1_idedsavefiles_html");
        } else {
            n = 0;
        }
        if (n == 0) {
            int n4;
            CheckBoxListModel checkBoxListModel2 = new CheckBoxListModel();
            int n5 = checkBoxListModel.getSize();
            int n6 = 0;
            while (n6 < n5) {
                if (checkBoxListModel.isElementSelected(n6)) {
                    URL uRL;
                    Node node = (Node)checkBoxListModel.getUserObjectAt(n6);
                    if (node.isReadOnly() && (uRL = node.getURL()) != null) {
                        URLFileSystem.setReadOnly(uRL, false);
                    }
                    try {
                        node.save();
                    }
                    catch (IOException iOException) {
                        checkBoxListModel2.addElement(node, node.getIcon(), true, true, node.getLongLabel());
                    }
                }
                ++n6;
            }
            int n7 = checkBoxListModel2.getSize();
            n2 = n7 > 0 ? (this.isNeedConfirm() ? ((n4 = SelectFilesPanel.showDialog(IdeArb.getString(286), IdeArb.format(282, checkBoxListModel.findTextForElement(0)), IdeArb.getString(281), checkBoxListModel2, false, 2, "f1_idedunabletosavefiles_html")) == 0 ? 0 : 1) : 1) : 0;
        } else if (n == 1) {
            n2 = 0;
        }
        return n2;
    }

    public int close(Iterator iterator, Context context, boolean bl, boolean bl2) {
        ArrayList arrayList = new ArrayList();
        this.recCollectClosingNodes(iterator, arrayList);
        return this.close(arrayList, context, bl, bl2);
    }

    protected int close(List list, Context context, boolean bl, boolean bl2) {
        this.notifyNodesClosing(list);
        return this.closeNoNotify(list, context, bl, bl2);
    }

    private int closeNoNotify(List list, Context context, boolean bl, boolean bl2) {
        UpdateMessage updateMessage = this._messageTemplate.forNewMessageID(UpdateMessage.OBJECT_CLOSED);
        updateMessage.setContext(context);
        ArrayList<Node> arrayList = new ArrayList<Node>();
        int n = 0;
        int n2 = list.size();
        while (n < n2) {
            Object e = list.get(n);
            if (e instanceof Node) {
                Node node = (Node)e;
                if (node instanceof Project && context.getProject() != node) {
                    Context context2 = new Context(context);
                    context2.setProject((Project)node);
                    context = context2;
                }
                try {
                    node.notifyObservers(node, updateMessage);
                    node.close();
                    if (bl2 && !URLFileSystem.exists(node.getURL())) {
                        arrayList.add(node);
                    }
                    this.affectedNodes.add(node);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                if (bl) {
                    NodeFactory.uncache(node.getURL());
                }
            }
            ++n;
        }
        if (arrayList.size() > 0) {
            this.removeUnsavedNodes(arrayList, context);
        }
        return 0;
    }

    private void collectAffectedNodes(Iterator iterator, List list, List list2) {
        while (iterator.hasNext()) {
            Iterator iterator2;
            Element element = (Element)iterator.next();
            if (element instanceof Node) {
                Node node = (Node)element;
                if (!list.contains(node) && node.isDirty() && node.getAttributes().isSet(ElementAttributes.SAVEABLE)) {
                    list.add(node);
                }
                if (!node.isOpen() || list2.contains(node)) continue;
                if (node.mayHaveChildren()) {
                    if (node instanceof Project) {
                        this.collectAffectedNodesFromProject((Project)node, list, list2);
                    } else {
                        Iterator iterator3 = node.getChildren();
                        if (iterator3 != null) {
                            this.collectAffectedNodes(iterator3, list, list2);
                        }
                    }
                }
                list2.add(node);
                continue;
            }
            if (element instanceof LazyLoadable && !((LazyLoadable)((Object)element)).isOpen() || !element.mayHaveChildren() || (iterator2 = element.getChildren()) == null) continue;
            this.collectAffectedNodes(iterator2, list, list2);
        }
    }

    private void collectAffectedNodesFromProject(Project project, List list, List list2) {
        ContentSet contentSet = ProjectContent.getInstance(project).getAllContents();
        Iterator iterator = NodeFactory.getOpenNodes();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            if (this.isSystemNode(node) || !contentSet.canHaveMember(node.getURL())) continue;
            if (node.isDirty() && !list.contains(node) && node.getAttributes().isSet(ElementAttributes.SAVEABLE)) {
                list.add(node);
            }
            if (!node.isOpen()) continue;
            list2.add(node);
        }
    }

    private boolean isSystemNode(Node node) {
        return node instanceof Project || node instanceof Workspace;
    }

    protected void collectDirtyNodes(Iterator iterator, List list) {
        this.collectAffectedNodes(iterator, list, new ArrayList());
    }

    protected List confirmClose(TNode[] tNodeArray) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        int n = 0;
        while (n < tNodeArray.length) {
            Node node;
            TNode tNode = tNodeArray[n];
            Element element = tNode.getData();
            if (element instanceof Node && (!(element instanceof Node) || (node = (Node)element).isOpen())) {
                arrayList.add(element);
            }
            ++n;
        }
        return arrayList;
    }

    protected List confirmClose(Element element) {
        Node node;
        ArrayList<Element> arrayList = new ArrayList<Element>(1);
        if (element instanceof Node && (node = (Node)element).isOpen()) {
            arrayList.add(element);
        }
        return arrayList;
    }

    private void removeUnsavedNodes(List list, Context context) {
        HashMap<Folder, ArrayList<Node>> hashMap = new HashMap<Folder, ArrayList<Node>>();
        for (Node node : list) {
            Folder folder = Workspaces.findOwner(node, context);
            if (folder == null || !folder.canRemove(node)) continue;
            ArrayList<Node> arrayList = (ArrayList<Node>)hashMap.get(folder);
            if (arrayList == null) {
                arrayList = new ArrayList<Node>();
                hashMap.put(folder, arrayList);
            }
            arrayList.add(node);
            NodeFactory.uncache(node.getURL());
        }
        RemoveFileCommand removeFileCommand = new RemoveFileCommand();
        removeFileCommand.setContext(context);
        for (Folder folder : hashMap.keySet()) {
            List list2 = (List)hashMap.get(folder);
            removeFileCommand.remove(list2, folder, false);
        }
    }
}

