/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.cmd;

import java.util.Enumeration;
import java.util.Hashtable;
import oracle.ide.Context;
import oracle.ide.controller.Command;
import oracle.ide.explorer.ExplorerContext;
import oracle.ide.explorer.TNode;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspaces;
import oracle.ide.resource.IdeArb;

public class DeleteTNodeCommand
extends Command {
    Hashtable childParentMap;

    public DeleteTNodeCommand() {
        super(20, 0);
    }

    protected DeleteTNodeCommand(int n, int n2) {
        super(n, n2);
    }

    public int doit() throws Exception {
        if (this.childParentMap != null) {
            return this.redo();
        }
        Context context = this.getContext();
        TNode[] tNodeArray = ExplorerContext.getTNodes(context);
        int n = 1;
        if (tNodeArray != null) {
            this.childParentMap = new Hashtable();
            UpdateMessage updateMessage = new UpdateMessage(UpdateMessage.CHILD_REMOVED, null);
            if (tNodeArray.length == 0) {
                return 1;
            }
            TNode tNode = (TNode)tNodeArray[0].getParent();
            Folder folder = null;
            if (tNode != null) {
                folder = (Folder)tNode.getData();
            }
            if (folder == null) {
                return 1;
            }
            Folder folder2 = null;
            int n2 = 0;
            while (n2 < tNodeArray.length) {
                TNode tNode2 = tNodeArray[n2];
                Element element = tNode2.getData();
                TNode tNode3 = (TNode)tNode2.getParent();
                if (tNode == tNode3 && (folder2 = this.getElementOwner(element, context, folder)).canRemove(element)) {
                    this.childParentMap.put(element, folder2);
                    folder2.remove(element);
                    updateMessage.getRemoveObjects().add(element);
                    n = 0;
                }
                ++n2;
            }
            if (folder2 instanceof Subject) {
                Subject subject = (Subject)((Object)folder2);
                subject.notifyObservers(folder2, updateMessage);
            }
        }
        return n;
    }

    public int undo() throws Exception {
        if (this.childParentMap != null && this.childParentMap.size() > 0) {
            Enumeration enumeration = this.childParentMap.keys();
            Folder folder = null;
            Folder folder2 = null;
            UpdateMessage updateMessage = new UpdateMessage(UpdateMessage.CHILD_ADDED, null);
            while (enumeration.hasMoreElements()) {
                Element element = (Element)enumeration.nextElement();
                if (folder == null) {
                    folder = (Folder)this.childParentMap.get(element);
                } else if (folder != this.childParentMap.get(element)) continue;
                folder2 = this.getElementOwner(element, this.getContext(), folder);
                folder2.add(element);
                updateMessage.getAddObjects().add(element);
            }
            if (folder2 instanceof Subject) {
                Subject subject = (Subject)((Object)folder2);
                subject.notifyObservers(folder2, updateMessage);
            }
            return 0;
        }
        return 1;
    }

    public String getName() {
        return IdeArb.getString(103);
    }

    private int redo() {
        if (this.childParentMap.size() > 0) {
            Enumeration enumeration = this.childParentMap.keys();
            Folder folder = null;
            Folder folder2 = null;
            UpdateMessage updateMessage = new UpdateMessage(UpdateMessage.CHILD_REMOVED, null);
            while (enumeration.hasMoreElements()) {
                Element element = (Element)enumeration.nextElement();
                if (folder == null) {
                    folder = (Folder)this.childParentMap.get(element);
                } else if (folder != this.childParentMap.get(element)) continue;
                folder2 = this.getElementOwner(element, this.getContext(), folder);
                if (!folder2.canRemove(element)) continue;
                folder2.remove(element);
                updateMessage.getRemoveObjects().add(element);
            }
            if (folder2 instanceof Subject) {
                Subject subject = (Subject)((Object)folder2);
                subject.notifyObservers(folder2, updateMessage);
            }
            return 0;
        }
        return 1;
    }

    private Folder getElementOwner(Element element, Context context, Folder folder) {
        Folder folder2 = Workspaces.findOwner(element, context);
        if (folder2 == null) {
            folder2 = folder;
        }
        return folder2;
    }
}

