/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.cmd;

import java.awt.Component;
import java.io.IOException;
import java.net.URL;
import javax.swing.JOptionPane;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.cmd.CloseNodeCommand;
import oracle.ide.cmd.SaveAsCommand;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.IdeArb;

public class EditorSaveAsCommand
extends SaveAsCommand {
    public EditorSaveAsCommand() {
        super(12);
    }

    protected int doSaveAs(String string) {
        Node node;
        int n = super.doSaveAs(string);
        if (!(n != 0 || (node = NodeFactory.find(this._newURL)) == null || this._elementOwner != null && this._elementOwner.canAdd(node))) {
            Ide.addToMiscellaneousFolder(node);
        }
        return n;
    }

    protected int saveAsNewNode(Node node) {
        URL uRL = node.getURL();
        String string = URLFileSystem.getSuffix(uRL);
        try {
            boolean bl;
            boolean bl2 = node.isDirty();
            if (bl2 || node.isNew()) {
                URL uRL2 = URLFileSystem.createTempFile("jdev", string, URLFileSystem.getParent(this._newURL));
                if (uRL2 == null) {
                    throw new IOException();
                }
                node.setURL(uRL2);
                node.markDirty(true);
                try {
                    node.save();
                }
                catch (Exception exception) {
                    node.setURL(uRL);
                    node.markDirty(bl2);
                    throw exception;
                }
                if (URLFileSystem.exists(this._newURL) && !URLFileSystem.delete(this._newURL) || !URLFileSystem.renameTo(uRL2, this._newURL)) {
                    node.setURL(uRL);
                    node.markDirty(bl2);
                    String string2 = IdeArb.format(248, uRL.getPath());
                    JOptionPane.showMessageDialog((Component)((Object)Ide.getMainWindow()), string2, IdeArb.getString(240), 0);
                    int n = 2;
                    return n;
                }
                node.setURL(uRL);
                node.markDirty(bl2);
            } else {
                if (URLFileSystem.exists(this._newURL) && !URLFileSystem.delete(this._newURL)) {
                    String string3 = IdeArb.format(248, uRL.getPath());
                    JOptionPane.showMessageDialog((Component)((Object)Ide.getMainWindow()), string3, IdeArb.getString(240), 0);
                    int n = 2;
                    return n;
                }
                URLFileSystem.copy(uRL, this._newURL);
            }
            Node node2 = NodeFactory.findOrCreate(this._nodeClass, this._newURL);
            node2.open();
            if (this._elementOwner != null && (bl = this._elementOwner.add(node2)) && this._elementOwner instanceof Subject) {
                UpdateMessage.fireChildAdded((Subject)((Object)this._elementOwner), node2);
            }
            this.reloadEditors(node2);
            if (!node.isDirty() && !node.isNew()) {
                this.closeNode(node);
            }
            int n = 0;
            return n;
        }
        catch (Exception exception) {
            String string4 = IdeArb.format(247, uRL.getPath(), exception.toString());
            JOptionPane.showMessageDialog((Component)((Object)Ide.getMainWindow()), string4, IdeArb.getString(240), 0);
            return 2;
        }
    }

    protected int convertToNewNode(Node node) {
        return this.saveAsNewNode(node);
    }

    protected int convertToDupNode(Node node) {
        return 2;
    }

    protected int saveAsDupNode(Node node) {
        URL uRL = node.getURL();
        try {
            this._duplicate.close();
            if (node.isNew()) {
                node.save();
            }
            URLFileSystem.copy(uRL, this._newURL);
            this._duplicate.open();
            if (this._elementOwner != null) {
                this._elementOwner.add(this._duplicate);
                if (this._elementOwner instanceof Subject) {
                    UpdateMessage.fireChildAdded((Subject)((Object)this._elementOwner), this._duplicate);
                }
            }
            this.reloadEditors(this._duplicate);
            int n = 0;
            return n;
        }
        catch (Exception exception) {
            String string = IdeArb.format(247, uRL.getPath(), exception.toString());
            JOptionPane.showMessageDialog((Component)((Object)Ide.getMainWindow()), string, IdeArb.getString(240), 0);
            return 2;
        }
    }

    private int closeNode(Node node) {
        CloseNodeCommand closeNodeCommand = new CloseNodeCommand();
        closeNodeCommand.setContext(this.getContext());
        return closeNodeCommand.close(node, false, false);
    }

    private void reloadEditors(Node node) {
        Context context = new Context(this.getContext());
        context.setNode(node);
        Element[] elementArray = new Element[]{node};
        context.setSelection(elementArray);
        EditorManager.getEditorManager().replaceEditors(this.getContext(), context);
    }
}

