/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.cmd;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import oracle.ide.Ide;
import oracle.ide.cmd.SaveAllCommand;
import oracle.ide.cmd.ShutdownHook;
import oracle.ide.config.EnvironOptions;
import oracle.ide.controller.Command;
import oracle.ide.controls.checkboxlist.CheckBoxListModel;
import oracle.ide.dialogs.SelectFilesPanel;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.model.Workspaces;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.IdeArb;
import oracle.ide.view.View;

public class ExitCommand
extends Command {
    private static Collection<ShutdownHook> _shutdownHooks;

    public ExitCommand() {
        super(4);
    }

    public static void addShutdownHook(ShutdownHook shutdownHook) {
        if (_shutdownHooks == null) {
            _shutdownHooks = new ArrayList<ShutdownHook>();
        }
        _shutdownHooks.add(shutdownHook);
    }

    public static void removeShutdownHook(ShutdownHook shutdownHook) {
        if (_shutdownHooks != null) {
            _shutdownHooks.remove(shutdownHook);
        }
    }

    private final Collection getShutdownHooks() {
        if (_shutdownHooks == null) {
            return Collections.emptyList();
        }
        return _shutdownHooks;
    }

    private boolean canShutdown() {
        if (_shutdownHooks == null) {
            return true;
        }
        for (ShutdownHook shutdownHook : _shutdownHooks) {
            try {
                if (shutdownHook.canShutdown()) continue;
                boolean bl = false;
                return bl;
            }
            catch (Throwable throwable) {
                if (throwable instanceof ThreadDeath) {
                    throw (ThreadDeath)throwable;
                }
                throwable.printStackTrace();
            }
        }
        boolean bl = true;
        return bl;
    }

    private void shutdown() {
        if (_shutdownHooks == null) {
            return;
        }
        for (ShutdownHook shutdownHook : _shutdownHooks) {
            try {
                shutdownHook.shutdown();
            }
            catch (Throwable throwable) {
                if (throwable instanceof ThreadDeath) {
                    throw (ThreadDeath)throwable;
                }
                throwable.printStackTrace();
            }
        }
    }

    public int doit() throws Exception {
        EnvironOptions environOptions;
        if (!this.canShutdown()) {
            return 1;
        }
        View view = (View)this.getData();
        if (view == null) {
            view = Ide.getMainWindow().getIdeMainWindowView();
        }
        if ((environOptions = (EnvironOptions)Ide.getSettings().getData("environment-options")).getSaveOnDeactivation()) {
            try {
                SaveAllCommand.saveAll();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ArrayList<Node> arrayList = new ArrayList<Node>();
        Iterator iterator = NodeFactory.getOpenNodes();
        CheckBoxListModel checkBoxListModel = new CheckBoxListModel();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            if (node.isDirty()) {
                if (!(!node.getAttributes().isSet(ElementAttributes.SAVEABLE) || node instanceof Project && ((Project)node).isDefaultProject())) {
                    checkBoxListModel.addElement(node, node.getIcon(), true, true, URLFileSystem.getPlatformPathName(node.getURL()));
                    continue;
                }
                arrayList.add(node);
                continue;
            }
            if (!(node instanceof Project)) continue;
            try {
                ((Project)node).saveUserProperties();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        boolean bl = true;
        boolean bl2 = true;
        if (checkBoxListModel.getSize() > 0) {
            int n = SelectFilesPanel.showDialog(IdeArb.getString(285), IdeArb.format(217, checkBoxListModel.findTextForElement(0)), IdeArb.getString(220), checkBoxListModel, true, 1, "f1_idedsavefiles_html");
            switch (n) {
                case 0: {
                    bl2 = false;
                    List list = checkBoxListModel.getSelectionList();
                    Iterator iterator2 = null;
                    if (list != null) {
                        iterator2 = list.iterator();
                    }
                    checkBoxListModel = null;
                    checkBoxListModel = new CheckBoxListModel();
                    while (iterator2 != null && iterator2.hasNext()) {
                        Node node = (Node)iterator2.next();
                        URL uRL = node.getURL();
                        if (node.isReadOnly()) {
                            URLFileSystem.setReadOnly(uRL, false);
                        }
                        try {
                            node.save();
                        }
                        catch (Exception exception) {
                            checkBoxListModel.addElement(node, node.getIcon(), true, true, URLFileSystem.getPlatformPathName(uRL));
                        }
                    }
                    if (checkBoxListModel.getSize() <= 0) break;
                    bl = this.exitWithUnsavedReadOnlyFiles(checkBoxListModel, IdeArb.getString(286));
                    break;
                }
                case -1: 
                case 2: {
                    bl = false;
                }
            }
        }
        if (bl) {
            this.sanitizeWorkspaces(checkBoxListModel, bl2);
            checkBoxListModel = null;
            checkBoxListModel = new CheckBoxListModel();
            for (Node node : arrayList) {
                URL uRL = node.getURL();
                if (node.isReadOnly()) {
                    URLFileSystem.setReadOnly(uRL, false);
                }
                try {
                    node.save();
                }
                catch (Exception exception) {
                    checkBoxListModel.addElement(node, node.getIcon(), true, true, URLFileSystem.getPlatformPathName(uRL));
                }
            }
            if (checkBoxListModel.getSize() > 0) {
                bl = this.exitWithUnsavedReadOnlyFiles(checkBoxListModel, IdeArb.getString(289));
            }
            if (bl) {
                view.close();
                this.shutdown();
            }
        }
        return bl ? 0 : 1;
    }

    private boolean exitWithUnsavedReadOnlyFiles(CheckBoxListModel checkBoxListModel, String string) {
        int n = SelectFilesPanel.showDialog(string, IdeArb.format(288, checkBoxListModel.findTextForElement(0)), IdeArb.getString(287), checkBoxListModel, false, 2, "f1_idedunabletosavefiles_html");
        return n == 0;
    }

    private void sanitizeWorkspaces(CheckBoxListModel checkBoxListModel, boolean bl) {
        if (checkBoxListModel == null || checkBoxListModel.getSize() == 0) {
            return;
        }
        Workspaces workspaces = (Workspaces)Ide.getSystem().getChild(Workspaces.class);
        if (workspaces == null) {
            return;
        }
        int n = checkBoxListModel.getSize();
        int n2 = 0;
        while (n2 < n) {
            Node node;
            if ((bl || !checkBoxListModel.isElementSelected(n2)) && (node = (Node)checkBoxListModel.getUserObjectAt(n2)).isOpen() && node instanceof Workspace && node.isNew()) {
                workspaces.remove(node);
            }
            ++n2;
        }
    }
}

