/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.cmd;

import java.awt.Component;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import oracle.ide.AddinManager;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.cmd.NewWorkspaceCommand;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuManager;
import oracle.ide.editor.EditorUtil;
import oracle.ide.layout.URL2String;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.model.Workspaces;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.NewWorkspacePanel;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.HistoryList;

public final class FileOpenHistory
implements Controller {
    public static final String OPENED_FILES_NAME = "OpenedFiles";
    public static final String OPENED_PROJECTS_NAME = "OpenedProjects";
    public static final String OPENED_WORKSPACES_NAME = "OpenedWorkspaces";
    private static FileOpenHistory instance = new FileOpenHistory();
    private HistoryList openedFiles;
    private HistoryList openedProjects;
    private HistoryList openedWorkspaces;
    private JMenu reopenMenu;
    private JMenuItem EMPTY_ITEM;
    private int historyCount;
    private Map menuCache;
    private static IdeAction GLOBAL_REOPEN_ACTION;

    void $init$() {
        this.historyCount = 4;
        this.menuCache = new HashMap();
    }

    private FileOpenHistory() {
        this.$init$();
        this.initialize();
    }

    public static FileOpenHistory getInstance() {
        return instance;
    }

    public void updateFileHistory(URL uRL) {
        this.getOpenedFiles().update(URL2String.toString(uRL));
    }

    public void updateProjectHistory(URL uRL) {
        this.getOpenedProjects().update(URL2String.toString(uRL));
    }

    public void updateWorkspaceHistory(URL uRL) {
        this.getOpenedWorkspaces().update(URL2String.toString(uRL));
    }

    public void updateHistory(Node node) {
        if (node instanceof Workspace) {
            this.getOpenedWorkspaces().update(URL2String.toString(node.getURL()));
        } else if (node instanceof Project) {
            this.getOpenedProjects().update(URL2String.toString(node.getURL()));
        } else {
            this.getOpenedFiles().update(URL2String.toString(node.getURL()));
        }
    }

    public void removeHistory(Node node) {
        if (node instanceof Workspace) {
            this.getOpenedWorkspaces().remove(URL2String.toString(node.getURL()));
        } else if (node instanceof Project) {
            this.getOpenedProjects().remove(URL2String.toString(node.getURL()));
        } else {
            this.getOpenedFiles().remove(URL2String.toString(node.getURL()));
        }
    }

    public String[] getFileHistory() {
        return this.getOpenedFiles().getHistory();
    }

    public String[] getProjectHistory() {
        return this.getOpenedProjects().getHistory();
    }

    public String[] getWorkspaceHistory() {
        return this.getOpenedWorkspaces().getHistory();
    }

    public int getHistoryCount() {
        return this.historyCount;
    }

    public void setHistoryCount(int n) {
        this.historyCount = n;
    }

    public void save() {
        if (this.openedFiles != null) {
            this.openedFiles.save();
        }
        if (this.openedProjects != null) {
            this.openedProjects.save();
        }
        if (this.openedWorkspaces != null) {
            this.openedWorkspaces.save();
        }
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == 10) {
            this.reopen(ideAction, context);
            return true;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        return false;
    }

    protected void initialize() {
        String string = Ide.getProperty("Ide.DefaultReopenHistoryCount");
        if (string != null) {
            try {
                this.historyCount = Integer.parseInt(string);
                this.setHistoryCount(this.historyCount);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.reopenMenu = MenuManager.getJMenu("FileReopen");
        if (this.reopenMenu != null) {
            this.reopenMenu.add(this.getEmptyItem());
            this.reopenMenu.getPopupMenu().addPopupMenuListener(new 2());
        }
    }

    protected HistoryList getOpenedFiles() {
        if (this.openedFiles == null) {
            this.openedFiles = Ide.loadHistoryList(OPENED_FILES_NAME);
            this.openedFiles.setMaxHistorySize(this.getHistoryCount());
        }
        return this.openedFiles;
    }

    protected HistoryList getOpenedProjects() {
        if (this.openedProjects == null) {
            this.openedProjects = Ide.loadHistoryList(OPENED_PROJECTS_NAME);
            this.openedProjects.setMaxHistorySize(this.getHistoryCount());
        }
        return this.openedProjects;
    }

    protected HistoryList getOpenedWorkspaces() {
        if (this.openedWorkspaces == null) {
            this.openedWorkspaces = Ide.loadHistoryList(OPENED_WORKSPACES_NAME);
            this.openedWorkspaces.setMaxHistorySize(this.getHistoryCount());
        }
        return this.openedWorkspaces;
    }

    private void callPoppingUp() {
        String[] stringArray = this.getFileHistory();
        String[] stringArray2 = this.getProjectHistory();
        String[] stringArray3 = this.getWorkspaceHistory();
        this.reopenMenu.removeAll();
        if (stringArray.length == 0 && stringArray2.length == 0 && stringArray3.length == 0) {
            this.reopenMenu.add(this.getEmptyItem());
            return;
        }
        int n = 0;
        n = this.addMenuItems(stringArray, n);
        n = this.addMenuItems(stringArray2, n);
        this.addMenuItems(stringArray3, n);
    }

    private int addMenuItems(String[] stringArray, int n) {
        if (stringArray.length > 0) {
            if (n > 0) {
                this.reopenMenu.add(new JSeparator());
            }
            n = 0;
            int n2 = 0;
            while (n2 < stringArray.length) {
                JMenuItem jMenuItem = this.getMenuItem(stringArray[n2]);
                if (jMenuItem != null) {
                    this.reopenMenu.add(jMenuItem);
                    ++n;
                }
                ++n2;
            }
        }
        return n;
    }

    private JMenuItem getEmptyItem() {
        if (this.EMPTY_ITEM == null) {
            this.EMPTY_ITEM = new JMenuItem(IdeArb.getString(233));
            this.EMPTY_ITEM.setEnabled(false);
        }
        return this.EMPTY_ITEM;
    }

    private JMenuItem getMenuItem(String string) {
        JMenuItem jMenuItem = (JMenuItem)this.menuCache.get(string);
        if (jMenuItem != null) {
            return jMenuItem;
        }
        try {
            URL uRL = URL2String.toURL(string);
            if (uRL == null) {
                JMenuItem jMenuItem2 = null;
                return jMenuItem2;
            }
            IdeAction ideAction = FileOpenHistory.getNewReopenAction(uRL);
            jMenuItem = Ide.getMenubar().createMenuItem(ideAction);
            this.menuCache.put(string, jMenuItem);
            JMenuItem jMenuItem3 = jMenuItem;
            return jMenuItem3;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static IdeAction getNewReopenAction(URL uRL) {
        Icon icon = null;
        try {
            Node node = NodeFactory.findOrCreate(uRL);
            icon = node.getIcon();
        }
        catch (Exception exception) {
            icon = IdeArb.getIcon(58);
        }
        IdeAction ideAction = FileOpenHistory.getGlobalReopenAction().newLocalAction(null);
        ideAction.putValue("Name", URLFileSystem.getPlatformPathName(uRL));
        ideAction.putValue("SmallIcon", icon);
        ideAction.putValue("UserData", uRL);
        return ideAction;
    }

    public static IdeAction getGlobalReopenAction() {
        if (GLOBAL_REOPEN_ACTION == null) {
            GLOBAL_REOPEN_ACTION = IdeAction.get(10, AddinManager.getAddinManager().getCommand(10, "oracle.ide.cmd.NotImplementedCommand"), null, IdeMainWindow.ACTION_CATEGORY_FILE, null, null, null, true);
            GLOBAL_REOPEN_ACTION.addController(FileOpenHistory.getInstance());
        }
        return GLOBAL_REOPEN_ACTION;
    }

    private void reopen(IdeAction ideAction, Context context) {
        URL uRL = (URL)ideAction.getValue("UserData");
        try {
            Node node = NodeFactory.findOrCreate(uRL);
            if (this.tryWorkspacesFolder(Ide.getWorkspaces(), node)) {
                return;
            }
            if (this.tryWorkspaceFolder(context.getWorkspace(), node)) {
                return;
            }
            if (this.tryProjectFolder(context.getProject(), node)) {
                return;
            }
            if (this.tryMiscellaneousFolder(node)) {
                return;
            }
            if (node instanceof Project) {
                NewWorkspacePanel newWorkspacePanel = new NewWorkspacePanel(false, false, true);
                if (!newWorkspacePanel.runDialog()) {
                    return;
                }
                URL uRL2 = newWorkspacePanel.getFileURL();
                Workspace workspace = NewWorkspaceCommand.createEmptyWorkspace(context, uRL2);
                Ide.setActiveWorkspace(workspace);
                if (this.tryWorkspaceFolder(workspace, node)) {
                    return;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.showErrorDialog(uRL);
    }

    private boolean tryWorkspacesFolder(Workspaces workspaces, Node node) {
        if (workspaces == null) {
            return false;
        }
        if (workspaces.canAdd(node)) {
            if (workspaces.containsChild(node)) {
                if (node instanceof Workspace) {
                    Workspace workspace = (Workspace)node;
                    Context context = Context.newIdeContext(workspace);
                    context.setWorkspace(workspace);
                    context.setProject(workspace.currentActiveProject());
                    NavigatorManager.getWorkspaceNavigatorManager().openNavigator(context);
                }
                return true;
            }
            if (workspaces.add(node)) {
                UpdateMessage.fireChildAdded(workspaces, node);
                return true;
            }
        }
        return false;
    }

    private boolean tryWorkspaceFolder(Workspace workspace, Node node) {
        if (workspace == null) {
            return false;
        }
        if (workspace.canAdd(node)) {
            if (workspace.containsChild(node)) {
                if (node instanceof Project) {
                    Project project = (Project)node;
                    Context context = Context.newIdeContext(project);
                    context.setWorkspace(workspace);
                    context.setProject(project);
                    NavigatorManager.getWorkspaceNavigatorManager().openNavigator(context);
                }
                return true;
            }
            if (workspace.add(node)) {
                UpdateMessage.fireChildAdded(workspace, node);
                return true;
            }
        }
        return false;
    }

    private boolean tryProjectFolder(Project project, Node node) {
        if (project != null && project.canAdd(node)) {
            boolean bl = project.containsChild(node) ^ true;
            this.openEditor(node, bl);
            return true;
        }
        return false;
    }

    private boolean tryMiscellaneousFolder(Node node) {
        if (Ide.addToMiscellaneousFolder(node)) {
            this.openEditor(node);
            return true;
        }
        return false;
    }

    private void openEditor(Node node) {
        this.openEditor(node, true);
    }

    private void openEditor(Node node, boolean bl) {
        if (bl) {
            this.updateFileHistory(node.getURL());
        }
        SwingUtilities.invokeLater(new 1(this, node));
    }

    private void showErrorDialog(URL uRL) {
        String string = URLFileSystem.getPlatformPathName(uRL);
        String string2 = IdeArb.format(290, string);
        JOptionPane.showMessageDialog((Component)((Object)Ide.getMainWindow()), string2, IdeArb.getString(291), 0);
    }

    static void mav$callPoppingUp(FileOpenHistory fileOpenHistory) {
        fileOpenHistory.callPoppingUp();
    }

    public final class 2
    implements PopupMenuListener {
        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            FileOpenHistory.mav$callPoppingUp(FileOpenHistory.this);
        }

        public final void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        }

        public final void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        }
    }

    public final class 1
    implements Runnable {
        private final /* synthetic */ Node v$node;
        final /* synthetic */ FileOpenHistory this$0;

        public void run() {
            EditorUtil.openDefaultEditorInFrame(this.v$node);
        }

        public 1(FileOpenHistory fileOpenHistory, Node node) {
            this.v$node = node;
            this.this$0 = fileOpenHistory;
        }
    }
}

