/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.cmd;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import oracle.ide.AddinManager;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.cmd.RemoveFileCommand;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.explorer.TNode;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectVersion;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.model.WorkspaceMigrator;
import oracle.ide.model.Workspaces;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.NewWorkspacePanel;

public class NewWorkspaceCommand
extends Command {
    private static boolean addProject = true;
    private static boolean openNavigator = false;

    public NewWorkspaceCommand() {
        super(0);
    }

    public int doit() throws Exception {
        URL uRL = this.getWorkspaceURL();
        Workspace workspace = NewWorkspaceCommand.createEmptyWorkspace(this.getContext(), uRL);
        if (workspace == null) {
            return 1;
        }
        Project project = null;
        if (addProject) {
            project = NewWorkspaceCommand.createProject(this.getContext(), workspace);
        }
        Project project2 = project;
        NavigatorWindow navigatorWindow = null;
        TNode tNode = null;
        if (openNavigator) {
            Context context = new Context(this.getContext());
            context.setWorkspace(workspace);
            Element[] elementArray = new Element[]{workspace};
            context.setSelection(elementArray);
            context.setProject(null);
            NavigatorManager navigatorManager = NavigatorManager.getWorkspaceNavigatorManager();
            if (navigatorManager != null) {
                navigatorWindow = navigatorManager.showNavigator(context);
                tNode = navigatorWindow.getTreeExplorer().getRoot();
            }
        } else {
            NavigatorManager navigatorManager = this.getNavigatorManager();
            if (navigatorManager != null && (tNode = (navigatorWindow = navigatorManager.getNavigatorWindow()).getTreeExplorer().findTNodeBreadthFirst(workspace, null)) != null) {
                navigatorWindow.show();
            }
        }
        if (project2 != null && navigatorWindow != null) {
            JTree jTree = navigatorWindow.getTreeExplorer().getJTree();
            NavigatorWindow navigatorWindow2 = navigatorWindow;
            TNode tNode2 = tNode;
            jTree.addTreeExpansionListener(new 1(this, navigatorWindow2, project2, tNode2, jTree));
        }
        if (tNode != null) {
            navigatorWindow.expand(tNode, true);
        }
        return 0;
    }

    public static Project createProject(Context context, Workspace workspace) throws Exception {
        Project project;
        block1: {
            Context context2 = Context.newIdeContext(workspace);
            context2.setView(context.getView());
            context2.setWorkspace(workspace);
            AddinManager addinManager = AddinManager.getAddinManager();
            String string = addinManager.getCommand(3, null);
            CommandProcessor commandProcessor = CommandProcessor.getInstance();
            Command command = CommandProcessor.createCommand(string, context2);
            if (command != null) {
                commandProcessor.invoke(command);
            }
            Iterator iterator = workspace.getChildren();
            project = null;
            if (!iterator.hasNext()) break block1;
            project = (Project)iterator.next();
        }
        return project;
    }

    public static Workspace createEmptyWorkspace(Context context, URL uRL) throws IllegalAccessException, InstantiationException {
        Workspace workspace;
        Workspace workspace2;
        if (uRL == null) {
            return null;
        }
        URL uRL2 = URLFileSystem.getParent(uRL);
        URL uRL3 = URLFileSystem.getParent(uRL2);
        Workspaces workspaces = Ide.getWorkspaces();
        workspaces.setWorkDirectory(uRL3);
        Node node = NodeFactory.find(uRL);
        if (node != null) {
            RemoveFileCommand removeFileCommand = new RemoveFileCommand();
            removeFileCommand.setContext(context);
            ArrayList<Node> arrayList = new ArrayList<Node>(1);
            arrayList.add(node);
            int n = removeFileCommand.remove(arrayList, workspaces, true);
            if (n != 0) {
                return null;
            }
        }
        if ((workspace2 = Ide.getDefaultWorkspace()) != null) {
            workspace = (Workspace)NodeFactory.clone(workspace2, uRL);
            ProjectVersion.initializeVersions(workspace, WorkspaceMigrator.MIGRATOR_NAME);
        } else {
            workspace = (Workspace)NodeFactory.findOrCreate(Workspace.class, uRL);
        }
        Iterator iterator = workspace.getChildren();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            if (!(element instanceof Node)) continue;
            NodeFactory.uncache(((Node)element).getURL());
        }
        workspace.removeAll();
        workspaces.add(workspace);
        UpdateMessage.fireChildAdded(workspaces, workspace);
        return workspace;
    }

    private NavigatorManager getNavigatorManager() {
        NavigatorManager navigatorManager;
        NavigatorWindow navigatorWindow = Ide.getLastActiveNavigator();
        if (navigatorWindow == null) {
            return NavigatorManager.getApplicationNavigatorManager();
        }
        if (navigatorWindow.isVisible()) {
            NavigatorManager navigatorManager2 = navigatorWindow.getManager();
            if (navigatorManager2 == NavigatorManager.getApplicationNavigatorManager()) {
                return navigatorManager2;
            }
            if (navigatorManager2 == NavigatorManager.getWorkspaceNavigatorManager()) {
                return navigatorManager2;
            }
        }
        if ((navigatorManager = NavigatorManager.getApplicationNavigatorManager()).getNavigatorWindow().isVisible()) {
            return navigatorManager;
        }
        NavigatorManager navigatorManager3 = NavigatorManager.getWorkspaceNavigatorManager();
        if (navigatorManager3.getNavigatorWindow().isVisible()) {
            return navigatorManager3;
        }
        return navigatorManager;
    }

    private URL getWorkspaceURL() {
        NewWorkspacePanel newWorkspacePanel = new NewWorkspacePanel(true, true, true);
        newWorkspacePanel.setAddProject(addProject);
        newWorkspacePanel.setOpenNavigator(openNavigator);
        if (newWorkspacePanel.runDialog()) {
            addProject = newWorkspacePanel.isAddProject();
            openNavigator = newWorkspacePanel.isOpenNavigator();
            return newWorkspacePanel.getFileURL();
        }
        return null;
    }

    public final class 1
    implements TreeExpansionListener {
        private final /* synthetic */ NavigatorWindow v$navWin;
        private final /* synthetic */ Project v$project;
        private final /* synthetic */ TNode v$tnode;
        private final /* synthetic */ JTree v$tree;
        final /* synthetic */ NewWorkspaceCommand this$0;

        public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
            TNode tNode = this.v$navWin.findTNode(this.v$project, this.v$tnode);
            if (tNode != null) {
                this.v$navWin.getTreeExplorer().setSelected(tNode);
            }
            this.v$tree.removeTreeExpansionListener(this);
        }

        public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
        }

        public 1(NewWorkspaceCommand newWorkspaceCommand, NavigatorWindow navigatorWindow, Project project, TNode tNode, JTree jTree) {
            this.v$tree = jTree;
            this.v$tnode = tNode;
            this.v$project = project;
            this.v$navWin = navigatorWindow;
            this.this$0 = newWorkspaceCommand;
        }
    }
}

