/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.cmd;

import java.awt.Component;
import java.awt.Window;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.cmd.FileOpenHistory;
import oracle.ide.cmd.NewWorkspaceCommand;
import oracle.ide.cmd.OpenCommandData;
import oracle.ide.controller.Command;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.EditorUtil;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.migration.MigrationInfo;
import oracle.ide.migration.NodeMigrator;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.TextNode;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.model.Workspaces;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.NewWorkspacePanel;
import oracle.ide.resource.IdeArb;
import oracle.javatools.dialogs.ExceptionDialog;

public class OpenCommand
extends Command {
    private Project project;
    private Workspace workspace;
    private Workspaces workspaces;
    private List addFiles;
    private List addToWorkspace;
    private List addToWorkspaces;

    void $init$() {
        this.addFiles = new ArrayList();
        this.addToWorkspace = new ArrayList();
        this.addToWorkspaces = new ArrayList();
    }

    public OpenCommand() {
        super(9);
        this.$init$();
    }

    public final int openURL(URL uRL) throws Exception {
        return this.open(URLFileSystem.canonicalize(uRL));
    }

    public final int doit() throws Exception {
        return this.open(null);
    }

    private int open(URL uRL) throws Exception {
        block14: {
            block13: {
                int n;
                Context context = this.getContext();
                this.project = context.getProject();
                if (this.project == null && uRL == null) {
                    this.project = Ide.getActiveProject();
                }
                OpenCommandData openCommandData = (OpenCommandData)this.getData();
                this.workspace = context.getWorkspace();
                this.workspaces = Ide.getWorkspaces();
                String string = IdeArb.getString(296);
                if (uRL != null) {
                    if (this.checkAddURL(uRL) != 0) {
                        return 0;
                    }
                    n = 0;
                } else {
                    OpenURLChooser openURLChooser = new OpenURLChooser();
                    DialogUtil.initURLChooser(openURLChooser, context);
                    openURLChooser.setSelectionScope(0);
                    if (openCommandData != null) {
                        string = openCommandData.dialogTitle;
                        openURLChooser.clearChooseableURLFilters();
                        openURLChooser.setURLFilter(openCommandData.urlFilter);
                    }
                    OpenURLChooser openURLChooser2 = openURLChooser;
                    n = openURLChooser.showOpenDialog((Component)((Object)Ide.getMainWindow()), openURLChooser2, string);
                    context.setProperty("selected-urls", openURLChooser.getSelectedURLs());
                }
                if (n != 0) break block13;
                ArrayList arrayList = new ArrayList(1);
                for (AddInfo addInfo : this.addToWorkspaces) {
                    if (this.workspaces.containsChild(addInfo.node)) continue;
                    this.checkWorkspaceOpen(addInfo, this.workspaces, arrayList);
                }
                if (arrayList.size() > 0) {
                    UpdateMessage.fireChildrenAdded(this.workspaces, arrayList);
                }
                arrayList.clear();
                for (AddInfo addInfo : this.addToWorkspace) {
                    if (this.workspace.containsChild(addInfo.node)) continue;
                    this.checkProjectOpen(addInfo, this.workspace, arrayList);
                }
                if (arrayList.size() > 0) {
                    UpdateMessage.fireChildrenAdded(this.workspace, arrayList);
                }
                AddInfo addInfo2 = null;
                if (openCommandData != null) break block14;
                for (AddInfo addInfo2 : this.addFiles) {
                    Node node = addInfo2.node;
                    FileOpenHistory.getInstance().updateFileHistory(node.getURL());
                    SwingUtilities.invokeLater(new 1(this, node));
                }
                break block14;
            }
            Iterator iterator = this.addToWorkspaces.iterator();
            while (iterator.hasNext()) {
                this.remove((AddInfo)iterator.next());
            }
            iterator = this.addToWorkspace.iterator();
            while (iterator.hasNext()) {
                this.remove((AddInfo)iterator.next());
            }
            iterator = this.addFiles.iterator();
            while (iterator.hasNext()) {
                this.remove((AddInfo)iterator.next());
            }
        }
        return 0;
    }

    private void openWithNoProject(Node node) {
        URL uRL = node.getURL();
        try {
            Node node2 = NodeFactory.findOrCreate(uRL);
            Context context = Context.newIdeContext(node2);
            EditorManager editorManager = EditorManager.getEditorManager();
            OpenEditorOptions openEditorOptions = new OpenEditorOptions(context);
            editorManager.openEditor(openEditorOptions);
        }
        catch (Exception exception) {
            IdeMainWindow ideMainWindow = Ide.getMainWindow();
            ExceptionDialog.showExceptionDialog((Window)((Object)ideMainWindow), (Exception)exception);
        }
    }

    private void remove(AddInfo addInfo) {
        if (addInfo.newNode) {
            NodeFactory.uncache(addInfo.node.getURL());
        }
    }

    /*
     * Unable to fully structure code
     */
    private int checkAddURL(URL var1_1) {
        var2_2 = URLFileSystem.getPlatformPathName(var1_1);
        var3_3 = false;
        var4_4 = NodeFactory.find(var1_1);
        if (var4_4 == null) {
            var3_3 = true;
            try {
                var4_4 = NodeFactory.findOrCreate(var1_1);
                var4_4 = this.checkOpenAsText(var4_4, var3_3);
                if (var4_4 == null) {
                    var12_5 = 1;
                    return var12_5;
                }
                if (!var4_4.isNew()) ** GOTO lbl22
                var4_4.markDirty(true);
            }
            catch (Exception var5_6) {
                var6_7 = IdeArb.format(290, var2_2);
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), var6_7, IdeArb.getString(291), 0);
                var13_8 = 1;
                return var13_8;
            }
        } else if ((var4_4 = this.checkOpenAsText(var4_4, var3_3)) == null) {
            return 1;
        }
lbl22:
        // 4 sources

        var7_9 = new AddInfo(var4_4, var3_3);
        var8_10 = 0;
        if (this.workspace != null && this.workspace.canAdd(var4_4)) {
            this.addToWorkspace.add(var7_9);
        } else if (this.workspaces != null && this.workspaces.canAdd(var4_4)) {
            this.addToWorkspaces.add(var7_9);
        } else if (var4_4 instanceof Project) {
            var9_11 = new NewWorkspacePanel(false, false, true);
            var9_11.defaultWorkspaceDirToURL(URLFileSystem.getParent(var4_4.getURL()));
            if (var9_11.runDialog(IdeArb.getString(274))) {
                var10_12 = var9_11.getFileURL();
                try {
                    this.workspace = NewWorkspaceCommand.createEmptyWorkspace(this.getContext(), var10_12);
                    if (this.workspace != null && this.workspace.canAdd(var4_4)) {
                        this.addToWorkspace.add(var7_9);
                    }
                }
                catch (Exception var11_13) {
                    var8_10 = 1;
                }
            } else {
                var8_10 = 1;
            }
            if (var8_10 == 1) {
                if (var3_3) {
                    NodeFactory.uncache(var1_1);
                }
                var8_10 = 0;
            }
        } else {
            this.addFiles.add(var7_9);
        }
        return var8_10;
    }

    private Node checkOpenAsText(Node node, boolean bl) {
        if (node.getAttributes().isSet(ElementAttributes.OPEN_AS_TEXT)) {
            URL uRL = node.getURL();
            try {
                URL uRL2 = URLFactory.newIdeURL("ide.text", uRL);
                node = NodeFactory.find(uRL2);
                if (node == null) {
                    node = new TextNode();
                    node.setURL(uRL2);
                }
                if (bl) {
                    NodeFactory.uncache(uRL);
                }
            }
            catch (Exception exception) {
                String string = IdeArb.format(290, URLFileSystem.getPlatformPathName(uRL));
                JOptionPane.showMessageDialog((Component)((Object)Ide.getMainWindow()), string, IdeArb.getString(291), 0);
                Node node2 = null;
                return node2;
            }
        }
        return node;
    }

    private void checkProjectOpen(AddInfo addInfo, Workspace workspace, List list) {
        MigrationInfo migrationInfo;
        NodeMigrator nodeMigrator = NodeMigrator.getNodeMigrator(NodeMigrator.getLookupKey(addInfo.node));
        if (nodeMigrator != null && (migrationInfo = nodeMigrator.getMigrationInfo(addInfo.node)).getVersionStatus() != MigrationInfo.VERSION_CURRENT && nodeMigrator.migrate(migrationInfo).getMigrationStatus() != MigrationInfo.MIGRATION_DONE) {
            this.remove(addInfo);
            return;
        }
        workspace.add(addInfo.node);
        list.add(addInfo.node);
        FileOpenHistory.getInstance().updateProjectHistory(addInfo.node.getURL());
    }

    private void checkWorkspaceOpen(AddInfo addInfo, Workspaces workspaces, List list) {
        MigrationInfo migrationInfo;
        NodeMigrator nodeMigrator = NodeMigrator.getNodeMigrator(NodeMigrator.getLookupKey(addInfo.node));
        if (nodeMigrator != null && (migrationInfo = nodeMigrator.getMigrationInfo(addInfo.node)).getVersionStatus() != MigrationInfo.VERSION_CURRENT && nodeMigrator.migrate(migrationInfo).getMigrationStatus() != MigrationInfo.MIGRATION_DONE) {
            this.remove(addInfo);
            return;
        }
        workspaces.add(addInfo.node);
        list.add(addInfo.node);
        FileOpenHistory.getInstance().updateWorkspaceHistory(addInfo.node.getURL());
    }

    static Project ra$project(OpenCommand openCommand) {
        return openCommand.project;
    }

    static void mav$openWithNoProject(OpenCommand openCommand, Node node) {
        openCommand.openWithNoProject(node);
    }

    static List ra$addFiles(OpenCommand openCommand) {
        return openCommand.addFiles;
    }

    static List ra$addToWorkspace(OpenCommand openCommand) {
        return openCommand.addToWorkspace;
    }

    static List ra$addToWorkspaces(OpenCommand openCommand) {
        return openCommand.addToWorkspaces;
    }

    static int mav$checkAddURL(OpenCommand openCommand, URL uRL) {
        return openCommand.checkAddURL(uRL);
    }

    public final class 1
    implements Runnable {
        private final /* synthetic */ Node v$node;
        final /* synthetic */ OpenCommand this$0;

        public void run() {
            if (OpenCommand.ra$project(this.this$0) == null || !OpenCommand.ra$project(this.this$0).containsChild(this.v$node)) {
                OpenCommand.mav$openWithNoProject(this.this$0, this.v$node);
            } else {
                EditorUtil.openExplicitDefaultEditorInFrame(this.v$node);
            }
            if (this.v$node.isNew()) {
                try {
                    this.v$node.save();
                    if (OpenCommand.ra$project(this.this$0) != null && OpenCommand.ra$project(this.this$0).isOpen()) {
                        UpdateMessage.fireChildAdded(OpenCommand.ra$project(this.this$0), this.v$node);
                    }
                }
                catch (IOException iOException) {
                    String string = URLFileSystem.getPlatformPathName(this.v$node.getURL());
                    String string2 = IdeArb.format(238, string);
                    JOptionPane.showMessageDialog((Component)((Object)Ide.getMainWindow()), string2, IdeArb.getString(240), 0);
                }
            }
        }

        public 1(OpenCommand openCommand, Node node) {
            this.v$node = node;
            this.this$0 = openCommand;
        }
    }

    private static class AddInfo {
        final Node node;
        final boolean newNode;

        AddInfo(Node node, boolean bl) {
            this.node = node;
            this.newNode = bl;
        }
    }

    private class OpenURLChooser
    extends URLChooser {
        private static final String HELP_TOPIC_OPEN = "f1_idedopenorcreatefile_html";

        OpenURLChooser() {
            this.setSelectionScope(2);
            this.setHelpID(HELP_TOPIC_OPEN);
        }

        public boolean approveSelection() {
            if (!super.approveSelection()) {
                return false;
            }
            OpenCommand.ra$addFiles(OpenCommand.this).clear();
            OpenCommand.ra$addToWorkspace(OpenCommand.this).clear();
            OpenCommand.ra$addToWorkspaces(OpenCommand.this).clear();
            URL[] uRLArray = this.getSelectedURLs();
            int n = 0;
            if (uRLArray != null && uRLArray.length > 0) {
                URL uRL;
                if (uRLArray.length == 1 && !URLFileSystem.isBound(uRL = uRLArray[0])) {
                    String string = URLFileSystem.getPlatformPathName(uRL);
                    String string2 = IdeArb.format(423, string);
                    if (!MessageDialog.confirm((Component)((Object)Ide.getMainWindow()), string2, IdeArb.getString(422), null)) {
                        return false;
                    }
                }
                int n2 = 0;
                while (n2 < uRLArray.length) {
                    if (OpenCommand.mav$checkAddURL(OpenCommand.this, uRLArray[n2]) == 0) {
                        ++n;
                    }
                    ++n2;
                }
            }
            return n > 0;
        }
    }
}

