/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.cmd;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.cmd.CloseNodeCommand;
import oracle.ide.cmd.FileOpenHistory;
import oracle.ide.controller.Command;
import oracle.ide.explorer.ExplorerContext;
import oracle.ide.explorer.TNode;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.model.Node;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.VetoableSubject;
import oracle.ide.model.Workspaces;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.IdeArb;

public class RemoveFileCommand
extends Command {
    private List affectedNodes;

    void $init$() {
        this.affectedNodes = new ArrayList(1);
    }

    public RemoveFileCommand() {
        super(21, 2);
        this.$init$();
    }

    public RemoveFileCommand(int n, int n2) {
        super(n, n2);
        this.$init$();
    }

    public int doit() throws Exception {
        Context context = this.getContext();
        TNode[] tNodeArray = ExplorerContext.getTNodes(context);
        if (tNodeArray == null) {
            return 1;
        }
        Folder folder = this.findOwner(tNodeArray, context);
        if (folder == null) {
            return 1;
        }
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        if (!this.canRemove(tNodeArray, folder, arrayList, arrayList2)) {
            return 1;
        }
        int n = this.remove(arrayList, folder, true, arrayList2);
        if (n == 0 && arrayList2.size() > 0) {
            String string = this.buildFileNamesString(arrayList2);
            String string2 = IdeArb.format(358, string);
            JOptionPane.showMessageDialog((Component)((Object)Ide.getMainWindow()), string2, IdeArb.getString(359), 2);
        }
        return n;
    }

    public Node[] getAffectedNodes() {
        Node[] nodeArray = new Node[this.affectedNodes.size()];
        this.affectedNodes.toArray(nodeArray);
        return nodeArray;
    }

    protected int remove(List list, Folder folder, boolean bl) {
        return this.remove(list, folder, bl, null);
    }

    protected int remove(List list, Folder folder, boolean bl, List list2) {
        UpdateMessage updateMessage = this.createUpdateMessage();
        if (bl) {
            CloseNodeCommand closeNodeCommand = new CloseNodeCommand(updateMessage);
            closeNodeCommand.setContext(this.getContext());
            closeNodeCommand.setNeedConfirm(this.isNeedConfirmClose());
            int n = closeNodeCommand.close(list, false, false);
            if (n != 0) {
                return n;
            }
        }
        int n = 0;
        while (n < list.size()) {
            Element element = (Element)list.get(n);
            if (element instanceof Node) {
                if (this.remove((Node)element, folder)) {
                    updateMessage.getRemoveObjects().add(element);
                    this.affectedNodes.add(element);
                } else if (list2 != null) {
                    list2.add(element);
                }
            }
            ++n;
        }
        if (updateMessage.getRemoveObjects().size() > 0 && folder instanceof Subject) {
            Subject subject = (Subject)((Object)folder);
            updateMessage.setContext(this.getContext());
            subject.notifyObservers(folder, updateMessage);
        }
        return 0;
    }

    protected UpdateMessage createUpdateMessage() {
        UpdateMessage updateMessage = new UpdateMessage(UpdateMessage.CHILD_REMOVED, null);
        updateMessage.setProperty("Message.COMMAND_ID_PROP", new Integer(21));
        return updateMessage;
    }

    protected boolean remove(Node node, Folder folder) {
        boolean bl = folder.remove(node);
        if (bl) {
            FileOpenHistory.getInstance().updateHistory(node);
        }
        return bl;
    }

    protected String buildFileNamesString(List list) {
        String string = "";
        int n = Math.min(list.size(), 4);
        int n2 = 0;
        while (n2 < n) {
            Element element = (Element)list.get(n2);
            if (element instanceof Node) {
                Node node = (Node)element;
                if (n2 > 0) {
                    string = string + "\n";
                }
                string = string + URLFileSystem.getPlatformPathName(node.getURL());
            }
            ++n2;
        }
        return string;
    }

    Folder findOwner(TNode[] tNodeArray, Context context) {
        if (tNodeArray.length == 0) {
            return null;
        }
        Folder folder = null;
        int n = 0;
        while (n < tNodeArray.length) {
            TNode tNode = tNodeArray[n];
            Folder folder2 = this.findOwner(tNode, context);
            if (folder == null) {
                folder = folder2;
            } else if (folder != folder2) {
                return null;
            }
            ++n;
        }
        return folder;
    }

    Folder findOwner(TNode tNode, Context context) {
        Element element;
        TNode tNode2;
        Element element2 = tNode.getData();
        Folder folder = Workspaces.findOwner(element2, context);
        if (folder == null && (tNode2 = (TNode)tNode.getParent()) != null && (element = tNode2.getData()) instanceof Folder) {
            folder = (Folder)element;
        }
        return folder;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean canRemove(Element element, Folder folder) {
        if (folder == null) return true;
        if (!folder.canRemove(element)) return false;
        try {
            if (!(folder instanceof VetoableSubject)) return true;
            UpdateMessage.fireCanRemoveChild((VetoableSubject)((Object)folder), element);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected boolean canRemove(TNode[] tNodeArray, Folder folder, List list, List list2) {
        int n = 0;
        while (n < tNodeArray.length) {
            TNode tNode = tNodeArray[n];
            Element element = tNode.getData();
            if (this.canRemove(element, folder)) {
                list.add(element);
            } else {
                list2.add(element);
            }
            ++n;
        }
        return list.size() > 0;
    }

    protected boolean isNeedConfirmClose() {
        return true;
    }
}

