/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.cmd;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.cmd.FileOpenHistory;
import oracle.ide.cmd.RemoveFileCommand;
import oracle.ide.config.DTCache;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.explorer.ExplorerContext;
import oracle.ide.explorer.TNode;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.RelativeDirectoryContextFolder;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.refactoring.RefactorManager;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.ResourceUtils;

public class RemoveFromDiskCommand
extends RemoveFileCommand {
    private static final String ERASE_SAFELY_PREF = "EraseSafely";

    public RemoveFromDiskCommand() {
        super(47, 2);
    }

    public int doit() throws Exception {
        int n = 1;
        Context context = this.getContext();
        ArrayList<Element> arrayList = new ArrayList<Element>();
        boolean bl = true;
        TNode[] tNodeArray = ExplorerContext.getTNodes(context);
        int n2 = tNodeArray.length;
        if (n2 > 0) {
            String string;
            RefactorManager refactorManager;
            ArrayList<URL> arrayList2 = new ArrayList<URL>(n2);
            int n3 = 0;
            while (n3 < n2) {
                TNode tNode = tNodeArray[n3];
                Element element = tNode.getData();
                arrayList.add(element);
                if (element instanceof Locatable) {
                    Locatable locatable = (Locatable)((Object)element);
                    URL uRL = locatable.getURL();
                    arrayList2.add(uRL);
                } else if (element instanceof RelativeDirectoryContextFolder) {
                    RelativeDirectoryContextFolder relativeDirectoryContextFolder = (RelativeDirectoryContextFolder)element;
                    URLPath uRLPath = relativeDirectoryContextFolder.getRootDirectories();
                    String string2 = relativeDirectoryContextFolder.getRelativePath();
                    Iterator iterator = uRLPath.iterator();
                    while (iterator.hasNext()) {
                        URL uRL = (URL)iterator.next();
                        URL uRL2 = URLFactory.newDirURL(uRL, string2);
                        arrayList2.add(uRL2);
                    }
                } else {
                    bl = false;
                }
                ++n3;
            }
            URL[] uRLArray = arrayList2.toArray(new URL[arrayList2.size()]);
            boolean bl2 = false;
            if (bl && (refactorManager = RefactorManager.getRefactorManager()).canSafeDelete(context, uRLArray)) {
                bl2 = true;
            }
            if (arrayList.size() == 1) {
                Element element = (Element)arrayList.get(0);
                String string3 = element.getLongLabel();
                string = MessageFormat.format(IdeArb.getString(362), string3);
            } else {
                string = IdeArb.getString(363);
            }
            int n4 = this.runDialog(string, bl2);
            switch (n4) {
                case 1: {
                    Folder folder = this.findOwner(tNodeArray[0], this.context);
                    n = this.eraseElements(folder, arrayList);
                    break;
                }
                case 2: {
                    RefactorManager refactorManager2 = RefactorManager.getRefactorManager();
                    if (!refactorManager2.safeDeleteFiles(context, uRLArray)) break;
                    n = 0;
                }
            }
        }
        return n;
    }

    protected boolean remove(Node node, Folder folder) {
        boolean bl = false;
        boolean bl2 = false;
        if (node.isNew()) {
            bl2 = true;
        } else if (URLFileSystem.canDelete(node.getURL())) {
            try {
                node.delete();
                bl2 = true;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (bl2 && (bl = !folder.containsChild(node) ? true : folder.remove(node))) {
            FileOpenHistory.getInstance().removeHistory(node);
            NodeFactory.uncache(node.getURL());
        }
        return bl;
    }

    private int eraseElements(Folder folder, ArrayList arrayList) {
        int n = arrayList.size();
        ArrayList<Element> arrayList2 = new ArrayList<Element>(n);
        int n2 = 0;
        while (n2 < n) {
            Element element = (Element)arrayList.get(n2);
            if (this.canRemove(element, folder)) {
                arrayList2.add(element);
            }
            ++n2;
        }
        1 var7_7 = new 1(this, arrayList2, folder);
        var7_7.run();
        return 0;
    }

    private int runDialog(String string, boolean bl) {
        int n = 0;
        JPanel jPanel = new JPanel(new GridBagLayout());
        MultiLineLabel multiLineLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), string);
        Insets insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)multiLineLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, insets, 0, 0));
        JCheckBox jCheckBox = new JCheckBox();
        ResourceUtils.resButton(jCheckBox, "Delete &Safely");
        DTCache dTCache = Ide.getDTCache();
        boolean bl2 = dTCache.getBoolean(ERASE_SAFELY_PREF, true);
        jCheckBox.setSelected(bl2);
        jPanel.add((Component)jCheckBox, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 16, 0, insets, 0, 0));
        jCheckBox.setEnabled(bl);
        boolean bl3 = MessageDialog.confirm((Component)((Object)Ide.getMainWindow()), jPanel, IdeArb.getString(227), "f1_idederasefromdisk1_html");
        if (bl3) {
            if (bl) {
                boolean bl4 = jCheckBox.isSelected();
                dTCache.putBoolean(ERASE_SAFELY_PREF, bl4);
                n = bl4 ? 2 : 1;
            } else {
                n = 1;
            }
        }
        return n;
    }

    protected UpdateMessage createUpdateMessage() {
        UpdateMessage updateMessage = new UpdateMessage(UpdateMessage.CHILD_REMOVED, null);
        updateMessage.setProperty("Message.COMMAND_ID_PROP", new Integer(47));
        return updateMessage;
    }

    protected boolean isNeedConfirmClose() {
        return false;
    }

    public final class 1
    implements Runnable {
        private final /* synthetic */ List v$finalFiles;
        private final /* synthetic */ Folder v$ownerFolder;
        final /* synthetic */ RemoveFromDiskCommand this$0;

        public void run() {
            ArrayList arrayList = new ArrayList();
            int n = this.this$0.remove(this.v$finalFiles, this.v$ownerFolder, true, arrayList);
            if (n == 0 && arrayList.size() > 0) {
                String string = this.this$0.buildFileNamesString(arrayList);
                String string2 = IdeArb.format(360, string);
                MessageDialog.error((Component)((Object)Ide.getMainWindow()), string2, IdeArb.getString(361), null);
            }
        }

        public 1(RemoveFromDiskCommand removeFromDiskCommand, List list, Folder folder) {
            this.v$ownerFolder = folder;
            this.v$finalFiles = list;
            this.this$0 = removeFromDiskCommand;
        }
    }
}

