/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.cmd;

import java.awt.Component;
import java.net.URL;
import java.util.List;
import javax.swing.JOptionPane;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.cmd.RenameMessage;
import oracle.ide.cmd.SaveAsCommand;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Recognizer;
import oracle.ide.model.RecognizerException;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.VetoableSubject;
import oracle.ide.net.URLFileSystem;
import oracle.ide.refactoring.RefactorManager;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.ModelUtil;
import oracle.javatools.dialogs.MessageDialog;

public class RenameCommand
extends SaveAsCommand {
    public RenameCommand() {
        super(14);
    }

    public int doit() throws Exception {
        Element element;
        Context context = this.getContext();
        Node node = null;
        Element[] elementArray = context.getSelection();
        if (elementArray != null && elementArray.length == 1 && (element = elementArray[0]) instanceof Node) {
            node = (Node)element;
        }
        if (node == null) {
            node = context.getNode();
        }
        URL uRL = node.getURL();
        RefactorManager refactorManager = RefactorManager.getRefactorManager();
        int n = refactorManager.canSafeRename(context, uRL);
        switch (n) {
            case 1: {
                return this.doFileRename(context, node);
            }
            case 0: {
                if (!refactorManager.doSafeRename(context, uRL)) break;
                return 0;
            }
        }
        return 1;
    }

    private int doFileRename(Context context, Node node) {
        int n;
        RefactorManager refactorManager;
        String string;
        int n2;
        URL uRL = node.getURL();
        Folder folder = this.getElementOwner(node, context, true);
        if (folder instanceof VetoableSubject) {
            try {
                UpdateMessage.fireCanRenameChild((VetoableSubject)((Object)folder), node);
            }
            catch (Exception exception) {
                int n3 = 2;
                return n3;
            }
        }
        if ((n2 = this.doSaveAs(string = IdeArb.getString(345))) == 2 || n2 == 1) {
            return 1;
        }
        if (URLFileSystem.exists(uRL) && !URLFileSystem.isDirectory(uRL) && !URLFileSystem.equals(uRL, this._newURL) && !URLFileSystem.delete(uRL)) {
            String string2 = IdeArb.format(245, URLFileSystem.getPlatformPathName(uRL), URLFileSystem.getPlatformPathName(this._newURL));
            JOptionPane.showMessageDialog((Component)((Object)Ide.getMainWindow()), string2, IdeArb.getString(240), 0);
        }
        if (!URLFileSystem.equals(uRL, this._newURL) && (refactorManager = RefactorManager.getRefactorManager()).canUpdateReferences(context, uRL) && (n = MessageDialog.confirmOrCancel((Component)((Object)Ide.getMainWindow()), (Object)"Do you want to update the references to this file?", (String)string)) == 1) {
            refactorManager.doUpdateReferences(context, uRL, this._newURL);
        }
        return 0;
    }

    protected int saveNode(Node node) {
        URL uRL = node.getURL();
        if (!URLFileSystem.exists(uRL)) {
            return super.saveNode(node);
        }
        if (URLFileSystem.exists(this._newURL) && !URLFileSystem.equals(uRL, this._newURL) && !URLFileSystem.delete(this._newURL)) {
            String string = IdeArb.format(252, URLFileSystem.getPlatformPathName(this._newURL));
            JOptionPane.showMessageDialog((Component)((Object)Ide.getMainWindow()), string, IdeArb.getString(240), 0);
            return 2;
        }
        if (!URLFileSystem.renameTo(uRL, this._newURL)) {
            String string = IdeArb.format(253, URLFileSystem.getPlatformPathName(uRL), URLFileSystem.getPlatformPathName(this._newURL));
            JOptionPane.showMessageDialog((Component)((Object)Ide.getMainWindow()), string, IdeArb.getString(240), 0);
            return 2;
        }
        node.setURL(this._newURL);
        return 0;
    }

    protected int saveAsNewNode(Node node) {
        int n;
        URL uRL = node.getURL();
        Subject subject = null;
        if (this._elementOwner instanceof Subject) {
            subject = (Subject)((Object)this._elementOwner);
            RenameMessage.firePreChildRenamed(subject, this._context);
        }
        if ((n = this.saveNode(node)) == 0) {
            RenameMessage.fireObjectRenamed(node, uRL, this._context);
            if (subject != null) {
                RenameMessage.fireChildRenamed(subject, uRL, node, this._context);
            }
        }
        return n;
    }

    protected int handleNodeOwnership(Node node, Node node2, URL uRL) throws Exception {
        List list;
        EditorManager editorManager = EditorManager.getEditorManager();
        if (editorManager != null && (list = editorManager.findEditors(this._context)).size() > 0) {
            this._noPlaceToAdd = true;
        }
        if (this._elementOwner != null) {
            this._elementOwner.remove(node);
            this._elementOwner.add(node2);
        }
        RenameMessage.fireObjectRenamed(node, uRL, node2, this._context);
        if (this._elementOwner instanceof Subject) {
            Subject subject = (Subject)((Object)this._elementOwner);
            RenameMessage.fireChildRenamed(subject, node, uRL, node2, this._context);
        }
        node.close();
        NodeFactory.uncache(uRL);
        return 0;
    }

    protected boolean isSameFile(URL uRL, URL uRL2) {
        return ModelUtil.areEqual((Object)uRL, (Object)uRL2);
    }

    protected URL validateNewURL(Recognizer recognizer, URL uRL, URL uRL2) {
        try {
            String string = URLFileSystem.getSuffix(uRL2);
            String string2 = URLFileSystem.getSuffix(uRL);
            if (ModelUtil.hasLength((String)string) && !ModelUtil.hasLength((String)string2) || ModelUtil.hasLength((String)string) && string.equals(".jws") && !string2.equals(".jws") || ModelUtil.hasLength((String)string) && string.equals(".jpr") && !string2.equals(".jpr")) {
                URL uRL3 = recognizer.validate(uRL, uRL2);
                return uRL3;
            }
            URL uRL4 = recognizer.validate(uRL, uRL2);
            URL uRL5 = uRL;
            return uRL5;
        }
        catch (RecognizerException recognizerException) {
            String string = recognizerException.getLocalizedMessage();
            if (string == null || string.length() == 0) {
                string = IdeArb.format(244, URLFileSystem.getPlatformPathName(uRL));
            }
            JOptionPane.showMessageDialog((Component)((Object)Ide.getMainWindow()), string, IdeArb.getString(240), 0);
            URL uRL6 = null;
            return uRL6;
        }
    }
}

