/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.cmd;

import java.net.URL;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.model.Node;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;

public final class RenameMessage {
    private static final String IS_PRE_RENAME_MESSAGE = "RenameMessage.IS_PRE_RENAME_MESSAGE";
    private static final String RENAMED_NODE = "RenameMessage.RENAMED_NODE";

    private RenameMessage() {
    }

    public static boolean isPreRenameMessage(UpdateMessage updateMessage) {
        if (updateMessage != null) {
            return Boolean.TRUE.equals(updateMessage.getProperty(IS_PRE_RENAME_MESSAGE));
        }
        return false;
    }

    public static void setPreRenameMessage(UpdateMessage updateMessage, boolean bl) {
        if (updateMessage != null) {
            updateMessage.setProperty(IS_PRE_RENAME_MESSAGE, bl);
        }
    }

    public static URL getOldURL(UpdateMessage updateMessage) {
        Object e;
        List list = updateMessage.getModifyObjects();
        if (list.size() > 0 && (e = list.get(0)) instanceof URL) {
            return (URL)e;
        }
        return null;
    }

    public static Node getRenamedNode(UpdateMessage updateMessage) {
        if (updateMessage != null) {
            return (Node)updateMessage.getProperty(RENAMED_NODE);
        }
        return null;
    }

    public static void setRenamedNode(UpdateMessage updateMessage, Node node) {
        if (updateMessage != null) {
            updateMessage.setProperty(RENAMED_NODE, node);
        }
    }

    public static Node getRemovedNode(UpdateMessage updateMessage) {
        Object e;
        List list = updateMessage.getRemoveObjects();
        if (list.size() > 0 && (e = list.get(0)) instanceof Node) {
            return (Node)e;
        }
        return null;
    }

    public static Node getNewNode(UpdateMessage updateMessage) {
        Object e;
        List list = updateMessage.getAddObjects();
        if (list.size() > 0 && (e = list.get(0)) instanceof Node) {
            return (Node)e;
        }
        return null;
    }

    public static void fireObjectRenamed(Subject subject, URL uRL, Context context) {
        UpdateMessage updateMessage = new UpdateMessage(UpdateMessage.OBJECT_RENAMED, null);
        updateMessage.getModifyObjects().add(uRL);
        updateMessage.setContext(context);
        RenameMessage.setRenamedNode(updateMessage, context.getNode());
        subject.notifyObservers(subject, updateMessage);
    }

    public static void fireChildRenamed(Subject subject, URL uRL, Node node, Context context) {
        UpdateMessage updateMessage = new UpdateMessage(UpdateMessage.CHILD_RENAMED, null);
        updateMessage.getModifyObjects().add(uRL);
        updateMessage.getModifyObjects().add(node);
        updateMessage.getAddObjects().add(context.getElement());
        updateMessage.setContext(context);
        RenameMessage.setRenamedNode(updateMessage, node);
        subject.notifyObservers(subject, updateMessage);
    }

    public static void fireObjectRenamed(Subject subject, URL uRL, Node node, Node node2, Context context) {
        UpdateMessage updateMessage = new UpdateMessage(UpdateMessage.OBJECT_RENAMED, null);
        if (node2 != null) {
            updateMessage.getAddObjects().add(node2);
        }
        updateMessage.getRemoveObjects().add(node);
        updateMessage.getModifyObjects().add(uRL);
        updateMessage.setContext(context);
        RenameMessage.setRenamedNode(updateMessage, node);
        node.notifyObservers(node, updateMessage);
    }

    public static void fireChildRenamed(Subject subject, URL uRL, Node node, Node node2, Context context) {
        UpdateMessage updateMessage = new UpdateMessage(UpdateMessage.CHILD_RENAMED, null);
        RenameMessage.setRenamedNode(updateMessage, node);
        if (node2 != null) {
            updateMessage.getAddObjects().add(node2);
        }
        updateMessage.getRemoveObjects().add(node);
        updateMessage.getModifyObjects().add(uRL);
        updateMessage.setContext(context);
        updateMessage.getModifyObjects().add(subject);
        subject.notifyObservers(subject, updateMessage);
    }

    public static void fireObjectRenamed(Node node, URL uRL, Node node2, Context context) {
        UpdateMessage updateMessage = new UpdateMessage(UpdateMessage.OBJECT_RENAMED, null);
        RenameMessage.setRenamedNode(updateMessage, node);
        updateMessage.getAddObjects().add(node2);
        updateMessage.getRemoveObjects().add(node);
        updateMessage.getModifyObjects().add(uRL);
        updateMessage.setContext(context);
        node.notifyObservers(node, updateMessage);
    }

    public static void fireChildRenamed(Subject subject, Node node, URL uRL, Node node2, Context context) {
        UpdateMessage updateMessage = new UpdateMessage(UpdateMessage.CHILD_RENAMED, null);
        RenameMessage.setRenamedNode(updateMessage, node);
        updateMessage.getAddObjects().add(node2);
        updateMessage.getRemoveObjects().add(node);
        updateMessage.getModifyObjects().add(uRL);
        updateMessage.setContext(context);
        subject.notifyObservers(subject, updateMessage);
    }

    public static void firePreChildRenamed(Subject subject, Context context) {
        UpdateMessage updateMessage = new UpdateMessage(UpdateMessage.CHILD_RENAMED, null);
        RenameMessage.setPreRenameMessage(updateMessage, true);
        updateMessage.getRemoveObjects().add(context.getElement());
        updateMessage.setContext(context);
        subject.notifyObservers(subject, updateMessage);
    }
}

