/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.cmd;

import java.awt.Component;
import java.awt.Window;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.cmd.CloseNodeCommand;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.model.Node;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.IdeArb;
import oracle.javatools.dialogs.ExceptionDialog;

public class RevertNodeCommand
extends Command {
    private boolean _confirm;

    public RevertNodeCommand() {
        this(false);
    }

    public RevertNodeCommand(boolean bl) {
        super(52, 2);
        this.setNeedConfirm(bl);
    }

    public int doit() throws Exception {
        Node node = this.getNode();
        if (node != null && this.getConfirmation()) {
            if (!node.mayHaveChildren()) {
                node.revert();
            } else {
                CloseNodeCommand closeNodeCommand = new CloseNodeCommand();
                closeNodeCommand.setContext(this.getContext());
                node.markDirty(false);
                closeNodeCommand.close(node);
                UpdateMessage.fireObjectReloaded(node);
            }
            return 0;
        }
        return 1;
    }

    public boolean isNeedConfirm() {
        return this._confirm;
    }

    public void setNeedConfirm(boolean bl) {
        this._confirm = bl;
    }

    public static int reload(Node node) {
        return RevertNodeCommand.reload(node, false);
    }

    public static int reload(Node node, boolean bl) {
        return RevertNodeCommand.reload(Context.newIdeContext(node), bl);
    }

    public static int reload(Context context) {
        return RevertNodeCommand.reload(context, true);
    }

    public static int reload(Context context, boolean bl) {
        int n;
        RevertNodeCommand revertNodeCommand = new RevertNodeCommand(bl);
        revertNodeCommand.setContext(context);
        try {
            n = CommandProcessor.getInstance().invoke(revertNodeCommand);
        }
        catch (Exception exception) {
            n = 1;
            ExceptionDialog.showExceptionDialog((Window)((Object)Ide.getMainWindow()), (Exception)exception);
        }
        return n;
    }

    private Node getNode() {
        Context context = this.getContext();
        if (context != null) {
            return context.getNode();
        }
        return null;
    }

    private boolean getConfirmation() {
        Context context = this.getContext();
        if (context == null) {
            return false;
        }
        if (!this.isNeedConfirm()) {
            return true;
        }
        Node node = this.getNode();
        String string = URLFileSystem.getPlatformPathName(node.getURL());
        return MessageDialog.confirm((Component)((Object)Ide.getMainWindow()), IdeArb.format(412, string), IdeArb.getString(411), null);
    }
}

