/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.cmd;

import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import oracle.ide.Ide;
import oracle.ide.cmd.FileOpenHistory;
import oracle.ide.controller.Command;
import oracle.ide.controls.WaitCursor;
import oracle.ide.controls.checkboxlist.CheckBoxListModel;
import oracle.ide.dialogs.SelectFilesPanel;
import oracle.ide.docking.DockStation;
import oracle.ide.layout.IdeProperties;
import oracle.ide.layout.Layouts;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.IdeArb;

public class SaveAllCommand
extends Command {
    public SaveAllCommand() {
        super(13);
    }

    public static int saveAll() throws Exception {
        int n = 0;
        int n2 = 0;
        CheckBoxListModel checkBoxListModel = new CheckBoxListModel();
        WaitCursor waitCursor = Ide.getWaitCursor();
        waitCursor.show();
        try {
            Iterator iterator = NodeFactory.getCachedNodes();
            while (iterator.hasNext()) {
                Node node = (Node)iterator.next();
                if (!node.isOpen()) continue;
                ++n;
                if (!node.isDirty()) continue;
                URL uRL = node.getURL();
                if (node.isReadOnly()) {
                    URLFileSystem.setReadOnly(uRL, false);
                }
                try {
                    node.save();
                    ++n2;
                }
                catch (Exception exception) {
                    String string = IdeArb.format(302, URLFileSystem.getPlatformPathName(uRL), exception.getLocalizedMessage());
                    checkBoxListModel.addElement(node, node.getIcon(), true, true, string);
                }
            }
        }
        finally {
            waitCursor.hide();
        }
        if (checkBoxListModel.getSize() > 0) {
            SelectFilesPanel.showDialog(IdeArb.getString(286), IdeArb.format(301, checkBoxListModel.findTextForElement(0)), IdeArb.getString(300), checkBoxListModel, false, -1, "f1_idedunabletosavefiles_html");
        }
        String string = IdeArb.format(299, new Integer(n), new Integer(n2));
        Ide.getStatusBar().setText(string);
        return 0;
    }

    public int doit() throws Exception {
        SaveAllCommand.saveAll();
        SaveAllCommand.saveSystemFiles();
        return 0;
    }

    public static void saveSystemFiles() {
        WaitCursor waitCursor = Ide.getWaitCursor();
        boolean bl = Ide.isQuitting();
        if (!bl) {
            waitCursor.show();
        }
        try {
            if (bl) {
                Ide.getSettings().save();
            }
            Ide.getDTCache().save();
            Layouts layouts = Layouts.getLayouts();
            if (layouts != null) {
                if (!bl) {
                    DockStation.getDockStation().saveLayout(layouts.getActiveLayout());
                }
                layouts.saveAll();
            }
            FileOpenHistory.getInstance().save();
            IdeProperties ideProperties = Ide.getIdeProperties();
            if (ideProperties != null) {
                try {
                    ideProperties.save();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        finally {
            if (!bl) {
                waitCursor.hide();
            }
        }
    }
}

